/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.tiporecursopcp;

import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.PrevOcupTipoRecursoPCP;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class AuxPrevOcupacaoTpRecursoPCP {
    public List getPrevisao(List osLinhaProd, Long idPeriodoProducao, List osLinhaSobEnc) throws ExceptionDatabase, ExceptionService {
        PeriodoProducao per = (PeriodoProducao)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOPeriodoProducao(), idPeriodoProducao);
        List ocupacoes = this.getOcupacoesSalvas(idPeriodoProducao);
        this.putOsTemporaria(osLinhaProd, ocupacoes);
        this.putOsTemporariaOsSobEnc(osLinhaSobEnc, ocupacoes);
        this.putTempoDisponivel(ocupacoes, idPeriodoProducao);
        this.calcEstimativas(ocupacoes, per);
        return ocupacoes;
    }

    private void putTempoDisponivel(List ocupacoes, Long idPeriodoProducao) throws ExceptionDatabase {
        PeriodoProducao per = (PeriodoProducao)CoreDAOFactory.getInstance().getDAOPeriodoProducao().findByPrimaryKey(idPeriodoProducao);
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "select sum(d.numHoras) as TOTAL_HORAS_PLANEJADAS from DiaPlanejTempoTrabalhoPCP o inner join o.planejTempoTrabalhoPCP p inner join p.celulasProdutivas c inner join o.diaPlanejHorarios d where d.dataInicio >= :dataInicial and d.dataTermino <=:dataFinal and c.identificador = :idCelula and d.tipoTempo = :produtivo";
        Query q = s.createQuery(st);
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            Long idCelulaProd = (Long)h.get("ID_CELULA_PRODUTIVA");
            q.setLong("idCelula", idCelulaProd.longValue());
            q.setDate("dataInicial", per.getDataInicial());
            q.setDate("dataFinal", per.getDataFinal());
            q.setShort("produtivo", (short)1);
            Double valor = (Double)q.uniqueResult();
            if (valor == null) {
                valor = 0.0;
            }
            h.put("TOTAL_HORAS_PLANEJADAS", valor);
        }
    }

    private void putOsTemporaria(List osLinhaProd, List ocupacoes) {
        if (osLinhaProd == null) {
            return;
        }
        for (Object o : osLinhaProd) {
            OrdemServicoProdLinhaProd os = (OrdemServicoProdLinhaProd)o;
            for (SubdivisaoOSProdLinhaProd s : os.getSubDivisoesOS()) {
                for (PrevOcupTipoRecursoPCP ocu : s.getPrevOcupTipoRecursos()) {
                    HashMap found = null;
                    if (ocu.getIdentificador() != null) continue;
                    for (Object ob : ocupacoes) {
                        HashMap f = (HashMap)ob;
                        Long idCelulaProdutiva = (Long)f.get("ID_TP_RECURSO");
                        if (!idCelulaProdutiva.equals(ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getIdentificador())) continue;
                        found = f;
                        break;
                    }
                    if (found == null) {
                        found = new HashMap();
                        found.put("ID_TP_RECURSO", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getIdentificador());
                        found.put("TP_RECURSO", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getDescricao());
                        found.put("ID_CELULA_PRODUTIVA", ocu.getFaseProdTipoRecursoPCP().getFaseProdutiva().getCelulaProdutiva().getIdentificador());
                        found.put("CELULA_PRODUTIVA", ocu.getFaseProdTipoRecursoPCP().getFaseProdutiva().getCelulaProdutiva().getDescricao());
                        found.put("TOTAL_HORAS", 0.0);
                        found.put("TOTAL_QUANTIDADE", 0.0);
                        found.put("QTD_RECURSOS_DISP", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getQuantidadeRecursosDisp());
                        ocupacoes.add(found);
                    }
                    found.put("TOTAL_HORAS", (Double)found.get("TOTAL_HORAS") + ocu.getNumeroHoras());
                    found.put("TOTAL_QUANTIDADE", (Double)found.get("TOTAL_QUANTIDADE") + ocu.getQuantidadeRecursos());
                }
            }
        }
    }

    private List getOcupacoesSalvas(Long idPeriodoProducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "select coalesce(sum(o.numeroHoras),0) as TOTAL_HORAS, coalesce(sum(o.quantidadeRecursos),0) as TOTAL_QUANTIDADE, t.identificador as ID_TP_RECURSO, t.descricao as TP_RECURSO, t.quantidadeRecursosDisp as QTD_RECURSOS_DISP, c.identificador as ID_CELULA_PRODUTIVA, c.descricao as CELULA_PRODUTIVA from PrevOcupTipoRecursoPCP o inner join o.faseProdTipoRecursoPCP ft inner join ft.tipoRecursoPCP t inner join ft.faseProdutiva f inner join f.celulaProdutiva c where o.periodoProducao.identificador=:idPeriodoProd group by t.identificador,t.descricao,c.identificador,c.descricao,t.quantidadeRecursosDisp order by t.descricao";
        Query q = s.createQuery(st);
        q.setLong("idPeriodoProd", idPeriodoProducao.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private void putOsTemporariaOsSobEnc(List osLinhaSobEnc, List ocupacoes) {
        if (osLinhaSobEnc == null) {
            return;
        }
        for (Object o : osLinhaSobEnc) {
            OrdemServicoProdSobEnc os = (OrdemServicoProdSobEnc)o;
            for (SubdivisaoOSProdSobEnc s : os.getSubDivisoesOS()) {
                for (PrevOcupTipoRecursoPCP ocu : s.getPrevOcupTipoRecursos()) {
                    HashMap found = null;
                    if (ocu.getIdentificador() != null) continue;
                    for (Object ob : ocupacoes) {
                        HashMap f = (HashMap)ob;
                        Long idTipoRecurso = (Long)f.get("ID_TP_RECURSO");
                        if (!idTipoRecurso.equals(ocu.getFaseProdTipoRecursoPCP().getIdentificador())) continue;
                        found = f;
                        break;
                    }
                    if (found == null) {
                        found = new HashMap();
                        found.put("ID_TP_RECURSO", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getIdentificador());
                        found.put("TP_RECURSO", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getDescricao());
                        found.put("ID_CELULA_PRODUTIVA", ocu.getFaseProdTipoRecursoPCP().getFaseProdutiva().getCelulaProdutiva().getIdentificador());
                        found.put("CELULA_PRODUTIVA", ocu.getFaseProdTipoRecursoPCP().getFaseProdutiva().getCelulaProdutiva().getDescricao());
                        found.put("TOTAL_HORAS", 0.0);
                        found.put("TOTAL_QUANTIDADE", 0.0);
                        found.put("QTD_RECURSOS_DISP", ocu.getFaseProdTipoRecursoPCP().getTipoRecursoPCP().getQuantidadeRecursosDisp());
                        ocupacoes.add(found);
                    }
                    found.put("TOTAL_HORAS", (Double)found.get("TOTAL_HORAS") + ocu.getNumeroHoras());
                    found.put("TOTAL_QUANTIDADE", (Double)found.get("TOTAL_QUANTIDADE") + ocu.getQuantidadeRecursos());
                }
            }
        }
    }

    private void calcEstimativas(List<Map> ocupacoes, PeriodoProducao per) {
        Double totalHorasPer = ToolDate.calcularDifHoras((Date)per.getDataInicial(), (Date)per.getDataFinal());
        for (Map h : ocupacoes) {
            Double totalHorasPlan = (Double)h.get("TOTAL_HORAS_PLANEJADAS");
            Double totalRecursos = (Double)h.get("TOTAL_QUANTIDADE");
            Double qtdRecursosDisp = (Double)h.get("QTD_RECURSOS_DISP");
            totalRecursos = totalRecursos <= 0.0 ? 1.0 : totalRecursos;
            qtdRecursosDisp = qtdRecursosDisp <= 0.0 ? 1.0 : qtdRecursosDisp;
            h.put("TOTAL_HORAS_PER", totalHorasPer);
            h.put("INDICE_HOR_PER_UTILIZADO", totalHorasPer / totalRecursos);
            h.put("INDICE_HOR_DISP_UTILIZADO", totalHorasPlan / totalRecursos);
            h.put("INDICE_HOR_PER_DISP", totalHorasPer / qtdRecursosDisp);
            h.put("INDICE_HOR_DISP_PLAN", totalHorasPlan / qtdRecursosDisp);
        }
    }
}

