/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.titulo;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;

class AuxBuildLogTitulos {
    private final Titulo titulo;

    public AuxBuildLogTitulos(Titulo titulo) {
        this.titulo = titulo;
    }

    public List<HashMap> buildLogs() {
        ArrayList<HashMap> logAlteracoes = new ArrayList<HashMap>();
        this.verificaLogTitulos(this.titulo, logAlteracoes);
        this.verificaBorderoTitulo(this.titulo, logAlteracoes);
        this.verificaBoletoTitulo(this.titulo, logAlteracoes);
        Collections.sort(logAlteracoes, new Comparator(this){

            public int compare(Object o1, Object o2) {
                HashMap item1 = (HashMap)o1;
                HashMap item2 = (HashMap)o2;
                if (item1.get("data") != null && item2.get("data") != null) {
                    Date vlr1 = (Date)item1.get("data");
                    Date vlr2 = (Date)item2.get("data");
                    return vlr2.compareTo(vlr1);
                }
                return 0;
            }
        });
        return logAlteracoes;
    }

    private void verificaLogTitulos(Titulo titulo, List<HashMap> logAlteracoes) {
        List<LogTitulos> listLogTitulos = CoreDAOFactory.getInstance().getDAOLogTitulos().findLogTitulos(titulo);
        if (listLogTitulos != null && !listLogTitulos.isEmpty()) {
            for (LogTitulos l : listLogTitulos) {
                HashMap<String, Object> log = new HashMap<String, Object>();
                log.put("operacao", "Log Titulo: " + l.getIdentificador());
                log.put("data", l.getDataCadastro());
                log.put("descricao", this.getDescricaoLogTitulo(l));
                logAlteracoes.add(log);
            }
        }
    }

    private void verificaBorderoTitulo(Titulo titulo, List<HashMap> logAlteracoes) {
        List<BorderoTitulos> listBorderoTitulos = CoreDAOFactory.getInstance().getDAOBorderoTitulos().getItensBorderoCobranca(titulo);
        if (listBorderoTitulos != null && !listBorderoTitulos.isEmpty()) {
            for (BorderoTitulos bt : listBorderoTitulos) {
                HashMap<String, Object> log = new HashMap<String, Object>();
                log.put("operacao", "Border\u00f4 Titulo: " + bt.getIdentificador());
                log.put("data", bt.getDataBordero());
                log.put("descricao", this.getDescricaoBorderoTitulo(bt));
                logAlteracoes.add(log);
            }
        }
    }

    private void verificaBoletoTitulo(Titulo titulo, List<HashMap> logAlteracoes) {
        List<ItemAltBoletoHist> itens = CoreDAOFactory.getInstance().getDAOBoletoTitulo().findItensAltBoleto(titulo);
        for (ItemAltBoletoHist bt : itens) {
            HashMap<String, Object> log = new HashMap<String, Object>();
            log.put("operacao", "Boleto Titulo: " + bt.getIdentificador());
            log.put("data", bt.getDataAlteracao());
            log.put("descricao", bt.getObservacao());
            logAlteracoes.add(log);
        }
    }

    private String getDescricaoBorderoTitulo(BorderoTitulos bt) {
        Object inf = "";
        inf = (String)inf + "Emiss\u00e3o do Border\u00f4 ";
        return inf;
    }

    private String getDescricaoLogTitulo(LogTitulos l) {
        Object inf = "";
        inf = (String)inf + l.getMotivo() + ", ";
        inf = (String)inf + l.getTipoAlteracaoTitulo().toString() + ", ";
        inf = (String)inf + "Usu\u00e1rio: " + l.getUsuario().getUsuarioBasico().getPessoa().getNome();
        return inf;
    }

    private String getDescricaoBoletoTitulo(BoletoTitulo bt) {
        Object inf = "";
        inf = (String)inf + "Emiss\u00e3o do Boleto ";
        return inf;
    }
}

