/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.titulo;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoBoletoEnvioMassa;
import com.touchcomp.basementor.model.vo.GrupoLogTitulos;
import com.touchcomp.basementor.model.vo.ItemBorderoCobranca;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemLiberacaoTitulo;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.LiberacaoTitulos;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosNaoBaixados;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;

class AuxProcessarLogTitulos {
    private final GrupoLogTitulos grupoLogTitulos;
    private final OpcoesFinanceiras opcoesFinanceiras;
    private final Usuario usuario;

    public AuxProcessarLogTitulos(GrupoLogTitulos grupoLogTitulos, OpcoesFinanceiras opcoesFinanceiras, Usuario usuario) {
        this.grupoLogTitulos = grupoLogTitulos;
        this.opcoesFinanceiras = opcoesFinanceiras;
        this.usuario = usuario;
    }

    Object processar(Empresa empresa) throws ExceptionService, ExceptionGeracaoBoletos, ExceptionDatabase, Exception {
        for (LogTitulos logTitulo : this.grupoLogTitulos.getLogTitulos()) {
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("03")) {
                this.excluirItemRemessaCnab(logTitulo);
                this.excluirTituloBordero(logTitulo);
                this.excluirTituloEnvioBoletoMassa(logTitulo);
                this.excluirLiberacaoTitulo(logTitulo);
                this.excluirRetornoCnabNaoBaixados(logTitulo);
                this.excluirItemRetornoCnabNaoBaixados(logTitulo);
                this.excluirTitulo(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("02")) {
                this.excluirItemRemessaCnab(logTitulo);
                this.excluirTituloBordero(logTitulo);
                this.excluirTituloEnvioBoletoMassa(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("00")) {
                this.alterarDataVenc(logTitulo);
                if (this.grupoLogTitulos.getAtualizarBoletos() != null && this.grupoLogTitulos.getAtualizarBoletos() == 1) {
                    this.atualizarBoletos(logTitulo, empresa);
                }
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("01")) {
                this.alterarValor(logTitulo);
                if (this.grupoLogTitulos.getAtualizarBoletos() != null && this.grupoLogTitulos.getAtualizarBoletos() == 1) {
                    logTitulo.getItemLogDadosTitulo().setDataVencimentoNovo(logTitulo.getTitulo().getDataVencimento());
                    this.atualizarBoletos(logTitulo, empresa);
                }
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("04")) {
                this.alterarDataVencBase(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("05")) {
                this.alterarDataEmissao(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("07")) {
                this.alterarDataEntrada(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("06")) {
                this.alterarDataCompetencia(logTitulo);
            }
            if (logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("08")) {
                this.alterarDesconto(logTitulo);
                if (this.grupoLogTitulos.getAtualizarBoletos() != null && this.grupoLogTitulos.getAtualizarBoletos() == 1) {
                    logTitulo.getItemLogDadosTitulo().setDataVencimentoNovo(logTitulo.getTitulo().getDataVencimento());
                    this.atualizarBoletos(logTitulo, empresa);
                }
            }
            if (!logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("09")) continue;
            this.alterarValorPercentual(logTitulo);
            if (this.grupoLogTitulos.getAtualizarBoletos() == null || this.grupoLogTitulos.getAtualizarBoletos() != 1) continue;
            logTitulo.getItemLogDadosTitulo().setDataVencimentoNovo(logTitulo.getTitulo().getDataVencimento());
            this.atualizarBoletos(logTitulo, empresa);
        }
        GrupoLogTitulos gr = (GrupoLogTitulos)CoreDAOFactory.getInstance().getDAOGrupoLogTitulos().saveOrUpdate(this.grupoLogTitulos);
        return gr;
    }

    private void excluirTitulo(LogTitulos logTitulo) throws ExceptionDatabase {
        Titulo titulo = logTitulo.getTitulo();
        logTitulo.setTitulo(null);
        CoreDAOFactory.getInstance().getDAOLogTitulos().updateLogTitulosExclusao(titulo);
        CoreDAOFactory.getInstance().getDAOBoletoTitulo().updateBolTitulosExclusao(titulo);
        CoreDAOFactory.getInstance().getDAOTitulo().delete(titulo);
    }

    private void excluirTituloBordero(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        if (logTitulo.getTitulo() == null) {
            return;
        }
        boolean alterarCarteira = true;
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            List<BorderoTitulos> listBorderoCobranca = CoreDAOFactory.getInstance().getDAOBorderoTitulos().getItensBorderoCobranca(logTitulo.getTitulo());
            System.out.println("<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>" + logTitulo.getTitulo().getIdentificador());
            listBorderoCobranca.forEach(t -> t.getItemBorderoCobranca().forEach(t1 -> System.out.println(t1.getTitulo().getIdentificador())));
            block0: for (BorderoTitulos b : listBorderoCobranca) {
                Titulo t2;
                if (b.getItemBorderoCobranca().size() > 1) {
                    for (ItemBorderoCobranca item : b.getItemBorderoCobranca()) {
                        if (!item.getTitulo().equals((Object)logTitulo.getTitulo())) continue;
                        if (!logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("03") && alterarCarteira) {
                            item.getTitulo().setCarteiraCobranca(b.getCarteiraOrigem());
                            CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(item.getTitulo());
                            alterarCarteira = false;
                        }
                        b.getItemBorderoCobranca().remove(item);
                        CoreDAOFactory.getInstance().getDAOBorderoTitulos().saveOrUpdate(b);
                        continue block0;
                    }
                    continue;
                }
                if (!logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("03") && !(t2 = ((ItemBorderoCobranca)b.getItemBorderoCobranca().get(0)).getTitulo()).getCarteiraCobranca().equals((Object)b.getCarteiraOrigem()) && alterarCarteira) {
                    t2.setCarteiraCobranca(b.getCarteiraOrigem());
                    CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t2);
                    alterarCarteira = false;
                }
                this.excluirEnvioBoletoMassa(b);
            }
        } else {
            List<BorderoPagamento> listBorderoPagamento = CoreDAOFactory.getInstance().getDAOBorderoPagamento().getItensBorderoPagamento(logTitulo.getTitulo());
            block2: for (BorderoPagamento b : listBorderoPagamento) {
                if (b.getItemBordero().size() > 1) {
                    for (ItemBorderoPagamento itemBordero : b.getItemBordero()) {
                        Titulo t3 = itemBordero.getItemLiberacao().getTitulo();
                        if (t3 == null) {
                            t3 = itemBordero.getTitulo();
                        }
                        if (!logTitulo.getTitulo().equals((Object)t3)) continue;
                        if (!logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("03") && alterarCarteira) {
                            t3.setCarteiraCobranca(b.getCarteiraOrigem());
                            CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t3);
                            alterarCarteira = false;
                        }
                        b.getItemBordero().remove(itemBordero);
                        CoreDAOFactory.getInstance().getDAOBorderoPagamento().saveOrUpdate(b);
                        continue block2;
                    }
                    continue;
                }
                if (!logTitulo.getTipoAlteracaoTitulo().getCodigo().equals("03")) {
                    Titulo t2 = ((ItemBorderoPagamento)b.getItemBordero().get(0)).getItemLiberacao().getTitulo();
                    if (t2 == null) {
                        t2 = ((ItemBorderoPagamento)b.getItemBordero().get(0)).getTitulo();
                    }
                    if (alterarCarteira) {
                        t2.setCarteiraCobranca(b.getCarteiraOrigem());
                        alterarCarteira = false;
                        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t2);
                    }
                }
                CoreDAOFactory.getInstance().getDAOBorderoPagamento().delete(b);
                break;
            }
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private void alterarDataVenc(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            logTitulo.getTitulo().setDataVencimento(logTitulo.getItemLogDadosTitulo().getDataVencimentoNovo());
        } else {
            this.excluirLiberacaoTitulo(logTitulo);
            logTitulo.getTitulo().setDataVencimento(logTitulo.getItemLogDadosTitulo().getDataVencimentoNovo());
        }
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarDataVencBase(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            logTitulo.getTitulo().setDataVencimentoBase(logTitulo.getItemLogDadosTitulo().getDataVencimentoBaseNovo());
        } else {
            logTitulo.getTitulo().setDataVencimentoBase(logTitulo.getItemLogDadosTitulo().getDataVencimentoBaseNovo());
        }
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarDataEmissao(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        logTitulo.getTitulo().setDataEmissao(logTitulo.getItemLogDadosTitulo().getDataNova());
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarDataCompetencia(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        logTitulo.getTitulo().setDataCompetencia(logTitulo.getItemLogDadosTitulo().getDataNova());
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarDataEntrada(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        logTitulo.getTitulo().setDataEntradaSaida(logTitulo.getItemLogDadosTitulo().getDataNova());
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarValor(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        Double valorSaldo = ContatoFormatUtil.arrredondarNumero((Double)(logTitulo.getItemLogDadosTitulo().getValorNovo() - logTitulo.getItemLogDadosTitulo().getValor() + logTitulo.getTitulo().getValorSaldo()), (int)2);
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            logTitulo.getTitulo().setValor(logTitulo.getItemLogDadosTitulo().getValorNovo());
        } else {
            this.excluirLiberacaoTitulo(logTitulo);
            logTitulo.getTitulo().setValor(logTitulo.getItemLogDadosTitulo().getValorNovo());
        }
        logTitulo.getTitulo().setValorSaldo(valorSaldo);
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarValorPercentual(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        Double percDesconto = logTitulo.getItemLogDadosTitulo().getPercentualDescontoFincanceiroNovo();
        if (percDesconto > 100.0) {
            throw new ExceptionService("Nenhum Percentual de Desconto n\u00e3o pode ser maior que 100%!");
        }
        Double newValor = logTitulo.getTitulo().getValor() * (percDesconto / 100.0);
        newValor = ContatoFormatUtil.arrredondarNumero((Double)newValor, (int)2);
        if (logTitulo.getTitulo().getPagRec().equals((short)0)) {
            this.excluirLiberacaoTitulo(logTitulo);
        }
        logTitulo.getTitulo().setDescontoFinanceiro(newValor);
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void alterarDesconto(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        Double valorDesconto = ContatoFormatUtil.arrredondarNumero((Double)logTitulo.getItemLogDadosTitulo().getValorDescontoFincanceiroNovo(), (int)2);
        logTitulo.getTitulo().setDescontoFinanceiro(valorDesconto);
        CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(logTitulo.getTitulo());
    }

    private void atualizarBoletos(LogTitulos logTitulo, Empresa empresa) throws ExceptionService, ExceptionGeracaoBoletos, ExceptionDatabase, Exception {
        BoletoTitulo b = CoreDAOFactory.getInstance().getDAOBoletoTitulo().getBoletoAtivo(logTitulo.getTitulo());
        if (b != null) {
            b.setCalcularDespBanc(Short.valueOf((short)1));
            b.setCalcularJuros(Short.valueOf((short)1));
            b.setCalcularMulta(Short.valueOf((short)1));
            b.setInformarValorManual(Short.valueOf((short)0));
            b.setValorTotal(logTitulo.getTitulo().getValor());
            CoreUtilityFactory.getUtilityBoleto().calcAndAtualizacaoVlrTitulo(b, logTitulo.getItemLogDadosTitulo().getDataVencimentoNovo(), this.opcoesFinanceiras, this.usuario, empresa);
            b.setDataVencimento(logTitulo.getTitulo().getDataVencimento());
            CoreDAOFactory.getInstance().getDAOBoletoTitulo().saveOrUpdate(b);
        }
    }

    private void excluirRetornoCnabNaoBaixados(LogTitulos logTitulo) throws ExceptionService, ExceptionDatabase {
        if (logTitulo.getTitulo() == null) {
            return;
        }
        List<RetornoCnabCobrancaTitulosNaoBaixados> listRet = this.findRetornoCnabTitulosNaoBaixados(logTitulo);
        if (listRet != null && !listRet.isEmpty()) {
            CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAORetornoCnabCobrancaTitulosNaoBaixados(), listRet);
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private List<RetornoCnabCobrancaTitulosNaoBaixados> findRetornoCnabTitulosNaoBaixados(LogTitulos logTitulo) throws ExceptionService {
        ArrayList<RetornoCnabCobrancaTitulosNaoBaixados> listRet = new ArrayList();
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAORetornoCnabCobrancaTitulosNaoBaixados().getVOClass());
        b.and().equal("titulo", logTitulo.getTitulo());
        listRet = CoreService.executeSearch(b);
        return listRet;
    }

    private LiberacaoTitulos findLiberacaoTituloByTitulo(LogTitulos logTitulo) throws ExceptionService {
        LiberacaoTitulos liberacao = null;
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOLiberacaoTitulos().getVOClass());
        b.and().equal("itemLiberacao.titulo.identificador", logTitulo.getTitulo().getIdentificador());
        liberacao = (LiberacaoTitulos)CoreService.executeSearchUniqueResult(b);
        return liberacao;
    }

    private void excluirEnvioBoletoMassa(BorderoTitulos b) throws ExceptionService, ExceptionDatabase {
        List envioBoleto = new ArrayList();
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGeracaoBoletoEnvioMassa().getVOClass());
        bc.and().equal("borderoTitulo.identificador", b.getIdentificador());
        envioBoleto = CoreService.executeSearch(bc);
        if (envioBoleto != null && !envioBoleto.isEmpty()) {
            CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOGeracaoBoletoEnvioMassa(), envioBoleto);
        } else {
            CoreDAOFactory.getInstance().getDAOBorderoTitulos().delete(b);
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private void excluirTituloEnvioBoletoMassa(LogTitulos logTitulo) throws ExceptionService, ExceptionDatabase {
        if (logTitulo.getTitulo() == null) {
            return;
        }
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            List envioBoleto = new ArrayList();
            BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOGeracaoBoletoEnvioMassa().getVOClass());
            bc.and().equal("listTitulo.identificador", logTitulo.getTitulo().getIdentificador());
            envioBoleto = CoreService.executeSearch(bc);
            if (envioBoleto != null && !envioBoleto.isEmpty()) {
                block0: for (GeracaoBoletoEnvioMassa envio : envioBoleto) {
                    for (Titulo t : envio.getListTitulo()) {
                        if (!t.equals((Object)logTitulo.getTitulo())) continue;
                        envio.getListTitulo().remove(t);
                        CoreDAOFactory.getInstance().getDAOGeracaoBoletoEnvioMassa().saveOrUpdate(envio);
                        continue block0;
                    }
                }
            }
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private List<RemessaCnabCobranca> findRemessaCnabCobrancaByItemBordero(Titulo t) throws ExceptionService {
        ArrayList<RemessaCnabCobranca> remessa = new ArrayList();
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAORemessaCnabCobranca().getVOClass());
        bc.and().equal("itemRemessaCobranca.itemBordero.titulo.identificador", t.getIdentificador());
        remessa = CoreService.executeSearch(bc);
        return remessa;
    }

    private List<RemessaCnabPagamento> findRemessaCnabPagamentoByItemBordero(Titulo t) throws ExceptionService {
        ArrayList<RemessaCnabPagamento> remessa = new ArrayList();
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAORemessaCnabPagamento().getVOClass());
        bc.and().equal("itemRemessaPagamento.itemBordero.itemLiberacao.titulo.identificador", t.getIdentificador());
        remessa = CoreService.executeSearch(bc);
        return remessa;
    }

    private void excluirLiberacaoTitulo(LogTitulos logTitulo) throws ExceptionDatabase, ExceptionService {
        if (logTitulo.getTitulo().getPagRec().equals((short)0)) {
            LiberacaoTitulos liberacao = this.findLiberacaoTituloByTitulo(logTitulo);
            if (liberacao != null) {
                for (ItemLiberacaoTitulo i : liberacao.getItemLiberacao()) {
                    if (i.getTitulo().equals((Object)logTitulo.getTitulo()) && liberacao.getItemLiberacao().size() == 1) {
                        CoreDAOFactory.getInstance().getDAOLiberacaoTitulos().delete(liberacao);
                        break;
                    }
                    if (!i.getTitulo().equals((Object)logTitulo.getTitulo())) continue;
                    liberacao.getItemLiberacao().remove(i);
                    CoreDAOFactory.getInstance().getDAOLiberacaoTitulos().saveOrUpdate(liberacao);
                    break;
                }
            }
            CoreBdUtil.getInstance().getSession().flush();
            CoreBdUtil.getInstance().getSession().clear();
        }
    }

    private void excluirItemRemessaCnab(LogTitulos logTitulo) throws ExceptionService, ExceptionDatabase {
        if (logTitulo.getTitulo().getPagRec().equals((short)1)) {
            List<RemessaCnabCobranca> remessa = this.findRemessaCnabCobrancaByItemBordero(logTitulo.getTitulo());
            block0: for (RemessaCnabCobranca r : remessa) {
                if (r.getItemRemessaCobranca().size() > 1) {
                    for (ItemRemessaCnabCobranca item : r.getItemRemessaCobranca()) {
                        if (!item.getItemBordero().getTitulo().equals((Object)logTitulo.getTitulo())) continue;
                        r.getItemRemessaCobranca().remove(item);
                        CoreDAOFactory.getInstance().getDAORemessaCnabCobranca().saveOrUpdate(r);
                        continue block0;
                    }
                    continue;
                }
                CoreDAOFactory.getInstance().getDAORemessaCnabCobranca().delete(r);
                break;
            }
        } else {
            List<RemessaCnabPagamento> remessaPagamento = this.findRemessaCnabPagamentoByItemBordero(logTitulo.getTitulo());
            block2: for (RemessaCnabPagamento r : remessaPagamento) {
                if (r.getItemRemessaPagamento().size() > 1) {
                    for (ItemRemessaCnabPagamento item : r.getItemRemessaPagamento()) {
                        if (!item.getItemBordero().getItemLiberacao().getTitulo().equals((Object)logTitulo.getTitulo())) continue;
                        r.getItemRemessaPagamento().remove(item);
                        CoreDAOFactory.getInstance().getDAORemessaCnabPagamento().saveOrUpdate(r);
                        continue block2;
                    }
                    continue;
                }
                CoreDAOFactory.getInstance().getDAORemessaCnabPagamento().delete(r);
                break;
            }
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private void excluirItemRetornoCnabNaoBaixados(LogTitulos logTitulo) throws ExceptionService {
        if (logTitulo.getTitulo() == null) {
            return;
        }
        List<ItemRetornoCnab> listRet = this.findItemRetornoCnabTitulosNaoBaixados(logTitulo);
        if (listRet != null && !listRet.isEmpty()) {
            CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOItemRetornoCnab(), listRet);
        }
        CoreBdUtil.getInstance().getSession().flush();
        CoreBdUtil.getInstance().getSession().clear();
    }

    private List<ItemRetornoCnab> findItemRetornoCnabTitulosNaoBaixados(LogTitulos logTitulo) throws ExceptionService {
        ArrayList<ItemRetornoCnab> listRet = new ArrayList();
        BaseCriteria b = BaseCriteria.create(ItemRetornoCnab.class);
        b.and().equal("titulo", logTitulo.getTitulo());
        listRet = CoreService.executeSearch(b);
        return listRet;
    }
}

