/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.titulo;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoLogTitulos;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemBorderoCobranca;
import com.touchcomp.basementor.model.vo.LiberacaoTitulos;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.service.impl.titulo.AuxBuildLogTitulos;
import mentorcore.service.impl.titulo.AuxProcessarLogTitulos;

public class ServiceTitulo
extends CoreService {
    public static String FIND_LIBERACAO_TITULO_POR_TITULO = "findLiberacaoTituloPorTitulo";
    public static final String SALVAR_LOG_TITULO = "salvarLogTitulos";
    public static final String SALVAR_GRUPO_LOG_TITULO = "salvarGrupoLogTitulos";
    public static String FIND_SALDO_TITULOS_ABERTOS_ID_PESSOA = "findSaldoTitulosAbertos";
    public static String SALVAR_TITULO_ATUALIZADO = "salvarTituloAtualizado";
    public static final String EXISTE_BORDERO_POR_TITULO = "existeBorderoPorTitulo";
    public static final String EXISTE_BORDERO_PAGAMENTO_POR_TITULO = "existeBorderoPagamentoPorTitulo";
    public static final String EXISTE_BAIXA_TITULO = "existeBaixaTitulo";
    public static final String FIND_BAIXA_TITULO = "findBaixaTitulo";
    public static final String FIND_BORDERO_POR_TITULO = "findBorderoPorTitulo";
    public static final String FIND_BORDERO_PAGAMENTO_POR_TITULO = "findBorderoPagamentoPorTitulo";
    public static final String FIND_REMESSA_POR_TITULO = "findRemessaPorTitulo";
    public static final String VERIFICA_DEPENDENCIAS_TITULO = "verificaDependenciasTitulo";
    public static String FIND_VALOR_TITULOS_NOTA_PROPRIA = "findValorTitulosNotaPropria";
    public static String EXISTE_TITULOS_VENCIDOS = "existeTitulosVencidos";
    public static String ATUALIZAR_TITULO_DA_BAIXA = "atualizarTituloDaBaixa";
    public static final String FIND_CENTRO_CUSTO = "findCentroCusto";
    public static final String FIND_ULTIMO_TITULO_POR_PESSOA = "findUltimoTituloPorPessoa";
    public static final String FIND_TITULOS_POR_DATA_EMISSAO_VENCIMENTO = "findTitulosPorDataEmissaoVencimento";
    public static String FIND_LOG_ALTERACOES_TITULOS = "findLogAlteracoesTitulos";
    public static final String FIND_TITULOS_NF_PROPRIA = "findTitulosNFPropria";
    public static final String FIND_TITULOS_NF_TERCEIROS = "findTitulosNFTerceiro";
    public static final String FIND_TITULOS_NF_PROPRIA_FATURAMENTO_ENTRADA = "findTitulosNFPropriaFaturamentoEntrada";
    public static String FIND_CARTEIRA_TITULO_BY_COLABORADOR = "findCarteiraCobrancaByColaborador";
    public static final String FIND_TITULOS_ABERTOS_POR_PESSOA_AND_PAG_REC = "findTitulosAbertosPorPessoaAndPagRec";

    public List<LiberacaoTitulos> findLiberacaoTituloPorTitulo(CoreRequestContext r) throws ExceptionDatabase {
        Titulo t = (Titulo)r.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().findLiberacaoTituloPorTitulo(t);
    }

    public Object salvarLogTitulos(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        LogTitulos logTitulos = (LogTitulos)r.getAttribute("logTitulos");
        List listBorderoCobranca = (List)r.getAttribute("listBorderoCobranca");
        List listLogTitulos = (List)r.getAttribute("listLogTitulos");
        if (logTitulos.getTipoAlteracaoTitulo().getCodigo().equals("03")) {
            Titulo titulo = logTitulos.getTitulo();
            logTitulos.setTitulo(null);
            CoreDAOFactory.getInstance().getDAOTitulo().delete(titulo);
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAORetornoCnabCobrancaTitulosNaoBaixados().getVOClass());
            b.and().equal("titulo", titulo);
            List listRet = CoreService.executeSearch(b);
            if (listRet != null && !listRet.isEmpty()) {
                CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAORetornoCnabCobrancaTitulosNaoBaixados(), listRet);
            }
            b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOItemLiberacaoTitulo().getVOClass());
            b.and().equal("titulo", titulo);
            List itensLiberacao = CoreService.executeSearch(b);
            if (itensLiberacao != null && !itensLiberacao.isEmpty()) {
                CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAOItemLiberacaoTitulo(), itensLiberacao);
            }
            for (LogTitulos l : listLogTitulos) {
                l.setTitulo(null);
                CoreDAOFactory.getInstance().getDAOLogTitulos().saveOrUpdate(l);
            }
        }
        if ((logTitulos = (LogTitulos)CoreDAOFactory.getInstance().getDAOLogTitulos().saveOrUpdate(logTitulos)).getTipoAlteracaoTitulo().getCodigo().equals("02")) {
            block1: for (BaseCriteria b : listBorderoCobranca) {
                if (b.getItemBorderoCobranca().size() > 1) {
                    for (ItemBorderoCobranca i : b.getItemBorderoCobranca()) {
                        if (!i.getTitulo().equals((Object)logTitulos.getTitulo())) continue;
                        b.getItemBorderoCobranca().remove(i);
                        CoreDAOFactory.getInstance().getDAOBorderoTitulos().saveOrUpdate(b);
                        continue block1;
                    }
                    continue;
                }
                CoreDAOFactory.getInstance().getDAOBorderoTitulos().delete(b);
            }
        }
        return logTitulos;
    }

    public Object salvarGrupoLogTitulos(CoreRequestContext r) throws ExceptionDatabase, ExceptionService, ExceptionGeracaoBoletos, Exception {
        GrupoLogTitulos grupoLogTitulos = (GrupoLogTitulos)r.getAttribute("grupoLogTitulos");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)r.getAttribute("opcoesFinanceiras");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return new AuxProcessarLogTitulos(grupoLogTitulos, opcoesFinanceiras, usuario).processar(empresa);
    }

    public Object findSaldoTitulosAbertos(CoreRequestContext request) throws ExceptionDatabase {
        Long idPessoa = (Long)request.getAttribute("idPessoa");
        return CoreDAOFactory.getInstance().getDAOTitulo().findSaldoTitulosAberto(idPessoa);
    }

    public Titulo salvarTituloAtualizado(CoreRequestContext request) throws ExceptionService {
        Titulo vo = (Titulo)request.getAttribute("titulo");
        String historicoFinal = (String)request.getAttribute("historicoFinal");
        CoreBdUtil.getInstance().getSession().evict((Object)vo);
        vo = (Titulo)ServiceTitulo.simpleSave(CoreDAOFactory.getInstance().getDAOTitulo(), vo);
        vo.setLoteAdLancamentos(CoreServiceFactory.getServiceLancamento().integrarTituloAdicional(vo, historicoFinal));
        return vo;
    }

    public Boolean existeBorderoPorTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().existeBorderosPorTitulo(t);
    }

    public Boolean existeBorderoPagamentoPorTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().existeBorderoPagamentoPorTitulo(t);
    }

    public Boolean existeBaixaTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().existeBaixaTitulo(t);
    }

    public List<BaixaTitulo> findBaixaTitulo(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Titulo vo = (Titulo)request.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().findBaixasPorTitulo(vo);
    }

    public List<BorderoTitulos> findBorderoPorTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().findBorderoPorTitulo(t);
    }

    public List<BorderoPagamento> findBorderoPagamentoPorTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().findBorderoPagamentoPorTitulo(t);
    }

    public List findRemessaPorTitulo(CoreRequestContext req) {
        Titulo t = (Titulo)req.getAttribute("titulo");
        return CoreDAOFactory.getInstance().getDAOTitulo().findRemessaPorTitulo(t);
    }

    public Boolean verificaDependenciasTitulo(CoreRequestContext req) throws ExceptionService {
        boolean ret;
        Titulo t = (Titulo)req.getAttribute("titulo");
        boolean bl = ret = t == null;
        if (ret) {
            return false;
        }
        ret = CoreDAOFactory.getInstance().getDAOTitulo().existeBaixaTitulo(t);
        if (ret) {
            return true;
        }
        ret = CoreDAOFactory.getInstance().getDAOTitulo().existeApuracaoComissaoPorTitulo(t);
        if (ret) {
            return true;
        }
        ret = CoreDAOFactory.getInstance().getDAOTitulo().existeBorderosPorTitulo(t);
        return ret;
    }

    public Object findValorTitulosNotaPropria(CoreRequestContext request) throws ExceptionDatabase {
        NotaFiscalPropria vo = (NotaFiscalPropria)request.getAttribute("notaFiscalPropria");
        return CoreDAOFactory.getInstance().getDAOTitulo().findValorTitulosNotaPropria(vo);
    }

    public Object existeTitulosVencidos(CoreRequestContext request) throws ExceptionDatabase {
        Long idPessoa = (Long)request.getAttribute("idPessoa");
        Date dataVencimento = (Date)request.getAttribute("dataVencimento");
        return CoreDAOFactory.getInstance().getDAOTitulo().existeTitulosVencidos(idPessoa, dataVencimento);
    }

    public Object atualizarTituloDaBaixa(CoreRequestContext request) throws ExceptionDatabase {
        List baixas = (List)request.getAttribute("baixas");
        for (BaixaTitulo b : baixas) {
            Titulo titulo = b.getTitulo();
            titulo = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(titulo);
            b.setTitulo(titulo);
        }
        return baixas;
    }

    public List<CentroCusto> findCentroCusto(CoreRequestContext req) {
        Empresa e = (Empresa)req.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOTitulo().findCentroCustoAnalitico(e);
    }

    public Object findUltimoTituloPorPessoa(CoreRequestContext req) throws ExceptionDatabase {
        Pessoa pessoa = (Pessoa)req.getAttribute("pessoa");
        return CoreDAOFactory.getInstance().getDAOTitulo().findUltimoTituloPorPessoa(pessoa);
    }

    public Object findTitulosPorDataEmissaoVencimento(CoreRequestContext req) throws ExceptionDatabase {
        Date dataEmissaoInicial = (Date)req.getAttribute("dataEmissaoInicial");
        Date dataEmissaoFinal = (Date)req.getAttribute("dataEmissaoFinal");
        Date dataVencimentoInicial = (Date)req.getAttribute("dataVencimentoInicial");
        Date dataVencimentoFinal = (Date)req.getAttribute("dataVencimentoFinal");
        Short exibirTitulosNotaPropria = (Short)req.getAttribute("exibirTitulosNotaPropria");
        Empresa empresa = (Empresa)req.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOTitulo().findTitulosPorDataEmissaoVencimento(dataEmissaoInicial, dataEmissaoFinal, dataVencimentoInicial, dataVencimentoFinal, exibirTitulosNotaPropria, empresa);
    }

    public Object findLogAlteracoesTitulos(CoreRequestContext request) throws ExceptionDatabase {
        Titulo titulo = (Titulo)request.getAttribute("titulo");
        return new AuxBuildLogTitulos(titulo).buildLogs();
    }

    public List<Titulo> findTitulosNFPropria(CoreRequestContext request) {
        Long nrNota = (Long)request.getAttribute("nrNota");
        Short parcela = (Short)request.getAttribute("parcela");
        return CoreDAOFactory.getInstance().getDAOTitulo().findTitulosNFPropria(nrNota, parcela);
    }

    public List<Titulo> findTitulosNFTerceiro(CoreRequestContext request) {
        Long nrNota = (Long)request.getAttribute("nrNota");
        Short parcela = (Short)request.getAttribute("parcela");
        return CoreDAOFactory.getInstance().getDAOTitulo().findTitulosNFTerceiros(nrNota, parcela);
    }

    public List<Titulo> findTitulosNFPropriaFaturamentoEntrada(CoreRequestContext request) {
        Long nrNota = (Long)request.getAttribute("nrNota");
        Short parcela = (Short)request.getAttribute("parcela");
        return CoreDAOFactory.getInstance().getDAOTitulo().findTitulosNFPropriaFaturamentoEntrada(nrNota, parcela);
    }

    public CarteiraCobranca findCarteiraCobrancaByColaborador(CoreRequestContext request) throws ExceptionService {
        CarteiraCobranca carteira = null;
        MovimentoFolha mov = (MovimentoFolha)request.getAttribute("mov");
        ContaSalarioColaborador contaColaborador = null;
        if (mov != null) {
            contaColaborador = UtilityArquivoCnab.getContaBancariaAtivaAndPreferencialByPessoa(mov.getColaborador().getPessoa().getContaSalarioColaborador());
        }
        if (mov != null && contaColaborador != null) {
            InstituicaoValores instValor = contaColaborador.getInstituicaoValor();
            Empresa empresa = mov.getColaborador().getEmpresa();
            carteira = CoreDAOFactory.getInstance().getDAOTitulo().findCarteiraCobrancaByColaborador(instValor, empresa);
        } else {
            InstituicaoValores instValor = (InstituicaoValores)request.getAttribute("instValor");
            Empresa empresa = (Empresa)request.getAttribute("empresa");
            carteira = CoreDAOFactory.getInstance().getDAOTitulo().findCarteiraCobrancaByColaborador(instValor, empresa);
        }
        return carteira;
    }

    public Object findTitulosAbertosPorPessoaAndPagRec(CoreRequestContext req) throws ExceptionDatabase {
        Pessoa pessoa = (Pessoa)req.getAttribute("pessoa");
        Short pagRec = (Short)req.getAttribute("pagRec");
        Empresa empresa = (Empresa)req.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOTitulo().findTitulosAbertosPorPessoaAndPagRec(pessoa, pagRec, empresa);
    }
}

