/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.transferenciacentroestoque;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.transferenciacentroestoque.GradeCorQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;

public class UtilTransfCentroEstoque {
    HashMap gerarTransferenciaInternal(TransferenciaCentroEstoque transfEst, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, List<GradeCorQTD> gc, Empresa emp, Date data) throws ExceptionService, ExceptionDatabase {
        List saldosDisponiveis = this.getSaldosDisponiveis(emp, centroEstoqueOrigem);
        LinkedList<ItemTransfCentroEstoque> itens = new LinkedList<ItemTransfCentroEstoque>();
        StringBuilder sb = new StringBuilder();
        for (GradeCorQTD p : gc) {
            sb.append(this.reservarEstoque(p, saldosDisponiveis, itens, centroEstoqueDestino, emp, centroEstoqueOrigem));
        }
        this.atualizaTotalizadores(itens);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("transferencia", this.geraTransferencia(transfEst, data, emp, centroEstoqueOrigem, centroEstoqueDestino, itens));
        String observacao = sb.toString();
        if (observacao.length() > 10000) {
            observacao = ToolString.subString((String)observacao, (int)10000);
        }
        h.put("observacao", observacao);
        return h;
    }

    private List getSaldosDisponiveis(Empresa emp, CentroEstoque centroEstoqueOrigem) throws ExceptionService {
        ArrayList lista = new ArrayList();
        List<SaldoEstoqueGeral> saldos = SaldoEstoqueUtilities.findSaldoGradeCentroEstoqueLoteLista(null, null, null, null, new Date(), null, centroEstoqueOrigem, centroEstoqueOrigem, emp, emp, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_LOTE_FABRICACAO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, null, centroEstoqueOrigem.getTipoEstProprioTerceiros(), null);
        Iterator<SaldoEstoqueGeral> iterator = saldos.iterator();
        while (iterator.hasNext()) {
            SaldoEstoqueGeral o;
            SaldoEstoqueGeral s = o = iterator.next();
            HashMap<String, Number> h = new HashMap<String, Number>();
            h.put("SALDO_QTD", s.getQuantidade());
            h.put("VLR_PRECO_MEDIO", s.getValorMedio());
            h.put("ID_LOTE_FABRICACAO", s.getLoteFabricacao().getIdentificador());
            h.put("ID_GRADE_COR", s.getGradeCor().getIdentificador());
            h.put("ID_C_ESTOQUE", s.getCentroEstoque().getIdentificador());
            lista.add(h);
        }
        return lista;
    }

    private String reservarEstoque(GradeCorQTD p, List<HashMap> saldosDisponiveis, List<ItemTransfCentroEstoque> itens, CentroEstoque reserva, Empresa emp, CentroEstoque centroEstoqueOrigem) throws ExceptionDatabase {
        Double qtdReservaBase;
        Double qtdReserva = qtdReservaBase = p.getQuantidade();
        GradeCor gc = p.getGradeCor();
        int i = 0;
        if (saldosDisponiveis.size() > 0) {
            do {
                HashMap h;
                Number idGradeCor;
                if ((idGradeCor = (Number)(h = saldosDisponiveis.get(i)).get("ID_GRADE_COR")).longValue() != gc.getIdentificador().longValue()) continue;
                qtdReserva = this.addReserva(qtdReserva, gc, h, itens, reserva, emp, centroEstoqueOrigem);
            } while (qtdReserva > 0.0 && ++i < saldosDisponiveis.size());
        }
        if (qtdReserva > 0.0) {
            return "N\u00e3o foi poss\u00edvel reservar a quantidade total para o item " + gc.getProdutoGrade().getProduto().getIdentificador() + "-" + gc.getProdutoGrade().getProduto().getCodigoAuxiliar() + "-" + gc.getProdutoGrade().getProduto().getNome() + ": Qtd/Falta: " + qtdReservaBase + " / " + qtdReserva + "\n";
        }
        return "";
    }

    private Double addReserva(Double qtdReserva, GradeCor gc, HashMap h, List<ItemTransfCentroEstoque> itens, CentroEstoque reserva, Empresa emp, CentroEstoque centroEstoqueOrigem) throws ExceptionDatabase {
        double aux;
        Number saldoQtdN = (Number)h.get("SALDO_QTD");
        Double saldoQtd = saldoQtdN != null ? saldoQtdN.doubleValue() : 0.0;
        if (saldoQtd > qtdReserva) {
            aux = 0.0;
            this.getTransfEstoquePCPLin(gc, itens, h, reserva, emp, qtdReserva, centroEstoqueOrigem);
            h.put("SALDO_QTD", saldoQtd - qtdReserva);
        } else {
            this.getTransfEstoquePCPLin(gc, itens, h, reserva, emp, saldoQtd, centroEstoqueOrigem);
            aux = qtdReserva - saldoQtd;
            h.put("SALDO_QTD", 0.0);
        }
        return aux;
    }

    private void getTransfEstoquePCPLin(GradeCor gc, List<ItemTransfCentroEstoque> itens, HashMap saldos, CentroEstoque reserva, Empresa emp, Double qtd, CentroEstoque centroEstoqueOrigem) throws ExceptionDatabase {
        Number valorPrecoMedioN = (Number)saldos.get("VLR_PRECO_MEDIO");
        Double valorPrecoMedio = valorPrecoMedioN != null ? valorPrecoMedioN.doubleValue() : 0.0;
        Number idLoteFabN = (Number)saldos.get("ID_LOTE_FABRICACAO");
        Long idLoteFab = idLoteFabN != null ? idLoteFabN.longValue() : 0L;
        Number idCentroEstoqueN = (Number)saldos.get("ID_C_ESTOQUE");
        Long idCentroEstoque = idCentroEstoqueN != null ? idCentroEstoqueN.longValue() : 0L;
        ItemTransfCentroEstoque item = new ItemTransfCentroEstoque();
        item.setDestino(reserva);
        item.setOrigem(centroEstoqueOrigem);
        item.setProduto(gc.getProdutoGrade().getProduto());
        item.setGradeItemTransCentroEst(new ArrayList());
        itens.add(item);
        GradeItemTransfCentroEstoque grade = new GradeItemTransfCentroEstoque();
        grade.setDataTransferencia(new Date());
        grade.setGradeCor(gc);
        grade.setItemTransfCentroEst(item);
        grade.setOrigem(item.getOrigem());
        grade.setDestino(item.getDestino());
        grade.setEmpresa(emp);
        item.getGradeItemTransCentroEst().add(grade);
        grade.setLoteFabricacao(this.getLoteFabricacao(idLoteFab));
        grade.setQuantidade(qtd);
    }

    private LoteFabricacao getLoteFabricacao(Long idLoteFab) throws ExceptionDatabase {
        return (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().findByPrimaryKey(idLoteFab);
    }

    private void atualizaTotalizadores(List<ItemTransfCentroEstoque> itens) {
        for (ItemTransfCentroEstoque itensTransf : itens) {
            double qtdTotal = 0.0;
            for (GradeItemTransfCentroEstoque gr : itensTransf.getGradeItemTransCentroEst()) {
                qtdTotal += gr.getQuantidade().doubleValue();
            }
            itensTransf.setQuantidadeTotal(Double.valueOf(qtdTotal));
        }
    }

    private Object geraTransferencia(TransferenciaCentroEstoque transfEst, Date data, Empresa emp, CentroEstoque centroEstoqueOrigem, CentroEstoque centroEstoqueDestino, List<ItemTransfCentroEstoque> itens) {
        if (transfEst == null) {
            transfEst = new TransferenciaCentroEstoque();
        }
        transfEst.setDataCadastro(new Date());
        transfEst.setDataTransferencia(data);
        transfEst.setDestino(centroEstoqueDestino);
        transfEst.setOrigem(centroEstoqueOrigem);
        transfEst.setEmpresa(emp);
        transfEst.setItemTransfCentroEstoque(itens);
        for (ItemTransfCentroEstoque iten : itens) {
            iten.setTransfCentroEstoque(transfEst);
            for (GradeItemTransfCentroEstoque g : iten.getGradeItemTransCentroEst()) {
                g.setItemTransfCentroEst(iten);
            }
        }
        return transfEst;
    }
}

