/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.transferenciacentroestoque;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.PlanejProdSobEncPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoProdSobEnc;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPSobEnc;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPSobEncItem;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilTransfCentroEstoquePCPEnc {
    HashMap gerarTransferencia(PlanejamentoProdSobEnc planejamento, CentroEstoque reserva, Empresa emp) throws ExceptionService, ExceptionDatabase {
        List saldosDisponiveis = this.getSaldosDisponiveis(emp);
        LinkedList<TransfEstoquePCPSobEncItem> itens = new LinkedList<TransfEstoquePCPSobEncItem>();
        if (planejamento.getLiberarReservaEstoque() == null || planejamento.getLiberarReservaEstoque() == 0) {
            throw new ExceptionService("Planejamento ainda n\u00e3o liberado para reserva de estoque.");
        }
        StringBuilder sb = new StringBuilder();
        for (PlanejProdSobEncPrevConsProd p : planejamento.getPrevisaoConsProdutos()) {
            sb.append(this.reservarEstoque(p, saldosDisponiveis, itens, reserva, emp));
        }
        this.atualizaTotalizadores(itens);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("itens", itens);
        h.put("observacao", sb.toString());
        return h;
    }

    private List getSaldosDisponiveis(Empresa emp) {
        Object st = "select  s.saldo_qtd as SALDO_QTD, s.valor_preco_medio as VLR_PRECO_MEDIO, s.ID_LOTE_FABRICACAO as ID_LOTE_FABRICACAO, s.id_grade_cor as ID_GRADE_COR, s.ID_C_ESTOQUE as ID_C_ESTOQUE from saldo_produto_detalhado(:tipo_inicial,:tipo_final,:produto_inicial,:produto_final,:data, :id_grade_cor_inicial,:id_grade_cor_final,:id_especie_inicial,:id_especie_final, :id_subespecie_inicial,:id_subespecie_final,:id_loc_inicial,:id_loc_final, :id_fab_inicial,:id_fab_final,:id_emp_inicial,:id_emp_final,:id_centro_inicial,:id_centro_final, null, :tipoSaldo, :tipoSaldoQtde, :tipoCarregamento,  null, :estoqueProprio, null) s inner join grade_cor g on g.id_grade_cor = s.id_grade_cor inner join cor c on c.id_cor = g.id_cor inner join produto_grade pg on pg.id_produto_grade=g.id_produto_grade inner join produto p on p.id_produto = pg.id_produto inner join lote_fabricacao l on l.id_lote_fabricacao = s.id_lote_fabricacao inner join centro_estoque cc on cc.id_centro_estoque = s.id_c_estoque left join especie e on e.id_especie = p.id_especie left join SUB_ESPECIE su on su.id_SUB_ESPECIE = p.id_SUB_ESPECIE left join unidade_medida u on p.id_unidade_medida = u.id_unidade_medida left join localizacao loc on p.id_localizacao = loc.id_localizacao where cc.TIPO_EST_PROPRIO_TERCEIROS = :estoqueProprio      and cc.TIPO_DISPONIBILIDADE = :estoqueDisponivel and s.saldo_qtd>0 ";
        st = (String)st + " order by p.nome";
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery q = s.createSQLQuery((String)st);
        q.setParameter("data", (Object)new Date());
        q.setParameter("tipo_inicial", (Object)0);
        q.setParameter("tipo_final", (Object)1);
        q.setParameter("produto_inicial", null);
        q.setParameter("produto_final", null);
        q.setParameter("id_grade_cor_inicial", (Object)0L);
        q.setParameter("id_grade_cor_final", (Object)999999999L);
        q.setParameter("id_especie_inicial", null);
        q.setParameter("id_especie_final", null);
        q.setParameter("id_subespecie_inicial", null);
        q.setParameter("id_subespecie_final", null);
        q.setParameter("id_loc_inicial", null);
        q.setParameter("id_loc_final", null);
        q.setParameter("id_fab_inicial", null);
        q.setParameter("id_fab_final", null);
        q.setParameter("id_emp_inicial", (Object)emp.getIdentificador());
        q.setParameter("id_emp_final", (Object)emp.getIdentificador());
        q.setParameter("id_centro_inicial", (Object)0L);
        q.setParameter("id_centro_final", (Object)999999L);
        q.setShort("estoqueProprio", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        q.setShort("estoqueDisponivel", EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL.getValue().shortValue());
        q.setInteger("tipoSaldo", 4);
        q.setInteger("tipoSaldoQtde", 2);
        q.setInteger("tipoCarregamento", 3);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private String reservarEstoque(PlanejProdSobEncPrevConsProd p, List<HashMap> saldosDisponiveis, List<TransfEstoquePCPSobEncItem> itens, CentroEstoque reserva, Empresa emp) throws ExceptionDatabase {
        Double qtdReservaBase;
        if (p.getEnviarParaReserva() == null || p.getEnviarParaReserva() == 0) {
            String erro = "O Produto " + p.getGradeCor().getProdutoGrade().getProduto().getIdentificador() + " - " + p.getGradeCor().getProdutoGrade().getProduto().getNome() + " Grade " + p.getGradeCor().getCor().getNome() + ", n\u00e3o foi marcado para reservar estoque.\n";
            return erro;
        }
        if (p.getQtdReserva() == null || p.getQtdReserva().equals(0.0)) {
            String erro = "O Produto " + p.getGradeCor().getProdutoGrade().getProduto().getIdentificador() + " - " + p.getGradeCor().getProdutoGrade().getProduto().getNome() + " Grade " + p.getGradeCor().getCor().getNome() + ", esta marcado para reservar estoque mas n\u00e3o possui a quantidade da reserva.\n";
            return erro;
        }
        Double qtdReserva = qtdReservaBase = p.getQtdReserva();
        GradeCor gc = p.getGradeCor();
        int i = 0;
        if (saldosDisponiveis.size() > 0) {
            do {
                HashMap h;
                Number idGradeCor;
                if ((idGradeCor = (Number)(h = saldosDisponiveis.get(i)).get("ID_GRADE_COR")).longValue() != gc.getIdentificador().longValue()) continue;
                qtdReserva = this.addReserva(qtdReserva, gc, h, itens, reserva, emp);
            } while (qtdReserva > 0.0 && ++i < saldosDisponiveis.size());
        }
        if (qtdReserva > 0.0) {
            return "N\u00e3o foi poss\u00edvel reservar a quantidade total para o item " + gc.getProdutoGrade().getProduto().getIdentificador() + "-" + gc.getProdutoGrade().getProduto().getCodigoAuxiliar() + "-" + gc.getProdutoGrade().getProduto().getNome() + ": Qtd/Falta: " + qtdReservaBase + " / " + qtdReserva + "\n";
        }
        return "";
    }

    private Double addReserva(Double qtdReserva, GradeCor gc, HashMap h, List<TransfEstoquePCPSobEncItem> itens, CentroEstoque reserva, Empresa emp) throws ExceptionDatabase {
        double aux;
        Number saldoQtdN = (Number)h.get("SALDO_QTD");
        Double saldoQtd = saldoQtdN != null ? saldoQtdN.doubleValue() : 0.0;
        if (saldoQtd > qtdReserva) {
            aux = 0.0;
            this.getTransfEstoquePCPLin(gc, itens, h, reserva, emp, qtdReserva);
            h.put("SALDO_QTD", saldoQtd - qtdReserva);
        } else {
            this.getTransfEstoquePCPLin(gc, itens, h, reserva, emp, saldoQtd);
            aux = qtdReserva - saldoQtd;
            h.put("SALDO_QTD", 0.0);
        }
        return aux;
    }

    private void getTransfEstoquePCPLin(GradeCor gc, List<TransfEstoquePCPSobEncItem> itens, HashMap saldos, CentroEstoque reserva, Empresa emp, Double qtd) throws ExceptionDatabase {
        Number valorPrecoMedioN = (Number)saldos.get("VLR_PRECO_MEDIO");
        Double valorPrecoMedio = valorPrecoMedioN != null ? valorPrecoMedioN.doubleValue() : 0.0;
        Number idLoteFabN = (Number)saldos.get("ID_LOTE_FABRICACAO");
        Long idLoteFab = idLoteFabN != null ? idLoteFabN.longValue() : 0L;
        Number idCentroEstoqueN = (Number)saldos.get("ID_C_ESTOQUE");
        Long idCentroEstoque = idCentroEstoqueN != null ? idCentroEstoqueN.longValue() : 0L;
        CentroEstoque origem = this.getCentroEstoqueOrigem(idCentroEstoque);
        TransfEstoquePCPSobEncItem transfItem = null;
        TransferenciaCentroEstoque transfEst = null;
        ItemTransfCentroEstoque item = null;
        GradeItemTransfCentroEstoque grade = null;
        for (TransfEstoquePCPSobEncItem aux : itens) {
            if (!aux.getCentroEstoqueOrin().equals((Object)origem)) continue;
            transfItem = aux;
            transfEst = aux.getTransferenciaCentroEst();
            block1: for (ItemTransfCentroEstoque itensTransf : aux.getTransferenciaCentroEst().getItemTransfCentroEstoque()) {
                if (!itensTransf.getProduto().equals((Object)gc.getProdutoGrade().getProduto())) continue;
                item = itensTransf;
                for (GradeItemTransfCentroEstoque gr : itensTransf.getGradeItemTransCentroEst()) {
                    if (!gr.getGradeCor().equals((Object)gc) || !gr.getLoteFabricacao().getIdentificador().equals(idLoteFab)) continue;
                    grade = gr;
                    continue block1;
                }
            }
        }
        if (transfItem == null) {
            transfItem = new TransfEstoquePCPSobEncItem();
            transfItem.setCentroEstoqueDest(reserva);
            transfItem.setCentroEstoqueOrin(origem);
            itens.add(transfItem);
        }
        if (transfEst == null) {
            transfEst = new TransferenciaCentroEstoque();
            transfEst.setDataCadastro(new Date());
            transfEst.setDataTransferencia(new Date());
            transfEst.setDestino(reserva);
            transfEst.setOrigem(origem);
            transfItem.setCentroEstoqueOrin(origem);
            transfEst.setEmpresa(emp);
            transfEst.setItemTransfCentroEstoque(new ArrayList());
            transfItem.setTransferenciaCentroEst(transfEst);
        }
        if (item == null) {
            item = new ItemTransfCentroEstoque();
            item.setDestino(reserva);
            item.setOrigem(origem);
            item.setProduto(gc.getProdutoGrade().getProduto());
            item.setTransfCentroEstoque(transfEst);
            item.setGradeItemTransCentroEst(new ArrayList());
            transfEst.getItemTransfCentroEstoque().add(item);
        }
        if (grade == null) {
            grade = new GradeItemTransfCentroEstoque();
            grade.setDataTransferencia(transfEst.getDataTransferencia());
            grade.setGradeCor(gc);
            grade.setItemTransfCentroEst(item);
            grade.setOrigem(item.getOrigem());
            grade.setDestino(item.getDestino());
            grade.setEmpresa(transfEst.getEmpresa());
            item.getGradeItemTransCentroEst().add(grade);
        }
        grade.setLoteFabricacao(this.getLoteFabricacao(idLoteFab));
        grade.setQuantidade(qtd);
    }

    private CentroEstoque getCentroEstoqueOrigem(Long idCentroEstoque) throws ExceptionDatabase {
        return (CentroEstoque)CoreDAOFactory.getInstance().getDAOCentroEstoque().findByPrimaryKey(idCentroEstoque);
    }

    private LoteFabricacao getLoteFabricacao(Long idLoteFab) throws ExceptionDatabase {
        return (LoteFabricacao)CoreDAOFactory.getInstance().getDAOLoteFabricacao().findByPrimaryKey(idLoteFab);
    }

    private void atualizaTotalizadores(List<TransfEstoquePCPSobEncItem> itens) {
        for (TransfEstoquePCPSobEncItem aux : itens) {
            for (ItemTransfCentroEstoque itensTransf : aux.getTransferenciaCentroEst().getItemTransfCentroEstoque()) {
                double qtdTotal = 0.0;
                for (GradeItemTransfCentroEstoque gr : itensTransf.getGradeItemTransCentroEst()) {
                    qtdTotal += gr.getQuantidade().doubleValue();
                }
                itensTransf.setQuantidadeTotal(Double.valueOf(qtdTotal));
            }
        }
    }

    void excluirTransfCentroEstoquePcpEnc(TransfEstoquePCPSobEnc transPcp) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (TransfEstoquePCPSobEncItem item : transPcp.getTransferencias()) {
            TransferenciaCentroEstoque transf = item.getTransferenciaCentroEst();
            item.setTransfEstoqueSobEnc(null);
            s.saveOrUpdate((Object)item);
            s.saveOrUpdate((Object)transf);
            s.delete((Object)transf);
            s.delete((Object)item);
        }
        s.delete((Object)transPcp);
    }
}

