/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.unificacaopedido;

import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.RotaClientePedidoPedido;
import com.touchcomp.basementor.model.vo.UnificacaoPedido;
import contatocore.util.ContatoFormatUtil;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;

public class ServiceUnificacaoPedido
extends CoreService {
    public static final String SALVAR_UNIFICACAO_PEDIDO = "salvarUnificacaoPedido";

    public Object salvarUnificacaoPedido(CoreRequestContext r) throws ExceptionDatabase {
        UnificacaoPedido vo = (UnificacaoPedido)r.getAttribute("unificacaoPedido");
        List rotasExcluidas = (List)r.getAttribute("rotasASeremExcluidas");
        StringBuilder sb = new StringBuilder();
        for (Pedido p : vo.getPedidosUnificados()) {
            sb.append("Pedido Unificado: ");
            sb.append(p.getIdentificador());
            sb.append("   Data Emissao: ");
            sb.append(DateUtil.dateToStr(p.getDataEmissao()));
            sb.append("   Valor Total: ");
            sb.append(ContatoFormatUtil.formataNumero((Number)p.getValorTotal(), (int)2));
            sb.append("   Perc. Comissao: ");
            sb.append(ContatoFormatUtil.formataNumero((Number)p.getPercComissao(), (int)2));
            sb.append("\n");
            for (ItemPedido i : p.getItemPedido()) {
                sb.append("Id. Item: ");
                sb.append(i.getIdentificador());
                sb.append("  Id. Produto: ");
                sb.append(i.getProduto().getIdentificador());
                sb.append("  Qtde: ");
                sb.append(ContatoFormatUtil.formataNumero((Number)i.getQuantidadeTotal(), (int)2));
                sb.append("  Vr Total: ");
                sb.append(ContatoFormatUtil.formataNumero((Number)i.getValorTotal(), (int)2));
                sb.append("  Perc. Comissao: ");
                sb.append(ContatoFormatUtil.formataNumero((Number)i.getPercComissao(), (int)2));
                sb.append("\n");
            }
            sb.append("\n");
        }
        vo.setObservacao(sb.toString());
        if (vo.getObservacao().length() > 10000) {
            vo.setObservacao(vo.getObservacao().substring(0, 9999));
        }
        vo = (UnificacaoPedido)CoreDAOFactory.getInstance().getDAOUnificacaoPedido().saveOrUpdate(vo);
        for (RotaClientePedidoPedido rc : rotasExcluidas) {
            rc = (RotaClientePedidoPedido)CoreDAOFactory.getInstance().getDAORotaClientePedidoPedido().findByPrimaryKey(rc.getIdentificador());
            CoreDAOFactory.getInstance().getDAORotaClientePedidoPedido().delete(rc);
        }
        return vo;
    }
}

