/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.vendas;

import com.touchcomp.basementor.model.vo.LogAlteracaoTabPrecoBase;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

class AuxImportarTabela {
    private static final TLogger logger = TLogger.get(AuxImportarTabela.class);

    CoreRequestContext importarTabela(String pathFile, TabelaPrecoBase tabelaBase, Integer linhaIn, Integer linhaFim, Integer custo, Integer venda, Integer percMinimo, Integer percMaximo, Integer comissao, Integer bonus, Integer codProduto, Integer tipoPesq, Integer vlrMinimo, Integer vlrMaximo, Integer percDescTribInd) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        ArrayList<LogAlteracaoTabPrecoBase> logs = new ArrayList<LogAlteracaoTabPrecoBase>();
        try {
            File f = new File(pathFile);
            if (!f.exists() || f.isDirectory()) {
                throw new ExceptionService("Arquivo invalido");
            }
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(f));
            HSSFSheet sh = workbook.getSheetAt(0);
            if (linhaFim - 1 > sh.getLastRowNum()) {
                throw new ExceptionService("A linha final informada \u00e9 maior que o numero de linhas no arquivo.");
            }
            for (int i = linhaIn.intValue(); i <= linhaFim; ++i) {
                Produto prod;
                HSSFRow row = sh.getRow(i - 1);
                Double vrCusto = this.getCell(custo - 1, row).getNumericCellValue();
                Double vrVenda = this.getCell(venda - 1, row).getNumericCellValue();
                Double vrPercMinimo = this.getCell(percMinimo - 1, row).getNumericCellValue();
                Double vrPercMaximo = this.getCell(percMaximo - 1, row).getNumericCellValue();
                Double vrMinimo = this.getCell(vlrMinimo - 1, row).getNumericCellValue();
                Double vrMaximo = this.getCell(vlrMaximo - 1, row).getNumericCellValue();
                Double vrPercComissao = this.getCell(comissao - 1, row).getNumericCellValue();
                Double vrPercBonus = this.getCell(bonus - 1, row).getNumericCellValue();
                Double percDescTrib = 0.0;
                if (percDescTribInd != null && percDescTribInd > 0) {
                    percDescTrib = this.getCell(percDescTribInd - 1, row).getNumericCellValue();
                }
                if (tipoPesq == 1) {
                    cell = this.getCell(codProduto - 1, row);
                    cell.setCellType(1);
                    String codAuxProd = cell.getCellTypeEnum() == CellType.STRING ? cell.getStringCellValue() : String.valueOf(cell.getNumericCellValue());
                    prod = this.findProduto(codAuxProd);
                    if (prod == null) {
                        sb.append(codAuxProd).append(" nao encontrado\n, ");
                    }
                } else if (tipoPesq == 0) {
                    cell = this.getCell(codProduto - 1, row);
                    cell.setCellType(0);
                    Double idProd = cell.getCellTypeEnum() == CellType.NUMERIC ? Double.valueOf(cell.getNumericCellValue()) : Double.valueOf(cell.getStringCellValue());
                    prod = this.findProduto(idProd);
                    if (prod == null) {
                        sb.append(idProd).append(" nao encontrado\n, ");
                    }
                } else {
                    cell = this.getCell(codProduto - 1, row);
                    cell.setCellType(1);
                    String codRefProd = cell.getCellTypeEnum() == CellType.STRING ? cell.getStringCellValue() : String.valueOf(cell.getNumericCellValue());
                    prod = this.findProdutoCodigoRef(codRefProd);
                    if (prod == null) {
                        sb.append(codRefProd).append(" nao encontrado\n, ");
                    }
                }
                if (prod == null) continue;
                TabelaPrecoBaseProduto tprod = this.getTabelaPrecoBaseProd(tabelaBase, prod);
                if (tprod == null) {
                    tprod = new TabelaPrecoBaseProduto();
                    tprod.setAtivo(Short.valueOf((short)1));
                    tprod.setProduto(prod);
                    tprod.setTabelaPrecoBase(tabelaBase);
                    tabelaBase.getProdutos().add(tprod);
                }
                tprod.setPercComissaoPadrao(vrPercComissao);
                tprod.setPercentualDescTrib(percDescTrib);
                tprod.setPercMaximo(vrPercMaximo);
                tprod.setPercMinimo(vrPercMinimo);
                tprod.setValorMaximo(vrMaximo);
                tprod.setValorMinimo(vrMinimo);
                tprod.setValorCusto(vrCusto);
                tprod.setValorVenda(vrVenda);
                tprod.setMargemLucro(this.getMargemLucro(tprod));
                if (vrPercMinimo > 100.0) {
                    throw new ExceptionService("Percentual minimo deve ser menor que 100%");
                }
                if (vrPercMaximo > 999.0) {
                    throw new ExceptionService("Percentual maximo deve ser menor que 1000%");
                }
                LogAlteracaoTabPrecoBase logAlt = new LogAlteracaoTabPrecoBase();
                logAlt.setDataAlteracao(new Date());
                logAlt.setTabelaPrecoBaseProduto(tprod);
                logAlt.setValorCusto(tprod.getValorCusto());
                logAlt.setValorVenda(tprod.getValorVenda());
                logs.add(logAlt);
            }
            CoreRequestContext cq = new CoreRequestContext();
            cq.setAttribute("tabelaPrecoBase", tabelaBase);
            cq.setAttribute("logs", logs);
            cq.setAttribute("produtosNaoEncontrados", sb.toString());
            return cq;
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao ler o arquivo.", ex);
        }
        catch (ExceptionDatabase ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao pesquisar os dados.", ex);
        }
    }

    private Double getMargemLucro(TabelaPrecoBaseProduto vo) {
        Double valorCusto = vo.getValorCusto();
        Double valorVenda = vo.getValorVenda();
        Double margemLucro = 0.0;
        if (valorCusto > 0.0) {
            margemLucro = (valorVenda - valorCusto) * 100.0 / valorCusto;
        }
        return margemLucro;
    }

    private Produto findProduto(Double idProd) throws ExceptionDatabase {
        return (Produto)CoreDAOFactory.getInstance().getDAOProduto().findByPrimaryKey(idProd.longValue());
    }

    private Produto findProduto(String codAuxProd) {
        return CoreDAOFactory.getInstance().getDAOProduto().pesquisarProduto(codAuxProd);
    }

    private Produto findProdutoCodigoRef(String codAuxProd) {
        return CoreDAOFactory.getInstance().getDAOProduto().pesquisarProdutoCodigoReferencia(codAuxProd);
    }

    private TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecoBase tabelaBase, Produto prod) {
        for (TabelaPrecoBaseProduto t : tabelaBase.getProdutos()) {
            if (!t.getProduto().equals((Object)prod)) continue;
            return t;
        }
        return null;
    }

    private HSSFCell getCell(int index, HSSFRow row) throws ExceptionService {
        try {
            return row.getCell(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionService("Erro ao recuperar a celula " + index + " na linha " + row.getRowNum() + ". Verifique se a mesma existe.", e);
        }
    }
}

