/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.vendas;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.LogAlteracaoTabPrecoBase;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.vendas.AuxImportarTabela;
import mentorcore.service.impl.vendas.UtilTabelaPrecoBase;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceTabelaPrecoBase
extends CoreService {
    public static final String IMPORTAR_TABELA_EXCEL = "importarTabelaExcel";
    public static final String DELETE_TABELA = "deletarTabela";
    public static String GET_LOG_PRODUTO = "getLogProduto";
    public static String GERAR_LISTAGEM_TABELA_PRECO_BASE_COM_VALOR_LIQUIDO = "gerarListagemTabelaPrecoBaseComValorLiquido";
    public static final String ATUALIZAR_PRECO_MIN_MAX = "atualizarValoresMinMax";
    public static final String GET_PROD_TABELA_BY_DESC = "getProdTabelaByDesc";
    public static final String GET_PROD_TABELA_BY_ID = "getProdTabelaById";

    public String importarTabelaExcel(CoreRequestContext request) throws ExceptionService {
        String pathFile = (String)request.getAttribute("pathFile");
        TabelaPrecoBase tabelaBase = (TabelaPrecoBase)request.getAttribute("tabelaBase");
        Integer linhaIn = (Integer)request.getAttribute("linhaIn");
        Integer linhaFim = (Integer)request.getAttribute("linhaFim");
        Integer custo = (Integer)request.getAttribute("custo");
        Integer venda = (Integer)request.getAttribute("venda");
        Integer percMinimo = (Integer)request.getAttribute("percMinimo");
        Integer percMaximo = (Integer)request.getAttribute("percMaximo");
        Integer vlrMinimo = (Integer)request.getAttribute("vlrMinimo");
        Integer vlrMaximo = (Integer)request.getAttribute("vlrMaximo");
        Integer comissao = (Integer)request.getAttribute("comissao");
        Integer bonus = (Integer)request.getAttribute("bonus");
        Integer codProduto = (Integer)request.getAttribute("codProduto");
        Integer percDescTrib = (Integer)request.getAttribute("percDescTrib");
        Integer tipoPesq = (Integer)request.getAttribute("tipoPesq");
        CoreRequestContext cq = new AuxImportarTabela().importarTabela(pathFile, tabelaBase, linhaIn, linhaFim, custo, venda, percMinimo, percMaximo, comissao, bonus, codProduto, tipoPesq, vlrMinimo, vlrMaximo, percDescTrib);
        ServiceTabelaPrecoBaseImpl service = this.getBean(ServiceTabelaPrecoBaseImpl.class);
        service.saveOrUpdate((InterfaceVO)tabelaBase);
        return (String)cq.getAttribute("produtosNaoEncontrados");
    }

    public TabelaPrecoBase deletarTabela(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        TabelaPrecoBase tabelaPrecoBase = (TabelaPrecoBase)request.getAttribute("tabelaPrecos");
        CoreDAOFactory.getInstance().getDAOLogTabPrecoBase().deleteLogs(tabelaPrecoBase);
        CoreDAOFactory.getInstance().getDAOTabelaPrecoBase().delete(tabelaPrecoBase);
        return null;
    }

    public List<LogAlteracaoTabPrecoBase> getLogProduto(CoreRequestContext request) {
        Long idProduto = (Long)request.getAttribute("idProduto");
        Long idTabela = (Long)request.getAttribute("idTabelaPrecoBase");
        Short filtrarData = (Short)request.getAttribute("filtrarData");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        if (dataFinal == null) {
            dataFinal = new Date();
        }
        return CoreDAOFactory.getInstance().getDAOLogTabPrecoBase().getLogTableProduct(idProduto, idTabela, filtrarData, dataInicial, dataFinal);
    }

    public JasperPrint gerarListagemTabelaPrecoBaseComValorLiquido(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        TipoFrete tipoFrete = (TipoFrete)request.getAttribute("tipoFrete");
        NaturezaOperacao naturezaOperacao = (NaturezaOperacao)request.getAttribute("naturezaOperacao");
        UnidadeFatCliente cliente = (UnidadeFatCliente)request.getAttribute("cliente");
        Representante representante = (Representante)request.getAttribute("representante");
        List condicaoPagamento = (List)request.getAttribute("condicaoPagamento");
        OpcoesFaturamento opcoesFaturamento = (OpcoesFaturamento)request.getAttribute("opcoesFaturamento");
        OpcoesImpostos opcoesImposto = (OpcoesImpostos)request.getAttribute("opcoesImposto");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)request.getAttribute("empresaContabilidade");
        TabelaPrecoBase tabelaPrecoBase = (TabelaPrecoBase)request.getAttribute("tabalePreco");
        String fecho = (String)request.getAttribute("fecho");
        Nodo nodo = (Nodo)request.getAttribute("nodo");
        HashMap params = (HashMap)request.getAttribute("parametros");
        Short filtrarSubEspecie = (Short)request.getAttribute("filtrarSubEspecie");
        Long idSubEspecieFinal = (Long)request.getAttribute("idSubEspecieFinal");
        Long idSubEspecieInicial = (Long)request.getAttribute("idSubEspecieInicial");
        Short ordenacao = (Short)request.getAttribute("ordenacao");
        Short agruparSubEspecie = (Short)request.getAttribute("agruparSubEspecie");
        String grupoCondPag = (String)request.getAttribute("condPagamento");
        Long idGrupoCondPag = (Long)request.getAttribute("idGrupoCondPag");
        Short filtrarFabricante = (Short)request.getAttribute("filtrarFabricante");
        Long fabricanteInicial = (Long)request.getAttribute("fabricanteInicial");
        Long favricanteFinal = (Long)request.getAttribute("favricanteFinal");
        return new UtilTabelaPrecoBase().gerarRelatorio(tipoFrete, naturezaOperacao, cliente, representante, condicaoPagamento, opcoesFaturamento, empresa, empresaContabilidade, tabelaPrecoBase, filtrarSubEspecie, idSubEspecieInicial, idSubEspecieFinal, ordenacao, fecho, nodo, params, agruparSubEspecie, idGrupoCondPag, grupoCondPag, filtrarFabricante, fabricanteInicial, favricanteFinal, opcoesImposto);
    }

    public TabelaPrecoBase atualizarValoresMinMax(CoreRequestContext request) throws ExceptionDatabase {
        TabelaPrecoBase vo = (TabelaPrecoBase)request.getAttribute("tabelaPrecoBase");
        for (TabelaPrecoBaseProduto p : vo.getProdutos()) {
            p.setValorMinimo(p.getValorVenda());
            p.setValorMaximo(p.getValorVenda());
        }
        vo = (TabelaPrecoBase)CoreDAOFactory.getInstance().getDAOTabelaPrecoBase().saveOrUpdate(vo);
        return vo;
    }

    public List<HashMap> getProdTabelaByDesc(CoreRequestContext request) {
        String texto = (String)request.getAttribute("texto");
        TabelaPrecoBase tabelaPreco = (TabelaPrecoBase)request.getAttribute("tabelaPreco");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOTabelaPrecoBaseProduto().buscarProdTabelaByDesc(texto, tabelaPreco, empresa);
    }

    public List<HashMap> getProdTabelaById(CoreRequestContext request) {
        Long idProduto = (Long)request.getAttribute("idProduto");
        TabelaPrecoBase tabelaPreco = (TabelaPrecoBase)request.getAttribute("tabelaPreco");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOTabelaPrecoBaseProduto().buscarProdTabelaById(idProduto, tabelaPreco, empresa);
    }
}

