/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.vendas;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstTipoTabelaPreco;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TabelaDescFinancProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaPropria;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.query.Query;

public class UtilTabelaPrecoBase {
    private final TLogger logger = TLogger.get(UtilTabelaPrecoBase.class);

    JasperPrint gerarRelatorio(TipoFrete tipoFrete, NaturezaOperacao naturezaOperacao, UnidadeFatCliente cliente, Representante representante, List<CondicoesPagamento> condicaoPagamento, OpcoesFaturamento opcoesFaturamento, Empresa empresa, EmpresaContabilidade empresaContabilidade, TabelaPrecoBase tabelaPrecoBase, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal, Short ordenacao, String fecho, Nodo nodo, HashMap params, Short agruparSubEspecie, Long idGrupoCondPag, String grupoCondPag, Short filtrarFabricante, Long fabricanteInicial, Long fabricanteFinal, OpcoesImpostos opImpostos) throws ExceptionService {
        ArrayList<SubEspecie> subEspecies = new ArrayList();
        if (filtrarSubEspecie.equals((short)1)) {
            subEspecies = this.findFiltroSubEspecie(idSubEspecieInicial, idSubEspecieFinal);
        }
        ArrayList<Fabricante> listaFabricante = new ArrayList();
        if (filtrarFabricante == 1) {
            listaFabricante = this.findFiltroFabricante(fabricanteInicial, fabricanteFinal);
        }
        List<HashMap> list = this.gerarValorTabelaPrecoBasePorProduto(tipoFrete, naturezaOperacao, cliente, representante, condicaoPagamento, opcoesFaturamento, empresa, empresaContabilidade, tabelaPrecoBase, subEspecies, listaFabricante, opImpostos);
        params.put("P_ID_TABELA_PRECO", tabelaPrecoBase.getIdentificador());
        params.put("P_TABELA_PRECO", tabelaPrecoBase.getDescricao());
        params.put("P_AGRUPAR_SUB_ESPECIE", agruparSubEspecie);
        params.put("P_FILTRAR_SUB_ESPECIE", filtrarSubEspecie);
        params.put("P_ID_SUB_ESPECIE_INICIAL", idSubEspecieInicial);
        params.put("P_ID_SUB_ESPECIE_FINAL", idSubEspecieFinal);
        params.put("P_ID_GRUPO_COND_PAG", idGrupoCondPag);
        params.put("P_GRUPO_COND_PAG", grupoCondPag);
        params.put("P_ORDENACAO", ordenacao);
        params.put("FECHO", fecho);
        params.put("P_FILTRAR_FABRICANTE", filtrarFabricante);
        params.put("P_FABRICANTE_INICIAL", fabricanteInicial);
        params.put("P_FABRICANTE_FINAL", fabricanteFinal);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo).setAttribute("isPaisagem", true), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "vendas" + File.separator + "tabelaprecobase" + File.separator + "listagemtabelaprecocomvalorliquido" + File.separator + "LISTAGEM_TABELA_PRECO_COM_VALOR_LIQUIDO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", this.getDadosOrdenados(list, ordenacao, agruparSubEspecie));
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List<HashMap> gerarValorTabelaPrecoBasePorProduto(TipoFrete tipoFrete, NaturezaOperacao naturezaOperacao, UnidadeFatCliente cliente, Representante representante, List<CondicoesPagamento> condicaoPagamento, OpcoesFaturamento opcoesFaturamento, Empresa empresa, EmpresaContabilidade empresaContabilidade, TabelaPrecoBase tabelaPrecoBase, List<SubEspecie> subEspecies, List<Fabricante> listaFabricante, OpcoesImpostos opImpostos) throws ExceptionService {
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        for (TabelaPrecoBaseProduto tProd : tabelaPrecoBase.getProdutos()) {
            if (!tProd.getAtivo().equals((short)1) || !subEspecies.isEmpty() && !subEspecies.contains(tProd.getProduto().getSubEspecie()) || !listaFabricante.isEmpty() && !listaFabricante.contains(tProd.getProduto().getFabricante())) continue;
            HashMap<String, Object> hs = new HashMap<String, Object>();
            hs.put("F_ID_PRODUTO", tProd.getProduto().getIdentificador());
            hs.put("F_NOME_PRODUTO", tProd.getProduto().getNome());
            hs.put("F_UNIDADE_MEDIDA", tProd.getProduto().getUnidadeMedida().getSigla());
            hs.put("F_ID_SUB_ESPECIE", tProd.getProduto().getSubEspecie().getIdentificador());
            hs.put("F_SUB_ESPECIE", tProd.getProduto().getSubEspecie().getNome());
            int indiceCondicao = 1;
            for (CondicoesPagamento cp : condicaoPagamento) {
                Double percComissao;
                Double qtdeTotal = 1.0;
                HashMap<String, Object> h = new HashMap<String, Object>();
                h.put("produto", tProd.getProduto());
                h.put("cliente", cliente);
                h.put("empresa", empresa);
                h.put("opcoesFaturamento", opcoesFaturamento);
                h.put("opcoesImposto", opImpostos);
                h.put("empresaContabil", empresaContabilidade);
                h.put("naturezaOperacao", naturezaOperacao);
                h.put("percComissao", tProd.getPercComissaoPadrao());
                h.put("valorVenda", tProd.getValorVenda());
                h.put("valorMinimo", tProd.getValorVenda() - tProd.getValorVenda() * (tProd.getPercMinimo() / 100.0));
                h.put("valorMaximo", tProd.getValorVenda() + tProd.getValorVenda() * (tProd.getPercMaximo() / 100.0));
                h.put("valorCusto", tProd.getValorCusto());
                h.put("percComissao", 0.0);
                this.calcularValorComissaoMinorado(cp, h);
                this.calcularValoresMajorados(h, cp, opcoesFaturamento);
                this.calculaValoresFrete(tipoFrete, h);
                if (opcoesFaturamento.getTipoTabelaPreco().shortValue() == EnumConstTipoTabelaPreco.TABELA_BASE.getValue() && opcoesFaturamento.getPermitirMultiplasComissoes() == 1 && (percComissao = this.calculaComissaoMultiplasBases(tProd.getProduto(), new Date(), cliente.getPessoa().getEndereco().getCidade().getUf(), opcoesFaturamento.getMoeda(), opcoesFaturamento, (Double)h.get("valorVenda"))) != null) {
                    h.put("percComissao", percComissao);
                }
                this.putTabelaDescFinanceiro(tProd.getProduto(), cliente.getCliente().getClassificacaoClientes(), new Date(), h, opcoesFaturamento);
                this.arredondarValores(opcoesFaturamento, h);
                h.put("valorTotal", (Double)h.get("valorVenda") * qtdeTotal);
                h.put("valorComissao", (Double)h.get("valorVenda") * qtdeTotal * ((Double)h.get("percComissao") / 100.0));
                h.put("vlrUnitario", h.get("valorVenda"));
                this.calcularImpostos(h, opcoesFaturamento);
                h.put("condicaoPagamento", cp);
                this.getFieldsRelatorio(h, hs, indiceCondicao);
                ++indiceCondicao;
            }
            ret.add(hs);
        }
        return ret;
    }

    private void calcularImpostos(HashMap h, OpcoesFaturamento opcoesFaturamento) {
        if (h != null) {
            try {
                UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)h.get("cliente");
                NaturezaOperacao naturezaOperacao = (NaturezaOperacao)h.get("naturezaOperacao");
                List<ItemNotaFiscalPropria> itens = new ArrayList();
                List<ModeloFiscal> modelos = this.findModelosFiscais(h);
                for (ModeloFiscal m : modelos) {
                    ItemNotaFiscalPropria i = new ItemNotaFiscalPropria();
                    ItemNotaLivroFiscal il = new ItemNotaLivroFiscal();
                    il.setItemNotaFiscalPropria(i);
                    i.setItemNotaLivroFiscal(il);
                    i.setModeloFiscal(m);
                    i.setProduto((Produto)h.get("produto"));
                    i.setQuantidadeTotal(Double.valueOf(1.0));
                    i.setValorUnitario(Double.valueOf((Double)h.get("vlrUnitario") != null ? (Double)h.get("vlrUnitario") : 0.0));
                    i.setVrProduto(Double.valueOf((Double)h.get("valorTotal") != null ? (Double)h.get("valorTotal") : 0.0));
                    i.setCest(i.getProduto().getCest());
                    i.setNcm(i.getProduto().getNcm());
                    this.procurarCFOP(i, naturezaOperacao, unidadeFatCliente, h, opcoesFaturamento);
                    this.procurarAliquotaICMS(i, unidadeFatCliente, h, naturezaOperacao);
                    this.procurarPercRedBC(i);
                    this.mostrarDadosIpi(i);
                    this.mostrarDadosIcms(i);
                    this.mostrarDadosIcmsSt(i);
                    this.mostrarDadosPisCofins(i);
                    this.mostrarOutrasAliquotas(i);
                    new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(i, opcoesFaturamento.getEmpresa(), new Date(), naturezaOperacao, unidadeFatCliente);
                    h.put("item", i);
                    itens.add(i);
                }
                if (modelos != null && !modelos.isEmpty()) {
                    ModeloFiscal mf = modelos.get(0);
                    h.put("idModeloFiscal", mf.getIdentificador());
                    h.put("cst", mf.getModeloFiscalIcms().getIncidenciaIcms().getCodigo());
                }
                itens = new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(itens, ((Empresa)h.get("empresa")).getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente, this.getSituacaoDocumento(), (Empresa)h.get("empresa"), unidadeFatCliente.getCliente().getFaturamento().getTipoConsumidor(), (OpcoesFaturamento)h.get("opcoesFaturamento"), new Date(), (EmpresaContabilidade)h.get("empresaContabil"), (OpcoesImpostos)h.get("opcoesImposto"), naturezaOperacao);
                for (ItemNotaFiscalPropria i : itens) {
                    if (!h.get("item").equals(i)) continue;
                    h.put("valorLiquido", i.getItemNotaLivroFiscal().getValorTotal());
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
            }
        }
    }

    private List<ModeloFiscal> findModelosFiscais(HashMap h) {
        if (h.get("naturezaOperacao") != null && h.get("produto") != null && h.get("cliente") != null) {
            UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)h.get("cliente");
            NaturezaOperacao natOperacao = (NaturezaOperacao)h.get("naturezaOperacao");
            try {
                HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
                List mods = helper.getModelosFiscais((Produto)h.get("produto"), unidadeFatCliente, natOperacao, (Empresa)h.get("empresa"));
                return mods;
            }
            catch (ExceptionObjNotFound ex) {
                this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            }
        }
        return new ArrayList<ModeloFiscal>();
    }

    private SituacaoDocumento getSituacaoDocumento() {
        try {
            CoreRequestContext cq = new CoreRequestContext();
            cq.setAttribute("codigo", "00");
            return (SituacaoDocumento)CoreServiceFactory.getServiceSituacaoDocumento().execute(cq, "getSituacaoDocumento");
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            return null;
        }
    }

    private void calcularValorComissaoMinorado(CondicoesPagamento condicoesPagamento, HashMap h) {
        Double percComissao = (Double)h.get("percComissao");
        if (condicoesPagamento == null || condicoesPagamento.getMinoracaoComissao() == null || condicoesPagamento.getMinoracaoComissao() <= 0.0) {
            return;
        }
        if (condicoesPagamento.getCondMutante() != null && condicoesPagamento.getCondMutante() == 1) {
            int nrDiasMedios = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).calcularNrDiasMedios(condicoesPagamento, condicoesPagamento.getParcelasMutante());
            double percComissaoMinorado = percComissao * condicoesPagamento.getMinoracaoComissao() / 30.0 * ((double)nrDiasMedios / 100.0);
            percComissao = percComissao - percComissaoMinorado;
        } else {
            int numParc = condicoesPagamento.getNumeroParcelas();
            if (condicoesPagamento.getEntrada() != null && condicoesPagamento.getEntrada() == 1) {
                --numParc;
            }
            if (numParc > 0) {
                int prazo = 0;
                for (int i = 1; i <= numParc; ++i) {
                    prazo += i * condicoesPagamento.getNumeroDiasVencimento();
                }
                double percReaj = condicoesPagamento.getMinoracaoComissao() / 30.0 * (double)(prazo / numParc);
                if ((percComissao = Double.valueOf(percComissao - percComissao * (percReaj / 100.0))) < 0.0) {
                    percComissao = 0.0;
                }
            }
        }
        h.put("percComissao", percComissao);
    }

    private void calcularValoresMajorados(HashMap h, CondicoesPagamento condicao, OpcoesFaturamento opFat) {
        Double valorVenda = (Double)h.get("valorVenda");
        Double percComissao = (Double)h.get("percComissao");
        Double valorMinimo = (Double)h.get("valorMinimo");
        Double valorMaximo = (Double)h.get("valorMaximo");
        if (ToolMethods.isEquals((Object)opFat.getAplicarMajoracaoPrecoFechamentoPedido(), (Object)0)) {
            valorMaximo = CoreUtilityFactory.getUtilityCondicoesPagamento().calcularValorTotalMajorado(valorMaximo, condicao, condicao.getParcelasMutante());
            valorVenda = CoreUtilityFactory.getUtilityCondicoesPagamento().calcularValorTotalMajorado(valorVenda, condicao, condicao.getParcelasMutante());
            valorMinimo = CoreUtilityFactory.getUtilityCondicoesPagamento().calcularValorTotalMajorado(valorMinimo, condicao, condicao.getParcelasMutante());
        }
        h.put("valorVenda", valorVenda);
        h.put("percComissao", percComissao);
        h.put("valorMinimo", valorMinimo);
        h.put("valorMaximo", valorMaximo);
    }

    private void calculaValoresFrete(TipoFrete tipoFrete, HashMap h) {
        Double percFrete = 0.0;
        if (tipoFrete != null) {
            percFrete = tipoFrete.getPercFrete();
        }
        Double valorVenda = (Double)h.get("valorVenda");
        Double valorMinimo = (Double)h.get("valorMinimo");
        Double valorMaximo = (Double)h.get("valorMaximo");
        if (tipoFrete != null && tipoFrete.getOpcao() == 0) {
            valorVenda = valorVenda + tipoFrete.getPercFrete() / 100.0 * valorVenda;
            valorMinimo = valorMinimo + tipoFrete.getPercFrete() / 100.0 * valorMinimo;
            valorMaximo = valorMaximo + tipoFrete.getPercFrete() / 100.0 * valorMaximo;
            percFrete = 0.0;
        }
        h.put("percFrete", percFrete);
        h.put("valorVenda", valorVenda);
        h.put("valorMinimo", valorMinimo);
        h.put("valorMaximo", valorMaximo);
    }

    private Double calculaComissaoMultiplasBases(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, OpcoesFaturamento op, Double valorUnitario) throws ExceptionService {
        Double percComissao = this.findPercComissaoPorMultiplasOpcoesTabelaBase(produto, dataEmissao, uf, moeda, op, valorUnitario);
        return percComissao;
    }

    private Double findPercComissaoPorMultiplasOpcoesTabelaBase(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, OpcoesFaturamento op, Double valorUnitario) throws ExceptionService {
        dataEmissao = dataEmissao == null ? new Date() : dataEmissao;
        moeda = moeda == null ? op.getMoeda() : moeda;
        return CoreDAOFactory.getInstance().getDAOTabelaPrecoBase().getPercComissaoMultiplasComissoesTabelaBase(produto, dataEmissao, uf, moeda, valorUnitario);
    }

    private void putTabelaDescFinanceiro(Produto produto, ClassificacaoClientes classificacao, Date dataEmissao, HashMap h, OpcoesFaturamento op) throws ExceptionService {
        try {
            CoreRequestContext r = new CoreRequestContext();
            r.setAttribute("produto", produto);
            r.setAttribute("classificacaoClientes", classificacao);
            r.setAttribute("dataEmissao", dataEmissao);
            TabelaDescFinancProduto tab = (TabelaDescFinancProduto)CoreServiceFactory.getServiceTabelaDescontoFinanc().execute(r, "findDescontoFinanceiro");
            h.put("tabelaDecontoProm", tab);
            Double valorDesc = 0.0;
            if (tab != null) {
                valorDesc = tab.getValorDesc();
                valorDesc = valorDesc == null ? 0.0 : valorDesc;
            }
            h.put("valorDescontoPromo", valorDesc);
            this.calcularValorComDesconto(h, op);
        }
        catch (ExceptionService ex) {
            throw new ExceptionService("Erro ao pesquisar a tabela de desconto financeiro promocional.", ex);
        }
    }

    private void arredondarValores(OpcoesFaturamento op, HashMap h) {
        if (op.getArredondarVlrItem() != null && op.getArredondarVlrItem() == 1) {
            Double valorVenda = ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorVenda")), (int)2);
            Double valorMinimo = ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorMinimo")), (int)2);
            Double valorMaximo = ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorMaximo")), (int)2);
            h.put("valorVenda", valorVenda);
            h.put("valorMinimo", valorMinimo);
            h.put("valorMaximo", valorMaximo);
        }
    }

    private void calcularValorComDesconto(HashMap h, OpcoesFaturamento op) {
        Double valorUnitario = (Double)h.get("valorVenda");
        Double valorMin = (Double)h.get("valorMinimo");
        Double valorMax = (Double)h.get("valorMaximo");
        Double valorDesc = (Double)h.get("valorDescontoPromo");
        if (op.getUsarValorOriginalItemPedido() == null || op.getUsarValorOriginalItemPedido().equals((short)0)) {
            if (valorUnitario > 0.0) {
                double newVlrVenda = valorUnitario - valorDesc;
                if (newVlrVenda < 0.0) {
                    newVlrVenda = 0.0;
                }
                h.put("valorVenda", newVlrVenda);
            }
            if (valorMax > 0.0) {
                double newVlrMax = valorMax - valorDesc;
                if (newVlrMax < 0.0) {
                    newVlrMax = 0.0;
                }
                h.put("valorMinimo", newVlrMax);
            }
            if (valorMin > 0.0) {
                double newVlrMin = valorMin - valorDesc;
                if (newVlrMin < 0.0) {
                    newVlrMin = 0.0;
                }
                h.put("valorMaximo", newVlrMin);
            }
        }
    }

    private void procurarCFOP(ItemNotaFiscalPropria i, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFatCliente, HashMap h, OpcoesFaturamento opcoesFaturamento) {
        if (i.getModeloFiscal() != null && naturezaOperacao != null) {
            try {
                if (naturezaOperacao.getEntradaSaida() == 1) {
                    i.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopSaida(((Empresa)h.get("empresa")).getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), i.getModeloFiscal(), EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)opcoesFaturamento.getIndicadorPresencaConsumidor())));
                } else {
                    i.getItemNotaLivroFiscal().setCfop(CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(((Empresa)h.get("empresa")).getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), i.getModeloFiscal()));
                }
            }
            catch (ExceptionService ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
            }
            catch (ExceptionCFOPNotFound ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
            }
        }
    }

    private void procurarAliquotaICMS(ItemNotaFiscalPropria i, UnidadeFatCliente unidadeFatCliente, HashMap h, NaturezaOperacao naturezaOperacao) {
        i.getItemNotaLivroFiscal().setAliquotaICMSSimples(((Empresa)h.get("empresa")).getEmpresaDados().getAliquotaICMSSimples());
        if (i.getModeloFiscal() != null) {
            i.getItemNotaLivroFiscal().setAliquotaIcms(new HelperItemNotaPropria().findAliquotaIcms(naturezaOperacao, i.getModeloFiscal(), ((Empresa)h.get("empresa")).getPessoa().getEndereco().getCidade().getUf(), unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), (Produto)h.get("produto")));
        }
    }

    private void procurarPercRedBC(ItemNotaFiscalPropria i) {
        ModeloFiscal modelo = i.getModeloFiscal();
        if (ToolMethods.isEquals((Object)modelo.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            i.getItemNotaLivroFiscal().setPercReducaoBCIcms(modelo.getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            i.getItemNotaLivroFiscal().setPercReducaoBCIcms(i.getProduto().getReducaoBaseCalcIcms());
        }
    }

    private void mostrarDadosIpi(ItemNotaFiscalPropria i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
        i.setClasseEnquadramentoIpi(i.getProduto().getClasseEnqIpi());
        if (i.getModeloFiscal() != null && i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            i.setClasseEnquadramentoIpi(i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        }
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)i.getProduto(), (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
        i.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIpi);
    }

    private void mostrarDadosIcms(ItemNotaFiscalPropria i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setIncidenciaIcms(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms());
        i.setModalidadeIcms(modeloFiscal.getModeloFiscalIcms().getModalidadeIcms());
    }

    private void mostrarDadosIcmsSt(ItemNotaFiscalPropria i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setModalidadeIcmsSt(modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt());
    }

    private void mostrarDadosPisCofins(ItemNotaFiscalPropria i) {
        ModeloFiscal m = i.getModeloFiscal();
        i.setIncidenciaPisCofins(m.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        i.getItemNotaLivroFiscal().setAliquotaPis(i.getProduto().getAliquotaPis());
        i.getItemNotaLivroFiscal().setAliquotaCofins(i.getProduto().getAliquotaCofins());
        new HelperItemNotaPropria(i).setNatReceitaPisCofins();
    }

    private void mostrarOutrasAliquotas(ItemNotaFiscalPropria i) {
        ModeloFiscal mod = i.getModeloFiscal();
        Produto produto = i.getProduto();
        if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaIrrf(produto.getAliquotaIrrf());
            i.getItemNotaLivroFiscal().setPercRedIrrf(produto.getPercRedIrrf());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaIrrf(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedIrrf(Double.valueOf(0.0));
        }
        if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaInss(produto.getAliquotaInss());
            i.getItemNotaLivroFiscal().setPercRedBcInss(produto.getPercRedBCINSS());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaInss(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedBcInss(Double.valueOf(0.0));
        }
        if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaFunrural(produto.getAliquotaFunrural());
            i.getItemNotaLivroFiscal().setPercRedFunrural(produto.getPercRedFunrural());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaFunrural(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedFunrural(Double.valueOf(0.0));
        }
        if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaSenar(produto.getAliquotaSenar());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaSenar(Double.valueOf(0.0));
        }
        if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaRat(produto.getAliquotaRat());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaRat(Double.valueOf(0.0));
        }
        if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
            i.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(produto.getTaxaSanidadeAnimal());
            i.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(produto.getFatorTaxaSanidadeAnimal());
        } else {
            i.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(Double.valueOf(0.0));
        }
        if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaLei10833(produto.getAliquotaLei10833());
            i.getItemNotaLivroFiscal().setPercRedLei10833(produto.getPercRedLei10833());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaLei10833(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedLei10833(Double.valueOf(0.0));
        }
        if (mod.getTipoCalculoCide() != null && mod.getTipoCalculoCide() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaCIDE(produto.getAliquotaCide());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCIDE(Double.valueOf(0.0));
        }
        if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaOutros(produto.getAliquotaOutros());
            i.getItemNotaLivroFiscal().setPercRedOutros(produto.getPercRedOutros());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaOutros(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedOutros(Double.valueOf(0.0));
        }
        if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaContSoc(produto.getAliquotaContSoc());
            i.getItemNotaLivroFiscal().setPercRedContSoc(produto.getPercRedContSoc());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaContSoc(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedContSoc(Double.valueOf(0.0));
        }
        if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
            i.getItemNotaLivroFiscal().setAliquotaIss(produto.getAliquotaIss());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaIss(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaPis(i.getProduto().getAliquotaPis());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaPisSt(i.getProduto().getAliquotaPisSt());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaCofins(i.getProduto().getAliquotaCofins());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaCofinsSt(i.getProduto().getAliquotaCofinsSt());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
        }
    }

    private void getFieldsRelatorio(HashMap h, HashMap hs, int indiceCondicaoPagamento) {
        hs.put("F_VALOR_LIQUIDO_" + indiceCondicaoPagamento, (Double)h.get("valorLiquido"));
        if ((CondicoesPagamento)h.get("condicaoPagamento") != null) {
            hs.put("F_CONDICAO_PAGAMENTO_" + indiceCondicaoPagamento, ((CondicoesPagamento)h.get("condicaoPagamento")).getNome());
        }
    }

    private List<HashMap> getDadosOrdenados(List<HashMap> list, final Short ordenacao, final Short filtrarSubEspecie) {
        Collections.sort(list, new Comparator<HashMap>(){

            @Override
            public int compare(HashMap o1, HashMap o2) {
                if (filtrarSubEspecie.equals((short)1)) {
                    Long idSub2;
                    if (ordenacao == 0) {
                        Long idSub22;
                        Long n1 = (Long)o1.get("F_ID_PRODUTO");
                        Long n2 = (Long)o2.get("F_ID_PRODUTO");
                        Long idSub1 = (Long)o1.get("F_ID_SUB_ESPECIE");
                        if (idSub1.equals(idSub22 = (Long)o2.get("F_ID_SUB_ESPECIE"))) {
                            return n1.compareTo(n2);
                        }
                        return idSub1.compareTo(idSub22);
                    }
                    String n1 = (String)o1.get("F_NOME_PRODUTO");
                    String n2 = (String)o2.get("F_NOME_PRODUTO");
                    Long idSub1 = (Long)o1.get("F_ID_SUB_ESPECIE");
                    if (idSub1.equals(idSub2 = (Long)o2.get("F_ID_SUB_ESPECIE"))) {
                        return n1.compareTo(n2);
                    }
                    return idSub1.compareTo(idSub2);
                }
                if (ordenacao == 0) {
                    Long n1 = (Long)o1.get("F_ID_PRODUTO");
                    Long n2 = (Long)o2.get("F_ID_PRODUTO");
                    return n1.compareTo(n2);
                }
                String n1 = (String)o1.get("F_NOME_PRODUTO");
                String n2 = (String)o2.get("F_NOME_PRODUTO");
                return n1.compareTo(n2);
            }
        });
        return list;
    }

    public List<SubEspecie> findFiltroSubEspecie(Long idSubEspecieInicial, Long idSubEspecieFinal) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("from SubEspecie s where s.identificador between :inicial and :final ");
        q.setLong("inicial", idSubEspecieInicial.longValue());
        q.setLong("final", idSubEspecieFinal.longValue());
        return q.list();
    }

    private Short getContribuinteEstado(UnidadeFatCliente unidade) {
        if (unidade.getPessoa().getComplemento().getContribuinteEstado() == null || unidade.getPessoa().getComplemento().getContribuinteEstado().equals((short)3)) {
            return unidade.getCliente().getPessoa().getComplemento().getContribuinteEstado();
        }
        return unidade.getPessoa().getComplemento().getContribuinteEstado();
    }

    public List<Fabricante> findFiltroFabricante(Long fabricanteInicial, Long fabricanteFinal) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery("select f from Fabricante f where f.identificador between :inicial and :final ");
        q.setLong("inicial", fabricanteInicial.longValue());
        q.setLong("final", fabricanteFinal.longValue());
        return q.list();
    }
}

