/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.tools;

import java.util.Date;
import java.util.regex.Pattern;

public class CoreTextValidation {
    public static boolean validateRequired(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof String) || ((String)value).trim().length() >= 1;
    }

    public static boolean validateComboBoxRequired(Object value) {
        if (value != null) {
            return CoreTextValidation.validateRequired(value);
        }
        return false;
    }

    public static boolean validateRequired(Date date, Date date0) {
        return !date.after(date0);
    }

    public static boolean validateRequiredEmail(String email) {
        if (email == null) {
            return false;
        }
        if (email.trim().length() == 0) {
            return false;
        }
        email = email.toLowerCase();
        Pattern padrao = Pattern.compile("[a-zA-Z0-9]+[a-zA-Z0-9_.-]+@{1}[a-zA-Z0-9_.-]*\\.+[a-z]{2,4}");
        return padrao.matcher(email).find();
    }
}

