/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.tools;

import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoFormatUtil;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import mentorcore.tools.ClearUtil;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class DateUtil
implements Serializable {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DD_MM_YYYY = "dd-MM-yyyy";
    public static final String DD_MM_YYYY_HH_MM_SS = "dd/MM/yyyy hh:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DD_MM_YYYY_HH_MM_SS_SSS_SQL = "dd.MM.yyyy, HH:mm:ss.SSS";
    public static final String DD_MM_YYYY_HH_MM_SS_SSS = "dd-MM-yyyy HH:mm:ss.SSS";
    public static final String DD_MM_YYYY_HH_MM = "dd/MM/yyyy hh:mm";
    public static final String DD_MM_YYYY__HH_MM = "dd/MM/yyyy-HH:mm";
    public static final String YYYY_MM_DD_CLASSIC = "yyyy/MM/dd";
    public static final String DD_MM_YYYY_CLASSIC = "dd/MM/yyyy";
    public static final long oneDay = 86400000L;
    public static final long oneHour = 3600000L;
    public static final int MIL_SEG_EM_UM_DIA = 86400000;
    public static final String DD_MM_YYYY_HH_MM_SS_HIFEN = "dd/MM/yyyy HH:mm:ss";
    public static final String HH_MM = "HH:mm";

    public static Integer diferenceDayBetweenDates(java.util.Date d1, java.util.Date d2) {
        d1 = DateUtil.dataSemHora(d1);
        d2 = DateUtil.dataSemHora(d2);
        return Days.daysBetween((ReadablePartial)new LocalDate(d1.getTime()), (ReadablePartial)new LocalDate(d2.getTime())).getDays();
    }

    public static java.util.Date getCurrentDate() {
        return DateUtil.strToDate(DateUtil.dateToStr(new java.util.Date(), DD_MM_YYYY_CLASSIC));
    }

    public static boolean diferenceMonths(java.util.Date data1, java.util.Date data2) {
        int m2;
        int m1 = new Integer(DateUtil.dateToStr(data1, "MM"));
        return m1 != (m2 = new Integer(DateUtil.dateToStr(data2, "MM")).intValue());
    }

    public static int getLastDayOnMonth(int year, int month) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(1, year);
        g.set(2, month - 1);
        g.add(5, -1);
        return g.getActualMaximum(5);
    }

    public static java.util.Date strToDate(String strDate) {
        return DateUtil.strToDate(strDate, DD_MM_YYYY_CLASSIC);
    }

    public static java.util.Date strToDate(String strDate, String pattern) {
        return ContatoDateUtil.strToDate((String)strDate, (String)pattern);
    }

    public static String dateToStr(java.util.Date date) {
        return DateUtil.dateToStr(date, DD_MM_YYYY_CLASSIC);
    }

    public static java.util.Date strToDate(String strDate, int dateFormat) {
        try {
            if (strDate != null) {
                java.util.Date tempDate;
                DateFormat d = DateFormat.getDateInstance(dateFormat);
                if (!d.format(tempDate = d.parse(strDate)).equals(strDate)) {
                    throw new ParseException("", 5);
                }
                return tempDate;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("N\u00e3o foi poss\u00edvel converter o texto " + strDate + " em data");
        }
    }

    public static String dateToStr(java.util.Date date, int dateFormat) {
        if (date != null) {
            return DateFormat.getDateInstance(dateFormat).format(date);
        }
        return null;
    }

    public static java.util.Date formatDate(java.util.Date d, int dateFormat) {
        try {
            if (d != null) {
                String strHoje = DateUtil.dateToStr(d);
                java.util.Date hoje = DateFormat.getDateInstance(dateFormat).parse(strHoje);
                return hoje;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return d;
        }
    }

    public static java.util.Date formatDate(java.util.Date date) {
        return DateUtil.formatDate(date, 2);
    }

    public static String dateToStr(java.util.Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat sd = new SimpleDateFormat(pattern);
            return sd.format(date);
        }
        return "";
    }

    public static boolean comparaMesAno(String data1, String data2) {
        String data1Str = data1.substring(data1.indexOf("/") + 1);
        String data2Str = data2.substring(data2.indexOf("/") + 1);
        return data1Str.equals(data2Str);
    }

    public static java.util.Date nextDays(java.util.Date dataAtual, int numDias) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(5, numDias);
        return g.getTime();
    }

    public static java.util.Date nextDays(java.util.Date dataAtual, double numHoras) {
        java.util.Date date = new java.util.Date(dataAtual.getTime() + (long)(numHoras * 60.0 * 60.0 * 1000.0));
        return date;
    }

    public static java.util.Date nextDaySameTime(java.util.Date dataAtual, java.util.Date dateTimeBase, double numHoras) {
        java.util.Date dataProxima = new java.util.Date(dataAtual.getTime() + (long)(numHoras * 60.0 * 60.0 * 1000.0));
        GregorianCalendar gSource = new GregorianCalendar();
        GregorianCalendar gDest = new GregorianCalendar();
        gSource.setTime(dateTimeBase);
        gDest.setTime(dataProxima);
        gDest.set(11, gSource.get(11));
        gDest.set(12, gSource.get(12));
        gDest.set(13, gSource.get(13));
        return gDest.getTime();
    }

    public static java.util.Date nextMonth(java.util.Date dataAtual, int mes) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(2, mes);
        return g.getTime();
    }

    public static java.util.Date nextYear(java.util.Date data, int ano) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.add(1, ano);
        return g.getTime();
    }

    public static java.util.Date previousDays(java.util.Date dataAtual, int numDias) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataAtual);
        g.add(5, numDias * -1);
        return g.getTime();
    }

    public static Date toSQLDate(java.util.Date data) {
        try {
            long dataLong = data.getTime();
            return new Date(dataLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Timestamp toTimestamp(java.util.Date data) {
        try {
            long dataLong = data.getTime();
            return new Timestamp(dataLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar toCalendar(java.util.Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        return calendar;
    }

    public static java.util.Date toTime(java.util.Date data) {
        long dataLong = data.getTime();
        Time time = new Time(dataLong);
        return new Date(time.getTime());
    }

    public static String getDayInMonthDescription(java.util.Date date) {
        String dia = DateUtil.dateToStr(date, "dd");
        return DateUtil.getDayInMonthDescription(dia);
    }

    public static String getDayInMonthDescription(String dia) {
        if (Integer.parseInt(dia) > 31 || Integer.parseInt(dia) <= 0) {
            throw new IllegalArgumentException("Dia inv\u00e1lido");
        }
        HashMap<String, String> dias = new HashMap<String, String>();
        dias.put("01", "um");
        dias.put("02", "dois");
        dias.put("03", "tr\u00eas");
        dias.put("04", "quatro");
        dias.put("05", "cinco");
        dias.put("06", "seis");
        dias.put("07", "sete");
        dias.put("08", "oito");
        dias.put("09", "nove");
        dias.put("10", "dez");
        dias.put("11", "onze");
        dias.put("12", "doze");
        dias.put("13", "treze");
        dias.put("14", "quatorze");
        dias.put("16", "dezesseis");
        dias.put("17", "dezessete");
        dias.put("18", "dezoito");
        dias.put("19", "dezenove");
        dias.put("20", "vinte");
        dias.put("21", "vinte e um");
        dias.put("22", "vinte e dois");
        dias.put("23", "vinte e tr\u00eas");
        dias.put("24", "vinte e quatro");
        dias.put("25", "vinte e cinco");
        dias.put("26", "vinte e seis");
        dias.put("27", "vinte e sete");
        dias.put("28", "vinte e oito");
        dias.put("29", "vinte e nove");
        dias.put("30", "trinta");
        dias.put("31", "trinta e um");
        return (String)dias.get(dia);
    }

    public static Integer yearFromDate(Object obj) {
        return new Integer(new SimpleDateFormat("yyyy").format(obj));
    }

    public static Integer monthFromDate(java.util.Date obj) {
        return new Integer(new SimpleDateFormat("MM").format(obj));
    }

    public static Integer dayFromDate(java.util.Date obj) {
        return new Integer(new SimpleDateFormat("dd").format(obj));
    }

    public static Object strToDate(java.util.Date date) {
        return null;
    }

    public static java.util.Date getLastDateOnMonth(java.util.Date dataEmissao) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataEmissao);
        int year = g.get(1);
        int month = g.get(2);
        int day = DateUtil.getLastDayOnMonth(year, month + 1);
        g.set(5, day);
        return g.getTime();
    }

    public static java.util.Date getDataInicial(java.util.Date anoMes) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(anoMes);
        g.set(5, 1);
        return g.getTime();
    }

    public static java.util.Date getDataFinal(java.util.Date anoMes) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(anoMes);
        g.set(5, DateUtil.getLastDayOnMonth(g.get(1), g.get(2)));
        return g.getTime();
    }

    public static java.util.Date intToDate(Integer ano, Integer mes, Integer dia) {
        try {
            String strDate = dia + "-" + mes + "-" + ano;
            java.util.Date tempDate = null;
            SimpleDateFormat sd = new SimpleDateFormat(DD_MM_YYYY);
            if (ClearUtil.refina(strDate) == "") {
                return null;
            }
            tempDate = sd.parse(strDate);
            return tempDate;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Erro ao converter a Data");
        }
    }

    public static Double calcularDifHoras(java.util.Date dtAber, java.util.Date dtEnce) {
        if (dtAber == null || dtEnce == null) {
            return 0.0;
        }
        Duration duration = new Duration(dtAber.getTime(), dtEnce.getTime());
        double d = (double)duration.getStandardSeconds() / 60.0 / 60.0;
        return d;
    }

    public static Integer calcularDifMinutos(java.util.Date dtAber, java.util.Date dtEnce) {
        if (dtAber == null || dtEnce == null) {
            return 0;
        }
        Duration duration = new Duration(dtAber.getTime(), dtEnce.getTime());
        Double d = (double)duration.getStandardSeconds() / 60.0;
        return d.intValue();
    }

    public static java.util.Date dataSemHora(java.util.Date date) {
        return DateUtil.strToDate(DateUtil.dateToStr(date, DD_MM_YYYY), DD_MM_YYYY);
    }

    public static Double getHorasEmNumero(java.util.Date base) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(base);
        int h = g.get(11);
        int m = g.get(12);
        int s = g.get(13);
        double aux = s / 60;
        double aux1 = (aux + (double)m) / 60.0;
        return (double)h + aux1;
    }

    public static java.util.Date mergeDateWithHour(java.util.Date date, java.util.Date time) {
        GregorianCalendar calendarDate = new GregorianCalendar();
        GregorianCalendar calendarTime = new GregorianCalendar();
        calendarDate.setTime(date != null ? date : new java.util.Date());
        calendarTime.setTime(time != null ? time : new java.util.Date());
        calendarDate.set(11, calendarTime.get(11));
        calendarDate.set(12, calendarTime.get(12));
        calendarDate.set(13, calendarTime.get(13));
        return calendarDate.getTime();
    }

    public static Boolean dateBetween(java.util.Date date, java.util.Date inicialTarget, java.util.Date finalTarget) {
        if ((date.equals(inicialTarget) || date.after(inicialTarget)) && (date.equals(finalTarget) || date.before(finalTarget))) {
            return true;
        }
        return false;
    }

    public static Integer getMesesEntreDatas(java.util.Date dataInicial, java.util.Date dataFinal, Boolean ignoraMesDasDatas) {
        Calendar cIni = Calendar.getInstance();
        cIni.setTime(dataInicial);
        Calendar cFIm = Calendar.getInstance();
        cFIm.setTime(dataFinal);
        int difMes = cFIm.get(2) - cIni.get(2);
        int difAno = (cFIm.get(1) - cIni.get(1)) * 12;
        int total = difAno + difMes;
        if (ignoraMesDasDatas.booleanValue()) {
            return total - 1;
        }
        return total;
    }

    public static java.util.Date getCurrentDateTime() {
        return new java.util.Date();
    }

    public static java.util.Date lowDateTime(java.util.Date date) {
        Calendar aux = Calendar.getInstance();
        aux.setTime(date);
        DateUtil.toOnlyDate(aux);
        return aux.getTime();
    }

    public static java.util.Date highDateTime(java.util.Date date) {
        Calendar aux = Calendar.getInstance();
        aux.setTime(date);
        DateUtil.toOnlyDate(aux);
        aux.roll(11, false);
        aux.roll(12, false);
        aux.roll(13, false);
        aux.roll(14, false);
        return aux.getTime();
    }

    public static void toOnlyDate(Calendar date) {
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
    }

    public static int differenceYearsBetweenDates(java.util.Date first, java.util.Date last) {
        Calendar a = DateUtil.getCalendar(first);
        Calendar b = DateUtil.getCalendar(last);
        int diff = b.get(1) - a.get(1);
        if (a.get(2) > b.get(2) || a.get(2) == b.get(2) && a.get(5) > b.get(5)) {
            --diff;
        }
        return diff;
    }

    public static Calendar getCalendar(java.util.Date date) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(date);
        return cal;
    }

    public static Integer getDaysOnMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroDias = calendar.getActualMaximum(5);
        return numeroDias;
    }

    public static int getMonthFromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroMes = calendar.get(2);
        return numeroMes;
    }

    public static int getYearFromDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer numeroYear = calendar.get(1);
        return numeroYear;
    }

    public static Boolean comparePeriodFromDates(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            return Boolean.FALSE;
        }
        Integer ano1 = DateUtil.yearFromDate(date1);
        Integer mes1 = DateUtil.monthFromDate(date1);
        Integer ano2 = DateUtil.yearFromDate(date2);
        Integer mes2 = DateUtil.monthFromDate(date2);
        if (mes1.equals(mes2) && ano1.equals(ano2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static java.util.Date addMonthToDate(java.util.Date date, Integer numberMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, numberMonth);
        return c.getTime();
    }

    public static String diaDaSemanaTexto(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        switch (g.get(7)) {
            case 1: {
                return "Domingo";
            }
            case 2: {
                return "Segunda";
            }
            case 3: {
                return "Ter\u00e7a";
            }
            case 4: {
                return "Quarta";
            }
            case 5: {
                return "Quinta";
            }
            case 6: {
                return "Sexta";
            }
            case 7: {
                return "S\u00e1bado";
            }
        }
        return null;
    }

    public static java.util.Date getDateFirstMonthDay(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static java.util.Date getDateLastMonthDay(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, DateUtil.getDaysOnMonth(date));
        return c.getTime();
    }

    public static String getMonthDescription(int mes) {
        switch (mes) {
            case 0: {
                return "Janeiro";
            }
            case 1: {
                return "Fevereiro";
            }
            case 2: {
                return "Mar\u00e7o";
            }
            case 3: {
                return "Abril";
            }
            case 4: {
                return "Maio";
            }
            case 5: {
                return "Junho";
            }
            case 6: {
                return "Julho";
            }
            case 7: {
                return "Agosto";
            }
            case 8: {
                return "Setembro";
            }
            case 9: {
                return "Outubro";
            }
            case 10: {
                return "Novembro";
            }
            case 11: {
                return "Dezembro";
            }
        }
        return null;
    }

    public static String getMonthDescriptionCompacted(int mes) {
        switch (mes) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Fev";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Abr";
            }
            case 4: {
                return "Mai";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Ago";
            }
            case 8: {
                return "Set";
            }
            case 9: {
                return "Out";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dez";
            }
        }
        return null;
    }

    public static java.util.Date dataSemSegundos(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Integer diaDaSemana(java.util.Date data) {
        if (data == null) {
            return null;
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return g.get(7);
    }

    public static Boolean compareDate(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            return Boolean.FALSE;
        }
        Integer ano1 = DateUtil.yearFromDate(date1);
        Integer mes1 = DateUtil.monthFromDate(date1);
        Integer dia1 = DateUtil.dayFromDate(date1);
        Integer ano2 = DateUtil.yearFromDate(date2);
        Integer mes2 = DateUtil.monthFromDate(date2);
        Integer dia2 = DateUtil.dayFromDate(date2);
        if (mes1.equals(mes2) && ano1.equals(ano2) && dia1.equals(dia2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Double diffHorasPorData(java.util.Date data, Double horaInicio, Double horaFinal) {
        java.util.Date dataInicio = DateUtil.getDataComHoras(data, horaInicio);
        java.util.Date dataFinal = DateUtil.getDataComHoras(data, horaFinal);
        return DateUtil.calcularDifHoras(dataInicio, dataFinal);
    }

    private static java.util.Date getDataComHoras(java.util.Date data, Double hora) {
        GregorianCalendar g = new GregorianCalendar();
        hora = ContatoFormatUtil.arrredondarNumero((Double)hora, (int)2);
        Integer inteira = hora.intValue();
        Integer decimal = (int)Math.round((hora - (double)hora.intValue()) * 100.0);
        g.setTime(data);
        g.set(10, inteira);
        g.set(12, decimal);
        g.set(13, 0);
        return g.getTime();
    }

    public static java.util.Date getLastDayNextMonth(java.util.Date data, Integer diaBase) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int year = g.get(1);
        int month = g.get(2) + 1;
        g.set(1, year);
        g.set(2, month);
        g.set(5, g.getFirstDayOfWeek());
        int day = g.getActualMaximum(5);
        if (diaBase != null && diaBase > 0 && day > diaBase) {
            day = diaBase;
        }
        g.set(5, day);
        return g.getTime();
    }
}

