/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertificateImport {
    public static final String TRUST_STORE_FILE_NAME = "touchcompkeystore.jks";
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static void main(String[] args) {
        try {
            CertificateImport.importCerticateFromServer("hcte.fazenda.mg.gov.br", 443);
        }
        catch (Exception ex) {
            Logger.getLogger(CertificateImport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void importCerticateFromServer(String host, int port) throws UnknownHostException, Exception {
        String p = "touchcompKeyStore";
        char[] passphrase = p.toCharArray();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        File f = new File(TRUST_STORE_FILE_NAME);
        if (!f.exists() || f.length() == 0L) {
            ks.load(null, passphrase);
        } else {
            ks.load(new FileInputStream(f), passphrase);
        }
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
        }
        catch (SSLException e) {
            System.out.println("Erro ao verificar identidade do certificado");
        }
        X509Certificate[] chain = tm.getChain();
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        System.out.println();
        System.out.println("Server sent " + chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int k = 0; k < chain.length; ++k) {
            X509Certificate cert = chain[k];
            System.out.println(" " + (k + 1) + " Subject " + String.valueOf(cert.getSubjectDN()));
            System.out.println("   Issuer  " + String.valueOf(cert.getIssuerDN()));
            sha1.update(cert.getEncoded());
            System.out.println("   sha1    " + CertificateImport.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("   md5     " + CertificateImport.toHexString(md5.digest()));
            String alias = host + "-" + (k + 1);
            ks.setCertificateEntry(alias, cert);
            FileOutputStream out = new FileOutputStream(TRUST_STORE_FILE_NAME);
            ks.store(out, passphrase);
            ((OutputStream)out).close();
            System.out.println("Added certificate to keystore using alias '" + alias + "'");
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        public SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.setChain(chain);
            this.tm.checkServerTrusted(chain, authType);
        }

        public X509Certificate[] getChain() {
            return this.chain;
        }

        public void setChain(X509Certificate[] chain) {
            this.chain = chain;
        }
    }
}

