/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.util;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import contatocore.util.ContatoFormatUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRImageRenderer;

public class CoreReportUtil {
    public static final String SUBREPORT_DIR_IND_NEW = "SUB_DIR_SINGLE";
    public static final String SUBREPORT_DIR_LIST_NEW = "SUB_DIR_LIST";
    public static final String SUBREPORT_DIR_OUTR_NEW = "SUB_DIR_OTHERS";
    public static final String NOME_EMPRESA = "NOME_EMPRESA";
    public static final String CNPJ_NOME = "CNPJ_NOME";
    public static final String INSCRICAO_ESTADUAL_NOME = "INSCRICAO_ESTADUAL_NOME";
    public static final String CNPJ = "CNPJ";
    public static final String INSCRICAO_ESTADUAL = "INSCRICAO_ESTADUAL";
    public static final String INSCRICAO = "INSCRICAO";
    public static final String ID_INICIAL = "ID_INICIAL";
    public static final String ID_FINAL = "ID_FINAL";
    public static final String FECHO = "FECHO";
    public static final String LOGO = "LOGO";
    public static final String LOGO_RELATORIO = "LOGO_RELATORIO";
    public static final String SUBREPORT_DIR_IND = "SUBREPORT_DIR_IND";
    public static final String SUBREPORT_DIR_LIST = "SUBREPORT_DIR_LIST";
    public static final String SUBREPORT_DIR_OUTR = "SUBREPORT_DIR_OUTR";
    private static final String EMPRESA_LOGADA = "EMPRESA_LOGADA";
    private final Empresa empresa;

    public CoreReportUtil(Empresa empresa) {
        this.empresa = empresa;
    }

    public static CoreReportUtil instance(Empresa empresa) {
        return new CoreReportUtil(empresa);
    }

    private byte[] getBytesOfFile(String path) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(new File(path));
        byte[] byteArray = new byte[inputStream.available()];
        inputStream.read(byteArray);
        inputStream.close();
        return byteArray;
    }

    private String getFormattedInscEst() {
        if (this.empresa.getPessoa().getComplemento() == null) {
            return "";
        }
        if (this.empresa.getPessoa().getComplemento().getInscEst() != null && !this.empresa.getPessoa().getComplemento().getInscEst().equalsIgnoreCase("ISENTO")) {
            return ContatoFormatUtil.formatIE((String)this.empresa.getPessoa().getEndereco().getCidade().getUf().getSigla(), (String)this.empresa.getPessoa().getComplemento().getInscEst());
        }
        return this.empresa.getPessoa().getComplemento().getInscEst();
    }

    private String getFormattedCNPJ() {
        Complemento c = this.empresa.getPessoa().getComplemento();
        if (c.getCnpj() != null && c.getCnpj().length() == 11 && c.getCodCei() != null) {
            return c.getCodCei();
        }
        if (c != null) {
            return ContatoFormatUtil.formatCNPJCPF((String)c.getCnpj());
        }
        return "";
    }

    private byte[] criarImagem() {
        try {
            File f = new File("/images/LogoMentor.png");
            if (!f.exists()) {
                f = new File("img.png");
            }
            if (!f.exists()) {
                int width = 200;
                int height = 200;
                BufferedImage buffer = new BufferedImage(width, height, 1);
                Graphics2D g = buffer.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.BLACK);
                ImageIO.write((RenderedImage)buffer, "png", new File("img.png"));
            }
            return this.getBytesOfFile(f.getAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] getBytesImage() {
        byte[] img = null;
        img = this.empresa.getEmpresaDados().getLogoRelatorios() == null ? this.criarImagem() : this.empresa.getEmpresaDados().getLogoRelatorios();
        return img;
    }

    public Map getDefaultParams(Map params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put(SUBREPORT_DIR_IND_NEW, CoreReportUtil.getNewSubReportDirIndividual());
        params.put(SUBREPORT_DIR_LIST_NEW, CoreReportUtil.getNewSubReportDirListagens());
        params.put(SUBREPORT_DIR_OUTR_NEW, CoreReportUtil.getNewSubReportDirOutros());
        params.put(NOME_EMPRESA, this.empresa.getPessoa().getNome());
        params.put(EMPRESA_LOGADA, (String)this.empresa);
        params.put(CNPJ_NOME, this.getFormattedCNPJ());
        params.put(CNPJ, this.getFormattedCNPJ());
        params.put(INSCRICAO_ESTADUAL_NOME, this.getFormattedInscEst());
        params.put(INSCRICAO_ESTADUAL, this.getFormattedInscEst());
        params.put(INSCRICAO, this.getFormattedInscEst());
        params.put(SUBREPORT_DIR_IND, CoreReportUtil.getSubReportDirIndividual());
        params.put(SUBREPORT_DIR_LIST, CoreReportUtil.getSubReportDirListagens());
        params.put(SUBREPORT_DIR_OUTR, CoreReportUtil.getSubReportDirOutros());
        params.put(LOGO_RELATORIO, (String)JRImageRenderer.getInstance((byte[])this.getBytesImage()));
        return params;
    }

    public static String getPathRelatoriosIndividuais() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "individuais" + File.separator;
    }

    public static String getPathListagens() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "listagens" + File.separator;
    }

    public static String getPathOutros() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "outros" + File.separator;
    }

    public static String getNewPathIndividuais() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "single" + File.separator;
    }

    public static String getNewPathListagens() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "list" + File.separator;
    }

    public static String getNewPathOutros() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "others" + File.separator;
    }

    public static String getPathReports() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator;
    }

    public static String getSubReportDirIndividual() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "individuais" + File.separator + "subreports" + File.separator;
    }

    public static String getSubReportDirOutros() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "outros" + File.separator + "subreports" + File.separator;
    }

    public static String getSubReportDirListagens() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "relatorios" + File.separator + "listagens" + File.separator + "subreports" + File.separator;
    }

    public static String getNewSubReportDirIndividual() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "single" + File.separator + "subreports" + File.separator;
    }

    public static String getNewSubReportDirOutros() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "others" + File.separator + "subreports" + File.separator;
    }

    public static String getNewSubReportDirListagens() {
        String path = System.getProperty("user.dir");
        return path + File.separator + "reports" + File.separator + "list" + File.separator + "subreports" + File.separator;
    }
}

