/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtilities {
    public static Boolean findMessage(Throwable ex, String findIt) {
        return ExceptionUtilities.findMessage(ex, findIt, false);
    }

    public static Boolean findMessage(Throwable ex, String findIt, boolean trim) {
        Exception aux = new Exception(ex);
        StringWriter sw = new StringWriter();
        PrintWriter s = new PrintWriter(sw);
        aux.printStackTrace(s);
        String st = sw.toString().replaceAll(" ", "");
        if (st.toLowerCase().contains(findIt.toLowerCase())) {
            return true;
        }
        return false;
    }

    public static Boolean findException(Throwable ex, Throwable findIt) {
        Exception aux;
        for (aux = new Exception(ex); aux != null; aux = (Exception)aux.getCause()) {
            if (aux.getMessage() == null || !aux.getCause().getClass().equals(findIt.getClass())) continue;
            return true;
        }
        if (aux != null && aux.getMessage() != null && aux.getCause().getClass().equals(findIt.getClass())) {
            return true;
        }
        return false;
    }

    public static Boolean findException(Throwable ex, String expectionClass) {
        Exception aux;
        for (aux = new Exception(ex); aux != null; aux = (Exception)aux.getCause()) {
            if (aux.getMessage() == null || aux.getCause() == null || !aux.getCause().getClass().getCanonicalName().equalsIgnoreCase(expectionClass)) continue;
            return true;
        }
        if (aux != null && aux.getMessage() != null && aux.getCause() != null && aux.getCause().getClass().getCanonicalName().equalsIgnoreCase(expectionClass)) {
            return true;
        }
        return false;
    }

    public static String toString(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (ex != null) {
            if (ex.getCause() != null) {
                sb.append(ExceptionUtilities.toString(ex.getCause()));
            }
            sb.append("\n").append(ex.toString());
        }
        return sb.toString();
    }

    public static String getFullPrintStrack(Exception ex) {
        StringBuilder sb = new StringBuilder();
        ExceptionUtilities.processStraceError(ex, sb);
        return sb.toString();
    }

    private static StringBuilder processStraceError(Throwable tr, StringBuilder sb) {
        if (tr == null) {
            return sb;
        }
        if (tr.getCause() != null) {
            sb.append((CharSequence)ExceptionUtilities.processStraceError(tr.getCause(), sb));
        }
        sb.append(tr.toString());
        sb.append("\n");
        for (StackTraceElement s : tr.getStackTrace()) {
            sb.append("\t" + String.valueOf(s));
            sb.append("\n");
        }
        return sb;
    }

    public static String getMessage(Throwable ex) {
        while (ex != null) {
            String message = ex.getMessage();
            if (message != null && message.contains("@")) {
                return message;
            }
            ex = ex.getCause();
        }
        return null;
    }
}

