/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.abrirticketchamadotouch;

import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchFile;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorlogger.TLoggerUtils;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPTicketRecebido;
import com.touchcomp.touchvomodel.webservices.touch.output.TEMPRespostaTicket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.abrirticketchamadotouch.AuxRegistraAtUsuario;
import mentorcore.utilities.impl.abrirticketchamadotouch.UtilityTicketChamadoTouch;

public class AuxAbrirTicket {
    private static final TLogger logger = TLogger.get(UtilityTicketChamadoTouch.class);
    Integer VERSAO = 1;

    public void enviarChamados(List<LocalTicketAtendTouch> ti, String servidor) throws Exception {
        try {
            RequisicaoWebservice msg = this.getMsg(ti);
            RespostaWebService res = this.sendMessage(msg, servidor);
            this.updateAndProcess(res, ti);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private RequisicaoWebservice getMsg(List<LocalTicketAtendTouch> tickets) throws IOException, Exception {
        LinkedList<TEMPTicketRecebido> aux = new LinkedList<TEMPTicketRecebido>();
        for (LocalTicketAtendTouch ti : tickets) {
            TEMPTicketRecebido root = new TEMPTicketRecebido();
            root.setLocalTicketID(ti.getIdentificador());
            root.setEmail(ti.getEmail());
            root.setObservacao(ti.getObservacao());
            if (ti.getCodigoVersao() != null) {
                root.setCodigoVersao(ti.getCodigoVersao());
            }
            if (ti.getNodo() != null) {
                root.setIdNodo(ti.getNodo().getIdentificador());
            }
            root.setUsuario(new AuxRegistraAtUsuario().getElementUserUnique(ti.getUsuario(), ti.getEmpresa()));
            root.setFiles(this.getElementFiles(ti));
            aux.add(root);
        }
        RequisicaoWebservice req = new RequisicaoWebservice();
        req.setVersao(this.VERSAO);
        req.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson(aux)));
        return req;
    }

    private List<TEMPTicketRecebido.VOTicketFile> getElementFiles(LocalTicketAtendTouch ti) throws IOException, Exception {
        LinkedList<TEMPTicketRecebido.VOTicketFile> files = new LinkedList<TEMPTicketRecebido.VOTicketFile>();
        for (LocalTicketAtendTouchFile tfi : ti.getArquivos()) {
            File f = new File(tfi.getCaminhoArquivo());
            if (!f.exists()) continue;
            TEMPTicketRecebido.VOTicketFile file = new TEMPTicketRecebido.VOTicketFile();
            file.setDescricao(f.getName());
            file.setFileContent(this.getHexFile(f));
            files.add(file);
        }
        File log = this.addLogFile();
        if (log != null && log.exists()) {
            TEMPTicketRecebido.VOTicketFile file = new TEMPTicketRecebido.VOTicketFile();
            file.setDescricao(log.getName());
            file.setFileContent(this.getHexFile(log));
            files.add(file);
        }
        return files;
    }

    private RespostaWebService sendMessage(RequisicaoWebservice msg, String servidor) throws ExceptionWebService, ExceptionReflection, ExceptionIO {
        RespostaWebService resp = (RespostaWebService)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)"/sync/tickets-atend-touch/receber-atendimentos", (Object)msg, RespostaWebService.class);
        return resp;
    }

    private void updateAndProcess(RespostaWebService res, List<LocalTicketAtendTouch> ti) throws Exception {
        if (res.getCodStatus() == 0) {
            throw new ExceptionService(res.getMensagem());
        }
        List data = ToolJson.readJsonList((String)ToolHexString.decodeToStr((String)res.getDetalhes()), TEMPRespostaTicket.class);
        this.process(data, ti);
    }

    private LocalTicketAtendTouch getLocalTicketByID(List<LocalTicketAtendTouch> ti, Long localID) {
        for (LocalTicketAtendTouch aux : ti) {
            if (aux.getIdentificador().longValue() != localID.longValue()) continue;
            return aux;
        }
        return null;
    }

    private void process(List<TEMPRespostaTicket> data, List<LocalTicketAtendTouch> ti) throws Exception {
        for (TEMPRespostaTicket el : data) {
            Long localID = el.getLocalTicketID();
            Long nrProtocolo = el.getNrProtocolo();
            LocalTicketAtendTouch found = this.getLocalTicketByID(ti, localID);
            if (found == null) continue;
            found.setNrProtocolo(nrProtocolo);
        }
    }

    private File addLogFile() {
        FileReader f = null;
        PrintWriter pw = null;
        try {
            String linha;
            File log = TLoggerUtils.getLogFile();
            if (!log.exists()) {
                return null;
            }
            f = new FileReader(log);
            BufferedReader leitor = new BufferedReader(f);
            LinkedList<String> linhas = new LinkedList<String>();
            while ((linha = leitor.readLine()) != null) {
                if (linhas.size() > 1000) {
                    linhas.remove(0);
                }
                linhas.add(linha);
            }
            File tmp = File.createTempFile("error_reporter_log", ".txt");
            pw = new PrintWriter(tmp);
            for (Object e : linhas) {
                pw.write(e.toString() + "\n");
            }
            return tmp;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            return null;
        }
    }

    private String getHexFile(File f) throws IOException, Exception {
        return ToolFile.encodeHexAndCompress((File)f);
    }
}

