/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.abrirticketchamadotouch;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPResumoAtendimento;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPUsuario;
import java.io.IOException;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.abrirticketchamadotouch.AuxRegistraAtUsuario;

public class AuxConsultarAtendimentos {
    private static final TLogger logger = TLogger.get(AuxConsultarAtendimentos.class);
    private Integer VERSAO = 1;

    public List<TEMPResumoAtendimento> consultarChamados(Usuario user, Empresa emp, String servidor) throws Exception {
        try {
            RequisicaoWebservice msg = this.getMsg(user, emp);
            RespostaWebService res = this.sendMessage(msg, servidor);
            return this.processRet(res);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private RequisicaoWebservice getMsg(Usuario user, Empresa emp) throws IOException, Exception {
        TEMPUsuario root = new AuxRegistraAtUsuario().getElementUserUnique(user, emp);
        RequisicaoWebservice req = new RequisicaoWebservice();
        req.setVersao(this.VERSAO);
        req.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson((Object)root)));
        return req;
    }

    private RespostaWebService sendMessage(RequisicaoWebservice msg, String servidor) throws ExceptionWebService, ExceptionReflection, ExceptionIO {
        RespostaWebService resp = (RespostaWebService)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)"/sync/tickets-atend-touch/consultar-atendimentos", (Object)msg, RespostaWebService.class);
        return resp;
    }

    private List<TEMPResumoAtendimento> processRet(RespostaWebService res) throws Exception {
        if (res.getCodStatus() == 0) {
            throw new ExceptionService(res.getMensagem());
        }
        List data = ToolJson.readJsonList((String)ToolHexString.decodeToStr((String)res.getDetalhes()), TEMPResumoAtendimento.class);
        return data;
    }
}

