/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.abrirticketchamadotouch;

import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstTicketAtendStatus;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPNotaTicket;
import com.touchcomp.touchvomodel.webservices.touch.output.TEMPRespostaTicket;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.abrirticketchamadotouch.UtilityTicketChamadoTouch;

public class AuxEnviarNotasAtendTicket {
    private static final TLogger logger = TLogger.get(UtilityTicketChamadoTouch.class);
    Integer VERSAO = 1;

    public void enviarChamados(List<LocalTicketAtendTouch> ti, String servidor) throws Exception {
        try {
            RequisicaoWebservice msg = this.getMsg(ti);
            Thread.sleep(5000L);
            RespostaWebService res = this.sendMessage(msg, servidor);
            Thread.sleep(5000L);
            res = this.sendMessage(msg, servidor);
            this.updateAndProcess(res, ti);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private RespostaWebService sendMessage(RequisicaoWebservice msg, String servidor) throws ExceptionWebService, ExceptionReflection, ExceptionIO {
        RespostaWebService resp = (RespostaWebService)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)"/sync/tickets-atend-touch/receber-notas-atendimentos", (Object)msg, RespostaWebService.class);
        return resp;
    }

    private RequisicaoWebservice getMsg(List<LocalTicketAtendTouch> tickets) throws IOException, Exception {
        LinkedList<TEMPNotaTicket> aux = new LinkedList<TEMPNotaTicket>();
        for (LocalTicketAtendTouch ti : tickets) {
            TEMPNotaTicket root = new TEMPNotaTicket();
            root.setLocalTicketID(ti.getIdentificador());
            root.setNrProtocolo(ti.getNrProtocolo());
            root.setNota(ti.getNotaAtendimento().getNotaAtendimento());
            root.setObservacao(ti.getNotaAtendimento().getObservacao());
            aux.add(root);
        }
        RequisicaoWebservice req = new RequisicaoWebservice();
        req.setVersao(this.VERSAO);
        req.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson(aux)));
        return req;
    }

    private void updateAndProcess(RespostaWebService res, List<LocalTicketAtendTouch> ti) throws Exception {
        if (res.getCodStatus() == 0) {
            throw new ExceptionService(res.getMensagem());
        }
        List data = ToolJson.readJsonList((String)ToolHexString.decodeToStr((String)res.getDetalhes()), TEMPRespostaTicket.class);
        this.process(data, ti);
    }

    private void process(List<TEMPRespostaTicket> data, List<LocalTicketAtendTouch> ti) throws Exception {
        for (TEMPRespostaTicket el : data) {
            Long localID = el.getLocalTicketID();
            Long nrProtocolo = el.getNrProtocolo();
            LocalTicketAtendTouch found = this.getLocalTicketByID(ti, localID);
            if (found == null) continue;
            found.getNotaAtendimento().setNrReciboMsg(nrProtocolo);
            if (ToolMethods.isEquals((Object)el.getStatus(), (Object)EnumConstTicketAtendStatus.FECHADO_DEFINITIVAMENTE.getValue())) {
                found.setStatus(el.getStatus());
                continue;
            }
            found.setStatus(Short.valueOf(EnumConstTicketAtendStatus.FECHADO_NOTA_ATRIBUIDA.getValue()));
        }
    }

    private LocalTicketAtendTouch getLocalTicketByID(List<LocalTicketAtendTouch> ti, Long localID) {
        for (LocalTicketAtendTouch aux : ti) {
            if (aux.getIdentificador().longValue() != localID.longValue()) continue;
            return aux;
        }
        return null;
    }
}

