/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.abrirticketchamadotouch;

import com.touchcomp.basementor.model.vo.LocalTicketAtSolReab;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPSolicitaReabertAtend;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPSolicitaReabertAtendResp;
import java.util.LinkedList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.abrirticketchamadotouch.UtilityTicketChamadoTouch;

public class AuxReabrirTicket {
    private static final TLogger logger = TLogger.get(UtilityTicketChamadoTouch.class);
    Integer VERSAO = 1;

    public void enviarSolicitacoesReabertura(List<LocalTicketAtSolReab> ti, String servidor) throws Exception {
        try {
            RequisicaoWebservice msg = this.getMsg(ti);
            RespostaWebService res = this.sendMessage(msg, servidor);
            this.updateAndProcess(res, ti);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private RequisicaoWebservice getMsg(List<LocalTicketAtSolReab> tickets) throws Exception {
        LinkedList<TEMPSolicitaReabertAtend> aux = new LinkedList<TEMPSolicitaReabertAtend>();
        for (LocalTicketAtSolReab ti : tickets) {
            TEMPSolicitaReabertAtend root = new TEMPSolicitaReabertAtend();
            root.setInfoAdicional(ti.getDescMotivo());
            root.setLocalId(ti.getIdentificador());
            root.setNrProtocolo(ti.getLocalTicketAtendTouch().getNrProtocolo());
            aux.add(root);
        }
        RequisicaoWebservice req = new RequisicaoWebservice();
        req.setVersao(this.VERSAO);
        req.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson(aux)));
        return req;
    }

    private RespostaWebService sendMessage(RequisicaoWebservice msg, String servidor) throws Exception {
        RespostaWebService resp = (RespostaWebService)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)"/sync/tickets-atend-touch/reabrir-atendimentos", (Object)msg, RespostaWebService.class);
        return resp;
    }

    private void updateAndProcess(RespostaWebService res, List<LocalTicketAtSolReab> ti) throws Exception {
        if (res.getCodStatus() == 0) {
            throw new ExceptionService(res.getMensagem());
        }
        List data = ToolJson.readJsonList((String)ToolHexString.decodeToStr((String)res.getDetalhes()), TEMPSolicitaReabertAtendResp.class);
        this.process(data, ti);
    }

    private LocalTicketAtSolReab getLocalTicketByID(List<LocalTicketAtSolReab> ti, Long localID) {
        for (LocalTicketAtSolReab aux : ti) {
            if (aux.getIdentificador().longValue() != localID.longValue()) continue;
            return aux;
        }
        return null;
    }

    private void process(List<TEMPSolicitaReabertAtendResp> data, List<LocalTicketAtSolReab> ti) throws Exception {
        for (TEMPSolicitaReabertAtendResp el : data) {
            Long localID = el.getLocalId();
            Long nrProtocolo = el.getRemoteId();
            LocalTicketAtSolReab found = this.getLocalTicketByID(ti, localID);
            if (found == null) continue;
            found.setNrReciboMsg(String.valueOf(nrProtocolo));
        }
    }
}

