/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.abrirticketchamadotouch;

import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.touchvomodel.vo.vo.VOCidade;
import com.touchcomp.touchvomodel.vo.vo.VOComplemento;
import com.touchcomp.touchvomodel.vo.vo.VOEmailPessoa;
import com.touchcomp.touchvomodel.vo.vo.VOEndereco;
import com.touchcomp.touchvomodel.vo.vo.VOPessoa;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import com.touchcomp.touchvomodel.webservices.touch.input.TEMPUsuario;
import com.touchcomp.touchvomodel.webservices.touch.output.TEMPRespostaUsuario;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.abrirticketchamadotouch.UtilityTicketChamadoTouch;

public class AuxRegistraAtUsuario {
    private static final TLogger logger = TLogger.get(UtilityTicketChamadoTouch.class);
    private Integer VERSAO = 1;

    public void registraAtualizaUsuario(Usuario user, Empresa emp, String servidor) throws Exception {
        try {
            Date date = new Date();
            RequisicaoWebservice msg = this.getMsg(user, emp);
            RespostaWebService res = this.sendMessage(msg, servidor);
            this.updateAndProcess(date, res, user);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void updateAndProcess(Date date, RespostaWebService res, Usuario user) throws Exception {
        if (res.getCodStatus() == 0) {
            throw new ExceptionService(res.getMensagem());
        }
        List data = ToolJson.readJsonList((String)ToolHexString.decodeToStr((String)res.getDetalhes()), TEMPRespostaUsuario.class);
        for (TEMPRespostaUsuario t : data) {
            if (t.getInseridoAtSucesso() != null && t.getInseridoAtSucesso() == 1) {
                user.setCodigoRegistro(t.getRegistroUsuarioTouch());
                user.setDataSincTouch(date);
                continue;
            }
            throw new Exception(t.getObservacoes());
        }
    }

    private RequisicaoWebservice getMsg(Usuario user, Empresa emp) throws IOException, Exception {
        RequisicaoWebservice req = new RequisicaoWebservice();
        req.setVersao(this.VERSAO);
        req.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson(this.getElementUser(user, emp))));
        return req;
    }

    public List<TEMPUsuario> getElementUser(Usuario user, Empresa empresa) {
        TEMPUsuario root = new TEMPUsuario();
        VOPessoa voUser = this.getVOPessoa(user.getUsuarioBasico().getPessoa());
        String cnpj = empresa.getPessoa().getComplemento().getCnpj();
        root.setIdUsuarioLocal(user.getIdentificador());
        root.setAtivo(user.getUsuarioBasico().getPessoa().getAtivo());
        root.setCnpjsEmpresas(cnpj);
        root.setPessoa(voUser);
        return Arrays.asList(root);
    }

    public TEMPUsuario getElementUserUnique(Usuario user, Empresa empresa) {
        TEMPUsuario root = new TEMPUsuario();
        VOPessoa voUser = this.getVOPessoa(user.getUsuarioBasico().getPessoa());
        String cnpj = empresa.getPessoa().getComplemento().getCnpj();
        root.setIdUsuarioLocal(user.getIdentificador());
        root.setAtivo(user.getUsuarioBasico().getPessoa().getAtivo());
        root.setCnpjsEmpresas(cnpj);
        root.setPessoa(voUser);
        return root;
    }

    public VOPessoa getVOPessoa(Pessoa pessoa) {
        VOPessoa ret = new VOPessoa();
        ret.setNome(pessoa.getNome());
        ret.setNomeFantasia(pessoa.getNomeFantasia());
        ret.setComplemento(this.getComplemento(pessoa.getComplemento()));
        ret.setEndereco(this.getEndereco(pessoa.getEndereco()));
        return ret;
    }

    private VOEndereco getEndereco(Endereco end) {
        VOEndereco root = new VOEndereco();
        root.setLogradouro(end.getLogradouro());
        root.setCep(end.getCep());
        root.setComplemento(end.getComplemento());
        root.setNumero(end.getNumero());
        root.setBairro(end.getBairro());
        VOCidade cidade = new VOCidade();
        cidade.setCodIbgeCompleto(end.getCidade().getCodIbgeCompleto());
        cidade.setDescricao(end.getCidade().getDescricao());
        root.setCidade(cidade);
        return root;
    }

    private VOComplemento getComplemento(Complemento complemento) {
        VOComplemento root = new VOComplemento();
        root.setFone1(complemento.getFone1());
        root.setFone2(complemento.getFone2());
        root.setCel1(complemento.getCel1());
        root.setCel2(complemento.getCel2());
        root.setFax1(complemento.getFax1());
        root.setFax2(complemento.getFax2());
        root.setCnpj(complemento.getCnpj());
        root.setInscEst(complemento.getInscEst());
        root.setDataNascimento(complemento.getDataNascimento());
        root.setSite(complemento.getSite());
        root.setEmailPrincipal(complemento.getEmailPrincipal());
        for (EmailPessoa em : complemento.getEmails()) {
            VOEmailPessoa email = new VOEmailPessoa();
            email.setAtivo(em.getAtivo());
            email.setDescricao(em.getDescricao());
            email.setEmail(em.getEmail());
            root.getEmails().add(email);
        }
        return root;
    }

    private RespostaWebService sendMessage(RequisicaoWebservice msg, String servidor) throws MalformedURLException, ExceptionWebService, ExceptionIO {
        RespostaWebService resp = (RespostaWebService)ToolRESTWebServiceClient.createServicePost((String)servidor, (String)"/sync/tickets-atend-touch//registra-usuario", (Object)msg, RespostaWebService.class);
        return resp;
    }
}

