/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.acuracidadeestoque;

import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GradeItemImpSaldo;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtility;
import mentorcore.utilities.CoreUtilityFactory;

public class UtilityAcuracidadeEstoque
extends CoreUtility {
    public void processarAcuracidade(ApuracidadeEstoque p, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaContabilidade empCont, EmpresaFinanceiro empFin, OpcoesContabeis opCont, OpcoesImpostos opImp) throws ExceptionService {
        if (p.getTipoBaixaEstoque() == 0) {
            this.validarDados(p);
            this.faturarNotaFiscalSaida(p, opFat, opFin, empCont, empFin, opCont, opImp);
        } else if (p.getTipoBaixaEstoque() == 1) {
            Requisicao r = ((HelperRequisicao)Context.get(HelperRequisicao.class)).gerarRequisicao(p);
            p.setRequisicao(r);
            if (p.getRequisicao() != null) {
                p.getRequisicao().setApuracidadeEstoque(p);
            }
        }
        if (p.getTipoEntradaEstoque() == 0) {
            this.validarDados(p);
            this.faturarNotaFiscalEntrada(p, opFat, opFin, empCont, empFin, opCont, opImp);
        } else if (p.getTipoEntradaEstoque() == 1) {
            p.setImplantacaoSaldo(this.getImplantacaoSaldos(p));
        }
    }

    private ImplantacaoSaldos getImplantacaoSaldos(ApuracidadeEstoque apuracidadeEstoque) throws ExceptionService {
        ImplantacaoSaldos implantacaoSaldos = this.buildImplantacaoSaldos(apuracidadeEstoque);
        if (implantacaoSaldos == null || implantacaoSaldos.getItemImplantaSaldo() == null || implantacaoSaldos.getItemImplantaSaldo().isEmpty()) {
            return null;
        }
        return implantacaoSaldos;
    }

    private void faturarNotaFiscalEntrada(ApuracidadeEstoque p, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaContabilidade empCont, EmpresaFinanceiro empFin, OpcoesContabeis opCont, OpcoesImpostos opImp) throws ExceptionService {
        List<NotaFiscalPropria> nf;
        if ((p.getNotasEntrada() == null || p.getNotasEntrada().isEmpty()) && (nf = CoreUtilityFactory.getUtilityGeracaoNFPropria().gerarNotaFiscalAcuracidadeEntrada(p, opFat, opFin, empCont, empFin, opCont, opImp)) != null) {
            p.setNotasEntrada(nf);
            for (NotaFiscalPropria n : p.getNotasEntrada()) {
                n.setApuracidadeEntrada(p);
            }
        }
    }

    private void faturarNotaFiscalSaida(ApuracidadeEstoque p, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaContabilidade empCont, EmpresaFinanceiro empFin, OpcoesContabeis opCont, OpcoesImpostos opImp) throws ExceptionService {
        List<NotaFiscalPropria> nf;
        if ((p.getNotasPerda() == null || p.getNotasPerda().isEmpty()) && (nf = CoreUtilityFactory.getUtilityGeracaoNFPropria().gerarNotaFiscalAcuracidadePerda(p, opFat, opFin, empCont, empFin, opCont, opImp)) != null) {
            p.setNotasPerda(nf);
            for (NotaFiscalPropria n : p.getNotasPerda()) {
                n.setApuracidadeSaida(p);
            }
        }
    }

    private List<Produto> getProducts(List<ItemApuracidadeEstoque> itens) {
        ArrayList<Produto> produtos = new ArrayList<Produto>();
        List<HashMap<String, Object>> productsList = this.buildItensHash(itens);
        for (HashMap<String, Object> produtoHash : productsList) {
            produtos.add((Produto)produtoHash.get("PRODUTO"));
        }
        return produtos;
    }

    private List<ItemApuracidadeEstoque> getItensApuracidade(List<ItemApuracidadeEstoque> itens, Produto produto) {
        List<HashMap<String, Object>> productsList = this.buildItensHash(itens);
        for (HashMap<String, Object> produtoHash : productsList) {
            if (!produtoHash.get("PRODUTO").equals(produto)) continue;
            return (List)produtoHash.get("ITENS");
        }
        return null;
    }

    private ImplantacaoSaldos buildImplantacaoSaldos(ApuracidadeEstoque apuracidadeEstoque) throws ExceptionService {
        if (apuracidadeEstoque.getTipoEntradaEstoque() == null || apuracidadeEstoque.getTipoEntradaEstoque() != 1) {
            return null;
        }
        ImplantacaoSaldos ret = apuracidadeEstoque.getImplantacaoSaldo();
        if (ret == null) {
            ret = new ImplantacaoSaldos();
        }
        ret.setDataCadastro(apuracidadeEstoque.getDataCadastro());
        ret.setDataEntradaSaida(apuracidadeEstoque.getDataApuracidadeEstoque());
        ret.setEmpresa(apuracidadeEstoque.getEmpresa());
        ret.getItemImplantaSaldo().clear();
        ret.getItemImplantaSaldo().addAll(this.getItensImplantacaoSaldos(ret, apuracidadeEstoque));
        return ret;
    }

    private List<ItemImplantaSaldo> getItensImplantacaoSaldos(ImplantacaoSaldos implantacaoSaldos, ApuracidadeEstoque apuracidadeEstoque) throws ExceptionService {
        ArrayList<ItemImplantaSaldo> itens = new ArrayList<ItemImplantaSaldo>();
        for (Produto produto : this.getProducts(apuracidadeEstoque.getItensApuracidadeEstoque())) {
            ItemImplantaSaldo itemImplantaSaldo = new ItemImplantaSaldo();
            itemImplantaSaldo.setCentroEstoque(apuracidadeEstoque.getCentroEstoque());
            itemImplantaSaldo.setProduto(produto);
            itemImplantaSaldo.setUnidadeMedida(produto.getUnidadeMedida());
            itemImplantaSaldo.setImplantacaoSaldos(implantacaoSaldos);
            itemImplantaSaldo.setGradeItem(this.buildGradeItensImplantacaoSaldos(itemImplantaSaldo, this.getItensApuracidade(apuracidadeEstoque.getItensApuracidadeEstoque(), produto), implantacaoSaldos.getDataEntradaSaida(), implantacaoSaldos.getEmpresa()));
            itemImplantaSaldo.setQuantidadeTotal(this.calculateQuantidadeTotalItemImplantacaoSaldo(itemImplantaSaldo.getGradeItem()));
            if (itemImplantaSaldo.getGradeItem() == null || itemImplantaSaldo.getGradeItem().isEmpty()) continue;
            itens.add(itemImplantaSaldo);
        }
        return itens;
    }

    private List<GradeItemImpSaldo> buildGradeItensImplantacaoSaldos(ItemImplantaSaldo itemImplantaSaldo, List<ItemApuracidadeEstoque> itens, Date data, Empresa emp) throws ExceptionService {
        ArrayList<GradeItemImpSaldo> grades = new ArrayList<GradeItemImpSaldo>();
        for (ItemApuracidadeEstoque itemApuracidade : itens) {
            Double totalEstoque = itemApuracidade.getQuantidadeInicial();
            if (!(totalEstoque < itemApuracidade.getQuantidadeFinal())) continue;
            GradeItemImpSaldo grade = new GradeItemImpSaldo();
            grade.setDataMovimentacao(data);
            grade.setGradeCor(itemApuracidade.getGradeCor());
            grade.setLoteFabricacao(itemApuracidade.getLoteFabricacao());
            grade.setQuantidade(Double.valueOf(itemApuracidade.getQuantidadeFinal() - totalEstoque));
            grade.setValorUnitario(itemApuracidade.getPrecoMedioFinal());
            grade.setItemImplantaSaldo(itemImplantaSaldo);
            grade.setCentroEstoque(itemImplantaSaldo.getCentroEstoque());
            grade.setEmpresa(emp);
            grades.add(grade);
        }
        return grades;
    }

    private Double calculateQuantidadeTotalItemImplantacaoSaldo(List<GradeItemImpSaldo> grades) {
        Double total = 0.0;
        for (GradeItemImpSaldo grade : grades) {
            total = total + grade.getQuantidade();
        }
        return total;
    }

    private List<HashMap<String, Object>> buildItensHash(List<ItemApuracidadeEstoque> itens) {
        ArrayList<HashMap<String, Object>> toAdd = new ArrayList<HashMap<String, Object>>();
        for (ItemApuracidadeEstoque item : itens) {
            if (this.addItemToHash(toAdd, item).booleanValue()) continue;
            toAdd.add(this.buildItemHash(item));
        }
        return toAdd;
    }

    private Boolean addItemToHash(List<HashMap<String, Object>> itens, ItemApuracidadeEstoque item) {
        for (HashMap<String, Object> produtoHash : itens) {
            Produto produto = item.getGradeCor().getProdutoGrade().getProduto();
            if (!produtoHash.get("PRODUTO").equals(produto)) continue;
            ((List)produtoHash.get("ITENS")).add(item);
            return true;
        }
        return false;
    }

    private HashMap buildItemHash(ItemApuracidadeEstoque item) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList<ItemApuracidadeEstoque> list = new ArrayList<ItemApuracidadeEstoque>();
        list.add(item);
        ret.put("PRODUTO", item.getGradeCor().getProdutoGrade().getProduto());
        ret.put("ITENS", list);
        return ret;
    }

    private void validarDados(ApuracidadeEstoque p) throws ExceptionService {
        if (p.getUnidadeFatCliente() == null) {
            throw new ExceptionService("Informe a unidade de faturamento do cliente.");
        }
        if (p.getNaturezaOperacaoEntrada() == null) {
            throw new ExceptionService("Informe a natureza de opera\u00e7\u00e3o.");
        }
        if (p.getNaturezaOperacaoSaida() == null) {
            throw new ExceptionService("Informe a natureza de opera\u00e7\u00e3o.");
        }
        if (p.getCondicoesPagamento() == null) {
            throw new ExceptionService("Informe a condi\u00e7\u00e3o de pagamento.");
        }
        if (p.getSituacaoDocumento() == null) {
            throw new ExceptionService("Informe a situa\u00e7\u00e3o do documento.");
        }
    }
}

