/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.apuracaoipi;

import com.touchcomp.basementor.model.vo.AjusteApuracaoIpi;
import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;

public class UtilityApuracaoIPI
extends CoreUtilityFactory {
    public ApuracaoIPI calcularValores(ApuracaoIPI vo) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("dataIn", vo.getDataInicial());
        r.setAttribute("dataFim", vo.getDataFinal());
        r.setAttribute("tpApuracao", vo.getTipoApuracao());
        r.setAttribute("empresa", vo.getEmpresa());
        HashMap h = (HashMap)CoreServiceFactory.getServiceApuracaoIpi().execute(r, "calcularValoresIpi");
        Double valorDebito = (Double)h.get("valorDebito");
        Double valorCredito = (Double)h.get("valorCredito");
        Double valorSaldoAnt = (Double)h.get("valorSaldoAnt");
        List ajustesDebitos = (List)h.get("ajustesDebitos");
        List ajustesCreditos = (List)h.get("ajustesCreditos");
        this.setAndDeleteAjustesAntigos(vo, ajustesDebitos, ajustesCreditos);
        Double outrosDebitos = this.getValorOutrosDebitos((short)0, vo);
        Double outrosCreditos = this.getValorOutrosDebitos((short)1, vo);
        Double saldoCredAntSis = vo.getSaldoCredorAntOutSis();
        if (saldoCredAntSis != null && saldoCredAntSis > 0.0) {
            valorSaldoAnt = saldoCredAntSis;
        }
        Double estornoCreditos = vo.getVrEstornoCredito();
        Double estornoDebitos = vo.getVrEstornoDebito();
        Double vlrTotalDeb = valorDebito + outrosDebitos + estornoCreditos;
        Double vlrTotalCred = valorCredito + outrosCreditos + estornoDebitos;
        Double saldoCredor = 0.0;
        Double saldoDevedor = 0.0;
        Double saldo = valorSaldoAnt + vlrTotalCred - vlrTotalDeb;
        if (saldo > 0.0) {
            saldoCredor = saldo;
        } else {
            saldoDevedor = Math.abs(saldo);
        }
        vo.setVrOutroDebito(outrosDebitos);
        vo.setVrOutroCredito(outrosCreditos);
        vo.setVrCredito(valorCredito);
        vo.setVrDebito(valorDebito);
        vo.setVrTotalDedito(vlrTotalDeb);
        vo.setVrTotalCredito(vlrTotalCred);
        vo.setSaldoCreditoAnterior(valorSaldoAnt);
        vo.setSaldoDevedor(saldoDevedor);
        vo.setSaldoCredor(saldoCredor);
        vo.setVrEstornoCredito(estornoCreditos);
        vo.setVrEstornoDebito(estornoDebitos);
        vo.setAgrupamentoValorIpi((List)h.get("dados"));
        return vo;
    }

    private Double getValorOutrosDebitos(Short tipo, ApuracaoIPI vo) {
        Double valor = 0.0;
        for (Object o : vo.getAjustesApuracaoIpi()) {
            AjusteApuracaoIpi a = (AjusteApuracaoIpi)o;
            if (a.getTipoAjuste().shortValue() != tipo.shortValue()) continue;
            valor = valor + a.getValorAjuste();
        }
        return valor;
    }

    private void setAndDeleteAjustesAntigos(ApuracaoIPI vo, List<AjusteApuracaoIpi> ajustesDebitos, List<AjusteApuracaoIpi> ajustesCreditos) {
        ArrayList<AjusteApuracaoIpi> manuais = new ArrayList<AjusteApuracaoIpi>();
        for (AjusteApuracaoIpi a : vo.getAjustesApuracaoIpi()) {
            if (!ToolMethods.isEquals((Object)a.getGerado(), (Object)0)) continue;
            manuais.add(a);
        }
        vo.getAjustesApuracaoIpi().clear();
        vo.setAjustesApuracaoIpi(new ArrayList());
        vo.getAjustesApuracaoIpi().addAll(ajustesCreditos);
        vo.getAjustesApuracaoIpi().addAll(ajustesDebitos);
        vo.getAjustesApuracaoIpi().addAll(manuais);
    }
}

