/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.baixatitulo;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilityBaixaTitulo {
    public static String completarHistoricoPadrao(BaixaTitulo b, HistoricoPadrao h) throws ExceptionService {
        String st = h.getDescricao();
        List token = ToolString.getReplaceTokens((String)st);
        HashMap<String, String> m = new HashMap<String, String>();
        for (Object o : token) {
            StringToken sk = (StringToken)o;
            m.put(sk.getChave(), UtilityBaixaTitulo.getFixedValue(sk.getChave(), b).toString());
        }
        st = ToolString.build((String)st, m);
        return st;
    }

    private static Object getFixedValue(String valor, BaixaTitulo b) throws ExceptionService {
        if (valor == null) {
            return "";
        }
        if (b != null && valor.equals("nrTitulo")) {
            return b.getTitulo().getIdentificador().toString();
        }
        if (b != null && valor.equalsIgnoreCase("numeroNotaTitulo")) {
            return UtilityBaixaTitulo.findNumeroNotaTerceiroTitulo(b);
        }
        if (b != null && valor.equalsIgnoreCase("nomePessoaTitulo")) {
            return b.getTitulo().getPessoa().getNome();
        }
        if (b != null && valor.equalsIgnoreCase("cfpPessoaTitulo")) {
            return b.getTitulo().getPessoa().getComplemento().getCnpj();
        }
        if (b != null && valor.equalsIgnoreCase("dataBaixaTitulo")) {
            return DateUtil.dateToStr(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao());
        }
        if (b != null && valor.equalsIgnoreCase("favorecidoCheque")) {
            if (b.getCheque() != null) {
                return b.getCheque().getFavorecido();
            }
        } else if (b != null && valor.equalsIgnoreCase("nrChequeProprio")) {
            if (b.getCheque() != null) {
                return b.getCheque().getNumero().toString();
            }
        } else {
            if (b != null && valor.equalsIgnoreCase("nrChequeTerceiros")) {
                Object cheques = "";
                if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                    for (Object o : b.getGrupoDeBaixaFormas().getChequeTerceirosPag()) {
                        ChequeTerceiros c = (ChequeTerceiros)o;
                        cheques = (String)cheques + c.getNumero().toString() + ",";
                    }
                } else {
                    for (Object o : b.getGrupoDeBaixaFormas().getChequeTerceirosRec()) {
                        ChequeTerceiros c = (ChequeTerceiros)o;
                        cheques = (String)cheques + c.getNumero().toString() + ",";
                    }
                }
                if (!((String)cheques).isEmpty()) {
                    return ((String)cheques).substring(0, ((String)cheques).trim().length() - 1);
                }
                return cheques;
            }
            if (b != null && valor.equalsIgnoreCase("vlrChequeProprio")) {
                if (b.getCheque() != null) {
                    return ContatoFormatUtil.formataNumero((Number)b.getCheque().getValor(), (int)2);
                }
            } else {
                if (b != null && valor.equalsIgnoreCase("vlrChequeTerceirosBaixa")) {
                    Double vrCheques = 0.0;
                    if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                        for (Object o : b.getGrupoDeBaixaFormas().getChequeTerceirosPag()) {
                            ChequeTerceiros c = (ChequeTerceiros)o;
                            vrCheques = vrCheques + c.getValor();
                        }
                    } else {
                        for (Object o : b.getGrupoDeBaixaFormas().getChequeTerceirosRec()) {
                            ChequeTerceiros c = (ChequeTerceiros)o;
                            vrCheques = vrCheques + c.getValor();
                        }
                    }
                    return vrCheques.toString();
                }
                if (b != null && valor.equalsIgnoreCase("dtVencimentoChequeBaixa")) {
                    if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                        return DateUtil.dateToStr(((ChequeTerceiros)b.getGrupoDeBaixaFormas().getChequeTerceirosPag().get(0)).getDataVencimento());
                    }
                    return DateUtil.dateToStr(((ChequeTerceiros)b.getGrupoDeBaixaFormas().getChequeTerceirosRec().get(0)).getDataVencimento());
                }
                if (b != null && valor.equalsIgnoreCase("dtVencTitulo")) {
                    return DateUtil.dateToStr(b.getTitulo().getDataVencimento());
                }
                if (b != null && valor.equalsIgnoreCase("valorTotalBaixa")) {
                    Double vrTotal = b.getValor() + b.getVrJuros() + b.getVrMulta() + b.getVrContribSocial() + b.getVrConfins() + UtilityBaixaTitulo.getValoresPagRec(b) + b.getVrPis() - b.getVrDesconto();
                    return vrTotal.toString();
                }
                if (b == null || !valor.equalsIgnoreCase("valorTotalChequesBaixa")) {
                    if (b != null && valor.equalsIgnoreCase("nomePessoa")) {
                        return b.getTitulo().getPessoa().getNome();
                    }
                    if (b != null && valor.equalsIgnoreCase("dataVencimentoTitulo")) {
                        return DateUtil.dateToStr(b.getTitulo().getDataVencimento());
                    }
                    if (b != null && valor.equalsIgnoreCase("tipodocFinanceiro")) {
                        return b.getTitulo().getTipoDoc().getNome();
                    }
                    if (b != null && valor.equalsIgnoreCase("observacao")) {
                        return b.getTitulo().getObservacao();
                    }
                    if (b != null && valor.equalsIgnoreCase("serieNota")) {
                        if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getSerie();
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getSerie();
                        }
                        return "";
                    }
                    if (b != null && valor.equalsIgnoreCase("nrNota")) {
                        if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota();
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota();
                        }
                        return "";
                    }
                    if (b != null && valor.equalsIgnoreCase("dtEmissaoNota")) {
                        if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEmissao();
                            }
                            return null;
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEmissaoNota();
                        }
                        return null;
                    }
                    if (b != null && valor.equalsIgnoreCase("dtEntSaidaNota")) {
                        if (b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec() == 0) {
                            if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
                                return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getDataEntrada();
                            }
                            return "";
                        }
                        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEntradaSaida();
                        }
                        return "";
                    }
                    if (b != null && b.getGrupoDeBaixaFormas() != null && valor.equalsIgnoreCase("dataBaixa")) {
                        return DateUtil.dateToStr(b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao());
                    }
                    if (b == null || !valor.equalsIgnoreCase("favorecido")) {
                        if (b != null && valor.equalsIgnoreCase("vlrDesconto")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrDesconto(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrAtMonetaria")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrAtualizacaoMonetariaRecebida(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrAtMonetariaPag")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrAtualizacaoMonetariaPaga(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrDespesaBancaria")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrDespBancariaPaga(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrDespesaBancariaRec")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrDespBancariaRecebida(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrMulta")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrMulta(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrPis")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrPis(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrConfins")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrConfins(), (int)3);
                        }
                        if (b != null && valor.equalsIgnoreCase("observacaoBaixa")) {
                            return b.getObservacao();
                        }
                        if (b != null && valor.equalsIgnoreCase("vlrContSocial")) {
                            return ContatoFormatUtil.formataNumero((Number)b.getVrContribSocial(), (int)3);
                        }
                    }
                }
            }
        }
        return "";
    }

    private static Object findNumeroNotaTerceiroTitulo(BaixaTitulo b) throws ExceptionService {
        if (b.getTitulo().getInfPagamentoNfTerceiros() != null && b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros() != null) {
            return b.getTitulo().getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getNumeroNota().toString();
        }
        if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            return b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota();
        }
        return "";
    }

    public static String getBaixaExedeValorTitulo(ExceptionService e) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            int init = ex.getMessage().indexOf("@");
            if (init > -1) {
                String aux = ex.getMessage().substring(init + 1);
                int end = aux.indexOf("@");
                if (end <= -1) continue;
                return aux.substring(0, end);
            }
            ex = ex.getCause();
        }
        return "";
    }

    private static double getValoresPagRec(BaixaTitulo b) {
        Double valorTotal = 0.0;
        valorTotal = b.getGrupoDeBaixaFormas().getGrupoDeBaixa().getPagRec().equals((short)0) ? Double.valueOf(valorTotal + (b.getVrDespBancariaPaga() - b.getVrDespBancariaRecebida() + b.getVrAtualizacaoMonetariaPaga() - b.getVrAtualizacaoMonetariaRecebida())) : Double.valueOf(valorTotal + (b.getVrDespBancariaRecebida() - b.getVrDespBancariaPaga() - b.getVrAtualizacaoMonetariaPaga() + b.getVrAtualizacaoMonetariaRecebida()));
        return valorTotal;
    }
}

