/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.boleto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.model.impl.ValoresAtBoletoTitulo;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.ItemLogDadosTitulo;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.TipoAlteracaoTitulo;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

class AuxAtualizaBoleto {
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);

    AuxAtualizaBoleto() {
    }

    ValoresAtBoletoTitulo calcValoresBoletoAt(BoletoTitulo boleto, Date novoVencimento, OpcoesFinanceiras opcoesFinanceiras, Usuario usuario) throws ExceptionService {
        if (novoVencimento == null) {
            throw new ExceptionService("Informe a data de vencimento para atualiza\u00e7\u00e3o do boleto.");
        }
        ValoresAtBoletoTitulo v = new ValoresAtBoletoTitulo();
        if (novoVencimento.before(boleto.getTitulo().getDataVencimento())) {
            v.setValorBase(boleto.getTitulo().getValorSaldo());
            v.setValorBoleto(boleto.getTitulo().getValorSaldo());
            if (boleto.getCalcularJuros() != null && boleto.getCalcularJuros().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorJuros(Double.valueOf(0.0));
                v.setPercJuros(boleto.getTitulo().getPercJurosMes());
            }
            if (boleto.getCalcularMulta() != null && boleto.getCalcularMulta().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorMulta(Double.valueOf(0.0));
                v.setPercMulta(boleto.getTitulo().getPercMulta());
            }
            if (boleto.getCalcularDespBanc() != null && boleto.getCalcularDespBanc().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorDespBanc(Double.valueOf(0.0));
            }
            v.setValorDesconto(boleto.getValorDesconto());
            v.setDataLimiteDesconto(boleto.getDataLimiteDesconto());
            v.setInformarManual(boleto.getInformarValorManual());
            v.setDataVenc(novoVencimento);
            v.setValorAbatimento(boleto.getValorAbatimento());
            if (boleto.getInformarValorManual() == null || boleto.getInformarValorManual().shortValue() != EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorTotal(Double.valueOf(v.getValorDespBanc() + v.getValorJuros() + v.getValorMulta() + v.getValorBase() - v.getValorDesconto() - v.getValorAbatimento()));
            } else {
                v.setValorTotal(boleto.getValorTotal());
                v.setValorBase(boleto.getValorTotal());
                v.setValorBoleto(boleto.getValorTotal());
                v.setValorDesconto(Double.valueOf(0.0));
                v.setValorDespBanc(Double.valueOf(0.0));
                v.setValorJuros(Double.valueOf(0.0));
                v.setValorMulta(Double.valueOf(0.0));
            }
        } else {
            v.setValorBase(boleto.getTitulo().getValorSaldo());
            v.setValorBoleto(boleto.getTitulo().getValorSaldo());
            if (boleto.getCalcularJuros() != null && boleto.getCalcularJuros().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorJuros(this.calcularValorJuros(boleto, novoVencimento));
                v.setPercJuros(boleto.getTitulo().getPercJurosMes());
            }
            if (boleto.getCalcularMulta() != null && boleto.getCalcularMulta().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorMulta(this.calcularValorMulta(boleto, novoVencimento));
                v.setPercMulta(boleto.getTitulo().getPercMulta());
            }
            if (boleto.getCalcularDespBanc() != null && boleto.getCalcularDespBanc().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorDespBanc(this.calcularValorDespBanc(boleto, opcoesFinanceiras));
            }
            v.setValorDesconto(boleto.getValorDesconto());
            v.setInformarManual(boleto.getInformarValorManual());
            v.setDataVenc(novoVencimento);
            v.setDataLimiteDesconto(boleto.getDataLimiteDesconto());
            v.setValorAbatimento(boleto.getValorAbatimento());
            if (boleto.getInformarValorManual() == null || boleto.getInformarValorManual().shortValue() != EnumConstantsMentorSimNao.SIM.getValue()) {
                v.setValorTotal(Double.valueOf(v.getValorDespBanc() + v.getValorJuros() + v.getValorMulta() + v.getValorBase() - v.getValorDesconto() - v.getValorAbatimento()));
            } else {
                v.setValorTotal(boleto.getValorTotal());
                v.setValorBase(boleto.getValorTotal());
                v.setValorBoleto(boleto.getValorTotal());
                v.setValorDesconto(Double.valueOf(0.0));
                v.setValorDespBanc(Double.valueOf(0.0));
                v.setValorJuros(Double.valueOf(0.0));
                v.setValorMulta(Double.valueOf(0.0));
            }
        }
        return v;
    }

    BoletoTitulo atualizarBoleto(BoletoTitulo boleto, ValoresAtBoletoTitulo val, Usuario usuario, OpcoesFinanceiras opcoesFinanceiras, Empresa empresa) throws ExceptionGeracaoBoletos, Exception {
        try {
            if (val == null) {
                throw new ExceptionGeracaoBoletos("Boleto nao foi recalculado.");
            }
            if (opcoesFinanceiras.getTipoAtualizacaoBoleto() != null && opcoesFinanceiras.getTipoAtualizacaoBoleto() == 0 && val.getDataVenc().before(boleto.getDataVencimento())) {
                throw new ExceptionService("Opcao de embutir valores no t\u00edtulo n\u00e3o permite que a nova data de vencimento seja menor que a anterior.");
            }
            this.gerarLogTituloDataVencimento(usuario, boleto, boleto.getDataVencimento(), val.getDataVenc(), opcoesFinanceiras);
            this.gerarLogTituloValor(usuario, boleto, val.getValorBase(), boleto.getValorTotal(), opcoesFinanceiras);
            boleto.setDataVencimento(val.getDataVenc());
            boleto.setDataLimiteDesconto(val.getDataLimiteDesconto());
            boleto.setValorBase(val.getValorBase());
            boleto.setValorDespBanc(val.getValorDespBanc());
            boleto.setValorJuros(val.getValorJuros());
            boleto.setValorMulta(val.getValorMulta());
            boleto.setValorTotal(val.getValorTotal());
            boleto.setPercJuros(val.getPercJuros());
            boleto.setPercMulta(val.getPercMulta());
            boleto.setValorDesconto(val.getValorDesconto());
            boleto.setValorBoleto(val.getValorBoleto());
            boleto.setValorAbatimento(val.getValorAbatimento());
            if (opcoesFinanceiras.getTipoAtualizacaoBoleto() != null && opcoesFinanceiras.getTipoAtualizacaoBoleto() == 0) {
                this.embutirValoresTitulo(boleto, empresa);
            } else {
                this.embutirDesconto(boleto);
            }
            this.addLogBoleto(boleto);
            boleto = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), boleto);
            return boleto;
        }
        catch (ExceptionService ex) {
            throw new ExceptionGeracaoBoletos(ex.getMessage(), (Throwable)ex);
        }
    }

    private Double calcularValorMulta(BoletoTitulo boleto, Date novoVenc) {
        int dias;
        Date dataIn = boleto.getTitulo().getDataAplicacaoMulta();
        if (dataIn == null) {
            dataIn = boleto.getTitulo().getDataVencimento();
        }
        if ((dias = this.calcularDifDias(dataIn, novoVenc)) > 0) {
            return ContatoFormatUtil.arrredondarNumero((Double)(boleto.getValorBase() * (boleto.getTitulo().getPercMulta() / 100.0)), (int)2);
        }
        return 0.0;
    }

    private int calcularDifDias(Date dataIn, Date dataFim) {
        Integer diasDif = DateUtil.diferenceDayBetweenDates(dataIn, dataFim);
        return diasDif;
    }

    private Double calcularValorJuros(BoletoTitulo boleto, Date novoVenc) {
        Date dataIn = boleto.getTitulo().getDataInicioJuros();
        if (dataIn == null) {
            dataIn = boleto.getTitulo().getDataVencimento();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(boleto.getValorBase() * (boleto.getTitulo().getPercJurosMes() / 100.0) / 30.0), (int)2) * (double)this.calcularDifDias(dataIn, novoVenc);
    }

    private void embutirValoresTitulo(BoletoTitulo boleto, Empresa empresa) throws ExceptionService, Exception {
        Titulo t = boleto.getTitulo();
        t.setDataVencimento(boleto.getDataVencimento());
        t.setDataLimiteDesconto(boleto.getDataLimiteDesconto());
        t.setValorDespBancPaga(boleto.getValorDespBanc());
        t.setValorDescontosEmbutido(boleto.getValorDesconto());
        t.setValorJurosEmbutido(boleto.getValorJuros());
        t.setValorMultaEmbutida(boleto.getValorMulta());
        t.setValorDespesaBancariaEmbutida(boleto.getValorDespBanc());
        t.setVrAbatimento(boleto.getValorAbatimento());
        t.setValor(boleto.getValorTotal());
        this.criarLancamentosGerenciaisJurosMultaEDespBancaria(boleto, empresa);
    }

    private Double calcularValorDespBanc(BoletoTitulo boleto, OpcoesFinanceiras opcoesFinanceiras) {
        return opcoesFinanceiras.getValorDespesaBancaria();
    }

    private void criarLancamentosGerenciaisJurosMultaEDespBancaria(BoletoTitulo b, Empresa empresa) throws ExceptionService, Exception {
        LancamentoCtbGerencial l;
        Titulo titulo = b.getTitulo();
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(titulo.getPagRec(), titulo.getTipoDoc(), titulo.getClassificacaoPessoa(), Short.valueOf((short)1), empresa);
        LancamentoCtbGerencial ll = (LancamentoCtbGerencial)titulo.getLancCtbGerencial().get(0);
        if (ToolMethods.isEquals((Object)opcoesContabeisBaixaTitulos.getPlanoGerencialJurosEmbutidosRec(), null)) {
            throw new ExceptionService("Primeiro, informe o Plano de Contas Gerencial para Juros Embutidos Recebidos em Empresa Financeiro!");
        }
        if (b.getValorJuros() > 0.0) {
            l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), new Date(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), titulo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente a juros embutidos do titulo nr: " + titulo.getIdentificador(), opcoesContabeisBaixaTitulos.getPlanoGerencialJurosEmbutidosRec(), titulo.getProvisao(), ll.getTipoLancamento(), opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao(), b.getValorJuros(), null);
            titulo.getLancCtbGerencial().add(l);
        }
        if (b.getValorMulta() > 0.0) {
            if (ToolMethods.isEquals((Object)opcoesContabeisBaixaTitulos.getPlanoGerencialMultaEmbutidaRec(), null)) {
                throw new ExceptionService("Primeiro, informe o Plano de Contas Gerencial para Multa Embutida Recebidos em Empresa Financeiro!");
            }
            l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), new Date(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), titulo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente a multa embutida do titulo nr: " + titulo.getIdentificador(), opcoesContabeisBaixaTitulos.getPlanoGerencialMultaEmbutidaRec(), titulo.getProvisao(), ll.getTipoLancamento(), opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao(), b.getValorMulta(), null);
            titulo.getLancCtbGerencial().add(l);
        }
        if (b.getValorDespBanc() > 0.0) {
            if (ToolMethods.isEquals((Object)opcoesContabeisBaixaTitulos.getPlanoGerencialDespBanEmbutidosRec(), null)) {
                throw new ExceptionService("Primeiro, informe o Plano de Contas Gerencial para Despesa Bancaria Embutida Recebidos em Empresa Financeiro!");
            }
            l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), new Date(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), titulo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente a despesa bancaria embutida do titulo nr: " + titulo.getIdentificador(), opcoesContabeisBaixaTitulos.getPlanoGerencialDespBanEmbutidosRec(), titulo.getProvisao(), ll.getTipoLancamento(), opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao(), b.getValorDespBanc(), null);
            titulo.getLancCtbGerencial().add(l);
        }
        if (b.getValorDesconto() > 0.0) {
            if (ToolMethods.isEquals((Object)opcoesContabeisBaixaTitulos.getPlanoContaDesc2Gerencial(), null)) {
                throw new ExceptionService("Primeiro, informe o Plano de Contas Gerencial para Descontos Concebidos em Empresa Financeiro!");
            }
            l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), new Date(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), titulo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente a desconto embutido do titulo nr: " + titulo.getIdentificador(), opcoesContabeisBaixaTitulos.getPlanoContaDesc2Gerencial(), titulo.getProvisao(), ll.getTipoLancamento(), opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao(), b.getValorDesconto(), null);
            titulo.getLancCtbGerencial().add(l);
        }
    }

    private void gerarLogTituloDataVencimento(Usuario usuario, BoletoTitulo boleto, Date dataAnterior, Date dataAtual, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        if (opcoesFinanceiras.getGerarLogCnabAtBoleto() == null || opcoesFinanceiras.getGerarLogCnabAtBoleto().shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            return;
        }
        if (usuario.getIdentificador() == null || usuario.getIdentificador() <= 0L) {
            throw new ExceptionService("Usuario nao pode registrar log de titulos.");
        }
        Titulo titulo = boleto.getTitulo();
        LogTitulos vo = new LogTitulos();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(titulo.getEmpresa());
        vo.setUsuario(usuario);
        vo.setTitulo(titulo);
        vo.setBoletoTitulo(boleto);
        vo.setTipoAlteracaoTitulo(this.findTipoAlteracaoTitulo("00"));
        vo.setMotivo("Alteracao de data de vencimento atraves do recurso de atualizacao de boleto.");
        ItemLogDadosTitulo itemLogDadosTitulo = new ItemLogDadosTitulo();
        itemLogDadosTitulo.setLogTitulos(vo);
        itemLogDadosTitulo.setNumeroTitulo(titulo.getIdentificador());
        itemLogDadosTitulo.setPessoa(titulo.getPessoa());
        itemLogDadosTitulo.setPagRec(titulo.getPagRec());
        itemLogDadosTitulo.setProvisao(titulo.getProvisao());
        itemLogDadosTitulo.setDataEmissao(titulo.getDataEmissao());
        itemLogDadosTitulo.setDataVencimento(dataAnterior);
        itemLogDadosTitulo.setDataVencimentoNovo(dataAtual);
        itemLogDadosTitulo.setCarteiraCobranca(titulo.getCarteiraCobranca());
        itemLogDadosTitulo.setValor(titulo.getValor());
        vo.setItemLogDadosTitulo(itemLogDadosTitulo);
        CoreUtilityFactory.getUtilityTitulos().updateLancGerencial(vo.getTitulo());
        boleto.getLogTitulos().add(vo);
    }

    private void gerarLogTituloValor(Usuario usuario, BoletoTitulo boleto, Double valorAnterior, Double valorAtual, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        if (opcoesFinanceiras.getGerarLogCnabAtBoleto() == null || opcoesFinanceiras.getGerarLogCnabAtBoleto().shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            return;
        }
        if (usuario.getIdentificador() == null || usuario.getIdentificador() <= 0L) {
            throw new ExceptionService("Usuario nao pode registrar log de titulos.");
        }
        Titulo titulo = boleto.getTitulo();
        LogTitulos vo = new LogTitulos();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(titulo.getEmpresa());
        vo.setUsuario(usuario);
        vo.setTitulo(titulo);
        vo.setTipoAlteracaoTitulo(this.findTipoAlteracaoTitulo("01"));
        vo.setMotivo("Alteracao do valor do titulo atraves do recurso de atualizacao de boleto.");
        ItemLogDadosTitulo itemLogDadosTitulo = new ItemLogDadosTitulo();
        itemLogDadosTitulo.setLogTitulos(vo);
        itemLogDadosTitulo.setNumeroTitulo(titulo.getIdentificador());
        itemLogDadosTitulo.setPessoa(titulo.getPessoa());
        itemLogDadosTitulo.setPagRec(titulo.getPagRec());
        itemLogDadosTitulo.setProvisao(titulo.getProvisao());
        itemLogDadosTitulo.setDataEmissao(titulo.getDataEmissao());
        itemLogDadosTitulo.setDataVencimento(titulo.getDataVencimento());
        itemLogDadosTitulo.setCarteiraCobranca(titulo.getCarteiraCobranca());
        itemLogDadosTitulo.setValor(valorAnterior);
        itemLogDadosTitulo.setValorNovo(valorAtual);
        vo.setItemLogDadosTitulo(itemLogDadosTitulo);
        boleto.getLogTitulos().add(vo);
    }

    private TipoAlteracaoTitulo findTipoAlteracaoTitulo(String codigoTipoAlteracao) throws ExceptionService {
        return (TipoAlteracaoTitulo)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoAlteracaoTitulo(), "codigo", codigoTipoAlteracao, 0);
    }

    private void addLogBoleto(BoletoTitulo boleto) {
        ItemAltBoletoHist it = new ItemAltBoletoHist();
        it.setDataAlteracao(new Date());
        it.setBoletoTitulo(boleto);
        StringBuilder sb = new StringBuilder();
        sb.append("Alteracao de boleto: Valor base: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorBase(), (int)2));
        sb.append(" Juros: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorJuros(), (int)2));
        sb.append(" Despesas: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDespBanc(), (int)2));
        sb.append(" Multa: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorMulta(), (int)2));
        sb.append(" Desc: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDesconto(), (int)2));
        sb.append(" Total: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorTotal(), (int)2));
        it.setObservacao(sb.toString());
        boleto.getItensAltBoleto().add(it);
    }

    private void embutirDesconto(BoletoTitulo boleto) {
        boleto.getTitulo().setVrAbatimento(boleto.getValorAbatimento());
        boleto.getTitulo().setValorDescontosEmbutido(boleto.getValorDesconto());
    }
}

