/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.boleto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.impl.ValoresAtBoletoTitulo;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoBoletos;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ResultProcessGerBol;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.boleto.AuxAtualizaBoleto;
import mentorcore.utilities.impl.notafiscalpropria.UtilNotaFiscalPropriaBuildText;
import net.sf.jasperreports.engine.JasperPrint;
import org.jboleto.JBoleto;
import org.jboleto.JBoletoBean;
import org.jboleto.control.Generator;
import org.jboleto.control.JasperGenerator;
import org.jboleto.exceptions.BoletoException;

public class UtilityBoleto {
    private JBoletoBean jBoletoBean;
    private File tmp;
    private Generator generator = null;
    private JBoleto jBoleto = null;
    private static final TLogger logger = TLogger.get(UtilityBoleto.class);

    public UtilityBoleto() {
        try {
            this.tmp = File.createTempFile("boleto", ".pdf");
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
    }

    public BoletoTitulo verificarBoletoTituloAtivo(Titulo t) {
        BoletoTitulo boleto = null;
        if (t.getBoletoTitulo() != null) {
            for (BoletoTitulo bo : t.getBoletoTitulo()) {
                if (bo.getAtivo() != 1) continue;
                boleto = bo;
            }
        }
        return boleto;
    }

    public String getCodigoBarras(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos, ExceptionService {
        try {
            UtilityBoleto n = new UtilityBoleto();
            n.createJBoletoBean(b, tipoNumero);
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            new JBoleto(n.getGenerator(), n.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto);
            return n.getjBoletoBean().getCodigoBarras();
        }
        catch (Throwable ex) {
            logger.error(ex.getClass(), ex);
            throw new ExceptionService("Erro ao gerar o boleto\n" + ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createJBoletoBean(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos, ExceptionService {
        if (b == null) throw new ExceptionGeracaoTitulos("O t\u00edtulo " + b.getTitulo().getIdentificador() + " n\u00e3o est\u00e1 inclu\u00eddo em uma Carteira de Cobran\u00e7a, por isso n\u00e3o foi poss\u00edvel gerar o boleto.");
        this.setjBoletoBean(new JBoletoBean());
        this.getjBoletoBean().setDataDocumento(DateUtil.dateToStr(b.getTitulo().getDataEmissao()));
        this.getjBoletoBean().setDataProcessamento(DateUtil.dateToStr(b.getDataCadastro()));
        if (ToolMethods.isEquals((Object)b.getCarteiraCobranca().getUsarAgenciaValorBeneficiario(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            this.getjBoletoBean().setCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getNome());
            this.getjBoletoBean().setCpfCedente(ContatoFormatUtil.formatCNPJCPF((String)b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getComplemento().getCnpj()));
            this.getjBoletoBean().setEnderecoCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getLogradouro());
            this.getjBoletoBean().setNumeroCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getNumero());
            this.getjBoletoBean().setBairroCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getBairro());
            this.getjBoletoBean().setCidadeCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getCidade().getDescricao());
            this.getjBoletoBean().setUfCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getCidade().getUf().getSigla());
            this.getjBoletoBean().setCepCedente(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa().getEndereco().getCep());
        } else {
            this.getjBoletoBean().setCedente(b.getTitulo().getEmpresa().getPessoa().getNome());
            this.getjBoletoBean().setCpfCedente(ContatoFormatUtil.formatCNPJCPF((String)b.getTitulo().getEmpresa().getPessoa().getComplemento().getCnpj()));
            this.getjBoletoBean().setEnderecoCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getLogradouro());
            this.getjBoletoBean().setNumeroCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getNumero());
            this.getjBoletoBean().setBairroCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getBairro());
            this.getjBoletoBean().setCidadeCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
            this.getjBoletoBean().setUfCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
            this.getjBoletoBean().setCepCedente(b.getTitulo().getEmpresa().getPessoa().getEndereco().getCep());
        }
        this.getjBoletoBean().setNomeSacado(b.getTitulo().getPessoa().getNome());
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("pessoa", b.getTitulo().getPessoa());
        Endereco endereco = null;
        if (b.getTitulo().getInfPagamentoNfPropria() != null) {
            endereco = b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEnderecoCobranca() != null ? b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEnderecoCobranca() : b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco();
            this.getjBoletoBean().setNomeSacado(b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getNome());
        } else {
            endereco = b.getTitulo().getPessoa().getEnderecoCobranca() != null ? b.getTitulo().getPessoa().getEnderecoCobranca() : (b.getTitulo().getRps() != null ? b.getTitulo().getRps().getUnidadeTomPrestRPS().getEndereco() : b.getTitulo().getPessoa().getEndereco());
        }
        if (endereco == null) {
            throw new ExceptionGeracaoTitulos("Erro ao gerar Boleto. A pessoa " + b.getTitulo().getPessoa().getNome().toUpperCase() + " esta sem Endere\u00e7o!");
        }
        this.getjBoletoBean().setEnderecoSacado(endereco.getLogradouro() + ", " + endereco.getNumero() + " - " + endereco.getComplemento());
        this.getjBoletoBean().setBairroSacado(endereco.getBairro());
        this.getjBoletoBean().setCidadeSacado(endereco.getCidade().getDescricao());
        this.getjBoletoBean().setUfSacado(endereco.getCidade().getUf().getSigla());
        this.getjBoletoBean().setCepSacado(endereco.getCep());
        this.getjBoletoBean().setNumeroSacado(endereco.getNumero());
        if (b.getCarteiraCobranca().getContaValor().getOperacao() != null) {
            this.getjBoletoBean().setCodigoOperacao(b.getCarteiraCobranca().getContaValor().getOperacao());
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("104")) {
            throw new ExceptionGeracaoTitulos("Para a Institui\u00e7\u00e3o Financeira " + b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNomeBanco() + " \u00e9 necess\u00e1rio informar o N\u00ba Raz\u00e3o da Conta Banc\u00e1ria no cadastro da Conta Valor");
        }
        if (!b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("756")) {
            if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
                this.getjBoletoBean().setCodigoFornecidoAgencia(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()));
            } else if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
                this.getjBoletoBean().setCodigoFornecidoAgencia(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()));
            } else {
                if (b.getCarteiraCobranca().getContaValor().getNumeroConvenio() == null || b.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) throw new ExceptionGeracaoTitulos("Informe o numero do convenio no cadastro da Carteira do Titulo: " + b.getTitulo().getIdentificador());
                this.getjBoletoBean().setCodigoFornecidoAgencia(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
            }
        } else if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
            this.getjBoletoBean().setCodigoFornecidoAgencia(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()));
        } else if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
            this.getjBoletoBean().setCodigoFornecidoAgencia(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()));
        } else {
            this.getjBoletoBean().setCodigoFornecidoAgencia(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
        }
        this.getjBoletoBean().setCpfSacado(ContatoFormatUtil.formatCNPJCPF((String)b.getTitulo().getPessoa().getComplemento().getCnpj()));
        this.getjBoletoBean().setImagemMarketing(this.getImageBoleto(b.getTitulo().getEmpresa()));
        this.getjBoletoBean().setDataVencimento(DateUtil.dateToStr(b.getDataVencimento(), "dd/MM/yyyy"));
        this.getjBoletoBean().setInstrucao1(UtilityBoleto.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto1(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao2(UtilityBoleto.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto2(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao3(UtilityBoleto.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto3(), b.getTitulo()));
        this.getjBoletoBean().setInstrucao4(UtilityBoleto.getInstrucaoBoleto(b.getCarteiraCobranca().getInstrucaoBoleto4(), b.getTitulo()));
        if (b.getCarteiraCobranca().getCodigoCarteira() == null) {
            throw new ExceptionGeracaoTitulos("C\u00f3digo da Carteira n\u00e3o informado no cadastro da Carteira de Cobran\u00e7a.");
        }
        if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new ExceptionGeracaoTitulos("N\u00famero da Ag\u00eancia n\u00e3o informado no cadastro da Institui\u00e7\u00e3o Financeira.");
        }
        if (b.getCarteiraCobranca().getContaValor().getNrConta() == null) {
            throw new ExceptionGeracaoTitulos("N\u00famero da Conta n\u00e3o informado no cadastro da Institui\u00e7\u00e3o Financeira.");
        }
        if (b == null || b.getNumeroTituloInst().equals(null)) {
            throw new ExceptionGeracaoTitulos("N\u00famero do T\u00edtulo n\u00e3o foi gerado, verifique o cadastro da Carteira de Cobran\u00e7a.");
        }
        this.getjBoletoBean().setAceite("N");
        if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("CODIGO_CARTEIRA_BOLETO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
            this.getjBoletoBean().setCarteira(UtilityArquivoCnab.getValueByKey("CODIGO_CARTEIRA_BOLETO", b.getTitulo().getConfiguracaoCnab()));
        } else {
            this.getjBoletoBean().setCarteira(b.getCarteiraCobranca().getCodigoCarteira());
        }
        this.getjBoletoBean().setLocalPagamento(b.getCarteiraCobranca().getLocalPagamento());
        this.getjBoletoBean().setAgencia(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia()));
        this.getjBoletoBean().setDvAgencia(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia()));
        this.getjBoletoBean().setContaCorrente(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getNrConta()));
        this.getjBoletoBean().setDvContaCorrente(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getDvConta()));
        this.getjBoletoBean().setEspecieDocumento("OU");
        this.getjBoletoBean().setCodCliente(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getNrCliente()));
        if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
            this.getjBoletoBean().setNumConvenio(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO", b.getTitulo().getConfiguracaoCnab()));
        } else if (b.getTitulo().getConfiguracaoCnab() != null && UtilityArquivoCnab.validValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()).booleanValue()) {
            this.getjBoletoBean().setNumConvenio(UtilityArquivoCnab.getValueByKey("NUMERO_CONVENIO_BOLETO", b.getTitulo().getConfiguracaoCnab()));
        } else {
            this.getjBoletoBean().setNumConvenio(ClearUtil.refina(b.getCarteiraCobranca().getContaValor().getNumeroConvenio()));
        }
        if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("041")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("001")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 17);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("237")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 11);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("104")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("399")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("341")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("389")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("999")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("033")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 12);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("756")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("409")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("422")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 9);
        } else if (b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco().equals("637")) {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 12);
        } else {
            this.getjBoletoBean().setNossoNumero(ClearUtil.refina(b.getNumeroTituloInst().toString()), 8);
        }
        if (tipoNumero != null && tipoNumero == 1) {
            if (b.getTitulo().getInfPagamentoNfPropria() != null && b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString()));
            } else if (b.getTitulo().getFaturaCte() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getFaturaCte().getIdentificador().toString()));
            } else if (b.getTitulo().getRps() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getRps().getNumero().toString()));
            } else if (b.getTitulo().getOrdemCompra() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getOrdemCompra().getIdentificador().toString()));
            } else if (b.getTitulo().getInfPagamentoPedido() != null && b.getTitulo().getInfPagamentoPedido().getPedido() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getInfPagamentoPedido().getPedido().getIdentificador().toString()));
            } else if (b.getTitulo().getPedidoComercio() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getPedidoComercio().getIdentificador().toString()));
            } else if (b.getTitulo().getAdiantamentoViagem() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getAdiantamentoViagem().getIdentificador().toString()));
            } else if (b.getTitulo().getNotaContratoLocacao() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getNotaContratoLocacao().getNumero().toString()));
            } else if (b.getTitulo().getContratoLocacao() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getContratoLocacao().getNumeroContrato().toString()));
            } else if (b.getTitulo().getApuracaoLocacaoContrato() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getApuracaoLocacaoContrato().getIdentificador().toString()));
            } else if (b.getTitulo().getCte() != null) {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getCte().getNumero().toString()));
            } else {
                this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getIdentificador().toString()));
            }
        } else {
            this.getjBoletoBean().setNoDocumento(ClearUtil.refina(b.getTitulo().getIdentificador().toString()));
        }
        if (b.getInformarValorManual() == null || b.getInformarValorManual() != 1) {
            Double valorTituloTotal = ContatoFormatUtil.arrredondarNumero((Double)b.getValorBoleto(), (int)2);
            this.getjBoletoBean().setValorBoleto(valorTituloTotal.toString());
            Double juros = ContatoFormatUtil.arrredondarNumero((Double)(b.getValorJuros() + b.getValorMulta()), (int)2);
            this.getjBoletoBean().setValorJuros(juros.toString());
            Double valorCobrado = ContatoFormatUtil.arrredondarNumero((Double)b.getValorTotal(), (int)2);
            this.getjBoletoBean().setValorCobrado(valorCobrado.toString());
            Double valorDescontos = ContatoFormatUtil.arrredondarNumero((Double)b.getValorDesconto(), (int)2);
            this.getjBoletoBean().setValorDescontos(valorDescontos.toString());
        } else {
            Double valorTituloTotal = ContatoFormatUtil.arrredondarNumero((Double)b.getValorBase(), (int)2);
            this.getjBoletoBean().setValorBoleto(valorTituloTotal.toString());
            this.getjBoletoBean().setValorCobrado(valorTituloTotal.toString());
        }
        this.getjBoletoBean().setNrBanco(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco());
        if (b.getTitulo().getNumParcTituloEstnota() == null) {
            this.getjBoletoBean().setNumeroParcela(ClearUtil.refina("1"));
        } else {
            this.getjBoletoBean().setNumeroParcela(ClearUtil.refina(b.getTitulo().getNumParcTituloEstnota().toString()));
        }
        if (b.getCarteiraCobranca().getSituacaoCobranca() == null || b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao() == null || b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao().isEmpty()) {
            throw new ExceptionGeracaoTitulos("Primeiro informe o Codigo Situa\u00e7\u00e3o na Situa\u00e7\u00e3o Cobran\u00e7a que esta vinculada na Carteira Financeira!");
        }
        this.getjBoletoBean().setModalidadeCobranca(ClearUtil.refina(b.getCarteiraCobranca().getSituacaoCobranca().getCodigoSituacao()));
        this.getjBoletoBean().getCodigoBarras();
    }

    public void gerarBoleto(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos, ExceptionService {
        try {
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)new JasperGenerator());
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00f3digo de barras errado. Quantidade \u00edmpar de d\u00edgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00e7a.");
            }
            this.getjBoleto().addBoleto();
            this.getjBoleto().closeBoleto(this.getTmp().getAbsolutePath());
        }
        catch (BoletoException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.", (Throwable)ex);
        }
    }

    public JasperPrint getJasperPrint(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos, ExceptionService {
        try {
            JasperGenerator jp = new JasperGenerator();
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)jp);
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00f3digo de barras errado. Quantidade \u00edmpar de d\u00edgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00e7a.");
            }
            this.getjBoleto().addBoleto();
            return null;
        }
        catch (BoletoException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.", (Throwable)ex);
        }
    }

    public static String getInstrucaoBoleto(String instrucao, Titulo titulo) {
        if (instrucao == null) {
            return "";
        }
        List tokens = ToolString.getReplaceTokens((String)instrucao);
        HashMap<String, String> values = new HashMap<String, String>();
        String value = "";
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            NotaFiscalPropria n = titulo.getInfPagamentoNfPropria() != null ? titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() : null;
            value = UtilNotaFiscalPropriaBuildText.getInstance().getValueEmail(tk.getChave(), n);
            if (value == null || value.isEmpty()) {
                value = UtilityBoleto.getFixedValue(tk.getChave(), titulo);
            }
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)instrucao, values);
    }

    public JBoletoBean getjBoletoBean() {
        return this.jBoletoBean;
    }

    public void setjBoletoBean(JBoletoBean jBoletoBean) {
        this.jBoletoBean = jBoletoBean;
    }

    public File getTmp() {
        return this.tmp;
    }

    public void setTmp(File tmp) {
        this.tmp = tmp;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public JBoleto getjBoleto() {
        return this.jBoleto;
    }

    public void setjBoleto(JBoleto jBoleto) {
        this.jBoleto = jBoleto;
    }

    public static String getFixedValue(String chave, Titulo titulo) {
        if (chave.equalsIgnoreCase("dataVencimentoTitulo")) {
            return DateUtil.dateToStr(titulo.getDataVencimento());
        }
        if (chave.equalsIgnoreCase("vlrJuros")) {
            return ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        }
        if (chave.equalsIgnoreCase("vlrMulta")) {
            return ContatoFormatUtil.formataNumero((Number)(titulo.getValor() * titulo.getPercMulta() / 100.0), (int)2);
        }
        if (chave.equalsIgnoreCase("numero rps") && titulo.getRps() != null && titulo.getRps().getNumeroNFse() != null) {
            return titulo.getRps().getNumeroNFse().toString();
        }
        if (chave.equalsIgnoreCase("nrParcela") && titulo.getNumParcTituloEstnota() != null) {
            return titulo.getNumParcTituloEstnota().toString();
        }
        if (chave.equalsIgnoreCase("nrParcelas") && titulo.getNumeroParcelas() != null) {
            return titulo.getNumeroParcelas().toString();
        }
        if (chave.equalsIgnoreCase("centroCusto") && titulo.getLancCtbGerencial() != null) {
            return UtilityBoleto.getCentroCustoLancGerencial(titulo.getLancCtbGerencial());
        }
        if (chave.equalsIgnoreCase("planoGerencial") && titulo.getLancCtbGerencial() != null) {
            return UtilityBoleto.getPlanoGerencialLancGerencial(titulo.getLancCtbGerencial());
        }
        if (chave.equalsIgnoreCase("observacao") && titulo.getObservacao() != null && !titulo.getObservacao().isEmpty()) {
            return titulo.getObservacao();
        }
        if (chave.equalsIgnoreCase("vlrDesconto")) {
            return ContatoFormatUtil.formataNumero((Number)titulo.getDescontoFinanceiro(), (int)2);
        }
        if (chave.equalsIgnoreCase("dataLimiteDesconto")) {
            return DateUtil.dateToStr(titulo.getDataLimiteDesconto());
        }
        return "";
    }

    public JBoletoBean gerarBoletoBI(BoletoTitulo b, Short tipoNumero) throws ExceptionGeracaoTitulos, ExceptionService {
        if (b.getAtivo() == 0) {
            throw new ExceptionGeracaoTitulos("Boleto inativo: " + b.getNumeroTituloInst());
        }
        if (b.getTitulo() == null) {
            throw new ExceptionGeracaoTitulos("Boleto sem titulo vinculado(Possivel exclus\u00e3o do titulo): " + b.getNumeroTituloInst());
        }
        try {
            this.createJBoletoBean(b, tipoNumero);
            this.setGenerator((Generator)new JasperGenerator());
            Integer codBancoEmissaoBoleto = b.getCarteiraCobranca().getInstValorRespEmissaoBoleto() != null ? Integer.valueOf(b.getCarteiraCobranca().getInstValorRespEmissaoBoleto().getNrBanco()) : null;
            this.setjBoleto(new JBoleto(this.getGenerator(), this.getjBoletoBean(), Integer.valueOf(b.getCarteiraCobranca().getContaValor().getAgenciaValor().getInstituicaoValor().getNrBanco()).intValue(), codBancoEmissaoBoleto));
            if (this.getjBoleto().getBanco().getCodigoBarras().length() % 2 != 0) {
                throw new ExceptionGeracaoTitulos("C\u00f3digo de barras errado. Quantidade \u00edmpar de d\u00edgitos. Revise os cadastros da Conta Valor e da Carteira de Cobran\u00e7a.");
            }
            this.getjBoleto().addBoleto();
            return this.getjBoletoBean();
        }
        catch (BoletoException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionGeracaoTitulos("Erro ao gerar o boleto.\n" + ex.getMessage(), (Throwable)ex);
        }
    }

    private String getImageBoleto(Empresa empresa) {
        try {
            byte[] img = UtilityBoleto.getBytesImageBoleto(empresa);
            if (img != null) {
                File tmp = File.createTempFile("logo", "png", new File(System.getProperty("java.io.tmpdir")));
                FileOutputStream f = null;
                f = new FileOutputStream(tmp);
                f.write(img);
                f.flush();
                f.close();
                return tmp.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
        return null;
    }

    private static byte[] getBytesImageBoleto(Empresa empresa) {
        byte[] img = null;
        img = empresa.getEmpresaDados().getLogoBoleto() != null ? empresa.getEmpresaDados().getLogoBoleto() : empresa.getEmpresaDados().getLogoRelatorios();
        return img;
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, CarteiraCobranca carteiraDestino, OpcoesFinanceiras opFin, Usuario usuario, Grupo grupoUsuarios, Empresa empresa) throws ExceptionGeracaoBoletos {
        for (Titulo titulo : titulos) {
            titulo.setCartCobrancaDestino(carteiraDestino);
        }
        return this.converterSalvarEGerarBoletoTitulo(titulos, opFin, usuario, grupoUsuarios, empresa);
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, OpcoesFinanceiras opFin, Usuario usuario, Grupo grupoUsuarios, Empresa empresa) throws ExceptionGeracaoBoletos {
        return this.converterSalvarEGerarBoletoTitulo(titulos, opFin, true, usuario, grupoUsuarios, empresa, false);
    }

    public ResultProcessGerBol converterSalvarEGerarBoletoTitulo(List<Titulo> titulos, OpcoesFinanceiras opFin, boolean gerarPDF, Usuario usuario, Grupo grupoUsuarios, Empresa empresa, Boolean objetoNaSessao) throws ExceptionGeracaoBoletos {
        try {
            this.validarTitulosParaGeracaoBoleto(titulos);
            ResultProcessGerBol res = new ResultProcessGerBol();
            Iterator<Titulo> iterator = titulos.iterator();
            while (iterator.hasNext()) {
                Titulo titulo;
                Titulo t = titulo = iterator.next();
                this.gerarBoletoTitulo(t, res);
            }
            LinkedList<BoletoTitulo> aux = new LinkedList<BoletoTitulo>();
            for (BoletoTitulo boleto : res.getBoletos()) {
                aux.add((BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), boleto));
                if (!objetoNaSessao.booleanValue()) continue;
                CoreBdUtil.getInstance().getSession().flush();
            }
            res.setBoletos(aux);
            aux = new LinkedList();
            for (BoletoTitulo boleto : res.getBoletos()) {
                String str = CoreUtilityFactory.getUtilityBoleto().getCodigoBarras(boleto, boleto.getTitulo().getConfiguracaoCnab().getTipoNumeroTitulo());
                boleto.setCodigoBarras(str);
                aux.add((BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), boleto));
            }
            res.setBoletos(aux);
            if (gerarPDF && aux.size() > 0) {
                CoreRequestContext coreRequestContext = new CoreRequestContext();
                coreRequestContext.setAttribute("boletos", res.getBoletos());
                coreRequestContext.setAttribute("usuario", usuario);
                coreRequestContext.setAttribute("grupoUsuarios", grupoUsuarios);
                coreRequestContext.setAttribute("empresa", empresa);
                coreRequestContext.setAttribute("tipoNumero", ((BoletoTitulo)res.getBoletos().get(0)).getTitulo().getConfiguracaoCnab().getTipoNumeroTitulo());
                List h = (List)CoreServiceFactory.getServiceBoletoTitulo().execute(coreRequestContext, "gerarBoletoTitulo");
                res.setDataOutput(h);
            }
            return res;
        }
        catch (ExceptionGeracaoTitulos | ExceptionService ex) {
            logger.error(ex.getClass(), ex);
            throw new ExceptionGeracaoBoletos("Erro ao gerar os boletos." + ex.getMessage(), ex);
        }
    }

    public BoletoTitulo gerarCopiaBoletoTitulo(BoletoTitulo oldBoleto, BoletoTitulo newBoleto, OpcoesFinanceiras opFin) throws ExceptionGeracaoBoletos {
        try {
            newBoleto = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), newBoleto);
            this.addLogBoletoGeradoEmRelacaoAoAnterior(newBoleto);
            Short tipoNumero = newBoleto.getTitulo().getConfiguracaoCnab().getTipoNumeroTitulo();
            String str = CoreUtilityFactory.getUtilityBoleto().getCodigoBarras(newBoleto, tipoNumero);
            newBoleto.setCodigoBarras(str);
            newBoleto = (BoletoTitulo)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBoletoTitulo(), newBoleto);
            return newBoleto;
        }
        catch (ExceptionGeracaoTitulos | ExceptionService ex) {
            logger.error(ex.getClass(), ex);
            throw new ExceptionGeracaoBoletos("Erro ao gerar os boletos." + ex.getMessage(), ex);
        }
    }

    public BoletoTitulo getBoletoAtivo(Titulo titulo) {
        if (titulo.getBoletoTitulo() == null) {
            return null;
        }
        BoletoTitulo found = null;
        for (BoletoTitulo boletoTitulo : titulo.getBoletoTitulo()) {
            if (boletoTitulo.getAtivo() == null || boletoTitulo.getAtivo() != 1) continue;
            found = boletoTitulo;
        }
        return found;
    }

    private boolean validoTirarBoleto(Titulo t, BoletoTitulo b, CarteiraCobranca carteiraCobranca, ResultProcessGerBol result) throws ExceptionService {
        StringBuilder sb = result.getErrosGerados();
        if (carteiraCobranca.getDataInNossoNumero() == null) {
            sb.append("\nData inicial emissao boleto nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getDataInNossoNumero() != null && new Date().before(carteiraCobranca.getDataInNossoNumero())) {
            sb.append("\nData inicial emissao boleto nao pode ser maior que a data atual ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getNossoNumeroInicial() == null) {
            sb.append("\nNosso numero inicial nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (carteiraCobranca.getCodigoCarteira() == null) {
            sb.append("\nCodigo da carteira do banco nao informado na carteira ").append(carteiraCobranca.getNome());
        }
        if (t.getPagRec() != 1) {
            sb.append("\nTitulo deve ser de recebimento ").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        if (t.getProvisao() != 1) {
            sb.append("\nTitulo deve ser realizado ").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        Double saldo = t.getValor();
        if (t.getIdentificador() != null) {
            saldo = t.getValorSaldo();
        }
        if (b != null && saldo == 0.0) {
            sb.append("\nTitulo j\u00e1 baixado.").append(t.getIdentificador()).append(" ").append(t.getPessoa().getNome());
        }
        return sb.length() <= 0;
    }

    public ResultProcessGerBol gerarBoletoTitulo(Titulo t) throws ExceptionService {
        ResultProcessGerBol result = new ResultProcessGerBol();
        this.gerarBoletoTitulo(t, result);
        return result;
    }

    public ResultProcessGerBol gerarBoletoTitulo(Titulo t, ResultProcessGerBol result) throws ExceptionService {
        CarteiraCobranca cart = t.getCarteiraCobranca();
        if (t.getCartCobrancaDestino() != null) {
            cart = t.getCartCobrancaDestino();
        }
        if (t.getIdentificador() != null && t.getIdentificador() > 0L && t.getValorSaldo() <= 0.0) {
            throw new ExceptionService(" O T\u00edtulo " + t.toString().toUpperCase() + " n\u00e3o possui saldo!");
        }
        BoletoTitulo b = this.getBoletoAtivo(t);
        if (b != null) {
            cart = b.getCarteiraCobranca();
        }
        if (this.validoTirarBoleto(t, b, cart, result)) {
            if (b == null) {
                b = new BoletoTitulo();
                b.setAtivo(Short.valueOf((short)1));
                b.setCalcularDespBanc(Short.valueOf((short)0));
                b.setCalcularJuros(Short.valueOf((short)0));
                b.setCalcularMulta(Short.valueOf((short)0));
                b.setDataCadastro(new Date());
                b.setDataVencimento(t.getDataVencimento());
                b.setPercDesconto(t.getPercDescontoMes());
                b.setPercJuros(t.getPercJurosMes());
                b.setPercMulta(t.getPercMulta());
                b.setValorDesconto(Double.valueOf(t.getDescontoFinanceiro() + t.getValorDescontosEmbutido()));
                b.setValorTotal(Double.valueOf(t.getValorSaldo() - b.getValorDesconto()));
                b.setValorBoleto(t.getValorSaldo());
                b.setCarteiraCobranca(cart);
                b.setNrTitulo(t.getIdentificador());
                this.addLogBoleto(b);
            }
            b.setTitulo(t);
            result.getBoletos().add(b);
        }
        return result;
    }

    public void addLogBoleto(BoletoTitulo boleto) {
        ItemAltBoletoHist it = new ItemAltBoletoHist();
        it.setDataAlteracao(new Date());
        it.setBoletoTitulo(boleto);
        StringBuilder sb = new StringBuilder();
        sb.append("Criacao de boleto: Valor base: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorBase(), (int)2));
        sb.append(" Juros: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorJuros(), (int)2));
        sb.append(" Despesas: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDespBanc(), (int)2));
        sb.append(" Multa: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorMulta(), (int)2));
        sb.append(" Desc: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDesconto(), (int)2));
        sb.append(" Total: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorTotal(), (int)2));
        it.setObservacao(sb.toString());
        boleto.getItensAltBoleto().add(it);
    }

    public BoletoTitulo atualizarBoletoTitulo(BoletoTitulo boleto, OpcoesFinanceiras opcoesFinanceiras, ValoresAtBoletoTitulo val, Usuario usuario, Empresa empresa) throws ExceptionGeracaoBoletos, Exception {
        return new AuxAtualizaBoleto().atualizarBoleto(boleto, val, usuario, opcoesFinanceiras, empresa);
    }

    public ValoresAtBoletoTitulo calcAtualizacaoVlrTitulo(BoletoTitulo boleto, Date novoVencimento, OpcoesFinanceiras opcoesFinanceiras, Usuario usuario) throws ExceptionService {
        return new AuxAtualizaBoleto().calcValoresBoletoAt(boleto, novoVencimento, opcoesFinanceiras, usuario);
    }

    public BoletoTitulo calcAndAtualizacaoVlrTitulo(BoletoTitulo b, Date dataVencimento, OpcoesFinanceiras opcoesFinanceiras, Usuario usuario, Empresa empresa) throws ExceptionService, ExceptionGeracaoBoletos, Exception {
        ValoresAtBoletoTitulo v = this.calcAtualizacaoVlrTitulo(b, dataVencimento, opcoesFinanceiras, usuario);
        return this.atualizarBoletoTitulo(b, opcoesFinanceiras, v, usuario, empresa);
    }

    private static String getCentroCustoLancGerencial(List<LancamentoCtbGerencial> lancamentos) {
        Object texto = "";
        int nrLanc = 0;
        for (LancamentoCtbGerencial l : lancamentos) {
            if (l.getCentroCusto() == null) continue;
            ++nrLanc;
        }
        int count = 1;
        for (LancamentoCtbGerencial l : lancamentos) {
            if (l.getCentroCusto() == null) continue;
            texto = count == nrLanc ? (String)texto + l.getCentroCusto().getNome() : (String)texto + l.getCentroCusto().getNome() + ", ";
            ++count;
        }
        return texto;
    }

    private static String getPlanoGerencialLancGerencial(List<LancamentoCtbGerencial> lancamentos) {
        Object texto = "";
        int nrLanc = lancamentos.size();
        int count = 1;
        for (LancamentoCtbGerencial l : lancamentos) {
            texto = count == nrLanc ? (String)texto + l.getPlanoContaGerencial().getDescricao() : (String)texto + l.getPlanoContaGerencial().getDescricao() + ", ";
            ++count;
        }
        return texto;
    }

    public void addLogBoletoGeradoEmRelacaoAoAnterior(BoletoTitulo boleto) {
        ItemAltBoletoHist it = new ItemAltBoletoHist();
        it.setDataAlteracao(new Date());
        it.setBoletoTitulo(boleto);
        StringBuilder sb = new StringBuilder();
        sb.append("Criacao de boleto com base em outro boleto: Valor base: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorBase(), (int)2));
        sb.append(" Juros: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorJuros(), (int)2));
        sb.append(" Despesas: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDespBanc(), (int)2));
        sb.append(" Multa: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorMulta(), (int)2));
        sb.append(" Desc: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorDesconto(), (int)2));
        sb.append(" Total: " + ContatoFormatUtil.formataNumero((Number)boleto.getValorTotal(), (int)2));
        it.setObservacao(sb.toString());
        boleto.getItensAltBoleto().add(it);
    }

    private void validarTitulosParaGeracaoBoleto(List<Titulo> titulos) throws ExceptionGeracaoBoletos {
        Object aux = "";
        for (Titulo titulo : titulos) {
            CarteiraCobranca carteiraCobranca = titulo.getCarteiraCobranca();
            if (ToolMethods.isNotNull((Object)titulo.getCartCobrancaDestino()).booleanValue()) {
                carteiraCobranca = titulo.getCartCobrancaDestino();
            }
            if (ToolMethods.isNull((Object)carteiraCobranca.getDataInNossoNumero()).booleanValue() && !((String)aux).contains(MessagesBaseMentor.getMsg((String)"E.ERP.1213.001", (Object[])new Object[]{carteiraCobranca.getIdentificador()}))) {
                aux = (String)aux + MessagesBaseMentor.getMsg((String)"E.ERP.1213.001", (Object[])new Object[]{carteiraCobranca.getIdentificador()});
                aux = (String)aux + "\n";
            }
            if (!ToolMethods.isStrWithData((String)carteiraCobranca.getNossoNumeroInicial()) && !((String)aux).contains(MessagesBaseMentor.getMsg((String)"E.ERP.1213.002", (Object[])new Object[]{carteiraCobranca.getIdentificador()}))) {
                aux = (String)aux + MessagesBaseMentor.getMsg((String)"E.ERP.1213.002", (Object[])new Object[]{carteiraCobranca.getIdentificador()});
                aux = (String)aux + "\n";
            }
            if (ToolMethods.isStrWithData((String)carteiraCobranca.getCodigoCarteira()) || ((String)aux).contains(MessagesBaseMentor.getMsg((String)"E.ERP.1213.003", (Object[])new Object[]{carteiraCobranca.getIdentificador()}))) continue;
            aux = (String)aux + MessagesBaseMentor.getMsg((String)"E.ERP.1213.003", (Object[])new Object[]{carteiraCobranca.getIdentificador()});
            aux = (String)aux + "\n";
        }
        if (ToolMethods.isStrWithData((String)aux)) {
            throw new ExceptionGeracaoBoletos((String)aux);
        }
    }
}

