/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculocodigobarras;

import java.util.LinkedList;
import java.util.List;
import mentorcore.utilities.impl.calculocodigobarras.UtilCalculoModulo;

public class UtilCalculoCodigoBarras {
    public String calculaLinha(String barra) {
        String str = "";
        String linha = barra.replaceAll("[^0-9]", "");
        if (linha.length() != 44) {
            return null;
        }
        str = linha.substring(0, 2).equals("86") || linha.substring(0, 2).equals("83") || linha.substring(0, 2).equals("87") || linha.substring(0, 2).equals("81") || linha.substring(0, 2).equals("82") || linha.substring(0, 2).equals("84") || linha.substring(0, 2).equals("89") ? this.getLinhaDigitavelBoletosConcessionariasModulo10(linha) : (linha.substring(0, 2).equals("85") ? this.getLinhaDigitavelBoletosConcessionariasModulo11(linha) : this.getLinhaDigitavelBoletosBancarios(linha));
        return str;
    }

    public String calculaCodigoBarras(String linhaDigitavel) {
        String str = "";
        String linha = linhaDigitavel.replaceAll("[^0-9]", "");
        if (linha.substring(0, 2).equals("86") || linha.substring(0, 2).equals("83") || linha.substring(0, 2).equals("87") || linha.substring(0, 2).equals("85") || linha.substring(0, 2).equals("81") || linha.substring(0, 2).equals("82") || linha.substring(0, 2).equals("84") || linha.substring(0, 2).equals("89")) {
            if (linha.length() != 48) {
                return null;
            }
            str = this.getCodigoBarrasBoletosConcessionarias(linha);
        } else {
            if (linha.length() != 47) {
                return null;
            }
            str = this.getCodigoBarrasBoletosBancarios(linha);
        }
        return str;
    }

    static boolean isBoleto(String barcode) {
        if (barcode.length() != 44) {
            return false;
        }
        for (Banco bb : UtilCalculoCodigoBarras.getListaBancos()) {
            if (!bb.nrBanco.endsWith(barcode.substring(0, 3))) continue;
            return true;
        }
        return false;
    }

    private static List<Banco> getListaBancos() {
        LinkedList<Banco> l = new LinkedList<Banco>();
        l.add(new Banco("246", "Banco ABC Brasil S.A."));
        l.add(new Banco("025", "Banco Alfa S.A."));
        l.add(new Banco("641", "Banco Alvorada S.A."));
        l.add(new Banco("029", "Banco Banerj S.A."));
        l.add(new Banco("000", "Banco Bankpar S.A."));
        l.add(new Banco("740", "Banco Barclays S.A."));
        l.add(new Banco("107", "Banco BBM S.A."));
        l.add(new Banco("031", "Banco Beg S.A."));
        l.add(new Banco("739", "Banco BGN S.A."));
        l.add(new Banco("096", "Banco BM&F de Servicos de Liquidacao e Custodia S.A"));
        l.add(new Banco("318", "Banco BMG S.A."));
        l.add(new Banco("752", "Banco BNP Paribas Brasil S.A."));
        l.add(new Banco("248", "Banco Boavista Interatl\u00e2ntico S.A."));
        l.add(new Banco("218", "Banco Bonsucesso S.A."));
        l.add(new Banco("065", "Banco Bracce S.A."));
        l.add(new Banco("036", "Banco Bradesco BBI S.A."));
        l.add(new Banco("204", "Banco Bradesco Cartoes S.A."));
        l.add(new Banco("394", "Banco Bradesco Financiamentos S.A."));
        l.add(new Banco("237", "Banco Bradesco S.A."));
        l.add(new Banco("225", "Banco Brascan S.A."));
        l.add(new Banco("208", "Banco BTG Pactual S.A."));
        l.add(new Banco("044", "Banco BVA S.A."));
        l.add(new Banco("263", "Banco Cacique S.A."));
        l.add(new Banco("473", "Banco Caixa Geral - Brasil S.A."));
        l.add(new Banco("040", "Banco Cargill S.A."));
        l.add(new Banco("233", "Banco Cifra S.A."));
        l.add(new Banco("745", "Banco Citibank S.A."));
        l.add(new Banco("215", "Banco Comercial e de Investimento Sudameris S.A."));
        l.add(new Banco("756", "Banco Cooperativo do Brasil S.A. - BANCOOB"));
        l.add(new Banco("748", "Banco Cooperativo Sicredi S.A."));
        l.add(new Banco("222", "Banco Credit Agricole Brasil S.A."));
        l.add(new Banco("505", "Banco Credit Suisse (Brasil) S.A."));
        l.add(new Banco("229", "Banco Cruzeiro do Sul S.A."));
        l.add(new Banco("000", "Banco CSF S.A."));
        l.add(new Banco("003", "Banco da Amazonia S.A."));
        l.add(new Banco("083", "Banco da China Brasil S.A."));
        l.add(new Banco("707", "Banco Daycoval S.A."));
        l.add(new Banco("024", "Banco de Pernambuco S.A. - BANDEPE"));
        l.add(new Banco("456", "Banco de Tokyo-Mitsubishi UFJ Brasil S.A."));
        l.add(new Banco("214", "Banco Dibens S.A."));
        l.add(new Banco("047", "Banco do Estado de Sergipe S.A."));
        l.add(new Banco("037", "Banco do Estado do Para S.A."));
        l.add(new Banco("041", "Banco do Estado do Rio Grande do Sul S.A."));
        l.add(new Banco("004", "Banco do Nordeste do Brasil S.A."));
        l.add(new Banco("265", "Banco Fator S.A."));
        l.add(new Banco("224", "Banco Fibra S.A."));
        l.add(new Banco("626", "Banco Ficsa S.A."));
        l.add(new Banco("000", "Banco Fidis S.A."));
        l.add(new Banco("394", "Banco Finasa BMC S.A."));
        l.add(new Banco("612", "Banco Guanabara S.A."));
        l.add(new Banco("063", "Banco Ibi S.A. Banco Multiplo"));
        l.add(new Banco("604", "Banco Industrial do Brasil S.A."));
        l.add(new Banco("320", "Banco Industrial e Comercial S.A."));
        l.add(new Banco("653", "Banco Indusval S.A."));
        l.add(new Banco("249", "Banco Investcred Unibanco S.A."));
        l.add(new Banco("184", "Banco Itau BBA S.A."));
        l.add(new Banco("479", "Banco ItauBank S.A"));
        l.add(new Banco("000", "Banco Itaucard S.A."));
        l.add(new Banco("376", "Banco J. P. Morgan S.A."));
        l.add(new Banco("074", "Banco J. Safra S.A."));
        l.add(new Banco("217", "Banco John Deere S.A."));
        l.add(new Banco("600", "Banco Luso Brasileiro S.A."));
        l.add(new Banco("389", "Banco Mercantil do Brasil S.A."));
        l.add(new Banco("746", "Banco Modal S.A."));
        l.add(new Banco("045", "Banco Opportunity S.A."));
        l.add(new Banco("079", "Banco Original do Agronegocio S.A."));
        l.add(new Banco("623", "Banco Panamericano S.A."));
        l.add(new Banco("611", "Banco Paulista S.A."));
        l.add(new Banco("643", "Banco Pine S.A."));
        l.add(new Banco("638", "Banco Prosper S.A."));
        l.add(new Banco("747", "Banco Rabobank International Brasil S.A."));
        l.add(new Banco("356", "Banco Real S.A."));
        l.add(new Banco("633", "Banco Rendimento S.A."));
        l.add(new Banco("072", "Banco Rural Mais S.A."));
        l.add(new Banco("453", "Banco Rural S.A."));
        l.add(new Banco("422", "Banco Safra S.A."));
        l.add(new Banco("033", "Banco Santander (Brasil) S.A."));
        l.add(new Banco("250", "Banco Schahin S.A."));
        l.add(new Banco("749", "Banco Simples S.A."));
        l.add(new Banco("366", "Banco Societe Generale Brasil S.A."));
        l.add(new Banco("637", "Banco Sofisa S.A."));
        l.add(new Banco("012", "Banco Standard de Investimentos S.A."));
        l.add(new Banco("464", "Banco Sumitomo Mitsui Brasileiro S.A."));
        l.add(new Banco("082", "Banco Topazio S.A."));
        l.add(new Banco("634", "Banco Tri\u00e2ngulo S.A."));
        l.add(new Banco("655", "Banco Votorantim S.A."));
        l.add(new Banco("610", "Banco VR S.A."));
        l.add(new Banco("119", "Banco Western Union do Brasil S.A."));
        l.add(new Banco("370", "Banco WestLB do Brasil S.A."));
        l.add(new Banco("000", "Banco Yamaha Motor S.A."));
        l.add(new Banco("021", "BANESTES S.A. Banco do Estado do Espirito Santo"));
        l.add(new Banco("719", "Banif-Banco Internacional do Funchal (Brasil)S.A."));
        l.add(new Banco("755", "Bank of America Merrill Lynch Banco Multiplo S.A."));
        l.add(new Banco("073", "BB Banco Popular do Brasil S.A."));
        l.add(new Banco("078", "BES Investimento do Brasil S.A.-Banco de Investimento"));
        l.add(new Banco("069", "BPN Brasil Banco Multiplo S.A."));
        l.add(new Banco("070", "BRB - Banco de Brasilia S.A."));
        l.add(new Banco("104", "Caixa Economica Federal"));
        l.add(new Banco("477", "Citibank S.A."));
        l.add(new Banco("081", "Concordia Banco S.A."));
        l.add(new Banco("487", "Deutsche Bank S.A. - Banco Alemao"));
        l.add(new Banco("064", "Goldman Sachs do Brasil Banco Multiplo S.A."));
        l.add(new Banco("062", "Hipercard Banco Multiplo S.A."));
        l.add(new Banco("399", "HSBC Bank Brasil S.A."));
        l.add(new Banco("492", "ING Bank N.V."));
        l.add(new Banco("652", "Itau Unibanco Holding S.A."));
        l.add(new Banco("341", "Itau Unibanco S.A."));
        l.add(new Banco("488", "JPMorgan Chase Bank"));
        l.add(new Banco("751", "Scotiabank Brasil S.A. Banco Multiplo"));
        l.add(new Banco("000", "Standard Chartered Bank (Brasil) S/A?Bco Invest."));
        l.add(new Banco("409", "UNIBANCO - Uniao de Bancos Brasileiros S.A."));
        l.add(new Banco("230", "Unicard Banco Multiplo S.A."));
        l.add(new Banco("999", "OUTROS."));
        l.add(new Banco("001", "BANCO DO BRASIL"));
        return l;
    }

    static String formataBoleto(String codigo) {
        return codigo.substring(0, 5) + "." + codigo.substring(5, 10) + "  " + codigo.substring(10, 15) + "." + codigo.substring(15, 21) + "  " + codigo.substring(21, 26) + "." + codigo.substring(26, 32) + "  " + codigo.substring(32, 33) + "  " + codigo.substring(33);
    }

    private String getLinhaDigitavelBoletosBancarios(String linha) {
        String campo1 = linha.substring(0, 4) + linha.substring(19, 20) + linha.substring(20, 24);
        String campo2 = linha.substring(24, 29) + linha.substring(29, 34);
        String campo3 = linha.substring(34, 39) + linha.substring(39, 44);
        String campo4 = linha.substring(4, 5);
        String campo5 = linha.substring(5, 19);
        String modulo10_1 = String.valueOf(new UtilCalculoModulo().modulo10(campo1));
        String modulo10_2 = String.valueOf(new UtilCalculoModulo().modulo10(campo2));
        String modulo10_3 = String.valueOf(new UtilCalculoModulo().modulo10(campo3));
        String str = campo1 + modulo10_1 + campo2 + modulo10_2 + campo3 + modulo10_3 + campo4 + campo5;
        return str;
    }

    private String getLinhaDigitavelBoletosConcessionariasModulo10(String linha) {
        String campo1 = linha.substring(0, 11);
        String modulo10_1 = String.valueOf(new UtilCalculoModulo().modulo10(campo1));
        String campo2 = linha.substring(11, 22);
        String modulo10_2 = String.valueOf(new UtilCalculoModulo().modulo10(campo2));
        String campo3 = linha.substring(22, 33);
        String modulo10_3 = String.valueOf(new UtilCalculoModulo().modulo10(campo3));
        String campo4 = linha.substring(33, 44);
        String modulo10_4 = String.valueOf(new UtilCalculoModulo().modulo10(campo4));
        String str = campo1 + modulo10_1 + campo2 + modulo10_2 + campo3 + modulo10_3 + campo4 + modulo10_4;
        return str;
    }

    private String getLinhaDigitavelBoletosConcessionariasModulo11(String linha) {
        String campo1 = linha.substring(0, 11);
        String modulo11_1 = String.valueOf(new UtilCalculoModulo().modulo11(campo1));
        String campo2 = linha.substring(11, 22);
        String modulo11_2 = String.valueOf(new UtilCalculoModulo().modulo11(campo2));
        String campo3 = linha.substring(22, 33);
        String modulo11_3 = String.valueOf(new UtilCalculoModulo().modulo11(campo3));
        String campo4 = linha.substring(33, 44);
        String modulo11_4 = String.valueOf(new UtilCalculoModulo().modulo11(campo4));
        String str = campo1 + modulo11_1 + campo2 + modulo11_2 + campo3 + modulo11_3 + campo4 + modulo11_4;
        return str;
    }

    private String getCodigoBarrasBoletosConcessionarias(String linha) {
        String campo1 = linha.substring(0, 11);
        String campo2 = linha.substring(12, 23);
        String campo3 = linha.substring(24, 35);
        String campo4 = linha.substring(36, 47);
        String str = campo1 + campo2 + campo3 + campo4;
        return str;
    }

    private String getCodigoBarrasBoletosBancarios(String linha) {
        String campo1 = linha.substring(0, 4) + linha.substring(32, 33);
        String campo2 = linha.substring(33, 47);
        String campo3 = linha.substring(4, 9);
        String campo4 = linha.substring(10, 20);
        String campo5 = linha.substring(21, 31);
        String str = campo1 + campo2 + campo3 + campo4 + campo5;
        return str;
    }

    public Boolean compararCodigoBarrasLinhaDigitavel(String codigoBarras, String linhaDigitavel) {
        if (codigoBarras != null && codigoBarras.trim().length() > 0 && linhaDigitavel != null && linhaDigitavel.trim().length() > 0) {
            if (codigoBarras.substring(0, 2).equals("86") || codigoBarras.substring(0, 2).equals("83") || codigoBarras.substring(0, 2).equals("87") || codigoBarras.substring(0, 2).equals("85") || codigoBarras.substring(0, 2).equals("81") || codigoBarras.substring(0, 2).equals("82") || codigoBarras.substring(0, 2).equals("84") || codigoBarras.substring(0, 2).equals("89")) {
                String s2;
                String s1 = linhaDigitavel.substring(0, 11);
                if (!s1.equals(s2 = codigoBarras.substring(0, 11))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(12, 23);
                if (!s1.equals(s2 = codigoBarras.substring(11, 22))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(24, 35);
                if (!s1.equals(s2 = codigoBarras.substring(22, 33))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(36, 47);
                if (!s1.equals(s2 = codigoBarras.substring(33, 44))) {
                    return false;
                }
            } else {
                String s2;
                String s1 = linhaDigitavel.substring(0, 4);
                if (!s1.equals(s2 = codigoBarras.substring(0, 4))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(4, 9);
                if (!s1.equals(s2 = codigoBarras.substring(19, 24))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(10, 20);
                if (!s1.equals(s2 = codigoBarras.substring(24, 34))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(21, 31);
                if (!s1.equals(s2 = codigoBarras.substring(34, 44))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(32, 33);
                if (!s1.equals(s2 = codigoBarras.substring(4, 5))) {
                    return false;
                }
                s1 = linhaDigitavel.substring(33, 47);
                if (!s1.equals(s2 = codigoBarras.substring(5, 19))) {
                    return false;
                }
            }
        }
        return true;
    }

    static class Banco {
        private String nrBanco;
        private String descricao;

        public Banco(String nrBanco, String descricao) {
            this.nrBanco = nrBanco;
            this.descricao = descricao;
        }

        public int hashCode() {
            return this.nrBanco.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Banco) {
                Banco b = (Banco)obj;
                return this.nrBanco.equals(b.nrBanco);
            }
            if (obj instanceof String) {
                return this.nrBanco.equals((String)obj);
            }
            return false;
        }
    }
}

