/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModalidadeIcmsSt;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;

public class CalculoICMSEntUtilities {
    public static final String ALIQUOTA_ICMS = "aliquotaIPI";
    public static final String VALOR_ICMS = "valorIcms";
    public static final String ICMS_ISENTO = "icmsIsento";
    public static final String ICMS_SEM_APROV = "icmsSemAprov";
    public static final String INDICE_ALTERACAO_ST = "indiceAlteracaoST";
    public static final String ALIQUOTA_ICMS_ST = "aliquotaSt";
    public static final String DESCONTO_PADRAO_ST = "descontoPadraoST";
    public static final String VALOR_BC_NAO_TRIB_ICMS = "valorReducaoIcms";
    public static final String ICMS_OUTROS = "icmsOutros";
    public static final String ICMS_TRIBUTADO = "icmsTributado";
    public static final String BASE_CALCULO_ICMS = "bcIcms";
    public static final String BASE_CALCULO_ICMS_ST = "bcIcmsST";
    public static final String VALOR_ICMS_ST = "valorIcmsST";
    public static final String VALOR_DIFERENCA_ALIQUOTA = "valorDifAliquota";
    public static final String VALOR_ICMS_DESONERADO = "valorIcmsDesonerado";
    private final Short incluirSeguroBC;
    private final Short incluirFreteBC;
    private final Short incluirDespAcessBC;
    private final Short incluirDescontoBC;
    private final Short incluirSeguroBCST;
    private final Short incluirFreteBCST;
    private final Short incluirDespAcessBCST;
    private final Short incluirDescontoBCST;
    private final Short incluirIPIBCST;
    private final Short incluirIcmsDesonerado;

    public CalculoICMSEntUtilities(short incluirSeguroBC, short incluirFreteBC, short incluirDespAcessBC, short incluirDescontoBC, short incluirSeguroBCST, short incluirFreteBCST, short incluirDespAcessBCST, short incluirDescontoBCST, short incluirIPIBCST, short incluirIcmsDesonerado) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
        this.incluirSeguroBCST = incluirSeguroBC;
        this.incluirFreteBCST = incluirFreteBCST;
        this.incluirDespAcessBCST = incluirDespAcessBCST;
        this.incluirDescontoBCST = incluirDescontoBCST;
        this.incluirIPIBCST = incluirIPIBCST;
        this.incluirIcmsDesonerado = incluirIcmsDesonerado;
    }

    public HashMap valoresIcms(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Double valorIpiIndustria, Double valorIpiObservacao, Double aliquotaICMS, Double percRedICMS, Produto produto, short modoArredondamento, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, EmpresaContabilidade empresaContabilidade, double vrIcmsDesonerado, double vrIcmsSA, double quantidadeTotal) throws ExceptionService, ExceptionCalculoICMS {
        String codigo;
        IncidenciaIcms icms = modeloFiscalIcms.getIncidenciaIcms();
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(VALOR_ICMS, 0.0);
        h.put(ICMS_ISENTO, 0.0);
        h.put(ICMS_SEM_APROV, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(ALIQUOTA_ICMS_ST, 0.0);
        h.put(DESCONTO_PADRAO_ST, 0.0);
        h.put(ICMS_OUTROS, 0.0);
        h.put(ICMS_TRIBUTADO, 0.0);
        h.put(BASE_CALCULO_ICMS, 0.0);
        h.put(VALOR_BC_NAO_TRIB_ICMS, 0.0);
        h.put(VALOR_ICMS_DESONERADO, 0.0);
        h.put(VALOR_ICMS_ST, 0.0);
        percRedICMS = percRedICMS == null ? 0.0 : percRedICMS;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            vrProdServ += valorIpiIndustria + valorIpiObservacao;
        }
        if ((codigo = icms.getCodigo().substring(1)).equalsIgnoreCase("00")) {
            this.calcularICMS00(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("10")) {
            this.calcularICMS10(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("20")) {
            this.calcularICMS20(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("30")) {
            this.calcularICMS30(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("40")) {
            this.calcularICMS40(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("41")) {
            this.calcularICMS41(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("50")) {
            this.calcularICMS50(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("51")) {
            this.calcularICMS51(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("60")) {
            this.calcularICMS60(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado, vrIcmsSA);
        } else if (codigo.equalsIgnoreCase("61")) {
            this.calcularICMS61(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado, vrIcmsSA, quantidadeTotal);
        } else if (codigo.equalsIgnoreCase("70")) {
            this.calcularICMS70(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else if (codigo.equalsIgnoreCase("90")) {
            this.calcularICMS90(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
        } else {
            throw new ExceptionCalculoICMS("O sistema n\u00e3o contempla este tipo de ICMS na entrada.");
        }
        if (empresaContabilidade != null) {
            if (empresaContabilidade.getEmbutirIpiIcmsOutros().equals((short)1) && modeloFiscalIpi.getIpiCompoeBcIcms().equals((short)0)) {
                h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ICMS_OUTROS) + valorIpiIndustria + valorIpiObservacao), (int)2));
            }
            if (empresaContabilidade.getEmbutirIcmsStIcmsOutros().equals((short)1)) {
                h.put(ICMS_OUTROS, (Double)h.get(ICMS_OUTROS) + (Double)h.get(VALOR_ICMS_ST));
            }
        }
        h.put(VALOR_ICMS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_ICMS)), (int)2, (int)modoArredondamento));
        h.put(ALIQUOTA_ICMS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_ICMS)), (int)2, (int)modoArredondamento));
        h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ICMS_ISENTO)), (int)2, (int)modoArredondamento));
        h.put(ICMS_SEM_APROV, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ICMS_SEM_APROV)), (int)2, (int)modoArredondamento));
        h.put(BASE_CALCULO_ICMS_ST, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BASE_CALCULO_ICMS_ST)), (int)2, (int)modoArredondamento));
        h.put(VALOR_ICMS_ST, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_ICMS_ST)), (int)2, (int)modoArredondamento));
        h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ICMS_OUTROS)), (int)2, (int)modoArredondamento));
        h.put(ICMS_TRIBUTADO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(ICMS_TRIBUTADO)), (int)2, (int)modoArredondamento));
        h.put(BASE_CALCULO_ICMS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BASE_CALCULO_ICMS)), (int)2, (int)modoArredondamento));
        h.put(VALOR_BC_NAO_TRIB_ICMS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_BC_NAO_TRIB_ICMS)), (int)2, (int)modoArredondamento));
        return h;
    }

    private void calcularICMS00(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo);
            h.put(VALOR_ICMS, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ICMS_SEM_APROV, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void ajustarBCOutros(HashMap h, double baseCalculo, double bcTot) {
        Double bcOutros = (Double)h.get(ICMS_OUTROS);
        bcOutros = bcOutros == null ? 0.0 : bcOutros;
        Double valor = ContatoFormatUtil.arrredondarNumero((Double)(bcTot - baseCalculo), (int)2) + bcOutros;
        if (valor < 0.0) {
            return;
        }
        h.put(ICMS_OUTROS, valor);
    }

    private void calcularICMS10(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        boolean recTributos;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
        if (recTributos) {
            h.put(ICMS_TRIBUTADO, baseCalculo);
            h.put(VALOR_ICMS, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ICMS_SEM_APROV, baseCalculo * (aliquotaICMS / 100.0));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        }
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS20(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        this.calcReducao(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
    }

    private void calcReducao(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            baseCalculo -= valorDesconto;
        }
        if (this.incluirIcmsDesonerado == null || this.incluirIcmsDesonerado == 1) {
            baseCalculo -= vrIcmsDesonerado;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bcAcess += valorSeguro;
        }
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getTipoAliquotaIcms(), (Object)0)) {
            h.put(ICMS_OUTROS, baseCalculo += bcAcess);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
        } else if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            boolean recTributos;
            double vrReduz = (baseCalculo += bcAcess) * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
                this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
            } else {
                h.put(ICMS_OUTROS, baseCalculo - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo);
        } else {
            boolean recTributos;
            double vrReduz = baseCalculo * (percRedICMS / 100.0);
            boolean bl = recTributos = modeloFiscalIcms.getRecuperarTributosIcms() != null && modeloFiscalIcms.getRecuperarTributosIcms() == 1;
            if (recTributos) {
                h.put(ICMS_TRIBUTADO, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(VALOR_ICMS, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
                this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
            } else {
                h.put(ICMS_OUTROS, baseCalculo + bcAcess - vrReduz);
                h.put(ICMS_ISENTO, vrReduz);
                h.put(ICMS_SEM_APROV, (baseCalculo - vrReduz) * (aliquotaICMS / 100.0) + bcAcess * (aliquotaICMS / 100.0));
                if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                    Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                    Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                    h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    h.put(ICMS_ISENTO, valorIcmsIsento);
                }
                h.put(VALOR_BC_NAO_TRIB_ICMS, vrReduz);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
            h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        }
    }

    private void calcularICMS30(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS40(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
    }

    private void calcularICMS41(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS50(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS51(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(VALOR_ICMS_DESONERADO, vrIcmsDesonerado);
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS60(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado, double vrIcmsSA) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        if (aliquotaICMS > 0.0) {
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
            h.put(ICMS_SEM_APROV, vrIcmsSA);
        }
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS61(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado, double vrIcmsSA, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        double baseCalculoTot = this.getBCTotal(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, vrIcmsDesonerado);
        if (modeloFiscalIcms.getRecuperarTributosIcms().equals((short)0)) {
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            if (aliquotaICMS > 0.0) {
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
                h.put(ICMS_SEM_APROV, vrIcmsSA);
            }
        } else {
            h.put(ICMS_OUTROS, vrProdServ);
            h.put(VALOR_ICMS, quantidadeTotal * modeloFiscalIcms.getAliquotaIcms());
            h.put(ALIQUOTA_ICMS, 0.0);
        }
        this.ajustarBCOutros(h, baseCalculo, baseCalculoTot);
    }

    private void calcularICMS70(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        this.calcReducao(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
    }

    private void calcularICMS90(ModeloFiscalIcms modeloFiscalIcms, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIcmsDesonerado) {
        this.calcReducao(modeloFiscalIcms, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, vrIcmsDesonerado);
    }

    public HashMap calcularDiferencaAliquota(ModeloFiscalIcms modeloFiscalIcms, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, Produto produto, Double valorFrete, Double valorSeguro, Double valorDespAcessoria, Double valorDesconto, Double valorProdServ, Short ipiCompoeBC, Double valorIPI, Double aliqIcmsInfItem, Double vlrIcmsDestNota) throws ExceptionService {
        HashMap<String, Double> h = new HashMap<String, Double>();
        double valorDif = 0.0;
        double aliquotaIcms = this.getAliquotaInternaProduto(produto, ufEmpresa);
        if (modeloFiscalIcms.getCalcularDiferencaAliquota() != null && modeloFiscalIcms.getCalcularDiferencaAliquota() == 1 && aliquotaIcms > 0.0) {
            Double bcDifAliq = this.getBCDifAliquota(valorProdServ, valorDesconto, valorDespAcessoria, valorFrete, valorSeguro, ipiCompoeBC, valorIPI);
            if (!ufEmpresa.equals((Object)ufFornecedor) && ufFornecedor.getPais().equals((Object)ufEmpresa.getPais())) {
                Double aliqModeloOrEstado = 0.0;
                aliqModeloOrEstado = modeloFiscalIcms.getTipoAliquotaIcms() == 2 ? aliqIcmsInfItem : this.getAliquotaICMS(ufFornecedor, ufEmpresa);
                if (aliqModeloOrEstado != null && aliqModeloOrEstado > 0.0) {
                    valorDif = this.calcularDiferencaAliquota(aliqModeloOrEstado, aliquotaIcms, ufFornecedor, ufEmpresa, bcDifAliq, modeloFiscalIcms, vlrIcmsDestNota);
                }
            }
        }
        if (valorDif < 0.0) {
            valorDif = 0.0;
        }
        h.put(VALOR_DIFERENCA_ALIQUOTA, valorDif);
        return h;
    }

    public HashMap calcularSt(Double valorIcms, Double indiceAlteracao, Double aliquotaICMSST, Double descontoPadrao, Double quantidadeTotal, Produto produto, ModalidadeIcmsSt modalidade, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double vrIpiIndustria, double vrIpiObservacao, double percReducaoBCST) {
        double valorIPI = vrIpiIndustria + vrIpiObservacao;
        double baseCalculo = this.getBCST(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percReducaoBCST);
        valorIcms = valorIcms == null ? 0.0 : valorIcms;
        indiceAlteracao = indiceAlteracao == null ? 0.0 : indiceAlteracao;
        aliquotaICMSST = aliquotaICMSST == null ? 0.0 : aliquotaICMSST;
        descontoPadrao = descontoPadrao == null ? 0.0 : descontoPadrao;
        quantidadeTotal = quantidadeTotal == null ? 0.0 : quantidadeTotal;
        HashMap<String, Double> h = new HashMap<String, Double>();
        double bcIcmsst = baseCalculo;
        bcIcmsst = modalidade != null && modalidade.getCodigo().equalsIgnoreCase("0") ? produto.getValorTabICMSST() * quantidadeTotal : bcIcmsst * indiceAlteracao - bcIcmsst * (descontoPadrao / 100.0);
        bcIcmsst = ContatoFormatUtil.arrredondarNumero((Double)bcIcmsst, (int)2);
        h.put(INDICE_ALTERACAO_ST, indiceAlteracao);
        h.put(ALIQUOTA_ICMS_ST, aliquotaICMSST);
        h.put(DESCONTO_PADRAO_ST, descontoPadrao);
        Double valorSt = bcIcmsst * (aliquotaICMSST / 100.0) - valorIcms;
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        h.put(BASE_CALCULO_ICMS_ST, bcIcmsst);
        h.put(VALOR_ICMS_ST, valorSt);
        return h;
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws ExceptionService {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws ExceptionService {
        CoreRequestContext h = new CoreRequestContext();
        h.setAttribute("ufOrigem", ufOrigem);
        h.setAttribute("ufDestino", ufDestino);
        UnidadeFederativaOrigDest found = (UnidadeFederativaOrigDest)CoreServiceFactory.getServiceUF().execute(h, "findAliquotaIcmsInterUF");
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIcmsDesonerado) {
        double bc = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        if (this.incluirIcmsDesonerado == null || this.incluirIcmsDesonerado == 1) {
            bc -= valorIcmsDesonerado;
        }
        return ContatoFormatUtil.arrredondarNumero((Double)bc, (int)2);
    }

    private double getBCTotal(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIcmsDesonerado) {
        double bc = vrProdServ;
        bc -= valorDesconto;
        bc += valorDespAcess;
        bc += valorFrete;
        bc += valorSeguro;
        return ContatoFormatUtil.arrredondarNumero((Double)(bc -= valorIcmsDesonerado), (int)2);
    }

    private double getBCST(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST) {
        double bcIcmsst = vrProdServ;
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == 1) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == 1) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == 1) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == 1) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == 1) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private double getBCDifAliquota(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, Short ipiIncluiBC, double valorIPI) {
        double bcDifAliq = vrProdServ;
        if (this.incluirDescontoBC != null && this.incluirDescontoBC == 1) {
            bcDifAliq -= valorDesconto;
        }
        if (this.incluirDespAcessBC != null && this.incluirDespAcessBC == 1) {
            bcDifAliq += valorDespAcess;
        }
        if (this.incluirFreteBC != null && this.incluirFreteBC == 1) {
            bcDifAliq += valorFrete;
        }
        if (this.incluirSeguroBC != null && this.incluirSeguroBC == 1) {
            bcDifAliq += valorSeguro;
        }
        if (ipiIncluiBC != null && ipiIncluiBC == 1) {
            bcDifAliq += valorIPI;
        }
        return bcDifAliq;
    }

    public static boolean isIncidenciaIsenta(String codigo) {
        if (codigo.equalsIgnoreCase("41")) {
            return true;
        }
        if (codigo.equalsIgnoreCase("40")) {
            return true;
        }
        return codigo.equalsIgnoreCase("30");
    }

    public static boolean isIncidenciaReducao(String codigo) {
        if (codigo.equalsIgnoreCase("20")) {
            return true;
        }
        return codigo.equalsIgnoreCase("70");
    }

    private double calcularDiferencaAliquota(Double aliqModeloOrEstado, double aliquotaIcms, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, Double valorTotalItem, ModeloFiscalIcms mod, Double vlrIcmsDestNota) {
        double valorDif = 0.0;
        if (mod.getModoDifAliquota() != null && mod.getModoDifAliquota() == 1) {
            double valorCompraSemIcms = valorTotalItem * (1.0 - aliqModeloOrEstado / 100.0);
            double novaBCIcms = valorCompraSemIcms / (1.0 - aliquotaIcms / 100.0);
            double novoVlrIcms = novaBCIcms * aliquotaIcms / 100.0;
            if (ToolMethods.isWithData((Number)vlrIcmsDestNota)) {
                return novoVlrIcms - vlrIcmsDestNota;
            }
            return novoVlrIcms - (valorTotalItem - valorCompraSemIcms);
        }
        valorDif = valorTotalItem * (aliquotaIcms / 100.0) - valorTotalItem * (aliqModeloOrEstado / 100.0);
        return valorDif;
    }

    private double getAliquotaInternaProduto(Produto produto, UnidadeFederativa ufEmpresa) {
        for (ProdutoAliquotaUF produtoAliquotaUF : produto.getAliquotasUF()) {
            if (!produtoAliquotaUF.getUf().equals((Object)ufEmpresa)) continue;
            return produtoAliquotaUF.getAliquotaIcms();
        }
        return produto.getAliquotaIcms();
    }
}

