/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.modalidadeicms.EnumConstModIcms;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.constants.enums.modelofiscalicmsst.EnumConstModFiscalIcmsSTFatorCalculo;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.DadosFiscaisUFNcmFCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSSTItem;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NcmAliquotaUF;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoAliquotaUF;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.tools.DateUtil;

public class CalculoICMSSaiUtilities {
    public static final String ALIQUOTA_ICMS = "aliquotaICMS";
    public static final String ALIQUOTA_ICMS_SIMPLES = "aliquotaICMSSimples";
    public static final String VALOR_ICMS = "valorIcms";
    public static final String VALOR_ICMS_SIMPLES = "valorIcmsSimples";
    public static final String VALOR_ICMS_ST = "valorIcmsSt";
    public static final String ICMS_ISENTO = "icmsIsento";
    public static final String ICMS_SEM_APROV = "icmsSemAprov";
    public static final String INDICE_ALTERACAO_ST = "indiceAlteracaoST";
    public static final String ALIQUOTA_ICMS_ST = "aliquotaSt";
    public static final String DESCONTO_PADRAO_ST = "descontoPadraoST";
    public static final String ICMS_OUTROS = "icmsOutros";
    public static final String ICMS_TRIBUTADO = "icmsTributado";
    public static final String BASE_CALCULO_ICMS = "bcIcms";
    public static final String BASE_CALCULO_ICMS_ST = "bcIcmsST";
    public static final String VALOR_BC_NAO_TRIB_ICMS = "valorNaoTribIcms";
    public static final String BC_ICMS_UF_DEST = "valorBcIcmsUfDest";
    public static final String VR_ICMS_UF_DEST = "valorIcmsPartilhaDest";
    public static final String VR_ICMS_UF_REM = "valorIcmsPartilhaRem";
    public static final String ALIQ_INTERNA_UF_DEST = "aliquotaInternaUFDest";
    public static final String ALIQ_INTERESTADUAL = "aliquotaInterestadual";
    public static final String PERC_PARTILHA_ICMS = "percPartilhaIcms";
    public static final String ALIQ_FUNDO_POBREZA = "aliquotaFundoPobreza";
    public static final String VALOR_FUNDO_POBREZA = "valorFundoPobreza";
    public static final String BASE_CALCULO_FCP = "valorBCFCP";
    public static final String VALOR_FCP = "valorFCP";
    public static final String ALIQUOTA_FCP = "aliquotaFCP";
    public static final String BASE_CALCULO_FCP_ST = "valorBCFCPSt";
    public static final String VALOR_FCP_ST = "valorFCPSt";
    public static final String ALIQUOTA_FCP_ST = "aliquotaFCPSt";
    public static final String BASE_CALCULO_FCP_ST_RETIDO = "valorBCFCPStRetido";
    public static final String VALOR_FCP_ST_RETIDO = "valorFCPStRetido";
    public static final String ALIQUOTA_FCP_ST_RETIDO = "aliquotaFCPStRetido";
    public static final String VALOR_ICMS_DIFERIMENTO = "valorIcmsDiferimento";
    public static final String PERC_DIFERIMENTO = "percentualDiferimento";
    public static final String VALOR_ICMS_DESONERADO = "valorIcmsDesonerado";
    public static final String MOD_CALC_DIFAL_ICMSST = "modCalcDifalIcmsSt";
    private final Short incluirSeguroBC;
    private final Short incluirFreteBC;
    private final Short incluirDespAcessBC;
    private final Short incluirDescontoBC;
    private final Short tipoCalcST;
    private final Short incluirSeguroBCST;
    private final Short incluirFreteBCST;
    private final Short incluirDespAcessBCST;
    private final Short incluirDescontoBCST;
    private final Short incluirIPIBCST;
    private final Short contribuinteEstado;
    private final Short usarCategoriaST;
    private final Empresa empresa;
    private final CNAE cnae;
    private Date dataEmissao;
    private final VersaoNFe versaoNFe;
    private OpcoesFaturamento opcoesFaturamento;

    public CalculoICMSSaiUtilities(short incluirSeguroBC, short incluirFreteBC, short incluirDespAcessBC, short incluirDescontoBC, Short tipoCalcST, Empresa empresa, CNAE cnae, Short contribuinteEstado, short incluirSeguroBCST, short incluirFreteBCST, short incluirDespAcessBCST, short incluirDescontoBCST, short incluirIPIBCST, short usarCategoriaST, Date dataEmissao, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
        this.tipoCalcST = tipoCalcST;
        this.contribuinteEstado = contribuinteEstado;
        this.empresa = empresa;
        this.cnae = cnae;
        this.incluirDescontoBCST = incluirDescontoBCST;
        this.incluirDespAcessBCST = incluirDespAcessBCST;
        this.incluirFreteBCST = incluirFreteBCST;
        this.incluirIPIBCST = incluirIPIBCST;
        this.incluirSeguroBCST = incluirSeguroBCST;
        this.usarCategoriaST = usarCategoriaST;
        this.dataEmissao = dataEmissao;
        this.versaoNFe = versaoNFe;
        this.opcoesFaturamento = opcoesFaturamento;
    }

    public HashMap valoresIcmsIcmsST(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, double valorImpImportacao, double valorPis, double valorCofins, Double valorIpiIndustria, Double valorIpiObservacao, Double aliquotaICMS, Double percRedICMS, Double indiceCalcBCImportacaoICMS, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, Short consumidorFinal, Short contribuinteEstado, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, Short tipoCFOP, Double valorIpiDevolucao) throws ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        IncidenciaIcms icms = modeloFiscalIcms.getIncidenciaIcms();
        double valorIPI = valorIpiIndustria + valorIpiObservacao + valorIpiDevolucao;
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(VALOR_ICMS, 0.0);
        h.put(ICMS_ISENTO, 0.0);
        h.put(ICMS_SEM_APROV, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(ALIQUOTA_ICMS_ST, 0.0);
        h.put(DESCONTO_PADRAO_ST, 0.0);
        h.put(BASE_CALCULO_ICMS_ST, 0.0);
        h.put(INDICE_ALTERACAO_ST, 0.0);
        h.put(VALOR_ICMS_ST, 0.0);
        h.put(ICMS_OUTROS, 0.0);
        h.put(ICMS_TRIBUTADO, 0.0);
        h.put(VALOR_BC_NAO_TRIB_ICMS, 0.0);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_DESONERADO, 0.0);
        h.put(BC_ICMS_UF_DEST, 0.0);
        h.put(VR_ICMS_UF_DEST, 0.0);
        h.put(VR_ICMS_UF_REM, 0.0);
        h.put(ALIQ_INTERNA_UF_DEST, 0.0);
        h.put(ALIQ_INTERESTADUAL, 0.0);
        h.put(PERC_PARTILHA_ICMS, 0.0);
        h.put(ALIQ_FUNDO_POBREZA, 0.0);
        h.put(VALOR_FUNDO_POBREZA, 0.0);
        h.put(ALIQUOTA_FCP, 0.0);
        h.put(ALIQUOTA_FCP_ST, 0.0);
        h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
        h.put(VALOR_FCP, 0.0);
        h.put(VALOR_FCP_ST, 0.0);
        h.put(VALOR_FCP_ST_RETIDO, 0.0);
        h.put(BASE_CALCULO_FCP, 0.0);
        h.put(BASE_CALCULO_FCP_ST, 0.0);
        h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
        h.put(PERC_DIFERIMENTO, 0.0);
        h.put(VALOR_ICMS_DIFERIMENTO, 0.0);
        percRedICMS = percRedICMS == null ? 0.0 : percRedICMS;
        String cod = icms.getCodigo();
        cod = cod.substring(1);
        DadosFiscaisUF dadosFiscaisUF = this.getDAdosFiscaisUF(unidadeFatCliente, this.empresa);
        Double aliquotaFCP = 0.0;
        if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)1)) {
            aliquotaFCP = dadosFiscaisUF.getAliquotaFCP();
        } else if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)2)) {
            for (DadosFiscaisUFNcmFCP d : dadosFiscaisUF.getNcmsFCP()) {
                if (!d.getNcm().equals((Object)produto.getNcm())) continue;
                aliquotaFCP = d.getAliquotaFCP();
                break;
            }
        }
        if (cod.equalsIgnoreCase("00")) {
            this.calcularICMS00(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("10")) {
            this.calcularICMS10(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("20")) {
            this.calcularICMS20(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("30")) {
            this.calcularICMS30(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("40")) {
            this.calcularICMS40(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("41")) {
            this.calcularICMS41(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("50")) {
            this.calcularICMS50(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("51")) {
            this.calcularICMS51(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("60")) {
            this.calcularICMS60(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("61")) {
            this.calcularICMS61(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("70")) {
            this.calcularICMS70(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("90")) {
            this.calcularICMS90(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("101")) {
            this.calcularICMS101(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, aliqICMSSimples, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("102")) {
            this.calcularICMS102(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI);
        } else if (cod.equalsIgnoreCase("103")) {
            this.calcularICMS103(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("201")) {
            this.calcularICMS201(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, aliqICMSSimples, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("202")) {
            this.calcularICMS202(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("203")) {
            this.calcularICMS203(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else if (cod.equalsIgnoreCase("300")) {
            this.calcularICMS300(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("400")) {
            this.calcularICMS400(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("500")) {
            this.calcularICMS500(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, quantidadeTotal);
        } else if (cod.equalsIgnoreCase("900")) {
            this.calcularICMS900(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, aliqICMSSimples, quantidadeTotal, ufCliente, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, unidadeFatCliente, aliquotaFCP);
        } else {
            throw new ExceptionCalculoICMS("O sistema n\u00e3o contempla este tipo de ICMS no faturamento.");
        }
        if (empresaContabilidade != null) {
            Double valorIcmsNaoTrib;
            if (empresaContabilidade.getEmbutirIpiIcmsOutros().equals((short)1) && modeloFiscalIpi.getIpiCompoeBcIcms().equals((short)0)) {
                h.put(ICMS_OUTROS, (Double)h.get(ICMS_OUTROS) + valorIPI);
            }
            if (ToolMethods.isEquals((Object)this.incluirDespAcessBC, (Object)0) && valorDespAcess > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorDespAcess);
            }
            if (ToolMethods.isEquals((Object)this.incluirFreteBC, (Object)0) && valorFrete > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorFrete);
            }
            if (ToolMethods.isEquals((Object)this.incluirSeguroBC, (Object)0) && valorSeguro > 0.0) {
                valorIcmsNaoTrib = (Double)h.get(ICMS_OUTROS);
                h.put(ICMS_OUTROS, valorIcmsNaoTrib + valorSeguro);
            }
        }
        Double percentualPartilha = this.getPercentualPartilhaIcms();
        if (dadosFiscaisUF != null && dadosFiscaisUF.getCalcularFCP() != null && dadosFiscaisUF.getCalcularFCP().equals((short)3)) {
            aliquotaFCP = dadosFiscaisUF.getAliquotaFCP();
        }
        this.calcularIcmsPartilha(produto, this.empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente, percentualPartilha, consumidorFinal, h, contribuinteEstado, aliquotaICMS, cod, aliquotaFCP, EnumConstModFiscalDifal.get((Object)modeloFiscalIcms.getTipoCalculoDifal()), modeloFiscalIcms.getEntradaSaida());
        this.calcularIcmsDesoneradoSuframa(modeloFiscalIcms, modeloFiscalIpi, unidadeFatCliente, vrProdServ, h, produto.getNaoAplicaSuframa(), valorFrete, valorSeguro, valorDespAcess, valorDesconto, valorIPI, tipoCFOP, produto, quantidadeTotal);
        return h;
    }

    private void calcularICMS00(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        h.put(ICMS_TRIBUTADO, baseCalculo);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularICMS10(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        h.put(ICMS_TRIBUTADO, baseCalculo);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo, h, modeloFiscalIcms.getNaoCalcularFCP());
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS20(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP, double quantidadeTotal) {
        double baseCalculo = vrProdServ;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() != null && modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            baseCalculo += valorIPI;
        }
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vrReduz = ContatoFormatUtil.arrredondarNumero(baseCalculo * (percRedICMS / 100.0), 2);
        h.put(ICMS_TRIBUTADO, ContatoFormatUtil.arrredondarNumero(baseCalculo + bcAcess - vrReduz, 2));
        h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero(vrReduz, 2));
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
            Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
            Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
            h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
            h.put(ICMS_ISENTO, valorIcmsIsento);
        }
        Double vlrIcms = ContatoFormatUtil.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaICMS / 100.0), 2) + ContatoFormatUtil.arrredondarNumero(bcAcess * (aliquotaICMS / 100.0), 2);
        h.put(VALOR_ICMS, vlrIcms);
        h.put(VALOR_BC_NAO_TRIB_ICMS, ContatoFormatUtil.arrredondarNumero(vrReduz, 2));
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo + bcAcess - vrReduz, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularICMS30(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
            h.put(VALOR_ICMS_DESONERADO, ContatoFormatUtil.arrredondarNumero(vlrIcms, 2));
            h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero(baseCalculo - vlrIcms, 2));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ALIQUOTA_ICMS, 0.0);
        }
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, 0.0, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS40(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        Double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
            h.put(VALOR_ICMS_DESONERADO, ContatoFormatUtil.arrredondarNumero(vlrIcms, 2));
            h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero(baseCalculo - vlrIcms, 2));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ALIQUOTA_ICMS, 0.0);
        }
    }

    private void calcularICMS41(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        Double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
            h.put(VALOR_ICMS_DESONERADO, ContatoFormatUtil.arrredondarNumero(vlrIcms, 2));
            h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero(baseCalculo - vlrIcms, 2));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ALIQUOTA_ICMS, 0.0);
        }
    }

    private void calcularICMS50(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        Double vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
            h.put(VALOR_ICMS_DESONERADO, ContatoFormatUtil.arrredondarNumero(vlrIcms, 2));
            h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero(baseCalculo - vlrIcms, 2));
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            h.put(ALIQUOTA_ICMS, 0.0);
        }
    }

    private void calcularICMS51(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double aliquotaFCP, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        Double percDiferimento = produto.getPercentualDiferimento();
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getTipoPercDiferimento(), (Object)2)) {
            percDiferimento = modeloFiscalIcms.getPercentualDiferimento();
        }
        if (percDiferimento == 0.0) {
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(ICMS_OUTROS, baseCalculo);
        } else {
            Double valorIcmsTotal = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
            Double valorIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
            Double valorDiferimento = ContatoFormatUtil.arrredondarNumero(valorIcms * (percDiferimento / 100.0), 2);
            valorIcms = valorIcms - valorDiferimento;
            Double percBaseCalculoTrib = 0.0;
            if (valorIcmsTotal > 0.0) {
                percBaseCalculoTrib = ContatoFormatUtil.arrredondarNumero(valorIcms * 100.0 / valorIcmsTotal, 4);
            }
            Double baseCalculoTrib = ContatoFormatUtil.arrredondarNumero(baseCalculo * (percBaseCalculoTrib / 100.0), 2);
            Double baseCalculoOutros = ContatoFormatUtil.arrredondarNumero(baseCalculo - baseCalculoTrib, 2);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_TRIBUTADO, baseCalculoTrib);
            h.put(ICMS_OUTROS, baseCalculoOutros);
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
            h.put(VALOR_ICMS, valorIcms);
            h.put(PERC_DIFERIMENTO, percDiferimento);
            h.put(VALOR_ICMS_DIFERIMENTO, valorDiferimento);
            if (aliquotaFCP > 0.0) {
                h.put(VALOR_FCP, ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaFCP / 100.0), 2));
                h.put(ALIQUOTA_FCP, aliquotaFCP);
                h.put(BASE_CALCULO_FCP, baseCalculo);
            }
        }
    }

    private void calcularICMS60(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        h.put(ICMS_OUTROS, baseCalculo);
    }

    private void calcularICMS70(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vrReduz = ContatoFormatUtil.arrredondarNumero(baseCalculo * (percRedICMS / 100.0), 2);
        double vlrIcms = 0.0;
        h.put(ICMS_TRIBUTADO, ContatoFormatUtil.arrredondarNumero(baseCalculo + bcAcess - vrReduz, 2));
        h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
        h.put(ICMS_ISENTO, ContatoFormatUtil.arrredondarNumero(vrReduz, 2));
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            vlrIcms = ContatoFormatUtil.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaICMS / 100.0), 2) + ContatoFormatUtil.arrredondarNumero(bcAcess * (aliquotaICMS / 100.0), 2);
            h.put(VALOR_ICMS, vlrIcms);
            h.put(VALOR_BC_NAO_TRIB_ICMS, ContatoFormatUtil.arrredondarNumero(vrReduz, 2));
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                h.put(ICMS_ISENTO, valorIcmsIsento);
            }
            h.put(ALIQUOTA_ICMS, aliquotaICMS);
        } else {
            vlrIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
                Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)vlrIcms, (int)2);
                Double valorIcmsIsento = ToolFormatter.arrredondarNumero((Double)(baseCalculo - valorIcmsDesonerado), (int)2);
                h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                h.put(ICMS_ISENTO, valorIcmsIsento);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ALIQUOTA_ICMS, 0.0);
            }
        }
        this.calcularFCP(aliquotaFCP, vlrIcms, baseCalculo + bcAcess - vrReduz, h, modeloFiscalIcms.getNaoCalcularFCP());
        this.calcularIcmsDifalST(vrProdServ, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS90(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            if (percRedICMS > 0.0) {
                this.calcularICMS20(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
            } else {
                this.calcularICMS00(modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, h, aliquotaICMS, percRedICMS, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, aliquotaFCP, quantidadeTotal);
            }
        } else {
            double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
            double vlrIcms = baseCalculo * (aliquotaICMS / 100.0);
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_OUTROS, baseCalculo);
            if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null) {
                Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)vlrIcms, (int)2);
                Double valorIcmsOutros = ToolFormatter.arrredondarNumero((Double)(baseCalculo - valorIcmsDesonerado), (int)2);
                h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                h.put(ICMS_OUTROS, valorIcmsOutros);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            } else {
                h.put(ALIQUOTA_ICMS, 0.0);
            }
        }
        Double baseCalculo = (Double)h.get(BASE_CALCULO_ICMS);
        Double vlrIcms = (Double)h.get(VALOR_ICMS);
        this.calcularIcmsDifalST(baseCalculo, vlrIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularIcmsDifalST(Double baseCalculo, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, HashMap h, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, Double percRedBCICMSSt, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        EnumConstModFiscalDifalST tp = EnumConstModFiscalDifalST.get((Object)modeloFiscalIcms.getTipoTributacaoIcmsSt());
        if (tp == null || ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_NAO_INC_ICMSST)) {
            return;
        }
        if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_DUPLA)) {
            this.calcDifalSTBaseDupla(h, produto, ufCliente);
        } else if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_SIMPLES)) {
            this.calcDifalSTBaseSimples(h, produto, ufCliente);
        } else if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA) || ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_PRODUTO)) {
            this.calcularSt(tp, baseCalculo, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, percRedBCICMSSt, unidadeFatCliente, aliquotaFCP);
        }
        Double bcST = (Double)h.get(BASE_CALCULO_ICMS_ST);
        this.calcularFCPSt(aliquotaFCP, bcST, h, modeloFiscalIcms.getNaoCalcularFCP());
    }

    private void calcularSt(EnumConstModFiscalDifalST tp, Double baseCalculo, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Produto produto, Double quantidadeTotal, UnidadeFederativa ufCliente, HashMap h, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, Double percRedBCICMSSt, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double bcIcmsst = 0.0;
        bcIcmsst = modeloFiscalIcms.getCalcularIcmsPresumidoST() == null || modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)0) || unidadeFatCliente == null ? this.getBCST(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percRedBCICMSSt) : this.getBCSTPresumido(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, percRedBCICMSSt, unidadeFatCliente);
        if (this.tipoCalcST == null || this.tipoCalcST == 0) {
            this.putValoresSTAliquotaST(tp, h, produto, ufCliente, bcIcmsst, valorIcms, modeloFiscalIcms, vrProdServ, unidadeFatCliente);
        } else {
            this.putValoresSTModeloFiscalST(tp, h, produto, ufCliente, bcIcmsst, valorIcms, modeloFiscalIcms, consumidorFinal, unidadeFatCliente.getCategoriaPessoa());
        }
    }

    private void putValoresSTModeloFiscalST(EnumConstModFiscalDifalST tp, HashMap h, Produto produto, UnidadeFederativa uf, double bcIcmsst, double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Short consumidorFinal, CategoriaPessoa categoriaPessoa) throws ExceptionCategoriaSTNotFound, ExceptionService {
        Integer codigo;
        CategoriaSt cat = produto.getCategoriaSutr();
        if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA) && modeloFiscalIcms.getCategoriaST() != null) {
            cat = modeloFiscalIcms.getCategoriaST();
        }
        if (this.usarCategoriaST != null && this.usarCategoriaST == 1 && cat == null) {
            throw new ExceptionCategoriaSTNotFound("Foi informado que o ICMSST ser\u00e1 calculado pela categoria de ST, mas a mesma n\u00e3o foi informado no modelo fiscal ou no produto.");
        }
        ModeloFiscalICMSSTItem mod = this.getModeloFiscalItem(produto, uf, modeloFiscalIcms.getIncidenciaIcms(), cat, consumidorFinal, categoriaPessoa);
        if (mod == null && (codigo = Integer.valueOf(modeloFiscalIcms.getIncidenciaIcms().getCodigo())) != 90 && codigo != 190 && codigo != 290 && codigo != 900) {
            StringBuilder sb = new StringBuilder();
            sb.append("Modelo Fiscal ICMS ST n\u00e3o encontrado para:\n");
            if (this.cnae != null) {
                sb.append("CNAE:").append(this.cnae.getCodigo()).append("\n");
            } else {
                sb.append("CNAE:").append("N\u00e3o informado no cadastro do cliente").append("\n");
            }
            if (cat != null) {
                sb.append("Categoria ST:").append(cat.getNome()).append("\n");
            } else {
                sb.append("Categoria ST:").append("N\u00e3o informado no cadastro do modelo fiscal/produto").append("\n");
            }
            if (produto != null && produto.getNcm() != null) {
                sb.append("NCM:").append(produto.getNcm().getCodigo()).append("\n");
            } else {
                sb.append("NCM:").append("N\u00e3o informado no cadastro do produto").append("\n");
            }
            sb.append("UF:").append(uf.getSigla()).append("\n");
            sb.append("Empresa:").append(this.empresa.getPessoa().getNome()).append("\n");
            sb.append("Incidencia ICMS:").append(modeloFiscalIcms.getIncidenciaIcms().getCodigo()).append("\n");
            sb.append("ConsumidorFinal:").append(this.getSimOrNao(consumidorFinal)).append("\n");
            throw new ExceptionCategoriaSTNotFound(sb.toString());
        }
        h.put(INDICE_ALTERACAO_ST, mod.getIndiceAlteracao());
        h.put(ALIQUOTA_ICMS_ST, mod.getAliquotaIcms());
        h.put(DESCONTO_PADRAO_ST, mod.getDescontoPadrao());
        if (ToolMethods.isNull((Object)mod.getFatorCalculo()).booleanValue() || ToolMethods.isEquals((Object)mod.getFatorCalculo(), (Object)EnumConstModFiscalIcmsSTFatorCalculo.FATOR_CALCULO_MULTIPLICADOR.getValue())) {
            if (this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 1 || this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 2) {
                valorIcms = modeloFiscalIcms.getAliquotaIcms() > 0.0 ? bcIcmsst * modeloFiscalIcms.getAliquotaIcms() / 100.0 : bcIcmsst * produto.getAliquotaIcms() / 100.0;
            }
            if (mod.getIndiceAlteracao() > 0.0) {
                bcIcmsst = ContatoFormatUtil.arrredondarNumero(bcIcmsst * mod.getIndiceAlteracao(), 2);
            }
            bcSt = ContatoFormatUtil.arrredondarNumero(bcIcmsst - bcIcmsst * (mod.getDescontoPadrao() / 100.0), 2);
            Double valorSt = bcSt * (mod.getAliquotaIcms() / 100.0) - valorIcms;
            if (modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)1)) {
                Double aliquotaIcms = this.getAliquotaICMS(this.empresa.getPessoa().getEndereco().getCidade().getUf(), uf);
                valorSt = valorSt - (bcIcmsst - bcIcmsst * (aliquotaIcms / 100.0));
            }
            if (valorSt < 0.0) {
                valorSt = 0.0;
            }
            h.put(BASE_CALCULO_ICMS_ST, ContatoFormatUtil.arrredondarNumero(bcSt, 2));
            h.put(VALOR_ICMS_ST, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
            h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
        } else {
            if (this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 1 || this.empresa.getEmpresaDados().getRegimeTributario().getCodigo() == 2) {
                valorIcms = modeloFiscalIcms.getAliquotaIcms() > 0.0 ? bcIcmsst * modeloFiscalIcms.getAliquotaIcms() / 100.0 : bcIcmsst * produto.getAliquotaIcms() / 100.0;
            }
            bcSt = ContatoFormatUtil.arrredondarNumero((bcIcmsst - valorIcms) / mod.getIndiceAlteracao(), 2);
            Double valorSt = ContatoFormatUtil.arrredondarNumero(bcSt * (mod.getAliquotaIcms() / 100.0), 2);
            if ((valorSt = ContatoFormatUtil.arrredondarNumero(valorSt - valorIcms, 2)) < 0.0) {
                valorSt = 0.0;
            }
            h.put(BASE_CALCULO_ICMS_ST, ContatoFormatUtil.arrredondarNumero(bcSt, 2));
            h.put(VALOR_ICMS_ST, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
            h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
        }
    }

    private void putValoresSTAliquotaST(EnumConstModFiscalDifalST tp, HashMap h, Produto produto, UnidadeFederativa ufCliente, Double bcIcmsst, Double valorIcms, ModeloFiscalIcms modeloFiscalIcms, Double vrProdServ, UnidadeFatCliente unidadeFatCliente) throws ExceptionService, ExceptionCategoriaSTNotFound {
        block6: {
            try {
                CategoriaSt cat = produto.getCategoriaSutr();
                if (ToolMethods.isEquals((Object)tp, (Object)EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA)) {
                    cat = modeloFiscalIcms.getCategoriaST();
                }
                if (cat == null) {
                    throw new ExceptionCategoriaSTNotFound("N\u00e3o foi encontrado nenhuma Categoria de Substiui\u00e7\u00e3o Tribut\u00e1ria para o produto:  " + produto.getNome() + ". Verifique seu cadastro.");
                }
                AliquotaSt al = this.procurarAliquotaSt(cat, ufCliente);
                h.put(INDICE_ALTERACAO_ST, al.getIndiceAlteracao());
                h.put(ALIQUOTA_ICMS_ST, al.getAliquotaIcms());
                h.put(DESCONTO_PADRAO_ST, al.getDescontoPadrao());
                Double bcSt = ContatoFormatUtil.arrredondarNumero(bcIcmsst * al.getIndiceAlteracao() - bcIcmsst * (al.getDescontoPadrao() / 100.0), 2);
                Double valorSt = bcSt * (al.getAliquotaIcms() / 100.0) - valorIcms;
                if (modeloFiscalIcms.getCalcularIcmsPresumidoST().equals((short)1)) {
                    Double aliquotaIcms = this.getAliquotaICMS(this.empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente);
                    Double bc = this.getBCAbatendoSomentePisCofins(vrProdServ, unidadeFatCliente);
                    valorSt = valorSt - ContatoFormatUtil.arrredondarNumero(bc * (aliquotaIcms / 100.0), 2);
                }
                if (valorSt < 0.0) {
                    valorSt = 0.0;
                }
                h.put(BASE_CALCULO_ICMS_ST, ContatoFormatUtil.arrredondarNumero(bcSt, 2));
                h.put(VALOR_ICMS_ST, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
                h.put(ICMS_OUTROS, ContatoFormatUtil.arrredondarNumero(valorSt, 2));
            }
            catch (ExceptionCategoriaSTNotFound ex) {
                Integer codigo = new Integer(modeloFiscalIcms.getIncidenciaIcms().getCodigo());
                if (codigo == 90 || codigo == 190 || codigo == 290 || codigo == 900) break block6;
                throw ex;
            }
        }
    }

    private ModeloFiscalICMSSTItem getModeloFiscalItem(Produto produto, UnidadeFederativa uf, IncidenciaIcms inc, CategoriaSt cat, Short consumidorFinal, CategoriaPessoa categoriaPessoa) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("ncm", produto.getNcm());
        cq.setAttribute("uf", uf);
        cq.setAttribute("empresa", this.empresa);
        cq.setAttribute("cnae", this.cnae);
        cq.setAttribute("incidenciaIcms", inc);
        cq.setAttribute("contribuinteEstado", this.contribuinteEstado);
        cq.setAttribute("usarCategoriaST", this.usarCategoriaST);
        cq.setAttribute("categoriaST", cat);
        cq.setAttribute("consumidorFinal", consumidorFinal);
        cq.setAttribute("usarCategoriaPessoa", this.opcoesFaturamento.getUsarCategoriaPessoa());
        cq.setAttribute("categoriaPessoa", categoriaPessoa);
        return (ModeloFiscalICMSSTItem)CoreServiceFactory.getServiceModeloFiscalICMSST().execute(cq, "getModelosFiscaisIcmsSTItem");
    }

    private void calcularICMS101(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, aliqICMSSimples);
        h.put(VALOR_ICMS_SIMPLES, new Double(baseCalculo * (aliqICMSSimples / 100.0)));
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS102(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double baseCalculo) {
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS103(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS201(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, Double aliqICMSSimples, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS202(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS203(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = baseCalculo * (aliquotaICMS / 100.0);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    private void calcularICMS300(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS400(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_ISENTO, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS500(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
        h.put(VALOR_ICMS_SIMPLES, 0.0);
        h.put(ALIQUOTA_ICMS, 0.0);
    }

    private void calcularICMS900(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double aliqICMSSimples, Double quantidadeTotal, UnidadeFederativa ufCliente, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double valorIPI, Short consumidorFinal, UnidadeFatCliente unidadeFatCliente, Double aliquotaFCP) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ICMS_OUTROS, baseCalculo);
        if (modeloFiscalIcms.getCalcularIcmsSimples() != null && modeloFiscalIcms.getCalcularIcmsSimples() == 1) {
            h.put(ALIQUOTA_ICMS_SIMPLES, aliqICMSSimples);
            h.put(VALOR_ICMS_SIMPLES, baseCalculo * (aliqICMSSimples / 100.0));
        } else {
            h.put(ALIQUOTA_ICMS_SIMPLES, 0.0);
            h.put(VALOR_ICMS_SIMPLES, 0.0);
        }
        h.put(ALIQUOTA_ICMS, 0.0);
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            baseCalculo -= valorDesconto;
        }
        double bcAcess = 0.0;
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bcAcess += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bcAcess += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bcAcess += valorSeguro;
        }
        if (ToolMethods.isEquals((Object)modeloFiscalIcms.getIncluiDespAcessCalcRed(), (Object)1)) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vlrIcms = 0.0;
        if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
            if (percRedICMS > 0.0) {
                double vrReduz = ContatoFormatUtil.arrredondarNumero(baseCalculo * (percRedICMS / 100.0), 2);
                h.put(ICMS_OUTROS, baseCalculo + bcAcess);
                h.put(BASE_CALCULO_ICMS, baseCalculo + bcAcess);
                if (modeloFiscalIcms.getTipoAliquotaIcms() != 0) {
                    vlrIcms = ContatoFormatUtil.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaICMS / 100.0), 2) + ContatoFormatUtil.arrredondarNumero(bcAcess * (aliquotaICMS / 100.0), 2);
                    h.put(VALOR_ICMS, vlrIcms);
                    h.put(VALOR_BC_NAO_TRIB_ICMS, ContatoFormatUtil.arrredondarNumero(vrReduz, 2));
                    if (modeloFiscalIcms.getIcmsDispensadoDesconto() != null && (modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)1) || modeloFiscalIcms.getIcmsDispensadoDesconto().equals((short)2))) {
                        Double valorIcmsDesonerado = ToolFormatter.arrredondarNumero((Double)(vrReduz * (aliquotaICMS / 100.0)), (int)2);
                        Double valorIcmsBCNaoTrib = ToolFormatter.arrredondarNumero((Double)(vrReduz - valorIcmsDesonerado), (int)2);
                        h.put(VALOR_ICMS_DESONERADO, valorIcmsDesonerado);
                    }
                    h.put(ALIQUOTA_ICMS, aliquotaICMS);
                } else {
                    h.put(ALIQUOTA_ICMS, 0.0);
                }
            } else {
                vlrIcms = baseCalculo * (aliquotaICMS / 100.0);
                h.put(ICMS_OUTROS, baseCalculo);
                h.put(BASE_CALCULO_ICMS, baseCalculo);
                h.put(VALOR_ICMS, vlrIcms);
                h.put(ALIQUOTA_ICMS, aliquotaICMS);
            }
        } else {
            h.put(BASE_CALCULO_ICMS, baseCalculo);
            h.put(ICMS_OUTROS, baseCalculo);
            h.put(ALIQUOTA_ICMS, 0.0);
            h.put(VALOR_ICMS, 0.0);
            h.put(percRedICMS, 0.0);
        }
        UnidadeFederativa ufOrigem = this.empresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = ufCliente;
        aliquotaICMS = !ufOrigem.equals((Object)ufDestino) ? this.getAliquotaICMS(ufOrigem, ufDestino, produto) : produto.getAliquotaIcms();
        Double valorIcms = ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2);
        this.calcularIcmsDifalST(baseCalculo + valorDesconto, valorIcms, modeloFiscalIcms, produto, quantidadeTotal, ufCliente, h, valorFrete, valorSeguro, valorDespAcess, valorDesconto, vrProdServ, valorIPI, consumidorFinal, modeloFiscalIcms.getReducaoBaseCalcIcmsST(), unidadeFatCliente, aliquotaFCP);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws ExceptionService {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws ExceptionService {
        CoreRequestContext h = new CoreRequestContext();
        h.setAttribute("ufOrigem", ufOrigem);
        h.setAttribute("ufDestino", ufDestino);
        UnidadeFederativaOrigDest found = (UnidadeFederativaOrigDest)CoreServiceFactory.getServiceUF().execute(h, "findAliquotaIcmsInterUF");
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private AliquotaSt procurarAliquotaSt(CategoriaSt cat, UnidadeFederativa ufCliente) throws ExceptionCategoriaSTNotFound, ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("categoriaSt", cat);
        cq.setAttribute("unidadeFederativa", ufCliente);
        AliquotaSt al = (AliquotaSt)CoreServiceFactory.getServiceAliquotaSt().execute(cq, "procurarAliquotaSt");
        if (al == null) {
            throw new ExceptionCategoriaSTNotFound("Al\u00edquota de Substitui\u00e7\u00e3o Tribut\u00e1ria n\u00e3o encontrada para a Categoria " + (cat != null ? cat.getNome() : "") + " e UF " + ufCliente.getSigla());
        }
        return al;
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCfop, Produto produto, Double quantidadeTotal) {
        double bc = vrProdServ;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            bc += valorIPI;
        }
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        if (tipoCfop == 2) {
            Double indice = modeloFiscalIcms.getIndiceCalcImportacao();
            if (indice == null || indice <= 0.0) {
                indice = 1.0;
            }
            bc /= indice.doubleValue();
        }
        if (modeloFiscalIcms.getModalidadeIcms() != null && ToolMethods.isEquals((Object)modeloFiscalIcms.getModalidadeIcms().getCodigo(), (Object)EnumConstModIcms.PAUTA.getValue())) {
            bc = produto.getValorTabICMS() * quantidadeTotal;
        }
        return bc;
    }

    private double getBCTotal(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCfop) {
        double bc = vrProdServ;
        if (modeloFiscalIpi.getIpiCompoeBcIcms() == 1) {
            bc += valorIPI;
        }
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        if (tipoCfop == 2) {
            Double indice = modeloFiscalIcms.getIndiceCalcImportacao();
            if (indice == null || indice <= 0.0) {
                indice = 1.0;
            }
            bc /= indice.doubleValue();
        }
        return bc;
    }

    private double getBCST(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST) {
        double bcIcmsst = vrProdServ;
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == 1) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == 1) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == 1) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == 1) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == 1) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private void calcularIcmsPartilha(Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufCliente, Double percentualPartilha, Short consumidorFinal, HashMap h, Short contribuinteEstado, Double aliquotaIcms, String codigoIncidenciaIcms, Double aliquotaFCP, EnumConstModFiscalDifal tipoDifal, Short entradaSaida) throws ExceptionService {
        if (ToolMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_NAO_CALCULAR.getValue(), (Object)tipoDifal.getValue())) {
            return;
        }
        if (consumidorFinal != null && consumidorFinal == 1 && !ufEmpresa.equals((Object)ufCliente) && !ufCliente.getSigla().equals("EX") && contribuinteEstado.equals(EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId())) {
            Double baseCalculo = (Double)h.get(ICMS_TRIBUTADO);
            Double vrIcms = (Double)h.get(VALOR_ICMS);
            if (vrIcms != null && vrIcms > 0.0) {
                Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
                Double aliqInterestadual = aliquotaIcms;
                Double diferenca = Math.abs(aliqInternaDest - aliqInterestadual);
                if (diferenca >= 0.0 && ToolMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_CALCULAR.getValue(), (Object)tipoDifal.getValue())) {
                    Double valorIcmsACalcular = ContatoFormatUtil.arrredondarNumero(baseCalculo * diferenca / 100.0, 2);
                    Double vrIcmsUFDest = ContatoFormatUtil.arrredondarNumero(valorIcmsACalcular * percentualPartilha / 100.0, 2);
                    if (ToolMethods.isEquals((Object)entradaSaida, (Object)1)) {
                        h.put(VR_ICMS_UF_DEST, vrIcmsUFDest);
                        h.put(VR_ICMS_UF_REM, valorIcmsACalcular - vrIcmsUFDest);
                    } else {
                        h.put(VR_ICMS_UF_REM, vrIcmsUFDest);
                        h.put(VR_ICMS_UF_DEST, valorIcmsACalcular - vrIcmsUFDest);
                    }
                    h.put(BC_ICMS_UF_DEST, baseCalculo);
                    h.put(ALIQ_INTERNA_UF_DEST, aliqInternaDest);
                    h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                    h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                    if (aliquotaFCP != null && aliquotaFCP > 0.0) {
                        h.put(ALIQ_FUNDO_POBREZA, aliquotaFCP);
                        h.put(VALOR_FUNDO_POBREZA, baseCalculo * (aliquotaFCP / 100.0));
                    }
                } else {
                    h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                    h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                }
            } else if (codigoIncidenciaIcms.equals("101") || codigoIncidenciaIcms.equals("102") || codigoIncidenciaIcms.equals("103") || codigoIncidenciaIcms.equals("300") || codigoIncidenciaIcms.equals("400") || codigoIncidenciaIcms.equals("500")) {
                Double aliqInterestadual = this.getAliquotaICMS(ufEmpresa, ufCliente);
                h.put(BC_ICMS_UF_DEST, 0.0);
                h.put(ALIQ_INTERNA_UF_DEST, 0.0);
                h.put(ALIQ_INTERESTADUAL, aliqInterestadual);
                h.put(PERC_PARTILHA_ICMS, percentualPartilha);
                h.put(VR_ICMS_UF_DEST, 0.0);
                h.put(VR_ICMS_UF_REM, 0.0);
                if (aliquotaFCP != null && aliquotaFCP > 0.0) {
                    h.put(ALIQ_FUNDO_POBREZA, aliquotaFCP);
                    h.put(VALOR_FUNDO_POBREZA, baseCalculo * (aliquotaFCP / 100.0));
                }
            }
            h.put(ALIQUOTA_FCP, 0.0);
            h.put(ALIQUOTA_FCP_ST, 0.0);
            h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
            h.put(VALOR_FCP, 0.0);
            h.put(VALOR_FCP_ST, 0.0);
            h.put(VALOR_FCP_ST_RETIDO, 0.0);
            h.put(BASE_CALCULO_FCP, 0.0);
            h.put(BASE_CALCULO_FCP_ST, 0.0);
            h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
        }
    }

    private Double getAliquotaInternaUFDestinatario(Produto produto, UnidadeFederativa ufCliente) throws ExceptionService {
        List aliquotasUFNcm;
        List aliquotasUFProd = produto.getAliquotasUF();
        if (aliquotasUFProd != null) {
            for (ProdutoAliquotaUF aliqUF : aliquotasUFProd) {
                if (!aliqUF.getUf().equals((Object)ufCliente)) continue;
                return aliqUF.getAliquotaIcms();
            }
        }
        if ((aliquotasUFNcm = produto.getNcm().getAliquotasUF()) != null) {
            for (NcmAliquotaUF aliqUF : aliquotasUFNcm) {
                if (!aliqUF.getUf().equals((Object)ufCliente)) continue;
                return aliqUF.getAliquotaIcms();
            }
        }
        throw new ExceptionService("Primeiro, cadastre a al\u00edquota interestadual para o produto: " + produto.getIdentificador() + "-" + produto.getNome() + "  ou para o NCM: " + produto.getNcm().getCodigo());
    }

    private Double getPercentualPartilhaIcms() {
        int ano;
        if (this.dataEmissao == null) {
            this.dataEmissao = new Date();
        }
        if ((ano = DateUtil.yearFromDate(this.dataEmissao).intValue()) < 2017) {
            return 40.0;
        }
        if (ano == 2017) {
            return 60.0;
        }
        if (ano == 2018) {
            return 80.0;
        }
        return 100.0;
    }

    private String getSimOrNao(Short consumidorFinal) {
        if (consumidorFinal.equals((short)1)) {
            return "Sim";
        }
        return "N\u00e3o";
    }

    private double getBCSTPresumido(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIPI, Double percRedBCST, UnidadeFatCliente unidadeFatCliente) {
        double bcIcmsst = vrProdServ;
        if (unidadeFatCliente != null) {
            Double aliqPisSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualPisSufr();
            Double aliqCofinsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualCofinsSufr();
            Double aliqIcmsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualIcmsSufr();
            Double aliqIpiSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualIpiSufr();
            bcIcmsst = ContatoFormatUtil.arrredondarNumero(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0), 2);
            bcIcmsst = ContatoFormatUtil.arrredondarNumero(bcIcmsst - bcIcmsst * (aliqIcmsSuf / 100.0), 2);
            bcIcmsst = ContatoFormatUtil.arrredondarNumero(bcIcmsst + bcIcmsst * (aliqIpiSuf / 100.0), 2);
        }
        if (this.incluirDescontoBCST != null && this.incluirDescontoBCST == 1) {
            bcIcmsst -= valorDesconto;
        }
        if (this.incluirDespAcessBCST != null && this.incluirDespAcessBCST == 1) {
            bcIcmsst += valorDespAcess;
        }
        if (this.incluirFreteBCST != null && this.incluirFreteBCST == 1) {
            bcIcmsst += valorFrete;
        }
        if (this.incluirSeguroBCST != null && this.incluirSeguroBCST == 1) {
            bcIcmsst += valorSeguro;
        }
        if (this.incluirIPIBCST != null && this.incluirIPIBCST == 1) {
            bcIcmsst += valorIPI;
        }
        if (percRedBCST != null && percRedBCST > 0.0) {
            bcIcmsst -= bcIcmsst * percRedBCST / 100.0;
        }
        return bcIcmsst;
    }

    private Double getBCAbatendoSomentePisCofins(Double vrProdServ, UnidadeFatCliente unidadeFatCliente) {
        double bcIcmsst = vrProdServ;
        Double aliqPisSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualPisSufr();
        Double aliqCofinsSuf = unidadeFatCliente.getCliente().getFaturamento().getPercentualCofinsSufr();
        bcIcmsst = ContatoFormatUtil.arrredondarNumero(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0), 2);
        return bcIcmsst;
    }

    private DadosFiscaisUF getDAdosFiscaisUF(UnidadeFatCliente unidadeFatCliente, Empresa empresa) throws ExceptionService {
        if (unidadeFatCliente != null) {
            BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAODadosFiscaisUF().getVOClass());
            bc.and().equal("empresa", empresa);
            bc.and().equal("uf", unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf());
            return (DadosFiscaisUF)CoreService.executeSearchUniqueResult(bc);
        }
        return null;
    }

    private void calcularFCP(double aliquotaFCP, double vlrIcms, double baseCalculo, HashMap h, Short naoCalcularFCP) {
        if (this.versaoNFe.getCodigo().equals("4.00") && (naoCalcularFCP == null || naoCalcularFCP.equals((short)0)) && aliquotaFCP > 0.0 && vlrIcms > 0.0) {
            h.put(VALOR_FCP, ContatoFormatUtil.arrredondarNumero(baseCalculo * (aliquotaFCP / 100.0), 2));
            h.put(ALIQUOTA_FCP, aliquotaFCP);
            h.put(BASE_CALCULO_FCP, baseCalculo);
        }
    }

    private void calcularFCPSt(Double aliquotaFCP, Double bcST, HashMap h, Short naoCalcularFCP) {
        if (this.versaoNFe.getCodigo().equals("4.00") && (naoCalcularFCP == null || naoCalcularFCP.equals((short)0)) && bcST != null && bcST > 0.0 && aliquotaFCP > 0.0) {
            Double valorFCPSt = ContatoFormatUtil.arrredondarNumero(bcST * (aliquotaFCP / 100.0), 2);
            h.put(VALOR_FCP_ST, valorFCPSt);
            h.put(ALIQUOTA_FCP_ST, aliquotaFCP);
            h.put(BASE_CALCULO_FCP_ST, bcST);
            h.put(VALOR_FCP, 0.0);
            h.put(ALIQUOTA_FCP, 0.0);
            h.put(BASE_CALCULO_FCP, 0.0);
            h.put(VALOR_FCP_ST_RETIDO, 0.0);
            h.put(ALIQUOTA_FCP_ST_RETIDO, 0.0);
            h.put(BASE_CALCULO_FCP_ST_RETIDO, 0.0);
            Double valorIcmsOutros = (Double)h.get(ICMS_OUTROS);
            h.put(ICMS_OUTROS, valorIcmsOutros + valorFCPSt);
        }
    }

    private void calcularIcmsDesoneradoSuframa(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, UnidadeFatCliente unidadeFatCliente, double vrProdServ, HashMap h, Short naoAplicaSuframaProduto, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double valorIPI, Short tipoCFOP, Produto produto, double quantidadeTotal) {
        Cliente vo = unidadeFatCliente.getCliente();
        double perc = 0.0;
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        if (vo != null && vo.getPessoa().getComplemento().getHabilitarSuframa() != null && vo.getPessoa().getComplemento().getHabilitarSuframa() == 1 && modeloFiscalIcms.getMotivoDesoneracaoIcms() != null && modeloFiscalIcms.getMotivoDesoneracaoIcms().getCodigo().equals("7") && (naoAplicaSuframaProduto == null || naoAplicaSuframaProduto.equals((short)0)) && vo.getFaturamento().getPercentualIcmsSufr() > 0.0) {
            perc = vo.getFaturamento().getPercentualIcmsSufr();
            h.put(VALOR_ICMS_DESONERADO, ContatoFormatUtil.arrredondarNumero(perc / 100.0 * baseCalculo, 2));
        }
    }

    private void calcDifalSTBaseSimples(HashMap values, Produto produto, UnidadeFederativa ufCliente) throws ExceptionService {
        Double bcIcms = (Double)values.get(BASE_CALCULO_ICMS);
        Double aliqIcms = (Double)values.get(ALIQUOTA_ICMS);
        Double vlrIcms = (Double)values.get(VALOR_ICMS);
        Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
        Double bcDifalST = bcIcms;
        Double vrDifalST = bcIcms * (aliqInternaDest - aliqIcms) / 100.0;
        values.put(VALOR_ICMS_ST, vrDifalST);
        values.put(BASE_CALCULO_ICMS_ST, bcDifalST);
    }

    private void calcDifalSTBaseDupla(HashMap values, Produto produto, UnidadeFederativa ufCliente) throws ExceptionService {
        Double bcIcms = (Double)values.get(BASE_CALCULO_ICMS);
        Double aliqIcms = (Double)values.get(ALIQUOTA_ICMS);
        Double vlrIcms = (Double)values.get(VALOR_ICMS);
        Double aliqInternaDest = this.getAliquotaInternaUFDestinatario(produto, ufCliente);
        Double bcDifalST = (bcIcms - vlrIcms) / (1.0 - aliqInternaDest / 100.0);
        Double vrDifalST = bcDifalST * aliqInternaDest / 100.0 - vlrIcms;
        values.put(VALOR_ICMS_ST, vrDifalST);
        values.put(BASE_CALCULO_ICMS_ST, bcDifalST);
    }

    private void calcularICMS61(ModeloFiscalIcms modeloFiscalIcms, ModeloFiscalIpi modeloFiscalIpi, Short tipoCFOP, Produto produto, HashMap h, Double aliquotaICMS, Double percRedICMS, Double valorFrete, Double valorSeguro, Double valorDespAcess, Double valorDesconto, Double vrProdServ, Double valorIPI, Double quantidadeTotal) {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIPI, modeloFiscalIcms, modeloFiscalIpi, tipoCFOP, produto, quantidadeTotal);
        h.put(BASE_CALCULO_ICMS, baseCalculo);
        h.put(ALIQUOTA_ICMS, aliquotaICMS);
        h.put(ICMS_OUTROS, baseCalculo);
        h.put(VALOR_ICMS, 0.0);
    }
}

