/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionCalculoIPI;

public class CalculoIPIEntUtilities {
    public static final String ALIQUOTA_IPI = "aliquotaIPI";
    public static final String IPI_INDUSTRIA = "ipiIndustria";
    public static final String IPI_ISENTO = "ipiIsento";
    public static final String IPI_OBSERVACAO = "ipiObservacao";
    public static final String IPI_COMERCIO = "ipiComercio";
    public static final String IPI_OUTROS = "ipiOutros";
    public static final String IPI_TRIBUTADO = "ipiTributado";
    private final Short incluirSeguroBC;
    private final Short incluirFreteBC;
    private final Short incluirDespAcessBC;
    private final Short incluirDescontoBC;

    public CalculoIPIEntUtilities(Short incluirSeguroBC, Short incluirFreteBC, Short incluirDespAcessBC, Short incluirDescontoBC) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
    }

    public HashMap calcularIpi(ModeloFiscalIpi modeloFiscalIpi, IncidenciaIpi inc, UnidadeFatFornecedor fornecedor, Produto produto, Double aliquotaIpi, short modoArredondamento, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, double quantidadeTotal) throws ExceptionCalculoIPI {
        String codigoIPI = inc.getCodigo();
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro);
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(ALIQUOTA_IPI, 0.0);
        h.put(IPI_COMERCIO, 0.0);
        h.put(IPI_INDUSTRIA, 0.0);
        h.put(IPI_ISENTO, 0.0);
        h.put(IPI_OBSERVACAO, 0.0);
        h.put(IPI_OUTROS, 0.0);
        h.put(IPI_TRIBUTADO, 0.0);
        h.put(ALIQUOTA_IPI, aliquotaIpi);
        switch (Integer.valueOf(codigoIPI)) {
            case 0: {
                this.calcularIpi00(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi, produto.getIpiTributadoQuantidade(), quantidadeTotal);
                break;
            }
            case 1: {
                this.calcularIpi01(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            case 2: {
                this.calcularIpi02(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            case 3: {
                this.calcularIpi03(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            case 4: {
                this.calcularIpi04(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            case 5: {
                this.calcularIpi05(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            case 49: {
                this.calcularIpi49(modeloFiscalIpi, baseCalculo, fornecedor, produto, h, aliquotaIpi);
                break;
            }
            default: {
                throw new ExceptionCalculoIPI("O sistema n\u00e3o contempla este tipo de IPI na Entrada.");
            }
        }
        h.put(ALIQUOTA_IPI, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_IPI)), (int)2, (int)modoArredondamento));
        h.put(IPI_COMERCIO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_COMERCIO)), (int)2, (int)modoArredondamento));
        h.put(IPI_INDUSTRIA, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_INDUSTRIA)), (int)2, (int)modoArredondamento));
        h.put(IPI_ISENTO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_ISENTO)), (int)2, (int)modoArredondamento));
        h.put(IPI_OBSERVACAO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_OBSERVACAO)), (int)2, (int)modoArredondamento));
        h.put(IPI_OUTROS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_OUTROS)), (int)2, (int)modoArredondamento));
        h.put(IPI_TRIBUTADO, ToolFormatter.arrredondarNumero((Double)((Double)h.get(IPI_TRIBUTADO)), (int)2, (int)modoArredondamento));
        return h;
    }

    private void calcularIpi00(ModeloFiscalIpi modeloFiscalIpi, Double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, Double aliquotaIpi, Short ipiTributadoQtde, Double quantidade) {
        if (modeloFiscalIpi != null && fornecedor != null && produto != null) {
            boolean fornComercio;
            boolean recTributos = modeloFiscalIpi.getRecuperarTributosIPI() != null && modeloFiscalIpi.getRecuperarTributosIPI() == 1;
            boolean fornIndustria = fornecedor.getFornecedor().getTipo() == 1;
            boolean bl = fornComercio = fornecedor.getFornecedor().getTipo() == 0;
            if (recTributos && fornIndustria) {
                h.put(IPI_TRIBUTADO, baseCalculo);
                if (ipiTributadoQtde == null || ipiTributadoQtde.equals((short)0)) {
                    h.put(IPI_INDUSTRIA, baseCalculo * (aliquotaIpi / 100.0));
                } else {
                    h.put(IPI_INDUSTRIA, aliquotaIpi * quantidade);
                }
            } else if (recTributos && fornComercio) {
                h.put(IPI_TRIBUTADO, baseCalculo);
                if (ipiTributadoQtde == null || ipiTributadoQtde.equals((short)0)) {
                    h.put(IPI_COMERCIO, baseCalculo * (aliquotaIpi / 100.0) * 0.5);
                } else {
                    h.put(IPI_COMERCIO, aliquotaIpi * quantidade);
                }
            } else if (!recTributos && fornIndustria) {
                h.put(IPI_OUTROS, baseCalculo);
                if (ipiTributadoQtde == null || ipiTributadoQtde.equals((short)0)) {
                    h.put(IPI_OBSERVACAO, baseCalculo * (aliquotaIpi / 100.0));
                } else {
                    h.put(IPI_OBSERVACAO, aliquotaIpi * quantidade);
                }
            } else if (!recTributos && fornComercio || fornecedor.getFornecedor().getTipoEpp().equals((short)1)) {
                h.put(IPI_OUTROS, baseCalculo);
            }
        }
    }

    private void calcularIpi01(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_OUTROS, baseCalculo);
    }

    private void calcularIpi02(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_ISENTO, baseCalculo);
    }

    private void calcularIpi03(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_OUTROS, baseCalculo);
    }

    private void calcularIpi04(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_OUTROS, baseCalculo);
    }

    private void calcularIpi05(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_OUTROS, baseCalculo);
    }

    private void calcularIpi49(ModeloFiscalIpi modeloFiscalIpi, double baseCalculo, UnidadeFatFornecedor fornecedor, Produto produto, HashMap h, double aliquotaIpi) {
        h.put(IPI_OUTROS, baseCalculo);
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro) {
        double bc = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        return bc;
    }
}

