/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.constants.enums.modelorps.EnumConstTipoISSModeloRPS;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import contatocore.util.ContatoFormatUtil;
import java.util.HashMap;

public class CalculoOutrosImpostos {
    public static final String ALIQUOTA_INSS = "aliquotaInss";
    public static final String VALOR_INSS = "valorInss";
    public static final String VALOR_INSS_NAO_RETIDO = "valorInssNaoRetido";
    public static final String PERC_RED_INSS = "percRedInss";
    public static final String BC_INSS = "BCINSS";
    public static final String ALIQUOTA_IRRF = "aliquotaIrrf";
    public static final String VALOR_IRRF = "valorIrrf";
    public static final String BC_IRRF = "bcIrrf";
    public static final String PERC_RED_IRRF = "percRedIRRF";
    public static final String ALIQUOTA_ISS = "aliquotaIss";
    public static final String VALOR_ISS = "valorIss";
    public static final String BC_ISS = "bcIss";
    public static final String PERC_RED_ISS = "percRedISS";
    public static final String VALOR_DEDUCAO_ISS = "valorDeducaoISS";
    public static final String ALIQUOTA_FUNRURAL = "aliquotaFunrural";
    public static final String BC_FUNRURAL = "bcFunrural";
    public static final String VALOR_FUNRURAL = "valorFunrural";
    public static final String PERC_RED_FUNRURAL = "percRedFunrural";
    public static final String ALIQUOTA_LEI10833 = "aliquotaLei10833";
    public static final String VALOR_LEI10833 = "valorLei10833";
    public static final String BC_LEI10833 = "bcLei10833";
    public static final String ALIQUOTA_CIDE = "aliquotaCIDE";
    public static final String VALOR_CIDE = "valorCIDE";
    public static final String BC_CIDE = "bcCIDE";
    public static final String PERC_RED_LEI10833 = "percRedLei10833";
    public static final String ALIQUOTA_CONT_SOC = "aliquotaContSoc";
    public static final String VALOR_CONT_SOC = "valorContSoc";
    public static final String BC_CONT_SOC = "BCContSoc";
    public static final String PERC_RED_CONT_SOC = "percRedContSoc";
    public static final String ALIQUOTA_OUTROS = "aliquotaOutros";
    public static final String VALOR_OUTROS = "valorOutros";
    public static final String BC_OUTROS = "BCOutros";
    public static final String PERC_RED_OUTROS = "percRedOutros";
    public static final String ALIQUOTA_SEST_SENAT = "aliquotaSestSenat";
    public static final String VALOR_SEST_SENAT = "valorSestSenat";
    public static final String PERC_RED_SEST_SENAT = "percRedSestSenat";
    public static final String BC_SEST_SENAT = "BCSestSenat";
    public static final String BC_IMPOSTO_ESTIMADO = "bcImpostoEstimado";
    public static final String ALIQUOTA_IMPOSTO_ESTIMADA = "aliqImpEstimado";
    public static final String VALOR_IMPOSTOS_ESTIMADO = "vlrImpEstimado";
    public static final String BC_IMPOSTO_IMPORTACAO = "bcImpostoImportacao";
    public static final String ALIQUOTA_IMPOSTO_IMPORTACAO = "aliquotaImpostoImportacao";
    public static final String VALOR_IMPOSTO_IMPORTACAO = "valorImpostoImportacao";

    public static HashMap calculoIRRF(Short tipoIRRF, Double aliquotaIRRF, Double percRedIRRF, Double valorIrrf, Double valorMinimoIrrf, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (tipoIRRF != null && tipoIRRF == 1) {
            aliquotaIRRF = aliquotaIRRF == null ? 0.0 : aliquotaIRRF;
            percRedIRRF = percRedIRRF == null ? 0.0 : percRedIRRF;
            double bcIRRF = 0.0;
            bcIRRF = percRedIRRF > 0.0 ? baseCalculo - baseCalculo * (percRedIRRF / 100.0) : baseCalculo;
            h.put(ALIQUOTA_IRRF, aliquotaIRRF);
            h.put(VALOR_IRRF, aliquotaIRRF / 100.0 * bcIRRF);
            h.put(PERC_RED_IRRF, percRedIRRF);
            h.put(BC_IRRF, bcIRRF);
        } else if (tipoIRRF != null && tipoIRRF == 0) {
            h.put(ALIQUOTA_IRRF, 0.0);
            h.put(VALOR_IRRF, 0.0);
            h.put(PERC_RED_IRRF, 0.0);
            h.put(BC_IRRF, 0.0);
        } else {
            h.put(ALIQUOTA_IRRF, aliquotaIRRF);
            h.put(VALOR_IRRF, valorIrrf);
            h.put(PERC_RED_IRRF, percRedIRRF);
            h.put(BC_IRRF, baseCalculo);
        }
        valorIrrf = (Double)h.get(VALOR_IRRF);
        if (valorMinimoIrrf != null && valorIrrf < valorMinimoIrrf) {
            valorIrrf = 0.0;
        }
        h.put(VALOR_IRRF, ContatoFormatUtil.arrredondarNumero((Double)valorIrrf, (int)2, (int)modoArredondamento));
        h.put(BC_IRRF, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_IRRF)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoINSS(Short tipoInss, Double aliquotaINSS, Double percRedINSS, Double valorInss, Double valorInssNaoRetido, Double valorMinimoInss, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (tipoInss != null && (tipoInss == 1 || tipoInss == 3)) {
            aliquotaINSS = aliquotaINSS == null ? 0.0 : aliquotaINSS;
            percRedINSS = percRedINSS == null ? 0.0 : percRedINSS;
            double bcInss = 0.0;
            bcInss = percRedINSS > 0.0 ? baseCalculo - baseCalculo * (percRedINSS / 100.0) : baseCalculo;
            h.put(ALIQUOTA_INSS, aliquotaINSS);
            h.put(PERC_RED_INSS, percRedINSS);
            h.put(BC_INSS, bcInss);
            if (tipoInss == 1) {
                h.put(VALOR_INSS, aliquotaINSS / 100.0 * bcInss);
                h.put(VALOR_INSS_NAO_RETIDO, 0.0);
            } else {
                h.put(VALOR_INSS_NAO_RETIDO, aliquotaINSS / 100.0 * bcInss);
                h.put(VALOR_INSS, 0.0);
            }
        } else if (tipoInss != null && tipoInss == 0) {
            h.put(ALIQUOTA_INSS, 0.0);
            h.put(VALOR_INSS, 0.0);
            h.put(VALOR_INSS_NAO_RETIDO, 0.0);
            h.put(PERC_RED_INSS, 0.0);
            h.put(BC_INSS, 0.0);
        } else {
            h.put(ALIQUOTA_INSS, aliquotaINSS);
            h.put(VALOR_INSS, valorInss);
            h.put(VALOR_INSS_NAO_RETIDO, valorInssNaoRetido);
            h.put(PERC_RED_INSS, percRedINSS);
            h.put(BC_INSS, baseCalculo);
        }
        valorInss = (Double)h.get(VALOR_INSS);
        if (valorMinimoInss != null && valorInss < valorMinimoInss) {
            valorInss = 0.0;
        }
        h.put(VALOR_INSS, ContatoFormatUtil.arrredondarNumero((Double)valorInss, (int)2, (int)modoArredondamento));
        valorInss = (Double)h.get(VALOR_INSS_NAO_RETIDO);
        if (valorMinimoInss != null && valorInss < valorMinimoInss) {
            valorInss = 0.0;
        }
        h.put(VALOR_INSS_NAO_RETIDO, ContatoFormatUtil.arrredondarNumero((Double)valorInss, (int)2, (int)modoArredondamento));
        h.put(BC_INSS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_INSS)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoISS(Short tipoISS, Double aliquotaISS, Double percRedISS, Double valorIss, Double valorMinimoIss, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (tipoISS != null && (tipoISS.shortValue() == EnumConstTipoISSModeloRPS.TIPO_ISS_NORMAL.getValue() || tipoISS.shortValue() == EnumConstTipoISSModeloRPS.TIPO_ISS_RETIDO.getValue())) {
            aliquotaISS = aliquotaISS == null ? 0.0 : aliquotaISS;
            percRedISS = percRedISS == null ? 0.0 : percRedISS;
            double bcIss = 0.0;
            double bcOriginal = baseCalculo;
            bcIss = percRedISS > 0.0 ? baseCalculo - baseCalculo * (percRedISS / 100.0) : baseCalculo;
            h.put(ALIQUOTA_ISS, aliquotaISS);
            h.put(VALOR_ISS, aliquotaISS / 100.0 * bcIss);
            h.put(PERC_RED_ISS, percRedISS);
            h.put(BC_ISS, bcIss);
            h.put(VALOR_DEDUCAO_ISS, bcOriginal - bcIss);
        } else if (tipoISS.shortValue() == EnumConstTipoISSModeloRPS.TIPO_ISS_NAO_CALCULAR.getValue()) {
            h.put(ALIQUOTA_ISS, 0.0);
            h.put(VALOR_ISS, 0.0);
            h.put(PERC_RED_ISS, 0.0);
            h.put(BC_ISS, 0.0);
        } else if (tipoISS.shortValue() == EnumConstTipoISSModeloRPS.TIPO_ISS_EXIBIR_ALIQ_BC_NAO_CALC.getValue()) {
            h.put(ALIQUOTA_ISS, aliquotaISS);
            h.put(VALOR_ISS, 0.0);
            h.put(PERC_RED_ISS, percRedISS);
            h.put(BC_ISS, baseCalculo);
        } else {
            h.put(ALIQUOTA_ISS, aliquotaISS);
            h.put(VALOR_ISS, valorIss);
            h.put(BC_ISS, baseCalculo);
        }
        valorIss = (Double)h.get(VALOR_ISS);
        if (valorMinimoIss != null && valorIss < valorMinimoIss) {
            valorIss = 0.0;
        }
        h.put(VALOR_ISS, ContatoFormatUtil.arrredondarNumero((Double)valorIss, (int)2, (int)modoArredondamento));
        h.put(BC_ISS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_ISS)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoFunrural(ModeloFiscal modeloFiscal, Double aliquotaFunrural, Double percRedFunrural, Double valorFunrural, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (modeloFiscal.getTipoFunrural() != null && modeloFiscal.getTipoFunrural() == 1) {
            aliquotaFunrural = aliquotaFunrural == null ? 0.0 : aliquotaFunrural;
            percRedFunrural = percRedFunrural == null ? 0.0 : percRedFunrural;
            double bcFunrural = 0.0;
            bcFunrural = percRedFunrural > 0.0 ? baseCalculo - baseCalculo * (percRedFunrural / 100.0) : baseCalculo;
            h.put(ALIQUOTA_FUNRURAL, aliquotaFunrural);
            h.put(VALOR_FUNRURAL, aliquotaFunrural / 100.0 * bcFunrural);
            h.put(PERC_RED_FUNRURAL, percRedFunrural);
            h.put(BC_FUNRURAL, bcFunrural);
        } else if (modeloFiscal.getTipoFunrural() != null && modeloFiscal.getTipoFunrural() == 0) {
            h.put(ALIQUOTA_FUNRURAL, 0.0);
            h.put(VALOR_FUNRURAL, 0.0);
            h.put(PERC_RED_FUNRURAL, 0.0);
            h.put(BC_FUNRURAL, 0.0);
        } else {
            h.put(ALIQUOTA_FUNRURAL, aliquotaFunrural);
            h.put(VALOR_FUNRURAL, valorFunrural);
            h.put(PERC_RED_FUNRURAL, percRedFunrural);
            h.put(BC_FUNRURAL, baseCalculo);
        }
        h.put(VALOR_FUNRURAL, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_FUNRURAL)), (int)2, (int)modoArredondamento));
        h.put(BC_FUNRURAL, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_FUNRURAL)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoOutros(Short tipoOutros, Double aliquotaOutros, Double percRedOutros, Double valorOutros, Double valorMinimoOutros, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (tipoOutros != null && tipoOutros == 1) {
            aliquotaOutros = aliquotaOutros == null ? 0.0 : aliquotaOutros;
            percRedOutros = percRedOutros == null ? 0.0 : percRedOutros;
            double bcOutros = 0.0;
            bcOutros = percRedOutros > 0.0 ? baseCalculo - baseCalculo * (percRedOutros / 100.0) : baseCalculo;
            h.put(ALIQUOTA_OUTROS, aliquotaOutros);
            h.put(VALOR_OUTROS, aliquotaOutros / 100.0 * bcOutros);
            h.put(PERC_RED_OUTROS, percRedOutros);
            h.put(BC_OUTROS, bcOutros);
        } else if (tipoOutros != null && tipoOutros == 0) {
            h.put(ALIQUOTA_OUTROS, 0.0);
            h.put(VALOR_OUTROS, 0.0);
            h.put(PERC_RED_OUTROS, 0.0);
            h.put(BC_OUTROS, 0.0);
        } else {
            h.put(ALIQUOTA_OUTROS, aliquotaOutros);
            h.put(VALOR_OUTROS, valorOutros);
            h.put(PERC_RED_OUTROS, percRedOutros);
            h.put(BC_OUTROS, baseCalculo);
        }
        valorOutros = (Double)h.get(VALOR_OUTROS);
        if (valorMinimoOutros != null && valorOutros < valorMinimoOutros) {
            valorOutros = 0.0;
        }
        h.put(VALOR_OUTROS, ContatoFormatUtil.arrredondarNumero((Double)valorOutros, (int)2, (int)modoArredondamento));
        h.put(BC_OUTROS, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_OUTROS)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoSestSenat(ModeloFiscal modeloFiscal, Double aliquotaSestSenat, Double percRedSestSenat, Double valorSestSenat, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (modeloFiscal.getTipoSestSenat() != null && modeloFiscal.getTipoSestSenat() == 1) {
            aliquotaSestSenat = aliquotaSestSenat == null ? 0.0 : aliquotaSestSenat;
            percRedSestSenat = percRedSestSenat == null ? 0.0 : percRedSestSenat;
            double bcSestSenat = 0.0;
            bcSestSenat = percRedSestSenat > 0.0 ? baseCalculo - baseCalculo * (percRedSestSenat / 100.0) : baseCalculo;
            h.put(ALIQUOTA_SEST_SENAT, aliquotaSestSenat);
            h.put(VALOR_SEST_SENAT, aliquotaSestSenat / 100.0 * bcSestSenat);
            h.put(PERC_RED_SEST_SENAT, percRedSestSenat);
            h.put(BC_SEST_SENAT, bcSestSenat);
        } else if (modeloFiscal.getTipoSestSenat() != null && modeloFiscal.getTipoSestSenat() == 0) {
            h.put(ALIQUOTA_SEST_SENAT, 0.0);
            h.put(VALOR_SEST_SENAT, 0.0);
            h.put(PERC_RED_SEST_SENAT, 0.0);
            h.put(BC_SEST_SENAT, 0.0);
        } else {
            h.put(ALIQUOTA_SEST_SENAT, aliquotaSestSenat);
            h.put(VALOR_SEST_SENAT, valorSestSenat);
            h.put(PERC_RED_SEST_SENAT, percRedSestSenat);
            h.put(BC_SEST_SENAT, baseCalculo);
        }
        h.put(VALOR_SEST_SENAT, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_SEST_SENAT)), (int)2, (int)modoArredondamento));
        h.put(BC_SEST_SENAT, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_SEST_SENAT)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoContSoc(Short tipoContSoc, Double aliquotaContSoc, Double percRedContSoc, Double valorMinimoContSoc, Double valorContSoc, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (tipoContSoc != null && tipoContSoc == 1) {
            aliquotaContSoc = aliquotaContSoc == null ? 0.0 : aliquotaContSoc;
            percRedContSoc = percRedContSoc == null ? 0.0 : percRedContSoc;
            double bcContSoc = 0.0;
            bcContSoc = percRedContSoc > 0.0 ? baseCalculo - baseCalculo * (percRedContSoc / 100.0) : baseCalculo;
            h.put(ALIQUOTA_CONT_SOC, aliquotaContSoc);
            h.put(VALOR_CONT_SOC, aliquotaContSoc / 100.0 * bcContSoc);
            h.put(PERC_RED_CONT_SOC, percRedContSoc);
            h.put(BC_CONT_SOC, bcContSoc);
        } else if (tipoContSoc != null && tipoContSoc == 0) {
            h.put(ALIQUOTA_CONT_SOC, 0.0);
            h.put(VALOR_CONT_SOC, 0.0);
            h.put(PERC_RED_CONT_SOC, 0.0);
            h.put(BC_CONT_SOC, 0.0);
        } else {
            h.put(ALIQUOTA_CONT_SOC, aliquotaContSoc);
            h.put(VALOR_CONT_SOC, valorContSoc);
            h.put(PERC_RED_CONT_SOC, percRedContSoc);
            h.put(BC_CONT_SOC, baseCalculo);
        }
        h.put(VALOR_CONT_SOC, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_CONT_SOC)), (int)2, (int)modoArredondamento));
        valorContSoc = (Double)h.get(VALOR_CONT_SOC);
        if (valorMinimoContSoc != null && valorContSoc < valorMinimoContSoc) {
            valorContSoc = 0.0;
        }
        h.put(VALOR_CONT_SOC, valorContSoc);
        h.put(BC_CONT_SOC, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_CONT_SOC)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calculoLei10833(ModeloFiscal modeloFiscal, Double aliquotaLei10833, Double percRedLei10833, Double valorLei10833, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, short modoArredondamento) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (modeloFiscal.getTipoLei10833() != null && modeloFiscal.getTipoLei10833() == 1) {
            aliquotaLei10833 = aliquotaLei10833 == null ? 0.0 : aliquotaLei10833;
            percRedLei10833 = percRedLei10833 == null ? 0.0 : percRedLei10833;
            double bcLei10833 = 0.0;
            bcLei10833 = percRedLei10833 > 0.0 ? baseCalculo - baseCalculo * (percRedLei10833 / 100.0) : baseCalculo;
            h.put(ALIQUOTA_LEI10833, aliquotaLei10833);
            h.put(VALOR_LEI10833, aliquotaLei10833 / 100.0 * bcLei10833);
            h.put(PERC_RED_LEI10833, percRedLei10833);
            h.put(BC_LEI10833, bcLei10833);
        } else if (modeloFiscal.getTipoLei10833() != null && modeloFiscal.getTipoLei10833() == 0) {
            h.put(ALIQUOTA_LEI10833, 0.0);
            h.put(VALOR_LEI10833, 0.0);
            h.put(PERC_RED_LEI10833, 0.0);
            h.put(BC_LEI10833, 0.0);
        } else {
            h.put(ALIQUOTA_LEI10833, aliquotaLei10833);
            h.put(VALOR_LEI10833, valorLei10833);
            h.put(PERC_RED_LEI10833, percRedLei10833);
            h.put(BC_LEI10833, baseCalculo);
        }
        h.put(VALOR_LEI10833, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_LEI10833)), (int)2, (int)modoArredondamento));
        h.put(BC_LEI10833, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_LEI10833)), (int)2, (int)modoArredondamento));
        return h;
    }

    public static HashMap calcularValorImpostosPrevistos(ModeloFiscal modeloFiscal, Double aliquotaImpostoEst, Double valorImpostoEst, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ) {
        double baseCalculo = vrProdServ + valorDespAcess + valorFrete + valorSeguro;
        HashMap<String, Double> h = new HashMap<String, Double>();
        aliquotaImpostoEst = aliquotaImpostoEst == null ? 0.0 : aliquotaImpostoEst;
        double bcImpostoEst = 0.0;
        bcImpostoEst = baseCalculo;
        h.put(ALIQUOTA_IMPOSTO_ESTIMADA, aliquotaImpostoEst);
        h.put(VALOR_IMPOSTOS_ESTIMADO, aliquotaImpostoEst / 100.0 * bcImpostoEst);
        h.put(BC_IMPOSTO_ESTIMADO, bcImpostoEst);
        h.put(VALOR_IMPOSTOS_ESTIMADO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_IMPOSTOS_ESTIMADO)), (int)2));
        h.put(BC_IMPOSTO_ESTIMADO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_IMPOSTO_ESTIMADO)), (int)2));
        return h;
    }

    public static HashMap calculoCIDE(ModeloFiscal modeloFiscal, Double aliquotaCIDE, Double valorCIDE, double quantidadeBCCide) {
        double baseCalculo = quantidadeBCCide;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (modeloFiscal.getTipoCalculoCide() != null && modeloFiscal.getTipoCalculoCide() == 1) {
            aliquotaCIDE = aliquotaCIDE == null ? 0.0 : aliquotaCIDE;
            h.put(ALIQUOTA_CIDE, aliquotaCIDE);
            h.put(VALOR_CIDE, aliquotaCIDE * quantidadeBCCide);
            h.put(BC_CIDE, baseCalculo);
        } else if (modeloFiscal.getTipoCalculoCide() != null && modeloFiscal.getTipoCalculoCide() == 0) {
            h.put(ALIQUOTA_CIDE, 0.0);
            h.put(VALOR_CIDE, 0.0);
            h.put(BC_CIDE, 0.0);
        } else {
            h.put(ALIQUOTA_CIDE, aliquotaCIDE);
            h.put(VALOR_CIDE, valorCIDE);
            h.put(BC_CIDE, baseCalculo);
        }
        h.put(VALOR_CIDE, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_CIDE)), (int)4));
        h.put(BC_CIDE, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_CIDE)), (int)4));
        return h;
    }

    public static HashMap valoresImpImportacao(ModeloFiscal modeloFiscal, Double aliquotaImpImportacao, Double valorImpostoEst, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ) {
        double bc = vrProdServ;
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (modeloFiscal != null && modeloFiscal.getTipoCalculoImpImportacao() != null && modeloFiscal.getTipoCalculoImpImportacao() == 1) {
            aliquotaImpImportacao = aliquotaImpImportacao == null ? 0.0 : aliquotaImpImportacao;
            h.put(ALIQUOTA_IMPOSTO_IMPORTACAO, aliquotaImpImportacao);
            h.put(VALOR_IMPOSTO_IMPORTACAO, aliquotaImpImportacao / 100.0 * bc);
            h.put(BC_IMPOSTO_IMPORTACAO, bc);
        } else if (modeloFiscal != null && modeloFiscal.getTipoCalculoImpImportacao() != null && modeloFiscal.getTipoCalculoImpImportacao() == 0) {
            h.put(ALIQUOTA_IMPOSTO_IMPORTACAO, 0.0);
            h.put(VALOR_IMPOSTO_IMPORTACAO, 0.0);
            h.put(BC_IMPOSTO_IMPORTACAO, 0.0);
        }
        h.put(VALOR_IMPOSTO_IMPORTACAO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(VALOR_IMPOSTO_IMPORTACAO)), (int)2));
        h.put(BC_IMPOSTO_IMPORTACAO, ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get(BC_IMPOSTO_IMPORTACAO)), (int)2));
        return h;
    }
}

