/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionCalculoPisCofins;

public class CalculoPisCofins {
    public static final String ALIQUOTA_PIS = "aliquotaPis";
    public static final String ALIQUOTA_COFINS = "aliquotaCofins";
    public static final String ALIQUOTA_PIS_ST = "aliquotaPisSt";
    public static final String ALIQUOTA_COFINS_ST = "aliquotaCofinsSt";
    public static final String VALOR_PIS = "valorPis";
    public static final String VALOR_PIS_ST = "valorPisSt";
    public static final String VALOR_COFINS = "valorCofins";
    public static final String VALOR_COFINS_ST = "valorCofinsSt";
    public static final String VALOR_BC_COFINS = "valorBCCofins";
    public static final String VALOR_BC_PIS = "valorBCPis";
    public static final String VALOR_BC_COFINS_ST = "valorBCCofinsSt";
    public static final String VALOR_BC_PIS_ST = "valorBCPisSt";
    public static final String ALIQUOTA_PIS_QTDE = "aliquotaPisQtde";
    public static final String ALIQUOTA_COFINS_QTDE = "aliquotaCofinsQtde";
    private final Short incluirSeguroBC;
    private final Short incluirFreteBC;
    private final Short incluirDespAcessBC;
    private final Short incluirDescontoBC;
    private final Double valorMinCofins;
    private final Double valorMinPis;
    private final Short incluirValorIcmsBC;
    private final Short incluirValorIcmsDesoneradoBC;
    private final Short incluirValorIcmsSemAproveitamento;
    private final Short incluirValorIpiObservacaoBC;

    public CalculoPisCofins(short incluirSeguroBC, short incluirFreteBC, short incluirDespAcessBC, short incluirDescontoBC, Double valorMinCofins, Double valorMinPis, short incluirValorIcms, short incluirValorIcmsDesonerado, short incluirValorIcmsSemAproveitamento, short incluirValorIpiObservacao) {
        this.incluirSeguroBC = incluirSeguroBC;
        this.incluirFreteBC = incluirFreteBC;
        this.incluirDespAcessBC = incluirDespAcessBC;
        this.incluirDescontoBC = incluirDescontoBC;
        this.valorMinCofins = valorMinCofins;
        this.valorMinPis = valorMinPis;
        this.incluirValorIcmsBC = incluirValorIcms;
        this.incluirValorIcmsDesoneradoBC = incluirValorIcmsDesonerado;
        this.incluirValorIcmsSemAproveitamento = incluirValorIcmsSemAproveitamento;
        this.incluirValorIpiObservacaoBC = incluirValorIpiObservacao;
    }

    public HashMap calculoPisCofins(Short calcularPisNormal, Short calcularPisSt, Short calcularCofinsNormal, Short calcularCofinsSt, IncidenciaPisCofins inc, Double aliquotaPis, Double aliquotaPisST, Double aliquotaCofins, Double aliquotaCofinsST, double valorFrete, double valorSeguro, double valorDespAcess, double valorDesconto, double vrProdServ, int modoArredondamento, Short tributadoPorQtde, Double qtdeTotal, Double aliquotaPisQtde, Double aliquotaCofinsQtde, Double valorIcms, Double valorIcmsDesonerado, Double valorIcmsSemAproveitamento, Double valorIpiObservacao) throws ExceptionCalculoPisCofins {
        double baseCalculo = this.getBC(vrProdServ, valorDesconto, valorDespAcess, valorFrete, valorSeguro, valorIcms, valorIcmsDesonerado, valorIcmsSemAproveitamento, valorIpiObservacao);
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put(VALOR_BC_COFINS, 0.0);
        h.put(VALOR_BC_COFINS_ST, 0.0);
        h.put(VALOR_BC_PIS, 0.0);
        h.put(VALOR_BC_PIS_ST, 0.0);
        h.put(VALOR_COFINS, 0.0);
        h.put(VALOR_COFINS_ST, 0.0);
        h.put(VALOR_PIS, 0.0);
        h.put(VALOR_PIS_ST, 0.0);
        h.put(ALIQUOTA_COFINS, 0.0);
        h.put(ALIQUOTA_PIS, 0.0);
        h.put(ALIQUOTA_COFINS_QTDE, 0.0);
        h.put(ALIQUOTA_PIS_QTDE, 0.0);
        this.calculoPisCofinsST(calcularPisSt, calcularCofinsSt, baseCalculo, aliquotaPisST, aliquotaCofinsST, h);
        this.calculoPisCofinsNormal(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h, inc, tributadoPorQtde, qtdeTotal, aliquotaPisQtde, aliquotaCofinsQtde);
        h.put(ALIQUOTA_PIS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_PIS)), (int)4));
        h.put(ALIQUOTA_COFINS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_COFINS)), (int)4));
        h.put(ALIQUOTA_PIS_ST, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_PIS_ST)), (int)4));
        h.put(ALIQUOTA_COFINS_ST, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_COFINS_ST)), (int)4));
        Double valorPis = (Double)h.get(VALOR_PIS);
        if (this.valorMinPis != null && valorPis < this.valorMinPis) {
            valorPis = 0.0;
        }
        h.put(VALOR_PIS, ToolFormatter.arrredondarNumero((Double)valorPis, (int)2, (int)modoArredondamento));
        valorPis = (Double)h.get(VALOR_PIS_ST);
        if (this.valorMinPis != null && valorPis < this.valorMinPis) {
            valorPis = 0.0;
        }
        h.put(VALOR_PIS_ST, ToolFormatter.arrredondarNumero((Double)valorPis, (int)2, (int)modoArredondamento));
        Double valorCofins = (Double)h.get(VALOR_COFINS);
        if (this.valorMinCofins != null && valorCofins < this.valorMinCofins) {
            valorCofins = 0.0;
        }
        h.put(VALOR_COFINS, ToolFormatter.arrredondarNumero((Double)valorCofins, (int)2, (int)modoArredondamento));
        valorCofins = (Double)h.get(VALOR_COFINS_ST);
        if (this.valorMinCofins != null && valorCofins < this.valorMinCofins) {
            valorCofins = 0.0;
        }
        h.put(VALOR_COFINS_ST, ToolFormatter.arrredondarNumero((Double)valorCofins, (int)2, (int)modoArredondamento));
        h.put(VALOR_BC_COFINS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(VALOR_BC_COFINS)), (int)2, (int)modoArredondamento));
        h.put(VALOR_BC_PIS, ToolFormatter.arrredondarNumero((Double)((Double)h.get(VALOR_BC_PIS)), (int)2, (int)modoArredondamento));
        h.put(ALIQUOTA_PIS_QTDE, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_PIS_QTDE)), (int)4, (int)modoArredondamento));
        h.put(ALIQUOTA_COFINS_QTDE, ToolFormatter.arrredondarNumero((Double)((Double)h.get(ALIQUOTA_COFINS_QTDE)), (int)4, (int)modoArredondamento));
        return h;
    }

    private void calculoPisCofinsTrib(Short calcularPisNormal, Short calcularCofinsNormal, Double baseCalculo, Double aliquotaPis, Double aliquotaCofins, HashMap h) {
        if (calcularCofinsNormal == 1) {
            if (aliquotaCofins == null) {
                aliquotaCofins = 0.0;
            }
            double vrCofins = baseCalculo * (aliquotaCofins / 100.0);
            h.put(VALOR_COFINS, vrCofins);
            h.put(ALIQUOTA_COFINS, aliquotaCofins);
            h.put(VALOR_BC_COFINS, baseCalculo);
        }
        if (calcularPisNormal == 1) {
            if (aliquotaPis == null) {
                aliquotaPis = 0.0;
            }
            double vrPis = baseCalculo * (aliquotaPis / 100.0);
            h.put(VALOR_PIS, vrPis);
            h.put(ALIQUOTA_PIS, aliquotaPis);
            h.put(VALOR_BC_PIS, baseCalculo);
        }
    }

    private void calculoPisCofins03(Short calcularPisNormal, Short calcularCofinsNormal, Double baseCalculo, Double aliquotaPisQtde, Double aliquotaCofinsQtde, HashMap h, Short tributadoPorQtde, Double qtdeTotal) throws ExceptionCalculoPisCofins {
        if (calcularCofinsNormal == 1) {
            if (tributadoPorQtde.equals((short)0)) {
                throw new ExceptionCalculoPisCofins("Para incid\u00eancia Pis/Cofins 03, no cadastro do produto deve est\u00e1 marcado a op\u00e7\u00e3o Tributado por Quantidade!");
            }
            if (aliquotaCofinsQtde == null) {
                aliquotaCofinsQtde = 0.0;
            }
            h.put(VALOR_COFINS, qtdeTotal * aliquotaCofinsQtde);
            h.put(ALIQUOTA_COFINS_QTDE, aliquotaCofinsQtde);
            h.put(VALOR_BC_COFINS, 0.0);
        }
        if (calcularPisNormal == 1) {
            if (aliquotaPisQtde == null) {
                aliquotaPisQtde = 0.0;
            }
            h.put(VALOR_PIS, qtdeTotal * aliquotaPisQtde);
            h.put(ALIQUOTA_PIS_QTDE, aliquotaPisQtde);
            h.put(VALOR_BC_PIS, 0.0);
        }
    }

    private void calculoPisCofinsNormal(Short calcularPisNormal, Short calcularCofinsNormal, Double baseCalculo, Double aliquotaPis, Double aliquotaCofins, HashMap h, IncidenciaPisCofins inc, Short tributadoPorQtde, Double qtdeTotal, Double aliquotaPisQtde, Double aliquotaCofinsQtde) throws ExceptionCalculoPisCofins {
        switch (Integer.valueOf(inc.getCodigo())) {
            case 1: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 2: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 3: {
                this.calculoPisCofins03(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPisQtde, aliquotaCofinsQtde, h, tributadoPorQtde, qtdeTotal);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 49: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 50: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 51: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 52: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 53: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 54: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 55: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 56: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 60: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 61: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 62: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 63: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 64: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 65: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 66: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 67: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 70: {
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                break;
            }
            case 73: {
                break;
            }
            case 74: {
                break;
            }
            case 75: {
                break;
            }
            case 98: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            case 99: {
                this.calculoPisCofinsTrib(calcularPisNormal, calcularCofinsNormal, baseCalculo, aliquotaPis, aliquotaCofins, h);
                break;
            }
            default: {
                throw new ExceptionCalculoPisCofins("O sistema n\u00e3o contempla este tipo de Pis/Cofins.");
            }
        }
    }

    private void calculoPisCofinsST(Short calcularPisST, Short calcularCofinsST, double baseCalculo, Double aliquotaPisST, Double aliquotaCofinsST, HashMap h) {
        if (calcularCofinsST != null && calcularCofinsST == 1) {
            if (aliquotaCofinsST == null) {
                aliquotaCofinsST = 0.0;
            }
            double vrCofinsSt = baseCalculo * (aliquotaCofinsST / 100.0);
            h.put(VALOR_COFINS, 0.0);
            h.put(VALOR_COFINS_ST, vrCofinsSt);
            h.put(ALIQUOTA_COFINS_ST, aliquotaCofinsST);
            h.put(VALOR_BC_COFINS_ST, baseCalculo);
        }
        if (calcularPisST != null && calcularPisST == 1) {
            if (aliquotaPisST == null) {
                aliquotaPisST = 0.0;
            }
            double vrPisSt = baseCalculo * (aliquotaPisST / 100.0);
            h.put(VALOR_PIS, 0.0);
            h.put(VALOR_PIS_ST, vrPisSt);
            h.put(ALIQUOTA_PIS_ST, aliquotaPisST);
            h.put(VALOR_BC_PIS_ST, baseCalculo);
        }
    }

    private double getBC(double vrProdServ, double valorDesconto, double valorDespAcess, double valorFrete, double valorSeguro, double valorIcms, double valorIcmsDesonerado, double valorIcmsSemAproveitamento, double valorIpiObservacao) {
        double bc = vrProdServ;
        if (this.incluirDescontoBC == null || this.incluirDescontoBC == 1) {
            bc -= valorDesconto;
        }
        if (this.incluirDespAcessBC == null || this.incluirDespAcessBC == 1) {
            bc += valorDespAcess;
        }
        if (this.incluirFreteBC == null || this.incluirFreteBC == 1) {
            bc += valorFrete;
        }
        if (this.incluirSeguroBC == null || this.incluirSeguroBC == 1) {
            bc += valorSeguro;
        }
        if (this.incluirValorIcmsBC != null && this.incluirValorIcmsBC == 1) {
            bc -= valorIcms;
        }
        if (this.incluirValorIcmsDesoneradoBC != null && this.incluirValorIcmsDesoneradoBC == 1) {
            bc -= valorIcmsDesonerado;
        }
        if (this.incluirValorIcmsSemAproveitamento != null && this.incluirValorIcmsSemAproveitamento == 1) {
            bc -= valorIcmsSemAproveitamento;
        }
        if (this.incluirValorIpiObservacaoBC != null && this.incluirValorIpiObservacaoBC == 1) {
            bc += valorIpiObservacao;
        }
        return bc;
    }
}

