/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendas;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculoICMSSaiUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoIPISaiUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

public class CalculosImpFiscaisCotacaoVendas {
    private static final TLogger logger = TLogger.get(CalculosImpFiscaisCotacaoVendas.class);

    public static List calcularImpostosFiscaisItemCotacaoVendas(List itensCotacao, UnidadeFederativa uf, Empresa emp, Short tipoCalcST, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, Short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionCalculoPisCofins, ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        for (Object o : itensCotacao) {
            ItemCotacaoVendas i = (ItemCotacaoVendas)o;
            CalculosImpFiscaisCotacaoVendas.calcularImpostosFiscaisItemCotacaoVendas(i, uf, emp, tipoCalcST, cnaeCliente, contribuinteEstado, usarCategoriaST, consumidorFinal, empresaContabilidade, unidadeFatCliente, versaoNFe, opcoesFaturamento);
        }
        return itensCotacao;
    }

    public static void calcularImpostosFiscaisItemCotacaoVendas(ItemCotacaoVendas item, UnidadeFederativa ufEmpresa, Empresa emp, Short tipoCalcST, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, Short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        if (item.getModeloFiscal() != null) {
            double vlrTotal = item.getValorUnitario() * item.getQuantidadeTotal();
            CalculosImpFiscaisCotacaoVendas.calcularIPI(vlrTotal, item, emp);
            CalculosImpFiscaisCotacaoVendas.calcularIcms(vlrTotal, item, ufEmpresa, emp, tipoCalcST, cnaeCliente, contribuinteEstado, usarCategoriaST, consumidorFinal, empresaContabilidade, unidadeFatCliente, versaoNFe, opcoesFaturamento);
            CalculosImpFiscaisCotacaoVendas.calcularPisCofins(vlrTotal, item);
            CalculosImpFiscaisCotacaoVendas.calcularOutrosImpostos(vlrTotal, item);
        }
        CalculosImpFiscaisCotacaoVendas.calcularValorTotalComImpostos(item);
    }

    private static void calcularIcms(double vlrTotal, ItemCotacaoVendas item, UnidadeFederativa ufCliente, Empresa empresa, short tipoCalcSt, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        CalculosImpFiscaisCotacaoVendas.procurarAliquotaICMS(item, ufCliente, empresa);
        item.getItemCotacaoVendasFiscal().setIncidenciaIcms(item.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        item.getItemCotacaoVendasFiscal().setModalidadeIcms(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        item.getItemCotacaoVendasFiscal().setModalidadeIcmsSt(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
        Date dataEmissao = item.getCotacaoVendas() != null ? item.getCotacaoVendas().getDataEmissao() : new Date();
        HashMap h = new CalculoICMSSaiUtilities(item.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiDesconto(), tipoCalcSt, empresa, cnaeCliente, contribuinteEstado, item.getModeloFiscal().getModeloFiscalIcms().getIncluiSeguroST(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiFreteST(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiDespAcessST(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiDescontoST(), item.getModeloFiscal().getModeloFiscalIcms().getIncluiIPIST(), usarCategoriaST, dataEmissao, versaoNFe, opcoesFaturamento).valoresIcmsIcmsST(item.getModeloFiscal().getModeloFiscalIcms(), item.getModeloFiscal().getModeloFiscalIpi(), 0.0, item.getItemCotacaoVendasFiscal() != null ? item.getItemCotacaoVendasFiscal().getVrPis() : 0.0, item.getItemCotacaoVendasFiscal() != null ? item.getItemCotacaoVendasFiscal().getVrCofins() : 0.0, item.getItemCotacaoVendasFiscal().getVrIpiIndustria(), item.getItemCotacaoVendasFiscal().getVrIpiObservacao(), item.getItemCotacaoVendasFiscal().getAliquotaIcms(), item.getItemCotacaoVendasFiscal().getPercReducaoBCIcms(), 0.0, item.getProduto(), item.getQuantidadeTotal(), ufCliente, item.getItemCotacaoVendasFiscal().getAliquotaICMSSimples(), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), vlrTotal, consumidorFinal, contribuinteEstado, empresaContabilidade, unidadeFatCliente, item.getModeloFiscal().getTipoCfop(), 0.0);
        item.getItemCotacaoVendasFiscal().setVrBcCalculoIcmsSt((Double)h.get("bcIcmsST"));
        item.getItemCotacaoVendasFiscal().setVrBcCalculoIcms((Double)h.get("bcIcms"));
        item.getItemCotacaoVendasFiscal().setVrIcmsSt((Double)h.get("valorIcmsSt"));
        item.getItemCotacaoVendasFiscal().setVrIcms((Double)h.get("valorIcms"));
        item.getItemCotacaoVendasFiscal().setAliquotaICMSSimples((Double)h.get("aliquotaICMSSimples"));
        item.getItemCotacaoVendasFiscal().setValorICMSSimples((Double)h.get("valorIcmsSimples"));
        item.getItemCotacaoVendasFiscal().setVrIcmsIsento((Double)h.get("icmsIsento"));
        item.getItemCotacaoVendasFiscal().setVrIcmsOutros((Double)h.get("icmsOutros"));
        item.getItemCotacaoVendasFiscal().setVrIcmsTributado((Double)h.get("icmsTributado"));
        item.getItemCotacaoVendasFiscal().setVrIcmsSemAprov((Double)h.get("icmsSemAprov"));
        item.getItemCotacaoVendasFiscal().setVrICMSDispensado((Double)h.get("valorIcmsDesonerado"));
        item.getItemCotacaoVendasFiscal().setDescontoPadraoIcmsST((Double)h.get("descontoPadraoST"));
        item.getItemCotacaoVendasFiscal().setIndiceAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
        item.getItemCotacaoVendasFiscal().setAliquotaIcmsST((Double)h.get("aliquotaSt"));
        item.getItemCotacaoVendasFiscal().setAliquotaIcms((Double)h.get("aliquotaICMS"));
        item.getItemCotacaoVendasFiscal().setValorFCP((Double)h.get("valorFCP"));
        item.getItemCotacaoVendasFiscal().setValorFCPSt((Double)h.get("valorFCPSt"));
        item.getItemCotacaoVendasFiscal().setValorFCPStRetido((Double)h.get("valorFCPStRetido"));
        item.getItemCotacaoVendasFiscal().setValorBCFCP((Double)h.get("valorBCFCP"));
        item.getItemCotacaoVendasFiscal().setValorBCFCPSt((Double)h.get("valorBCFCPSt"));
        item.getItemCotacaoVendasFiscal().setValorBCFCPStRetido((Double)h.get("valorBCFCPStRetido"));
        item.getItemCotacaoVendasFiscal().setAliquotaFCP((Double)h.get("aliquotaFCP"));
        item.getItemCotacaoVendasFiscal().setAliquotaFCPSt((Double)h.get("aliquotaFCPSt"));
        item.getItemCotacaoVendasFiscal().setAliquotaFCPStRetido((Double)h.get("aliquotaFCPStRetido"));
        item.getItemCotacaoVendasFiscal().setPercentualDiferimento((Double)h.get("percentualDiferimento"));
        item.getItemCotacaoVendasFiscal().setValorIcmsDiferimento((Double)h.get("valorIcmsDiferimento"));
        if (h.get("valorBcIcmsUfDest") != null) {
            item.getItemCotacaoVendasFiscal().setValorBcIcmsUfDest((Double)h.get("valorBcIcmsUfDest"));
        } else {
            item.getItemCotacaoVendasFiscal().setValorBcIcmsUfDest(Double.valueOf(0.0));
        }
        if (h.get("valorIcmsPartilhaRem") != null) {
            item.getItemCotacaoVendasFiscal().setValorIcmsPartilhaRem(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaRem")), (int)2));
        } else {
            item.getItemCotacaoVendasFiscal().setValorIcmsPartilhaRem(Double.valueOf(0.0));
        }
        if (h.get("valorIcmsPartilhaDest") != null) {
            item.getItemCotacaoVendasFiscal().setValorIcmsPartilhaDest(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaDest")), (int)2));
        } else {
            item.getItemCotacaoVendasFiscal().setValorIcmsPartilhaDest(Double.valueOf(0.0));
        }
        if (h.get("aliquotaInternaUFDest") != null) {
            item.getItemCotacaoVendasFiscal().setAliquotaInternaUFDest((Double)h.get("aliquotaInternaUFDest"));
        } else {
            item.getItemCotacaoVendasFiscal().setAliquotaInternaUFDest(Double.valueOf(0.0));
        }
        if (h.get("aliquotaInterestadual") != null) {
            item.getItemCotacaoVendasFiscal().setAliquotaInterestadual((Double)h.get("aliquotaInterestadual"));
        } else {
            item.getItemCotacaoVendasFiscal().setAliquotaInterestadual(Double.valueOf(0.0));
        }
        if (h.get("percPartilhaIcms") != null) {
            item.getItemCotacaoVendasFiscal().setPercPartilhaIcms((Double)h.get("percPartilhaIcms"));
        } else {
            item.getItemCotacaoVendasFiscal().setPercPartilhaIcms(Double.valueOf(0.0));
        }
        if (h.get("aliquotaFundoPobreza") != null) {
            item.getItemCotacaoVendasFiscal().setAliquotaFundoPobreza((Double)h.get("aliquotaFundoPobreza"));
        } else {
            item.getItemCotacaoVendasFiscal().setAliquotaFundoPobreza(Double.valueOf(0.0));
        }
        if (h.get("valorFundoPobreza") != null) {
            item.getItemCotacaoVendasFiscal().setValorFundoPobreza(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorFundoPobreza")), (int)2));
        } else {
            item.getItemCotacaoVendasFiscal().setValorFundoPobreza(Double.valueOf(0.0));
        }
    }

    private static void procurarAliquotaICMS(ItemCotacaoVendas item, UnidadeFederativa ufCliente, Empresa empresa) throws ExceptionService {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        Double aliquotaIcmsSimples = empresa.getEmpresaDados().getAliquotaICMSSimples();
        if (aliquotaIcmsSimples == null) {
            aliquotaIcmsSimples = 0.0;
        }
        try {
            double alICMS = 0.0;
            alICMS = modeloFiscal.getModeloFiscalIcms().getTipoAliquotaIcms() == 2 ? modeloFiscal.getModeloFiscalIcms().getAliquotaIcms().doubleValue() : CalculosImpFiscaisCotacaoVendas.getAliquotaICMS(empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente, item.getProduto()).doubleValue();
            item.getItemCotacaoVendasFiscal().setAliquotaIcms(Double.valueOf(alICMS));
        }
        catch (ExceptionService ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao procurar a al\u00edquota de ICMS.", ex);
        }
    }

    private static void calcularIPI(double vlrTotal, ItemCotacaoVendas item, Empresa emp) throws ExceptionCalculoIPI {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        item.getItemCotacaoVendasFiscal().setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
        Produto produto = item.getProduto();
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)produto, (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
        item.getItemCotacaoVendasFiscal().setAliquotaIpi(aliquotaIpi);
        HashMap h = new CalculoIPISaiUtilities(item.getModeloFiscal().getModeloFiscalIpi().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDesconto()).calcularIpi(item.getModeloFiscal().getModeloFiscalIpi(), produto, item.getItemCotacaoVendasFiscal().getAliquotaIpi(), item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), vlrTotal, 0.0, emp);
        item.getItemCotacaoVendasFiscal().setVrIpiTributado((Double)h.get("ipiTributado"));
        item.getItemCotacaoVendasFiscal().setVrIpiIndustria((Double)h.get("ipiIndustria"));
        item.getItemCotacaoVendasFiscal().setVrIpiIsento((Double)h.get("ipiIsento"));
        item.getItemCotacaoVendasFiscal().setVrIpiOutros((Double)h.get("ipiOutros"));
    }

    private static void calcularPisCofins(double vlrTotal, ItemCotacaoVendas item) throws ExceptionCalculoPisCofins {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        item.getItemCotacaoVendasFiscal().setIncidenciaPisCofins(modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        Produto produto = item.getProduto();
        Short pisCofinsTribQtde = produto.getPisCofinsTributadoQuantidade();
        Double aliquotaPis = 0.0;
        Double aliquotaPisSt = 0.0;
        Double aliquotaCofins = 0.0;
        Double aliquotaCofinsSt = 0.0;
        aliquotaPis = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis() : item.getProduto().getAliquotaPis()) : Double.valueOf(0.0);
        aliquotaPisSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt() : item.getProduto().getAliquotaPisSt()) : Double.valueOf(0.0);
        aliquotaCofins = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins() : item.getProduto().getAliquotaCofins()) : Double.valueOf(0.0);
        aliquotaCofinsSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt() : item.getProduto().getAliquotaCofinsSt()) : Double.valueOf(0.0);
        HashMap h = new CalculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()).calculoPisCofins(modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal(), modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt(), modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal(), modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt(), modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins(), aliquotaPis, aliquotaPisSt, aliquotaCofins, aliquotaCofinsSt, item.getValorFrete(), item.getValorSeguro(), item.getValorDespesaAcessoria(), item.getValorDesconto(), vlrTotal, 4, pisCofinsTribQtde, 0.0, 0.0, 0.0, item.getItemCotacaoVendasFiscal().getVrIcms(), item.getItemCotacaoVendasFiscal().getVrICMSDispensado(), item.getItemCotacaoVendasFiscal().getVrIcmsSemAprov(), item.getItemCotacaoVendasFiscal().getVrIpiObservacao());
        item.getItemCotacaoVendasFiscal().setAliquotaCofins((Double)h.get("aliquotaCofins"));
        item.getItemCotacaoVendasFiscal().setVrCofins((Double)h.get("valorCofins"));
        item.getItemCotacaoVendasFiscal().setVrCofinsSt((Double)h.get("valorCofinsSt"));
        item.getItemCotacaoVendasFiscal().setVrBCCofins((Double)h.get("valorBCCofins"));
        item.getItemCotacaoVendasFiscal().setAliquotaPis((Double)h.get("aliquotaPis"));
        item.getItemCotacaoVendasFiscal().setVrPisSt((Double)h.get("valorPisSt"));
        item.getItemCotacaoVendasFiscal().setVrPis((Double)h.get("valorPis"));
        item.getItemCotacaoVendasFiscal().setVrBCPis((Double)h.get("valorBCPis"));
    }

    private static void calcularOutrosImpostos(double vlrTotal, ItemCotacaoVendas item) {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        Produto produto = item.getProduto();
        HashMap h = CalculoOutrosImpostos.calculoContSoc(modeloFiscal.getTipoContSoc(), produto.getAliquotaContSoc(), produto.getPercRedContSoc(), modeloFiscal.getValorMinimoCSLL(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setPercRedContSoc((Double)h.get("percRedContSoc"));
        item.getItemCotacaoVendasFiscal().setVrContSoc((Double)h.get("valorContSoc"));
        item.getItemCotacaoVendasFiscal().setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
        h = CalculoOutrosImpostos.calculoFunrural(modeloFiscal, produto.getAliquotaFunrural(), produto.getPercRedFunrural(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        item.getItemCotacaoVendasFiscal().setPercRedFunrural((Double)h.get("percRedFunrural"));
        item.getItemCotacaoVendasFiscal().setVrFunrural((Double)h.get("valorFunrural"));
        h = CalculoOutrosImpostos.calculoINSS(modeloFiscal.getTipoINSS(), produto.getAliquotaInss(), produto.getPercRedBCINSS(), 0.0, 0.0, modeloFiscal.getValorMinimoInss(), 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setVrInss((Double)h.get("valorInss"));
        item.getItemCotacaoVendasFiscal().setPercRedBcInss((Double)h.get("percRedInss"));
        item.getItemCotacaoVendasFiscal().setAliquotaInss((Double)h.get("aliquotaInss"));
        h = CalculoOutrosImpostos.calculoIRRF(modeloFiscal.getTipoIRRF(), produto.getAliquotaIrrf(), produto.getPercRedIrrf(), 0.0, modeloFiscal.getValorMinimoIR(), 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        item.getItemCotacaoVendasFiscal().setVrIrrf((Double)h.get("valorIrrf"));
        item.getItemCotacaoVendasFiscal().setPercRedFunrural((Double)h.get("percRedIRRF"));
        h = CalculoOutrosImpostos.calculoISS(modeloFiscal.getIssRetido(), item.getItemCotacaoVendasFiscal().getAliquotaIss(), 0.0, item.getItemCotacaoVendasFiscal().getVrIss(), modeloFiscal.getValorMinimoISS(), 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setAliquotaIss((Double)h.get("aliquotaIss"));
        item.getItemCotacaoVendasFiscal().setVrIss((Double)h.get("valorIss"));
        h = CalculoOutrosImpostos.calculoLei10833(modeloFiscal, produto.getAliquotaLei10833(), produto.getPercRedLei10833(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setPercRedLei10833((Double)h.get("percRedLei10833"));
        item.getItemCotacaoVendasFiscal().setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        item.getItemCotacaoVendasFiscal().setVrLei10833((Double)h.get("valorLei10833"));
        h = CalculoOutrosImpostos.calculoOutros(modeloFiscal.getTipoOutros(), produto.getAliquotaOutros(), produto.getPercRedOutros(), 0.0, modeloFiscal.getValorMinimoOutros(), 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)6);
        item.getItemCotacaoVendasFiscal().setAliquotaOutros((Double)h.get("aliquotaOutros"));
        item.getItemCotacaoVendasFiscal().setPercRedOutros((Double)h.get("percRedOutros"));
        item.getItemCotacaoVendasFiscal().setVrOutros((Double)h.get("valorOutros"));
    }

    public static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws ExceptionService {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return CalculosImpFiscaisCotacaoVendas.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws ExceptionService {
        CoreRequestContext h = new CoreRequestContext();
        h.setAttribute("ufOrigem", ufOrigem);
        h.setAttribute("ufDestino", ufDestino);
        UnidadeFederativaOrigDest found = (UnidadeFederativaOrigDest)CoreServiceFactory.getServiceUF().execute(h, "findAliquotaIcmsInterUF");
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private static void calcularValorTotalComImpostos(ItemCotacaoVendas item) {
        Double valorTotalComImpostos = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria() + item.getItemCotacaoVendasFiscal().getVrIpiIndustria() + item.getItemCotacaoVendasFiscal().getVrIcmsSt() + item.getItemCotacaoVendasFiscal().getVrFunrural() + item.getItemCotacaoVendasFiscal().getVrLei10833() + item.getItemCotacaoVendasFiscal().getVrIrrf() + item.getItemCotacaoVendasFiscal().getVrOutros() + item.getItemCotacaoVendasFiscal().getVrDevICMSST() + item.getItemCotacaoVendasFiscal().getValorFCPSt();
        if (item.getModeloFiscal() != null && item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
            valorTotalComImpostos = valorTotalComImpostos - item.getItemCotacaoVendasFiscal().getVrICMSDispensado();
        }
        item.setValorTotalComImpostos(ContatoFormatUtil.arrredondarNumero((Double)valorTotalComImpostos, (int)2));
    }
}

