/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.constants.enums.impostos.rat.EnumConstTipoCalcRat;
import com.touchcomp.basementor.constants.enums.impostos.senar.EnumConstTipoCalcSenar;
import com.touchcomp.basementor.constants.enums.impostos.taxasanidanimal.EnumConstCalcTipoTaxaSanidAnimal;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancCtoItemNota;
import com.touchcomp.basementor.model.vo.LancCtoSaidaItemNota;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.impostos.rat.CompImpostoRat;
import com.touchcomp.basementorrules.impostos.rat.model.RatCalculado;
import com.touchcomp.basementorrules.impostos.rat.model.RatParams;
import com.touchcomp.basementorrules.impostos.senar.CompImpostoSenar;
import com.touchcomp.basementorrules.impostos.senar.model.SenarCalculado;
import com.touchcomp.basementorrules.impostos.senar.model.SenarParams;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.CompImpostoTaxaSanidadeAnimal;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.model.TaxaSanidAnimalCalculado;
import com.touchcomp.basementorrules.impostos.taxasanidadeanimal.model.TaxaSanidAnimalParams;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.calculoimpostos.CalculoICMSEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoIPIEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

public class CalculosImpFiscaisNotaTerceiros {
    private static Double LIMITE_AJUSTE_PADRAO = 0.02;

    public static List calcularImpostosFiscaisItNotaTerceiros(Date dataEntradaSaida, List<ItemNotaTerceiros> itensNota, UnidadeFatFornecedor fornecedor, UnidadeFederativa ufPrestacao, UnidadeFederativa ufEmpresa, Double valorFrete, Double valorFreteCtrc, Double valorSeguro, Double valorDesconto, Double valorDespAcessorias, Double valorAgregado, Double valorIcmsInf, Double valorIpiInf, Double valorTotalInf, boolean naoRatearDespAcessorias, boolean naoRatearFrete, boolean naoRatearSeguro, boolean naoRatearDesconto, boolean naoRatearVlrAgregado, EmpresaContabilidade empresaContabilidade, OpcoesCompraSuprimentos opcoes, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins {
        ItemNotaTerceiros item;
        ItemNotaTerceiros o;
        Double valorTotal = 0.0;
        Double valorCalcAgregado = 0.0;
        Iterator<ItemNotaTerceiros> iterator = itensNota.iterator();
        while (iterator.hasNext()) {
            item = o = iterator.next();
            valorTotal = valorTotal + (item.getVrServico() + item.getVrProduto());
            if (item.getInformarValorAgregado() != null && !item.getInformarValorAgregado().equals((short)0)) continue;
            valorCalcAgregado = valorCalcAgregado + (item.getVrServico() + item.getVrProduto());
        }
        if (valorCalcAgregado == 0.0 && valorAgregado > 0.0) {
            throw new ExceptionService("Nenhum item encontrado para ser rateado o valor agregado!");
        }
        CalculosImpFiscaisNotaTerceiros.ratearDesconto(itensNota, valorDesconto, naoRatearDesconto);
        CalculosImpFiscaisNotaTerceiros.ratearFrete(itensNota, valorFrete, naoRatearFrete);
        CalculosImpFiscaisNotaTerceiros.ratearSeguro(itensNota, valorSeguro, naoRatearSeguro);
        CalculosImpFiscaisNotaTerceiros.ratearDespAcess(itensNota, valorDespAcessorias, naoRatearDespAcessorias);
        CalculosImpFiscaisNotaTerceiros.ratearOutrosValores(itensNota, valorTotal, valorAgregado, naoRatearVlrAgregado, valorCalcAgregado);
        CalculosImpFiscaisNotaTerceiros.ratearFreteCTRC(itensNota, valorFreteCtrc);
        CalculosImpFiscaisNotaTerceiros.ajustarValoresAcessorios(itensNota, valorDesconto, valorDespAcessorias, valorFrete, valorSeguro, valorAgregado, valorFreteCtrc, naoRatearDespAcessorias, naoRatearFrete, naoRatearSeguro, naoRatearDesconto, naoRatearVlrAgregado);
        iterator = itensNota.iterator();
        while (iterator.hasNext()) {
            item = o = iterator.next();
            CalculosImpFiscaisNotaTerceiros.calcularImpostosFiscaisItTerceiros(dataEntradaSaida, item, fornecedor, ufPrestacao, ufEmpresa, valorFrete, valorFreteCtrc, valorSeguro, valorDesconto, valorDespAcessorias, valorAgregado, valorTotal, false, naoRatearDespAcessorias, naoRatearFrete, naoRatearSeguro, naoRatearDesconto, naoRatearVlrAgregado, empresaContabilidade, opImpostos);
        }
        CalculosImpFiscaisNotaTerceiros.ajustarDiferencas(itensNota, valorIcmsInf, valorIpiInf, valorTotalInf, opcoes);
        return itensNota;
    }

    public static void calcularImpostosFiscaisItTerceiros(Date dataEntradaSaida, ItemNotaTerceiros item, UnidadeFatFornecedor fornecedor, UnidadeFederativa ufPrestacao, UnidadeFederativa ufEmpresa, Double valorFrete, Double valorFreteCtrc, Double valorSeguro, Double valorDesconto, Double valorDespAcessorias, Double valorAgregado, Double valorTotal, boolean naoRatearDespAcessorias, boolean naoRatearFrete, boolean naoRatearSeguro, boolean naoRatearDesconto, boolean naoRatearVlrAgregado, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins {
        CalculosImpFiscaisNotaTerceiros.calcularImpostosFiscaisItTerceiros(dataEntradaSaida, item, fornecedor, ufPrestacao, ufEmpresa, valorFrete, valorFreteCtrc, valorSeguro, valorDesconto, valorDespAcessorias, valorAgregado, valorTotal, true, naoRatearDespAcessorias, naoRatearFrete, naoRatearSeguro, naoRatearDesconto, naoRatearVlrAgregado, empresaContabilidade, opImpostos);
    }

    public static void calcularImpostosFiscaisItTerceiros(Date dataEntradaSaida, ItemNotaTerceiros item, UnidadeFatFornecedor fornecedor, UnidadeFederativa ufPrestacao, UnidadeFederativa ufEmpresa, Double valorFrete, Double valorFreteCtrc, Double valorSeguro, Double valorDesconto, Double valorDespAcessorias, Double valorAgregado, Double valorTotal, boolean calcVlrAcessorios, boolean naoRatearDespAcessorias, boolean naoRatearFrete, boolean naoRatearSeguro, boolean naoRatearDesconto, boolean naoRatearVlrAgregado, EmpresaContabilidade empresaContabilidade, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins {
        Produto produto = item.getProduto();
        if (item.getItemNotaLivroFiscal() == null) {
            item.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
        }
        if (item.getModeloFiscal() == null) {
            throw new ExceptionService("Item " + String.valueOf(item.getProduto()) + " sem modelo fiscal.");
        }
        if (item.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms() == null) {
            throw new ExceptionService("Item " + String.valueOf(item.getProduto()) + " sem incidencia icms no modelo fiscal " + item.getModeloFiscal().getDescricao());
        }
        ItemNotaLivroFiscal itLF = item.getItemNotaLivroFiscal();
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        double qtdTotal = item.getQuantidadeTotal();
        valorTotal = valorTotal == 0.0 ? 1.0 : valorTotal;
        if (item.getInformarValorAgregado() == null || item.getInformarValorAgregado().equals((short)0)) {
            if (item.getPercValorAgregado() != null) {
                item.setValorAgregado(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercValorAgregado() / 100.0 * item.getVrProduto()), (int)2));
            } else {
                item.setValorAgregado(Double.valueOf(0.0));
            }
        }
        if (produto.getTipoProduto() == 1) {
            if (item.getVrServico() > 0.0 && qtdTotal > 0.0) {
                item.setValorUnitario(Double.valueOf(item.getVrServico() / qtdTotal));
                item.setVrProduto(Double.valueOf(0.0));
            } else {
                item.setValorUnitario(Double.valueOf(0.0));
            }
        } else {
            if (item.getVrProduto() > 0.0 && qtdTotal > 0.0) {
                item.setValorUnitario(Double.valueOf(item.getVrProduto() / qtdTotal));
            } else {
                item.setValorUnitario(Double.valueOf(0.0));
            }
            item.setVrServico(Double.valueOf(0.0));
        }
        CalculosImpFiscaisNotaTerceiros.valoresIpiItemNotaPropria(modeloFiscal.getModeloFiscalIpi(), item, produto, fornecedor, item.getModoArredondamento());
        CalculosImpFiscaisNotaTerceiros.valoresIcmsIcmsSTItemNotaTerceiros(modeloFiscal, item, produto, ufEmpresa, fornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf(), item.getModoArredondamento(), empresaContabilidade);
        CalculosImpFiscaisNotaTerceiros.calculoOutrosImpostos(itLF, item, item.getModoArredondamento().shortValue());
        Double valor = item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIpiIndustria() + itLF.getVrIpiObservacao() + itLF.getVrIcmsSt();
        if (item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
            valor = valor - itLF.getVrIcmsDesonerado();
        }
        if (itLF.getValorStCustoCompTotNota() != null && itLF.getValorStCustoCompTotNota() == 1) {
            valor = valor + itLF.getVrCustoICMSST();
        }
        if (itLF.getValorFCPSt() != null) {
            valor = valor + itLF.getValorFCPSt();
        }
        itLF.setValorTotal(ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2, (int)item.getModoArredondamento().shortValue()));
        if (item.getProduto().getTipoProduto() == 0) {
            CalculosImpFiscaisNotaTerceiros.calcularDiferencaAliquota(item.getModeloFiscal(), ufPrestacao, ufEmpresa, item);
        }
        CalculosImpFiscaisNotaTerceiros.atualizarGrades(dataEntradaSaida, item, itLF, item.getGrade(), modeloFiscal);
        CalculosImpFiscaisNotaTerceiros.atualizarPrecoLancCto(item);
        CalculosImpFiscaisNotaTerceiros.atualizarValorCompra(item);
        try {
            CalculosImpFiscaisNotaTerceiros.atualizarValorTransf(item, opImpostos);
        }
        catch (Exception ex) {
            TLogger.get(CalculosImpFiscaisNotaTerceiros.class).error((Throwable)ex);
            throw new ExceptionService(ex);
        }
    }

    private static void atualizarGrades(Date dataEntrada, ItemNotaTerceiros item, ItemNotaLivroFiscal itLF, List grades, ModeloFiscal modeloFiscal) throws ExceptionService {
        if (!(item.getInfVrCustoManual() != null && item.getInfVrCustoManual() == 1 || itLF.getCfop() != null && itLF.getCfop().getCfopDevolucaoVenda() != null && itLF.getCfop().getCfopDevolucaoVenda() == 1)) {
            for (Object o : grades) {
                GradeItemNotaTerceiros g = (GradeItemNotaTerceiros)o;
                g.setValorCusto(Double.valueOf(item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIcmsSt() + itLF.getVrDifAliquota() + item.getVrFreteCtrc() - itLF.getVrCofins() - itLF.getVrPis() - itLF.getVrIpiComercio() + item.getValorAgregado() + itLF.getVrCustoICMSST() + itLF.getValorFCPSt()));
                if (modeloFiscal.getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)2) || modeloFiscal.getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
                    g.setValorCusto(Double.valueOf(g.getValorCusto() - itLF.getVrIcmsDesonerado()));
                }
                if (modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms() == 1) {
                    g.setValorCusto(Double.valueOf(g.getValorCusto() - itLF.getVrIcms()));
                }
                if (modeloFiscal.getModeloFiscalIcms().getCalcularIcmsSimples() == 1) {
                    g.setValorCusto(Double.valueOf(g.getValorCusto() - itLF.getValorICMSSimples()));
                }
                g.setValorCusto(Double.valueOf(g.getValorCusto() + itLF.getVrIpiObservacao()));
                if (item.getQuantidadeTotal() > 0.0 && item.getFatorConversao() > 0.0) {
                    g.setValorCusto(Double.valueOf(g.getValorCusto() / (item.getQuantidadeTotal() * item.getFatorConversao())));
                    continue;
                }
                g.setValorCusto(Double.valueOf(0.0));
            }
        }
    }

    public static Double getValorProdutosItens(List<ItemNotaTerceiros> itens) {
        Double qtdTotal = 0.0;
        if (itens != null) {
            Iterator<ItemNotaTerceiros> iterator = itens.iterator();
            while (iterator.hasNext()) {
                ItemNotaTerceiros o;
                ItemNotaTerceiros item = o = iterator.next();
                qtdTotal = qtdTotal + (item.getVrServico() + item.getVrProduto());
            }
        }
        return qtdTotal;
    }

    private static void valoresIpiItemNotaPropria(ModeloFiscalIpi modeloFiscalIpi, ItemNotaTerceiros item, Produto produto, UnidadeFatFornecedor fornecedor, short modoArredondamento) throws ExceptionCalculoIPI {
        ItemNotaLivroFiscal itLF = item.getItemNotaLivroFiscal();
        if (item.getNaoCalcularIpi() == null || item.getNaoCalcularIpi() != 1) {
            HashMap h = new CalculoIPIEntUtilities(modeloFiscalIpi.getIncluiSeguro(), modeloFiscalIpi.getIncluiFrete(), modeloFiscalIpi.getIncluiDespAcess(), modeloFiscalIpi.getIncluiDesconto()).calcularIpi(modeloFiscalIpi, item.getIncidenciaIpi(), fornecedor, produto, itLF.getAliquotaIpi(), modoArredondamento, item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), item.getQuantidadeTotal());
            itLF.setAliquotaIpi((Double)h.get("aliquotaIPI"));
            itLF.setVrIpiComercio((Double)h.get("ipiComercio"));
            itLF.setVrIpiIndustria((Double)h.get("ipiIndustria"));
            itLF.setVrIpiIsento((Double)h.get("ipiIsento"));
            itLF.setVrIpiObservacao((Double)h.get("ipiObservacao"));
            itLF.setVrIpiOutros((Double)h.get("ipiOutros"));
            itLF.setVrIpiTributado((Double)h.get("ipiTributado"));
        }
    }

    private static void valoresIcmsIcmsSTItemNotaTerceiros(ModeloFiscal modeloFiscal, ItemNotaTerceiros item, Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufFornecedor, short modoArredondamento, EmpresaContabilidade empresaContabilidade) throws ExceptionService, ExceptionCalculoICMS {
        if (item.getNaoCalcularIcms() == null || item.getNaoCalcularIcms() != 1) {
            HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).valoresIcms(modeloFiscal.getModeloFiscalIcms(), modeloFiscal.getModeloFiscalIpi(), item.getItemNotaLivroFiscal().getVrIpiIndustria(), item.getItemNotaLivroFiscal().getVrIpiObservacao(), item.getItemNotaLivroFiscal().getAliquotaIcms(), item.getItemNotaLivroFiscal().getPercReducaoBCIcms(), produto, modoArredondamento, item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), empresaContabilidade, item.getItemNotaLivroFiscal().getVrIcmsDesonerado(), item.getItemNotaLivroFiscal().getVrIcmsSemAprov(), item.getQuantidadeTotal());
            item.getItemNotaLivroFiscal().setAliquotaIcms((Double)h.get("aliquotaIPI"));
            item.getItemNotaLivroFiscal().setVrBcCalculoIcms((Double)h.get("bcIcms"));
            item.getItemNotaLivroFiscal().setVrIcmsIsento((Double)h.get("icmsIsento"));
            item.getItemNotaLivroFiscal().setVrIcmsOutros((Double)h.get("icmsOutros"));
            item.getItemNotaLivroFiscal().setVrIcmsSemAprov((Double)h.get("icmsSemAprov"));
            item.getItemNotaLivroFiscal().setVrIcmsTributado((Double)h.get("icmsTributado"));
            item.getItemNotaLivroFiscal().setVrIcmsDesonerado((Double)h.get("valorIcmsDesonerado"));
            item.getItemNotaLivroFiscal().setVrIcms((Double)h.get("valorIcms"));
            item.getItemNotaLivroFiscal().setVrNaoTribICMS((Double)h.get("valorReducaoIcms"));
            if (item.getItemNotaLivroFiscal().getCalcularIcmsST() != null && item.getItemNotaLivroFiscal().getCalcularIcmsST() == 1) {
                h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularSt(item.getItemNotaLivroFiscal().getVrIcms() + item.getItemNotaLivroFiscal().getVrIcmsSemAprov(), item.getItemNotaLivroFiscal().getIndiceAlteracaoIcmsST(), item.getItemNotaLivroFiscal().getAliquotaIcmsST(), item.getItemNotaLivroFiscal().getDescontoPadraoIcmsST(), item.getQuantidadeTotal(), produto, item.getItemNotaLivroFiscal().getModalidadeIcmsSt(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), item.getItemNotaLivroFiscal().getVrIpiIndustria(), item.getItemNotaLivroFiscal().getVrIpiObservacao(), modeloFiscal.getModeloFiscalIcms().getReducaoBaseCalcIcmsST());
                item.getItemNotaLivroFiscal().setIndiceAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
                item.getItemNotaLivroFiscal().setDescontoPadraoIcmsST((Double)h.get("descontoPadraoST"));
                item.getItemNotaLivroFiscal().setAliquotaIcmsST((Double)h.get("aliquotaSt"));
                item.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt((Double)h.get("bcIcmsST"));
                item.getItemNotaLivroFiscal().setVrIcmsSt((Double)h.get("valorIcmsST"));
                item.getItemNotaLivroFiscal().setVrNaoTribICMS((Double)h.get("valorReducaoIcms"));
            }
            if (item.getItemNotaLivroFiscal().getValorStCustoCompTotNota() != null && item.getItemNotaLivroFiscal().getValorStCustoCompTotNota() == 1) {
                item.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(item.getItemNotaLivroFiscal().getVrIcmsOutros() + item.getItemNotaLivroFiscal().getVrCustoICMSST()));
            }
            item.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(item.getItemNotaLivroFiscal().getVrIcmsOutros() + item.getItemNotaLivroFiscal().getValorFCPSt()));
        }
    }

    private static void calculoOutrosImpostos(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item, int modoArredondamento) throws ExceptionCalculoPisCofins {
        CalculosImpFiscaisNotaTerceiros.valoresPisCofinsItemNotaTerceiros(itLF, item, modoArredondamento);
        CalculosImpFiscaisNotaTerceiros.valoresContSocItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresFunruralItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresLei10833ItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresCideItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresInssItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresIRRFItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresIssItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresOutrosItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresSestSenatItemNotaTerceiros(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresSenar(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresRat(itLF, item);
        CalculosImpFiscaisNotaTerceiros.valoresTaxaSanidAnimal(itLF, item);
    }

    private static void valoresSenar(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        EnumConstTipoCalcSenar tp = ToolMethods.isEquals((Object)item.getModeloFiscal().getTipoSenar(), (Object)1) ? EnumConstTipoCalcSenar.CALCULAR_NORMAL : EnumConstTipoCalcSenar.NAO_CALCULAR;
        SenarParams params = new SenarParams(itLF.getAliquotaSenar(), itLF.getValorSenar(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getVrProduto() + item.getVrServico()), EnumConstTipoArredondamento.ROUND_DOWN, tp);
        SenarCalculado calc = CompImpostoSenar.calcularSenar((SenarParams)params);
        itLF.setAliquotaSenar(calc.getAliquotaSenar());
        itLF.setValorSenar(calc.getValorSenar());
    }

    private static void valoresTaxaSanidAnimal(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        TaxaSanidAnimalParams params = new TaxaSanidAnimalParams(itLF.getTaxaSanidadeAnimal(), itLF.getFatorTaxaSanidadeAnimal(), itLF.getValorTaxaSanidadeAnimal(), item.getQuantidadeTotal(), EnumConstTipoArredondamento.ROUND_DOWN, EnumConstCalcTipoTaxaSanidAnimal.CALCULAR_NORMAL);
        TaxaSanidAnimalCalculado calc = CompImpostoTaxaSanidadeAnimal.calcularTaxaSanidadeAnimal((TaxaSanidAnimalParams)params);
        itLF.setTaxaSanidadeAnimal(calc.getTaxaSanidAnimal());
        itLF.setValorTaxaSanidadeAnimal(calc.getValorSanidAnimal());
        itLF.setFatorTaxaSanidadeAnimal(calc.getFatorTaxaSanidAnimal());
        itLF.setBcTaxaSanidadeAnimal(calc.getBaseCalculoTaxaSanidAnimal());
    }

    private static void valoresRat(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        EnumConstTipoCalcRat tp = ToolMethods.isEquals((Object)item.getModeloFiscal().getTipoRat(), (Object)1) ? EnumConstTipoCalcRat.CALCULAR_NORMAL : EnumConstTipoCalcRat.NAO_CALCULAR;
        RatParams params = new RatParams(itLF.getAliquotaRat(), itLF.getValorRat(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getVrProduto() + item.getVrServico()), EnumConstTipoArredondamento.ROUND_DOWN, tp);
        RatCalculado calc = CompImpostoRat.calcularRat((RatParams)params);
        itLF.setAliquotaRat(calc.getAliquotaRat());
        itLF.setValorRat(calc.getValorRat());
    }

    private static void calcularDiferencaAliquota(ModeloFiscal modeloFiscal, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, ItemNotaTerceiros it) throws ExceptionService {
        ItemNotaLivroFiscal itLF = it.getItemNotaLivroFiscal();
        if (it.getNaoCalcularIcms() == null || it.getNaoCalcularIcms() != 1) {
            HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularDiferencaAliquota(itLF.getItemNotaTerceiros().getModeloFiscal().getModeloFiscalIcms(), ufFornecedor, ufEmpresa, itLF.getItemNotaTerceiros().getProduto(), it.getValorFrete(), it.getVrSeguro(), it.getValorDespAcessoria(), it.getValorDesconto(), it.getVrProduto() + it.getVrServico(), modeloFiscal.getModeloFiscalIcms().getIpiCompoeBCDifAliquota(), itLF.getVrIpiComercio() + itLF.getVrIpiIndustria() + itLF.getVrIpiObservacao(), it.getItemNotaLivroFiscal().getAliquotaIcms(), itLF.getVrIcms() + itLF.getVrIcmsSemAprov());
            itLF.setVrDifAliquota(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorDifAliquota")), (int)2));
        }
    }

    private static void atualizarPrecoLancCto(ItemNotaTerceiros i) throws ExceptionService {
        if (i.getLancCtoEntrada() != null) {
            GradeItemNotaTerceiros g;
            LancamentoCentroCusto aux;
            LancCtoItemNota lc;
            block0: for (Object ob : i.getLancCtoEntrada()) {
                lc = (LancCtoItemNota)ob;
                aux = lc.getLancCtoCusto();
                for (Object oc : i.getGrade()) {
                    g = (GradeItemNotaTerceiros)oc;
                    if (!g.getGradeCor().equals((Object)aux.getGradeCor())) continue;
                    aux.setValor(Double.valueOf(aux.getQuantidade() * g.getValorCusto()));
                    continue block0;
                }
            }
            block2: for (Object ob : i.getLancCtoGerSaida()) {
                lc = (LancCtoSaidaItemNota)ob;
                aux = lc.getLancCtoCusto();
                for (Object oc : i.getGrade()) {
                    g = (GradeItemNotaTerceiros)oc;
                    if (!g.getGradeCor().equals((Object)aux.getGradeCor())) continue;
                    aux.setValor(Double.valueOf(aux.getQuantidade() * g.getValorCusto()));
                    lc.getLancCtbGerencial().setValor(aux.getValor());
                    continue block2;
                }
            }
        }
    }

    private static void ajustarDiferencas(List<ItemNotaTerceiros> itensNota, Double valorIcmsInf, Double valorIpiInf, Double valorTotalInf, OpcoesCompraSuprimentos opcoes) {
        Double dif;
        Double valorTotalItens = 0.0;
        Double valorIpiItens = 0.0;
        Double valorIcmsItens = 0.0;
        Iterator<ItemNotaTerceiros> iterator = itensNota.iterator();
        while (iterator.hasNext()) {
            ItemNotaTerceiros o;
            ItemNotaTerceiros v = o = iterator.next();
            valorTotalItens = valorTotalItens + v.getItemNotaLivroFiscal().getValorTotal();
            valorIcmsItens = valorIcmsItens + (v.getItemNotaLivroFiscal().getVrIcms() + v.getItemNotaLivroFiscal().getVrIcmsSemAprov());
            valorIpiItens = valorIpiItens + (v.getItemNotaLivroFiscal().getVrIpiObservacao() + v.getItemNotaLivroFiscal().getVrIpiIndustria());
        }
        valorIcmsItens = ContatoFormatUtil.arrredondarNumero((Double)valorIcmsItens, (int)2);
        valorIpiItens = ContatoFormatUtil.arrredondarNumero((Double)valorIpiItens, (int)2);
        valorTotalItens = ContatoFormatUtil.arrredondarNumero((Double)valorTotalItens, (int)2);
        Double ajuste = opcoes.getDifLimiteArredEntrada();
        if (ajuste == null || ajuste <= 0.0) {
            ajuste = LIMITE_AJUSTE_PADRAO;
        }
        if (valorTotalItens > ajuste && valorTotalItens.doubleValue() != valorTotalInf.doubleValue() && valorTotalItens - valorTotalInf < 0.1 && valorTotalItens - valorTotalInf > -0.1 && Math.abs(dif = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalInf - valorTotalItens), (int)2)) <= ajuste) {
            CalculosImpFiscaisNotaTerceiros.atualizarDifValorTot(itensNota, dif);
        }
        if (valorIcmsItens > ajuste && valorIcmsItens.doubleValue() != valorIcmsInf.doubleValue() && valorIcmsItens - valorIcmsInf < 0.1 && valorIcmsItens - valorIcmsInf > -0.1 && Math.abs(dif = ContatoFormatUtil.arrredondarNumero((Double)(valorIcmsInf - valorIcmsItens), (int)2)) <= ajuste) {
            CalculosImpFiscaisNotaTerceiros.atualizarDifIcms(itensNota, dif);
        }
        if (valorIpiItens > ajuste && valorIpiItens.doubleValue() != valorIpiInf.doubleValue() && valorIpiItens - valorIpiInf < 0.1 && valorIpiItens - valorIpiInf > -0.1 && Math.abs(dif = ContatoFormatUtil.arrredondarNumero((Double)(valorIpiInf - valorIpiItens), (int)2)) <= ajuste) {
            CalculosImpFiscaisNotaTerceiros.atualizarDifIpi(itensNota, dif);
        }
        for (ItemNotaTerceiros itemNotaTerceiros : itensNota) {
            CalculosImpFiscaisNotaTerceiros.ajustarDifVrTotalBCImpostos(itemNotaTerceiros.getItemNotaLivroFiscal(), ajuste);
        }
    }

    private static void atualizarDifIcms(List<ItemNotaTerceiros> itensNota, double doubleValue) {
        for (ItemNotaTerceiros o : itensNota) {
            ItemNotaTerceiros i = o;
            if (i.getItemNotaLivroFiscal().getVrIcmsSemAprov() > 0.01) {
                i.getItemNotaLivroFiscal().setVrIcmsSemAprov(Double.valueOf(i.getItemNotaLivroFiscal().getVrIcmsSemAprov() + doubleValue));
                break;
            }
            if (!(i.getItemNotaLivroFiscal().getVrIcms() > 0.01)) continue;
            i.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(i.getItemNotaLivroFiscal().getVrIcms() + doubleValue));
            break;
        }
    }

    private static void atualizarDifIpi(List<ItemNotaTerceiros> itensNota, double doubleValue) {
        for (ItemNotaTerceiros o : itensNota) {
            ItemNotaTerceiros i = o;
            if (i.getItemNotaLivroFiscal().getVrIpiIndustria() > 0.01) {
                i.getItemNotaLivroFiscal().setVrIpiIndustria(Double.valueOf(i.getItemNotaLivroFiscal().getVrIpiIndustria() + doubleValue));
                break;
            }
            if (i.getItemNotaLivroFiscal().getVrIpiComercio() > 0.01) {
                i.getItemNotaLivroFiscal().setVrIpiComercio(Double.valueOf(i.getItemNotaLivroFiscal().getVrIpiComercio() + doubleValue));
                break;
            }
            if (!(i.getItemNotaLivroFiscal().getVrIpiObservacao() > 0.01)) continue;
            i.getItemNotaLivroFiscal().setVrIpiObservacao(Double.valueOf(i.getItemNotaLivroFiscal().getVrIpiObservacao() + doubleValue));
            break;
        }
    }

    private static void atualizarDifValorTot(List<ItemNotaTerceiros> itensNota, double dif) {
        if (itensNota.size() > 0) {
            ItemNotaTerceiros v = itensNota.get(itensNota.size() - 1);
            Double d = v.getItemNotaLivroFiscal().getValorTotal();
            d = ContatoFormatUtil.arrredondarNumero((Double)d, (int)2);
            d = d + dif;
            v.getItemNotaLivroFiscal().setValorTotal(d);
        }
    }

    private static void ratearOutrosValores(List<ItemNotaTerceiros> itens, Double valorTotalProdutos, Double valorAgregado, boolean naoRatearVlrAgregado, Double valorCalcAgregado) {
        for (ItemNotaTerceiros item : itens) {
            if (naoRatearVlrAgregado) {
                valorAgregado = item.getValorAgregado();
            }
            if (valorTotalProdutos <= 0.0) {
                valorTotalProdutos = 1.0;
            }
            if (item.getInformarValorAgregado() == null || item.getInformarValorAgregado().equals((short)0)) {
                if (!naoRatearVlrAgregado && valorCalcAgregado > 0.0) {
                    item.setPercValorAgregado(Double.valueOf(valorAgregado * 100.0 / valorCalcAgregado));
                    item.setValorAgregado(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercValorAgregado() / 100.0 * item.getValorAgregado()), (int)2));
                    continue;
                }
                if (!(valorAgregado > 0.0) || !(item.getVrProduto() > 0.0)) continue;
                item.setPercValorAgregado(Double.valueOf(valorAgregado * 100.0 / item.getVrProduto()));
                continue;
            }
            if (!(valorAgregado > 0.0) || !(item.getVrProduto() > 0.0)) continue;
            item.setPercValorAgregado(Double.valueOf(item.getValorAgregado() * 100.0 / item.getVrProduto()));
        }
    }

    private static void ajustarValoresAcessorios(List<ItemNotaTerceiros> itensNota, Double valorDesconto, Double valorDespAcessorias, Double valorFrete, Double valorSeguro, Double valorAgregado, Double valorTotalFreteCTRC, boolean naoRatearDespAcessorias, boolean naoRatearFrete, boolean naoRatearSeguro, boolean naoRatearDesconto, boolean naoRatearVlrAgregado) {
        Double valorDescontoCalc = 0.0;
        Double valorDespAcessoriasCalc = 0.0;
        Double valorFreteCalc = 0.0;
        Double valorSeguroCalc = 0.0;
        Double valorAgregadoCalc = 0.0;
        Double valorFreteCTRC = 0.0;
        for (ItemNotaTerceiros o : itensNota) {
            ItemNotaTerceiros i = o;
            if (i.getDescontoItem() == null || i.getDescontoItem().equals((short)0)) {
                valorDescontoCalc = valorDescontoCalc + i.getValorDesconto();
            }
            if (i.getDespAcessItem() == null || i.getDespAcessItem().equals((short)0)) {
                valorDespAcessoriasCalc = valorDespAcessoriasCalc + i.getValorDespAcessoria();
            }
            if (i.getFreteItem() == null || i.getFreteItem().equals((short)0)) {
                valorFreteCalc = valorFreteCalc + i.getValorFrete();
            }
            if (i.getSeguroItem() == null || i.getSeguroItem().equals((short)0)) {
                valorSeguroCalc = valorSeguroCalc + i.getVrSeguro();
            }
            valorAgregado = valorAgregado + i.getValorAgregado();
            valorFreteCTRC = valorFreteCTRC + i.getVrFreteCtrc();
        }
        if (itensNota != null && itensNota.size() > 0) {
            Optional<ItemNotaTerceiros> found;
            ItemNotaTerceiros i = itensNota.get(0);
            if (!naoRatearDesconto && (i.getDescontoItem() == null || i.getDescontoItem().equals((short)0)) && valorDesconto > 0.0) {
                i.setValorDesconto(Double.valueOf(i.getValorDesconto() + (valorDesconto - valorDescontoCalc)));
            }
            if (!naoRatearDespAcessorias && (i.getDespAcessItem() == null || i.getDespAcessItem().equals((short)0)) && valorDespAcessorias > 0.0) {
                i.setValorDespAcessoria(Double.valueOf(i.getValorDespAcessoria() + (valorDespAcessorias - valorDespAcessoriasCalc)));
            }
            if (!naoRatearFrete && (i.getFreteItem() == null || i.getFreteItem().equals((short)0)) && valorFrete > 0.0) {
                i.setValorFrete(Double.valueOf(i.getValorFrete() + (valorFrete - valorFreteCalc)));
            }
            if (!naoRatearSeguro && (i.getSeguroItem() == null || i.getSeguroItem().equals((short)0)) && valorSeguro > 0.0) {
                i.setVrSeguro(Double.valueOf(i.getVrSeguro() + (valorSeguro - valorSeguroCalc)));
            }
            if (!naoRatearVlrAgregado && (i.getInformarValorAgregado() == null || i.getInformarValorAgregado().equals((short)0))) {
                i.setValorAgregado(Double.valueOf(i.getValorAgregado() + (valorAgregado - valorAgregadoCalc)));
            }
            if ((found = itensNota.stream().filter(item -> Objects.equals(item.getNaoRatearFreteCtrc(), (short)0)).findAny()).isPresent()) {
                found.get().setVrFreteCtrc(Double.valueOf(found.get().getVrFreteCtrc() + (valorTotalFreteCTRC - valorFreteCTRC)));
            }
        }
    }

    private static void valoresPisCofinsItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item, int modoArredondamento) throws ExceptionCalculoPisCofins {
        if (item.getNaoCalcularPisCofins() == null || item.getNaoCalcularPisCofins() == 0) {
            HashMap h = new CalculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()).calculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins(), itLF.getAliquotaPis(), itLF.getAliquotaPisSt(), itLF.getAliquotaCofins(), itLF.getAliquotaCofinsSt(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), modoArredondamento, item.getProduto().getPisCofinsTributadoQuantidade(), item.getQuantidadeTotal(), 0.0, 0.0, itLF.getVrIcms(), itLF.getVrIcmsDesonerado(), itLF.getVrIcmsSemAprov(), itLF.getVrIpiObservacao());
            itLF.setAliquotaPis((Double)h.get("aliquotaPis"));
            itLF.setAliquotaPisSt((Double)h.get("aliquotaPisSt"));
            itLF.setAliquotaCofins((Double)h.get("aliquotaCofins"));
            itLF.setAliquotaCofinsSt((Double)h.get("aliquotaCofinsSt"));
            itLF.setVrPis((Double)h.get("valorPis"));
            itLF.setVrPisSt((Double)h.get("valorPisSt"));
            itLF.setVrCofins((Double)h.get("valorCofins"));
            itLF.setVrCofinsSt((Double)h.get("valorCofinsSt"));
            itLF.setVrBCCofins((Double)h.get("valorBCCofins"));
            itLF.setVrBCCofinsSt((Double)h.get("valorBCCofinsSt"));
            itLF.setVrBCPis((Double)h.get("valorBCPis"));
            itLF.setVrBCPisSt((Double)h.get("valorBCPisSt"));
        }
    }

    private static void valoresContSocItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoContSoc(item.getModeloFiscal().getTipoContSoc(), itLF.getAliquotaContSoc(), itLF.getPercRedContSoc(), item.getModeloFiscal().getValorMinimoCSLL(), itLF.getVrContSoc(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
        itLF.setVrContSoc((Double)h.get("valorContSoc"));
        itLF.setPercRedContSoc((Double)h.get("percRedContSoc"));
    }

    private static void valoresFunruralItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoFunrural(item.getModeloFiscal(), itLF.getAliquotaFunrural(), itLF.getPercRedFunrural(), itLF.getVrFunrural(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        itLF.setVrFunrural((Double)h.get("valorFunrural"));
        itLF.setPercRedFunrural((Double)h.get("percRedFunrural"));
    }

    private static void valoresLei10833ItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoLei10833(item.getModeloFiscal(), itLF.getAliquotaLei10833(), itLF.getPercRedLei10833(), itLF.getVrLei10833(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        itLF.setVrLei10833((Double)h.get("valorLei10833"));
        itLF.setPercRedLei10833((Double)h.get("percRedLei10833"));
    }

    private static void valoresCideItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoCIDE(item.getModeloFiscal(), itLF.getAliquotaCIDE(), itLF.getValorCIDE(), item.getQuantidadeTotal());
        itLF.setAliquotaCIDE((Double)h.get("aliquotaCIDE"));
        itLF.setValorCIDE((Double)h.get("valorCIDE"));
        itLF.setQuantidadeBCCIDE((Double)h.get("bcCIDE"));
    }

    private static void valoresInssItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoINSS(item.getModeloFiscal().getTipoINSS(), itLF.getAliquotaInss(), itLF.getPercRedBcInss(), itLF.getVrInss(), itLF.getVrInssNaoRetido(), item.getModeloFiscal().getValorMinimoInss(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaInss((Double)h.get("aliquotaInss"));
        itLF.setVrInss((Double)h.get("valorInss"));
        itLF.setVrInssNaoRetido((Double)h.get("valorInssNaoRetido"));
        itLF.setPercRedBcInss((Double)h.get("percRedInss"));
    }

    private static void valoresIRRFItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoIRRF(item.getModeloFiscal().getTipoIRRF(), itLF.getAliquotaIrrf(), itLF.getPercRedIrrf(), itLF.getVrIrrf(), item.getModeloFiscal().getValorMinimoIR(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        itLF.setVrIrrf((Double)h.get("valorIrrf"));
        itLF.setPercRedIrrf((Double)h.get("percRedIRRF"));
    }

    private static void valoresIssItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoISS(item.getModeloFiscal().getIssRetido(), itLF.getAliquotaIss(), 0.0, itLF.getVrIss(), item.getModeloFiscal().getValorMinimoISS(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIss((Double)h.get("aliquotaIss"));
        itLF.setVrIss((Double)h.get("valorIss"));
    }

    private static void valoresOutrosItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoOutros(item.getModeloFiscal().getTipoOutros(), itLF.getAliquotaOutros(), itLF.getPercRedOutros(), itLF.getVrOutros(), item.getModeloFiscal().getValorMinimoOutros(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaOutros((Double)h.get("aliquotaOutros"));
        itLF.setVrOutros((Double)h.get("valorOutros"));
        itLF.setPercRedOutros((Double)h.get("percRedOutros"));
    }

    private static void valoresSestSenatItemNotaTerceiros(ItemNotaLivroFiscal itLF, ItemNotaTerceiros item) {
        HashMap h = CalculoOutrosImpostos.calculoSestSenat(item.getModeloFiscal(), itLF.getAliquotaSestSenat(), itLF.getPercRedSestSenat(), itLF.getValorSestSenat(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaSestSenat((Double)h.get("aliquotaSestSenat"));
        itLF.setValorSestSenat((Double)h.get("valorSestSenat"));
        itLF.setPercRedSestSenat((Double)h.get("percRedSestSenat"));
    }

    /*
     * WARNING - void declaration
     */
    private static void ratearDesconto(List<ItemNotaTerceiros> itens, double valorDesconto, boolean naoRatearDesconto) throws ExceptionService {
        double valorTotal = 0.0;
        double valorDescontoTotal = valorDesconto;
        for (ItemNotaTerceiros it : itens) {
            if (it.getDescontoItem() != null && !it.getDescontoItem().equals((short)0)) continue;
            valorTotal += it.getVrServico() + it.getVrProduto();
        }
        if (valorTotal <= 0.0 && valorDesconto > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o desconto.");
        }
        ItemNotaTerceiros lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemNotaTerceiros itemNotaTerceiros : itens) {
            double vlrProduto = itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getVrProduto();
            double valorDescCalc = 0.0;
            double percDescCalc = 0.0;
            if (itemNotaTerceiros.getDescontoItem() != 1) {
                percDescCalc = valorDesconto > 0.0 && valorTotal > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorDesconto / valorTotal * 100.0), (int)4) : 0.0;
                valorDescCalc = ContatoFormatUtil.arrredondarNumero((Double)(vlrProduto * percDescCalc / 100.0), (int)2);
                valorDescTotal += valorDescCalc;
                lastItem = itemNotaTerceiros;
                itemNotaTerceiros.setPercDesconto(Double.valueOf(percDescCalc));
                itemNotaTerceiros.setValorDesconto(Double.valueOf(valorDescCalc));
                continue;
            }
            if (itemNotaTerceiros.getTipoDesconto() == 0) {
                if (!(itemNotaTerceiros.getPercDesconto() > 0.0)) continue;
                itemNotaTerceiros.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getPercDesconto() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            itemNotaTerceiros.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)itemNotaTerceiros.getValorDesconto(), (int)2));
            if (!(itemNotaTerceiros.getValorDesconto() > 0.0) || !(vlrProduto > 0.0)) continue;
            itemNotaTerceiros.setPercDesconto(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getValorDesconto() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDesconto > 0.0) {
            Double vrDesconto = lastItem.getValorDesconto() + (valorDesconto - valorDescTotal);
            lastItem.setValorDesconto(vrDesconto);
            if (lastItem.getValorDesconto() < 0.0) {
                lastItem.setValorDesconto(Double.valueOf(0.0));
                lastItem.setPercDesconto(Double.valueOf(0.0));
                vrDesconto = Math.abs(vrDesconto);
                for (ItemNotaTerceiros item : itens) {
                    if (item.getValorDesconto() >= vrDesconto) {
                        item.setValorDesconto(Double.valueOf(item.getValorDesconto() - vrDesconto));
                        break;
                    }
                    item.setValorDesconto(Double.valueOf(0.0));
                    vrDesconto = vrDesconto - item.getValorDesconto();
                }
            }
        }
        if (naoRatearDesconto && valorDescontoTotal > 0.0) {
            void var12_14;
            Boolean valorTotalmenteRateado = false;
            int n = itens.size() - 1;
            while (var12_14 >= 0) {
                ItemNotaTerceiros it = itens.get((int)var12_14);
                if (it.getDescontoItem() == null || it.getDescontoItem().equals((short)0)) {
                    Double valorProduto = it.getVrServico() + it.getVrProduto();
                    if (valorProduto > valorDescontoTotal) {
                        it.setValorDesconto(Double.valueOf(valorDescontoTotal));
                        valorDescontoTotal = 0.0;
                        valorTotalmenteRateado = true;
                    } else {
                        it.setValorDesconto(valorProduto);
                        valorDescontoTotal -= valorProduto.doubleValue();
                    }
                    if (it.getValorDesconto() > 0.0 && valorProduto > 0.0) {
                        it.setPercDesconto(ContatoFormatUtil.arrredondarNumero((Double)(it.getValorDesconto() * 100.0 / valorProduto), (int)4));
                    } else {
                        it.setPercDesconto(Double.valueOf(0.0));
                    }
                }
                --var12_14;
            }
            if (!valorTotalmenteRateado.booleanValue()) {
                throw new ExceptionService("Os valores dos itens n\u00e3o foram suficientes para ratear o desconto.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ratearFrete(List<ItemNotaTerceiros> itens, double valorFrete, boolean naoRatearFrete) throws ExceptionService {
        double valorTotal = 0.0;
        double valorFreteTotal = valorFrete;
        for (ItemNotaTerceiros it : itens) {
            if (it.getFreteItem() != null && !it.getFreteItem().equals((short)0)) continue;
            valorTotal += it.getVrServico() + it.getVrProduto();
        }
        if (valorTotal <= 0.0 && valorFrete > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o frete.");
        }
        ItemNotaTerceiros lastItem = null;
        double valorFrTotal = 0.0;
        for (ItemNotaTerceiros itemNotaTerceiros : itens) {
            double vlrProduto = itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getVrProduto();
            double valorFreteCalc = 0.0;
            double percFreteCalc = 0.0;
            if (itemNotaTerceiros.getFreteItem() != 1) {
                percFreteCalc = valorFrete > 0.0 && valorTotal > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorFrete / valorTotal * 100.0), (int)4) : 0.0;
                valorFreteCalc = ContatoFormatUtil.arrredondarNumero((Double)(vlrProduto * percFreteCalc / 100.0), (int)2);
                valorFrTotal += valorFreteCalc;
                lastItem = itemNotaTerceiros;
                itemNotaTerceiros.setPercFrete(Double.valueOf(percFreteCalc));
                itemNotaTerceiros.setValorFrete(Double.valueOf(valorFreteCalc));
                continue;
            }
            if (itemNotaTerceiros.getTipoFrete() == 0) {
                if (!(itemNotaTerceiros.getPercFrete() > 0.0)) continue;
                itemNotaTerceiros.setValorFrete(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getPercFrete() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            itemNotaTerceiros.setValorFrete(ContatoFormatUtil.arrredondarNumero((Double)itemNotaTerceiros.getValorFrete(), (int)2));
            if (!(itemNotaTerceiros.getValorFrete() > 0.0) || !(vlrProduto > 0.0)) continue;
            itemNotaTerceiros.setPercFrete(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getValorFrete() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorFrete > 0.0) {
            Double vrFrete = lastItem.getValorFrete() + (valorFrete - valorFrTotal);
            lastItem.setValorFrete(vrFrete);
            if (lastItem.getValorFrete() < 0.0) {
                lastItem.setValorFrete(Double.valueOf(0.0));
                lastItem.setPercFrete(Double.valueOf(0.0));
                vrFrete = Math.abs(vrFrete);
                for (ItemNotaTerceiros item : itens) {
                    if (item.getValorFrete() >= vrFrete) {
                        item.setValorFrete(Double.valueOf(item.getValorFrete() - vrFrete));
                        break;
                    }
                    item.setValorFrete(Double.valueOf(0.0));
                    vrFrete = vrFrete - item.getValorFrete();
                }
            }
        }
        if (naoRatearFrete && valorFreteTotal > 0.0) {
            void var12_14;
            Boolean valorTotalmenteRateado = false;
            int n = itens.size() - 1;
            while (var12_14 >= 0) {
                ItemNotaTerceiros it = itens.get((int)var12_14);
                if (it.getFreteItem() == null || it.getFreteItem().equals((short)0)) {
                    Double valorProduto = it.getVrServico() + it.getVrProduto();
                    if (valorProduto > valorFreteTotal) {
                        it.setValorFrete(Double.valueOf(valorFreteTotal));
                        valorFreteTotal = 0.0;
                        valorTotalmenteRateado = true;
                    } else {
                        it.setValorFrete(valorProduto);
                        valorFreteTotal -= valorProduto.doubleValue();
                    }
                    if (it.getValorFrete() > 0.0 && valorProduto > 0.0) {
                        it.setPercFrete(ContatoFormatUtil.arrredondarNumero((Double)(it.getValorFrete() * 100.0 / valorProduto), (int)4));
                    } else {
                        it.setPercFrete(Double.valueOf(0.0));
                    }
                }
                --var12_14;
            }
            if (!valorTotalmenteRateado.booleanValue()) {
                throw new ExceptionService("Os valores dos itens n\u00e3o foram suficientes para ratear o frete.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ratearSeguro(List<ItemNotaTerceiros> itens, double valorSeguro, boolean naoRatearSeguro) throws ExceptionService {
        double valorTotal = 0.0;
        double valorSeguroTotal = valorSeguro;
        for (ItemNotaTerceiros it : itens) {
            if (it.getSeguroItem() != null && !it.getSeguroItem().equals((short)0)) continue;
            valorTotal += it.getVrServico() + it.getVrProduto();
        }
        if (valorTotal <= 0.0 && valorSeguro > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o seguro.");
        }
        ItemNotaTerceiros lastItem = null;
        double valorSegTotal = 0.0;
        for (ItemNotaTerceiros itemNotaTerceiros : itens) {
            double vlrProduto = itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getVrProduto();
            double valorSeguroCalc = 0.0;
            double percSeguroCalc = 0.0;
            if (itemNotaTerceiros.getSeguroItem() != 1) {
                percSeguroCalc = valorSeguro > 0.0 && valorTotal > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorSeguro / valorTotal * 100.0), (int)4) : 0.0;
                valorSeguroCalc = ContatoFormatUtil.arrredondarNumero((Double)(vlrProduto * percSeguroCalc / 100.0), (int)2);
                valorSegTotal += valorSeguroCalc;
                lastItem = itemNotaTerceiros;
                itemNotaTerceiros.setPercSeguro(Double.valueOf(percSeguroCalc));
                itemNotaTerceiros.setVrSeguro(Double.valueOf(valorSeguroCalc));
                continue;
            }
            if (itemNotaTerceiros.getTipoSeguro() == 0) {
                if (!(itemNotaTerceiros.getPercSeguro() > 0.0)) continue;
                itemNotaTerceiros.setVrSeguro(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getPercSeguro() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            itemNotaTerceiros.setVrSeguro(ContatoFormatUtil.arrredondarNumero((Double)itemNotaTerceiros.getVrSeguro(), (int)2));
            if (!(itemNotaTerceiros.getVrSeguro() > 0.0) || !(vlrProduto > 0.0)) continue;
            itemNotaTerceiros.setPercSeguro(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getVrSeguro() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorSeguro > 0.0) {
            Double vrSeguro = lastItem.getVrSeguro() + (valorSeguro - valorSegTotal);
            lastItem.setVrSeguro(vrSeguro);
            if (lastItem.getVrSeguro() < 0.0) {
                lastItem.setVrSeguro(Double.valueOf(0.0));
                lastItem.setPercSeguro(Double.valueOf(0.0));
                vrSeguro = Math.abs(vrSeguro);
                for (ItemNotaTerceiros item : itens) {
                    if (item.getVrSeguro() >= vrSeguro) {
                        item.setVrSeguro(Double.valueOf(item.getVrSeguro() - vrSeguro));
                        break;
                    }
                    item.setVrSeguro(Double.valueOf(0.0));
                    vrSeguro = vrSeguro - item.getVrSeguro();
                }
            }
        }
        if (naoRatearSeguro && valorSeguroTotal > 0.0) {
            void var12_14;
            Boolean valorTotalmenteRateado = false;
            int n = itens.size() - 1;
            while (var12_14 >= 0) {
                ItemNotaTerceiros it = itens.get((int)var12_14);
                if (it.getSeguroItem() == null || it.getSeguroItem().equals((short)0)) {
                    Double valorProduto = it.getVrServico() + it.getVrProduto();
                    if (valorProduto > valorSeguroTotal) {
                        it.setVrSeguro(Double.valueOf(valorSeguroTotal));
                        valorSeguroTotal = 0.0;
                        valorTotalmenteRateado = true;
                    } else {
                        it.setVrSeguro(valorProduto);
                        valorSeguroTotal -= valorProduto.doubleValue();
                    }
                    if (it.getVrSeguro() > 0.0 && valorProduto > 0.0) {
                        it.setPercSeguro(ContatoFormatUtil.arrredondarNumero((Double)(it.getVrSeguro() * 100.0 / valorProduto), (int)4));
                    } else {
                        it.setPercSeguro(Double.valueOf(0.0));
                    }
                }
                --var12_14;
            }
            if (!valorTotalmenteRateado.booleanValue()) {
                throw new ExceptionService("Os valores dos itens n\u00e3o foram suficientes para ratear o seguro.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void ratearDespAcess(List<ItemNotaTerceiros> itens, double valorDespAcess, boolean naoRatearDespAcess) throws ExceptionService {
        double valorTotal = 0.0;
        double valorDespAcessTotal = valorDespAcess;
        for (ItemNotaTerceiros it : itens) {
            if (it.getDespAcessItem() != null && !it.getDespAcessItem().equals((short)0)) continue;
            valorTotal += it.getVrServico() + it.getVrProduto();
        }
        if (valorTotal <= 0.0 && valorDespAcess > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear as despesas acess\u00f3rias.");
        }
        ItemNotaTerceiros lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemNotaTerceiros itemNotaTerceiros : itens) {
            double vlrProduto = itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getVrProduto();
            double valorDespAcessCalc = 0.0;
            double percDespAcessCalc = 0.0;
            if (itemNotaTerceiros.getDespAcessItem() != 1) {
                percDespAcessCalc = valorDespAcess > 0.0 && valorTotal > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorDespAcess / valorTotal * 100.0), (int)4) : 0.0;
                valorDespAcessCalc = ContatoFormatUtil.arrredondarNumero((Double)(vlrProduto * percDespAcessCalc / 100.0), (int)2);
                valorDespTotal += valorDespAcessCalc;
                lastItem = itemNotaTerceiros;
                itemNotaTerceiros.setPercDespAcessoria(Double.valueOf(percDespAcessCalc));
                itemNotaTerceiros.setValorDespAcessoria(Double.valueOf(valorDespAcessCalc));
                continue;
            }
            if (itemNotaTerceiros.getTipoDespAcessoria() == 0) {
                if (!(itemNotaTerceiros.getPercDespAcessoria() > 0.0)) continue;
                itemNotaTerceiros.setValorDespAcessoria(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getPercDespAcessoria() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            itemNotaTerceiros.setValorDespAcessoria(ContatoFormatUtil.arrredondarNumero((Double)itemNotaTerceiros.getValorDespAcessoria(), (int)2));
            if (!(itemNotaTerceiros.getValorDespAcessoria() > 0.0) || !(vlrProduto > 0.0)) continue;
            itemNotaTerceiros.setPercDespAcessoria(ContatoFormatUtil.arrredondarNumero((Double)(itemNotaTerceiros.getValorDespAcessoria() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDespAcess > 0.0) {
            Double vrDespAcess = lastItem.getValorDespAcessoria() + (valorDespAcess - valorDespTotal);
            lastItem.setValorDespAcessoria(vrDespAcess);
            if (lastItem.getValorDespAcessoria() < 0.0) {
                lastItem.setValorDespAcessoria(Double.valueOf(0.0));
                lastItem.setPercDespAcessoria(Double.valueOf(0.0));
                vrDespAcess = Math.abs(vrDespAcess);
                for (ItemNotaTerceiros item : itens) {
                    if (item.getValorDespAcessoria() >= vrDespAcess) {
                        item.setValorDespAcessoria(Double.valueOf(item.getValorDespAcessoria() - vrDespAcess));
                        break;
                    }
                    item.setValorDespAcessoria(Double.valueOf(0.0));
                    vrDespAcess = vrDespAcess - item.getValorDespAcessoria();
                }
            }
        }
        if (naoRatearDespAcess && valorDespAcessTotal > 0.0) {
            void var12_14;
            Boolean valorTotalmenteRateado = false;
            Boolean bl = true;
            for (int i = itens.size() - 1; i >= 0; --i) {
                ItemNotaTerceiros it = itens.get(i);
                if (it.getDespAcessItem() != null && !it.getDespAcessItem().equals((short)0)) continue;
                Boolean bl2 = false;
                Double valorProduto = it.getVrServico() + it.getVrProduto();
                if (valorProduto > valorDespAcessTotal) {
                    it.setValorDespAcessoria(Double.valueOf(valorDespAcessTotal));
                    valorDespAcessTotal = 0.0;
                    valorTotalmenteRateado = true;
                } else {
                    it.setValorDespAcessoria(valorProduto);
                    valorDespAcessTotal -= valorProduto.doubleValue();
                }
                if (it.getValorDespAcessoria() > 0.0 && valorProduto > 0.0) {
                    it.setPercDespAcessoria(ContatoFormatUtil.arrredondarNumero((Double)(it.getValorDespAcessoria() * 100.0 / valorProduto), (int)4));
                    continue;
                }
                it.setPercDespAcessoria(Double.valueOf(0.0));
            }
            if (!valorTotalmenteRateado.booleanValue() && !var12_14.booleanValue()) {
                throw new ExceptionService("Os valores dos itens n\u00e3o foram suficientes para ratear as despesas acessorias.");
            }
        }
    }

    private static void ratearFreteCTRC(List<ItemNotaTerceiros> itens, Double valorFreteCTRC) {
        Double valorTotalProdutos = CalculosImpFiscaisNotaTerceiros.getValorRatFreteCTRC(itens);
        for (ItemNotaTerceiros item : itens) {
            if (Objects.equals(item.getNaoRatearFreteCtrc(), (short)1)) continue;
            valorFreteCTRC = valorFreteCTRC == null ? 0.0 : valorFreteCTRC;
            double aux = 0.0;
            if (item.getVrProduto() > 0.0 && valorTotalProdutos > 0.0) {
                aux = item.getVrProduto() / valorTotalProdutos * valorFreteCTRC;
            }
            item.setVrFreteCtrc(Double.valueOf(aux));
        }
    }

    private static Double getValorRatFreteCTRC(List<ItemNotaTerceiros> itens) {
        double valorTotalProdutos = 0.0;
        for (ItemNotaTerceiros item : itens) {
            if (Objects.equals(item.getNaoRatearFreteCtrc(), (short)1)) continue;
            valorTotalProdutos += item.getVrProduto() + item.getVrServico();
        }
        return valorTotalProdutos;
    }

    private static void ajustarDifVrTotalBCImpostos(ItemNotaLivroFiscal itLF, Double ajuste) {
        Double totBcICms = itLF.getVrIcmsOutros() + itLF.getVrIcmsIsento() + itLF.getVrIcmsTributado();
        Double dif = itLF.getValorTotal() - totBcICms;
        if (Math.abs(dif) < ajuste) {
            if (itLF.getVrIcmsOutros() != 0.0) {
                itLF.setVrIcmsOutros(Double.valueOf(itLF.getVrIcmsOutros() + dif));
                dif = 0.0;
                if (itLF.getVrIcmsOutros() < 0.0) {
                    itLF.setVrIcmsOutros(Double.valueOf(0.0));
                }
            }
            if (itLF.getVrIcmsIsento() > 0.0 && dif != 0.0) {
                itLF.setVrIcmsIsento(Double.valueOf(itLF.getVrIcmsIsento() + dif));
                dif = 0.0;
                if (itLF.getVrIcmsIsento() < 0.0) {
                    itLF.setVrIcmsIsento(Double.valueOf(0.0));
                }
            }
            if (itLF.getVrIcmsTributado() > 0.0 && dif != 0.0) {
                itLF.setVrIcmsTributado(Double.valueOf(itLF.getVrIcmsTributado() + dif));
                if (itLF.getVrIcmsTributado() < 0.0) {
                    itLF.setVrIcmsTributado(Double.valueOf(0.0));
                }
            }
        }
    }

    private static void atualizarValorTransf(ItemNotaTerceiros item, OpcoesImpostos opImpostos) throws ExceptionJEPParser, ExceptionReflection, ExceptionInvalidData {
        if (!ToolMethods.isEquals((Object)item.getItemNotaLivroFiscal().getCfop().getCfopCompra(), (Object)1)) {
            return;
        }
        for (GradeItemNotaTerceiros gr : item.getGrade()) {
            gr.setValorTransfFiscal(gr.getValorCusto());
        }
        if (opImpostos == null) {
            return;
        }
        if (!ToolMethods.isStrWithData((String)opImpostos.getExpressaoAnaliseVrTransfNFT())) {
            return;
        }
        for (GradeItemNotaTerceiros gr : item.getGrade()) {
            String str = ((CompOBSDinamica)Context.get(CompOBSDinamica.class)).build((Object)gr, opImpostos.getExpressaoAnaliseVrTransfNFT(), false);
            Double d = ToolJepExpressionParser.evaluate((String)str, new HashMap());
            gr.setValorTransfFiscal(d);
        }
    }

    private static void atualizarValorCompra(ItemNotaTerceiros item) {
        if (!ToolMethods.isEquals((Object)item.getItemNotaLivroFiscal().getCfop().getCfopCompra(), (Object)1)) {
            return;
        }
        for (GradeItemNotaTerceiros gr : item.getGrade()) {
            Double d = (item.getVrProduto() + item.getVrServico() + item.getItemNotaLivroFiscal().getVrIpiComercio() + item.getItemNotaLivroFiscal().getVrIpiIndustria() + item.getItemNotaLivroFiscal().getVrIpiObservacao() + item.getItemNotaLivroFiscal().getVrIcmsSt()) / (item.getQuantidadeTotal() * gr.getFatorConversao());
            gr.setValorUltPrecoCompra(d);
        }
    }
}

