/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperItemPedido;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculoICMSSaiUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoIPISaiUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

public class CalculosImpFiscaisPedidos {
    private static TLogger logger = TLogger.get(CalculosImpFiscaisPedidos.class);

    public static List calcularImpostosFiscaisItemPedido(List itensPedidos, UnidadeFederativa uf, Empresa emp, Short tipoCalcST, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, Short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionCalculoPisCofins, ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        for (Object o : itensPedidos) {
            ItemPedido i = (ItemPedido)o;
            if (i.getModeloFiscal() == null) continue;
            ItemPedidoFiscal item = i.getItemPedidoFiscal();
            if (item == null) {
                item = new ItemPedidoFiscal();
                i.setItemPedidoFiscal(item);
                item.setItemPedido(i);
            }
            item.setIncidenciaIcms(i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
            item.setIncidenciaIpi(i.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
            item.setIncidenciaPisCofins(i.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
            item.setIncidenciaIcms(i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
            CalculosImpFiscaisPedidos.calcularImpostosFiscaisItemPedido(i, uf, emp, tipoCalcST, cnaeCliente, contribuinteEstado, usarCategoriaST, (short)consumidorFinal, empresaContabilidade, unidadeFatCliente, versaoNFe, opcoesFaturamento);
        }
        return itensPedidos;
    }

    public static void calcularImpostosFiscaisItemPedido(ItemPedido item, UnidadeFederativa ufEmpresa, Empresa emp, Short tipoCalcST, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        if (item.getItemPedidoFiscal() == null) {
            item.setItemPedidoFiscal(new ItemPedidoFiscal());
            item.getItemPedidoFiscal().setItemPedido(item);
        }
        if (item.getModeloFiscal() != null) {
            double vlrTotal = ToolFormatter.arrredondarNumero((Double)(item.getValorUnitario() * item.getQuantidadeTotal()), (int)2);
            CalculosImpFiscaisPedidos.calcularIPI(vlrTotal, item, emp);
            CalculosImpFiscaisPedidos.calcularPisCofins(vlrTotal, item);
            CalculosImpFiscaisPedidos.calcularIcms(vlrTotal, item, ufEmpresa, emp, tipoCalcST, cnaeCliente, contribuinteEstado, usarCategoriaST, consumidorFinal, empresaContabilidade, unidadeFatCliente, versaoNFe, opcoesFaturamento);
            CalculosImpFiscaisPedidos.calcularOutrosImpostos(vlrTotal, item);
            CalculosImpFiscaisPedidos.calcularSuframa(item, unidadeFatCliente.getCliente());
            CalculosImpFiscaisPedidos.calcularValorTotalComImpostos(item);
        }
    }

    private static void calcularIcms(double vlrTotal, ItemPedido item, UnidadeFederativa ufCliente, Empresa empresa, short tipoCalcSt, CNAE cnaeCliente, short contribuinteEstado, short usarCategoriaST, short consumidorFinal, EmpresaContabilidade empresaContabilidade, UnidadeFatCliente unidadeFatCliente, VersaoNFe versaoNFe, OpcoesFaturamento opcoesFaturamento) throws ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound {
        ModeloFiscal modelo = item.getModeloFiscal();
        CalculosImpFiscaisPedidos.procurarAliquotaICMS(item, ufCliente, empresa);
        CalculosImpFiscaisPedidos.procurarPercRedBC(item);
        item.getItemPedidoFiscal().setIncidenciaIcms(item.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        item.getItemPedidoFiscal().setModalidadeIcms(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        item.getItemPedidoFiscal().setModalidadeIcmsSt(item.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
        Date dataEmissao = item.getPedido() != null ? item.getPedido().getDataEmissao() : new Date();
        HashMap h = new CalculoICMSSaiUtilities(modelo.getModeloFiscalIcms().getIncluiSeguro(), modelo.getModeloFiscalIcms().getIncluiFrete(), modelo.getModeloFiscalIcms().getIncluiDespAcess(), modelo.getModeloFiscalIcms().getIncluiDesconto(), tipoCalcSt, empresa, cnaeCliente, contribuinteEstado, modelo.getModeloFiscalIcms().getIncluiSeguroST(), modelo.getModeloFiscalIcms().getIncluiFreteST(), modelo.getModeloFiscalIcms().getIncluiDespAcessST(), modelo.getModeloFiscalIcms().getIncluiDescontoST(), modelo.getModeloFiscalIcms().getIncluiIPIST(), usarCategoriaST, dataEmissao, versaoNFe, opcoesFaturamento).valoresIcmsIcmsST(item.getModeloFiscal().getModeloFiscalIcms(), item.getModeloFiscal().getModeloFiscalIpi(), 0.0, modelo != null ? item.getItemPedidoFiscal().getVrPis() : 0.0, modelo != null ? item.getItemPedidoFiscal().getVrCofins() : 0.0, item.getItemPedidoFiscal().getVrIpiIndustria(), 0.0, item.getItemPedidoFiscal().getAliquotaIcms(), item.getItemPedidoFiscal().getPercReducaoBCIcms(), 0.0, item.getProduto(), item.getQuantidadeTotal(), ufCliente, item.getItemPedidoFiscal().getAliquotaICMSSimples(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, consumidorFinal, contribuinteEstado, empresaContabilidade, unidadeFatCliente, item.getModeloFiscal().getTipoCfop(), 0.0);
        item.getItemPedidoFiscal().setVrBcCalculoIcmsSt((Double)h.get("bcIcmsST"));
        item.getItemPedidoFiscal().setVrBcCalculoIcms((Double)h.get("bcIcms"));
        item.getItemPedidoFiscal().setVrIcmsSt((Double)h.get("valorIcmsSt"));
        item.getItemPedidoFiscal().setVrIcms((Double)h.get("valorIcms"));
        item.getItemPedidoFiscal().setAliquotaICMSSimples((Double)h.get("aliquotaICMSSimples"));
        item.getItemPedidoFiscal().setValorICMSSimples((Double)h.get("valorIcmsSimples"));
        item.getItemPedidoFiscal().setVrIcmsIsento((Double)h.get("icmsIsento"));
        item.getItemPedidoFiscal().setVrIcmsOutros((Double)h.get("icmsOutros"));
        item.getItemPedidoFiscal().setVrIcmsTributado((Double)h.get("icmsTributado"));
        item.getItemPedidoFiscal().setVrIcmsSemAprov((Double)h.get("icmsSemAprov"));
        item.getItemPedidoFiscal().setVrICMSDispensado((Double)h.get("valorIcmsDesonerado"));
        item.getItemPedidoFiscal().setVrNaoTribICMS((Double)h.get("valorNaoTribIcms"));
        item.getItemPedidoFiscal().setDescontoPadraoIcmsST((Double)h.get("descontoPadraoST"));
        item.getItemPedidoFiscal().setIndiceAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
        item.getItemPedidoFiscal().setAliquotaIcmsST((Double)h.get("aliquotaSt"));
        item.getItemPedidoFiscal().setValorFCP((Double)h.get("valorFCP"));
        item.getItemPedidoFiscal().setValorFCPSt((Double)h.get("valorFCPSt"));
        item.getItemPedidoFiscal().setValorFCPStRetido((Double)h.get("valorFCPStRetido"));
        item.getItemPedidoFiscal().setValorBCFCP((Double)h.get("valorBCFCP"));
        item.getItemPedidoFiscal().setValorBCFCPSt((Double)h.get("valorBCFCPSt"));
        item.getItemPedidoFiscal().setValorBCFCPStRetido((Double)h.get("valorBCFCPStRetido"));
        item.getItemPedidoFiscal().setAliquotaFCP((Double)h.get("aliquotaFCP"));
        item.getItemPedidoFiscal().setAliquotaFCPSt((Double)h.get("aliquotaFCPSt"));
        item.getItemPedidoFiscal().setAliquotaFCPStRetido((Double)h.get("aliquotaFCPStRetido"));
        item.getItemPedidoFiscal().setPercentualDiferimento((Double)h.get("percentualDiferimento"));
        item.getItemPedidoFiscal().setValorIcmsDiferimento((Double)h.get("valorIcmsDiferimento"));
        if (h.get("valorBcIcmsUfDest") != null) {
            item.getItemPedidoFiscal().setValorBcIcmsUfDest((Double)h.get("valorBcIcmsUfDest"));
        } else {
            item.getItemPedidoFiscal().setValorBcIcmsUfDest(Double.valueOf(0.0));
        }
        if (h.get("valorIcmsPartilhaRem") != null) {
            item.getItemPedidoFiscal().setValorIcmsPartilhaRem(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaRem")), (int)2));
        } else {
            item.getItemPedidoFiscal().setValorIcmsPartilhaRem(Double.valueOf(0.0));
        }
        if (h.get("valorIcmsPartilhaDest") != null) {
            item.getItemPedidoFiscal().setValorIcmsPartilhaDest(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorIcmsPartilhaDest")), (int)2));
        } else {
            item.getItemPedidoFiscal().setValorIcmsPartilhaDest(Double.valueOf(0.0));
        }
        if (h.get("aliquotaInternaUFDest") != null) {
            item.getItemPedidoFiscal().setAliquotaInternaUFDest((Double)h.get("aliquotaInternaUFDest"));
        } else {
            item.getItemPedidoFiscal().setAliquotaInternaUFDest(Double.valueOf(0.0));
        }
        if (h.get("aliquotaInterestadual") != null) {
            item.getItemPedidoFiscal().setAliquotaInterestadual((Double)h.get("aliquotaInterestadual"));
        } else {
            item.getItemPedidoFiscal().setAliquotaInterestadual(Double.valueOf(0.0));
        }
        if (h.get("percPartilhaIcms") != null) {
            item.getItemPedidoFiscal().setPercPartilhaIcms((Double)h.get("percPartilhaIcms"));
        } else {
            item.getItemPedidoFiscal().setPercPartilhaIcms(Double.valueOf(0.0));
        }
        if (h.get("aliquotaFundoPobreza") != null) {
            item.getItemPedidoFiscal().setAliquotaFundoPobreza((Double)h.get("aliquotaFundoPobreza"));
        } else {
            item.getItemPedidoFiscal().setAliquotaFundoPobreza(Double.valueOf(0.0));
        }
        if (h.get("valorFundoPobreza") != null) {
            item.getItemPedidoFiscal().setValorFundoPobreza(ContatoFormatUtil.arrredondarNumero((Double)((Double)h.get("valorFundoPobreza")), (int)2));
        } else {
            item.getItemPedidoFiscal().setValorFundoPobreza(Double.valueOf(0.0));
        }
    }

    private static void procurarAliquotaICMS(ItemPedido item, UnidadeFederativa ufCliente, Empresa empresa) throws ExceptionService {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        try {
            double alICMS = 0.0;
            if (modeloFiscal.getModeloFiscalIcms().getTipoAliquotaIcms() == 2) {
                alICMS = modeloFiscal.getModeloFiscalIcms().getAliquotaIcms();
            } else if (modeloFiscal.getModeloFiscalIcms().getTipoAliquotaIcms() == 1) {
                alICMS = CalculosImpFiscaisPedidos.getAliquotaICMS(empresa.getPessoa().getEndereco().getCidade().getUf(), ufCliente, item.getProduto());
            }
            item.getItemPedidoFiscal().setAliquotaIcms(Double.valueOf(alICMS));
        }
        catch (ExceptionService ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao procurar a al\u00edquota de ICMS.", ex);
        }
    }

    private static void calcularIPI(double vlrTotal, ItemPedido item, Empresa emp) throws ExceptionCalculoIPI {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (modeloFiscal == null) {
            return;
        }
        item.getItemPedidoFiscal().setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
        Produto produto = item.getProduto();
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)produto, (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
        item.getItemPedidoFiscal().setAliquotaIpi(aliquotaIpi);
        HashMap h = new CalculoIPISaiUtilities(item.getModeloFiscal().getModeloFiscalIpi().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalIpi().getIncluiDesconto()).calcularIpi(item.getModeloFiscal().getModeloFiscalIpi(), produto, item.getItemPedidoFiscal().getAliquotaIpi(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, 0.0, emp);
        item.getItemPedidoFiscal().setVrIpiTributado((Double)h.get("ipiTributado"));
        item.getItemPedidoFiscal().setVrIpiIndustria((Double)h.get("ipiIndustria"));
        item.getItemPedidoFiscal().setVrIpiIsento((Double)h.get("ipiIsento"));
        item.getItemPedidoFiscal().setVrIpiOutros((Double)h.get("ipiOutros"));
    }

    private static void calcularPisCofins(double vlrTotal, ItemPedido item) throws ExceptionCalculoPisCofins {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (modeloFiscal == null) {
            return;
        }
        item.getItemPedidoFiscal().setIncidenciaPisCofins(modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        Produto produto = item.getProduto();
        Short pisCofinsTribQtde = produto.getPisCofinsTributadoQuantidade();
        Double aliquotaPis = 0.0;
        Double aliquotaPisSt = 0.0;
        Double aliquotaCofins = 0.0;
        Double aliquotaCofinsSt = 0.0;
        aliquotaPis = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis() : item.getProduto().getAliquotaPis()) : Double.valueOf(0.0);
        aliquotaPisSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt() : item.getProduto().getAliquotaPisSt()) : Double.valueOf(0.0);
        aliquotaCofins = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins() : item.getProduto().getAliquotaCofins()) : Double.valueOf(0.0);
        aliquotaCofinsSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt() : item.getProduto().getAliquotaCofinsSt()) : Double.valueOf(0.0);
        HashMap h = new CalculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()).calculoPisCofins(modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal(), modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt(), modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal(), modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt(), modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins(), aliquotaPis, aliquotaPisSt, aliquotaCofins, aliquotaCofinsSt, CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, 4, pisCofinsTribQtde, 0.0, 0.0, 0.0, item.getItemPedidoFiscal().getVrIcms(), item.getItemPedidoFiscal().getVrICMSDispensado(), item.getItemPedidoFiscal().getVrIcmsSemAprov(), item.getItemPedidoFiscal().getVrIpiObservacao());
        item.getItemPedidoFiscal().setAliquotaCofins((Double)h.get("aliquotaCofins"));
        item.getItemPedidoFiscal().setVrCofins((Double)h.get("valorCofins"));
        item.getItemPedidoFiscal().setVrBCCofins((Double)h.get("valorBCCofins"));
        item.getItemPedidoFiscal().setAliquotaCofinsSt((Double)h.get("aliquotaCofinsSt"));
        item.getItemPedidoFiscal().setVrCofinsSt((Double)h.get("valorCofinsSt"));
        item.getItemPedidoFiscal().setVrBCCofinsSt((Double)h.get("valorBCCofinsSt"));
        item.getItemPedidoFiscal().setAliquotaPis((Double)h.get("aliquotaPis"));
        item.getItemPedidoFiscal().setAliquotaPisSt((Double)h.get("aliquotaPisSt"));
        item.getItemPedidoFiscal().setVrPisSt((Double)h.get("valorPisSt"));
        item.getItemPedidoFiscal().setVrPis((Double)h.get("valorPis"));
        item.getItemPedidoFiscal().setVrBCPis((Double)h.get("valorBCPis"));
        item.getItemPedidoFiscal().setVrBCPisSt((Double)h.get("valorBCPisSt"));
    }

    private static void calcularOutrosImpostos(double vlrTotal, ItemPedido item) {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (modeloFiscal == null) {
            return;
        }
        Produto produto = item.getProduto();
        HashMap h = CalculoOutrosImpostos.calculoContSoc(modeloFiscal.getTipoContSoc(), produto.getAliquotaContSoc(), produto.getPercRedContSoc(), modeloFiscal.getValorMinimoCSLL(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)4);
        item.getItemPedidoFiscal().setPercRedContSoc((Double)h.get("percRedContSoc"));
        item.getItemPedidoFiscal().setVrContSoc((Double)h.get("valorContSoc"));
        item.getItemPedidoFiscal().setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
        h = CalculoOutrosImpostos.calculoFunrural(modeloFiscal, produto.getAliquotaFunrural(), produto.getPercRedFunrural(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)4);
        item.getItemPedidoFiscal().setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        item.getItemPedidoFiscal().setPercRedFunrural((Double)h.get("percRedFunrural"));
        item.getItemPedidoFiscal().setVrFunrural((Double)h.get("valorFunrural"));
        h = CalculoOutrosImpostos.calculoINSS(modeloFiscal.getTipoINSS(), produto.getAliquotaInss(), produto.getPercRedBCINSS(), 0.0, 0.0, modeloFiscal.getValorMinimoInss(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, (short)4);
        item.getItemPedidoFiscal().setVrInss((Double)h.get("valorInss"));
        item.getItemPedidoFiscal().setPercRedBcInss((Double)h.get("percRedInss"));
        item.getItemPedidoFiscal().setAliquotaInss((Double)h.get("aliquotaInss"));
        h = CalculoOutrosImpostos.calculoIRRF(modeloFiscal.getTipoIRRF(), produto.getAliquotaIrrf(), produto.getPercRedIrrf(), 0.0, modeloFiscal.getValorMinimoIR(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, (short)4);
        item.getItemPedidoFiscal().setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        item.getItemPedidoFiscal().setVrIrrf((Double)h.get("valorIrrf"));
        item.getItemPedidoFiscal().setPercRedFunrural((Double)h.get("percRedIRRF"));
        h = CalculoOutrosImpostos.calculoISS(modeloFiscal.getIssRetido(), produto.getAliquotaIss(), 0.0, 0.0, modeloFiscal.getValorMinimoISS(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, (short)4);
        item.getItemPedidoFiscal().setAliquotaIss((Double)h.get("aliquotaIss"));
        item.getItemPedidoFiscal().setVrIss((Double)h.get("valorIss"));
        h = CalculoOutrosImpostos.calculoLei10833(modeloFiscal, produto.getAliquotaLei10833(), produto.getPercRedLei10833(), 0.0, 0.0, 0.0, 0.0, 0.0, vlrTotal, (short)4);
        item.getItemPedidoFiscal().setPercRedLei10833((Double)h.get("percRedLei10833"));
        item.getItemPedidoFiscal().setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        item.getItemPedidoFiscal().setVrLei10833((Double)h.get("valorLei10833"));
        h = CalculoOutrosImpostos.calculoOutros(modeloFiscal.getTipoOutros(), produto.getAliquotaOutros(), produto.getPercRedOutros(), 0.0, modeloFiscal.getValorMinimoOutros(), CalculosImpFiscaisPedidos.getValorFreteItem(item), CalculosImpFiscaisPedidos.getValorSeguroItem(item), CalculosImpFiscaisPedidos.getValorDespAcssItem(item), CalculosImpFiscaisPedidos.getValorDescontoItem(item), vlrTotal, (short)4);
        item.getItemPedidoFiscal().setAliquotaOutros((Double)h.get("aliquotaOutros"));
        item.getItemPedidoFiscal().setPercRedOutros((Double)h.get("percRedOutros"));
        item.getItemPedidoFiscal().setVrOutros((Double)h.get("valorOutros"));
    }

    public static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws ExceptionService {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return CalculosImpFiscaisPedidos.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws ExceptionService {
        CoreRequestContext h = new CoreRequestContext();
        h.setAttribute("ufOrigem", ufOrigem);
        h.setAttribute("ufDestino", ufDestino);
        UnidadeFederativaOrigDest found = (UnidadeFederativaOrigDest)CoreServiceFactory.getServiceUF().execute(h, "findAliquotaIcmsInterUF");
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private static void calcularValorTotalComImpostos(ItemPedido item) {
        Double valorTotalComImpostos = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
        if (item.getItemPedidoFiscal() != null) {
            valorTotalComImpostos = valorTotalComImpostos + (item.getItemPedidoFiscal().getVrIpiIndustria() + item.getItemPedidoFiscal().getVrIcmsSt() + item.getItemPedidoFiscal().getVrFunrural() + item.getItemPedidoFiscal().getVrLei10833() + item.getItemPedidoFiscal().getVrOutros() + item.getItemPedidoFiscal().getVrDevICMSST() + item.getItemPedidoFiscal().getValorFCPSt() - item.getValorDescontoTrib());
            if (item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && item.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
                valorTotalComImpostos = valorTotalComImpostos - item.getItemPedidoFiscal().getVrICMSDispensado();
            }
        }
        item.setValorTotalComImpostos(ContatoFormatUtil.arrredondarNumero((Double)valorTotalComImpostos, (int)2));
    }

    private static void procurarPercRedBC(ItemPedido item) {
        Double percRedBCICMS = 0.0;
        if (item.getModeloFiscal() != null) {
            ModeloFiscal modelo = item.getModeloFiscal();
            percRedBCICMS = ToolMethods.isEquals((Object)modelo.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2) ? modelo.getModeloFiscalIcms().getReducaoBaseCalcIcms() : item.getProduto().getReducaoBaseCalcIcms();
        }
        item.getItemPedidoFiscal().setPercReducaoBCIcms(percRedBCICMS);
    }

    private static double getValorFreteItem(ItemPedido item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
    }

    private static double getValorDescontoItem(ItemPedido item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado() + item.getValorDescontoPromocional()), (int)2);
    }

    private static double getValorDespAcssItem(ItemPedido item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
    }

    private static double getValorSeguroItem(ItemPedido item) {
        return ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
    }

    private static void calcularSuframa(ItemPedido item, Cliente cliente) {
        new HelperItemPedido().calcularSuframa(item, cliente);
    }
}

