/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.calculoimpostos;

import com.touchcomp.basementor.model.vo.GrupoServicoRPS;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorservice.service.impl.impostos.cbs.calculo.SCompCBScalculo;
import com.touchcomp.basementorservice.service.impl.impostos.ibs.calculo.SCompIBScalculo;
import java.text.DecimalFormat;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

public class CalculosImpFiscaisRPS {
    public static void calcularImpFiscaisRPS(Rps rps) throws ExceptionCalculoPisCofins, ExceptionImpostoCbsIbs {
        if (rps.getModeloRps() == null) {
            return;
        }
        CalculosImpFiscaisRPS.calcularBCOutrosValores(rps);
        CalculosImpFiscaisRPS.setValorContSocial(rps);
        CalculosImpFiscaisRPS.setValorPisCofins(rps);
        CalculosImpFiscaisRPS.setValorInss(rps);
        CalculosImpFiscaisRPS.setValorIRRF(rps);
        CalculosImpFiscaisRPS.setValorIss(rps);
        CalculosImpFiscaisRPS.setValorOutros(rps);
        rps.setValorLiquidoNfse(Double.valueOf(rps.getValorServico() - rps.getValorPisST() - rps.getValorCofinsST() - rps.getValorInss() - rps.getValorIr() - rps.getValorContSoc() - rps.getValorOutros() - rps.getValorIssRetido() - rps.getValorDescontoIncondicionado() - rps.getValorDescontoCondicionado()));
        new SCompCBScalculo().calcular(rps);
        new SCompIBScalculo().calcular(rps);
        rps.setValorTotalDoc(Double.valueOf(rps.getValorLiquidoNfse() + rps.getImpostoCBS().getValorCBS() + rps.getImpostoIBS().getValorIBSMun() + rps.getImpostoIBS().getValorIBSUF()));
        CalculosImpFiscaisRPS.setOBSTributos(rps);
    }

    private static void setValorContSocial(Rps rps) {
        if (rps.getModeloRps() != null) {
            HashMap h = CalculoOutrosImpostos.calculoContSoc(rps.getModeloRps().getTipoContSoc(), rps.getAliquotaContSoc(), rps.getModeloRps().getPercRedCSLL(), rps.getModeloRps().getValorMinimoCSLL(), rps.getValorContSoc(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcCsll(), rps.getModoArredondamento());
            rps.setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
            rps.setValorContSoc((Double)h.get("valorContSoc"));
        }
    }

    private static void setValorPisCofins(Rps rps) throws ExceptionCalculoPisCofins {
        HashMap h = new CalculoPisCofins(0, 0, 0, 0, rps.getModeloRps().getValorMinimoCofins(), rps.getModeloRps().getValorMinimoPis(), 0, 0, 0, 0).calculoPisCofins(CalculosImpFiscaisRPS.getCalcularPisCofinsNormal(rps.getModeloRps().getTipoPis()), CalculosImpFiscaisRPS.getCalcularPisCofinsSt(rps.getModeloRps().getTipoPis()), CalculosImpFiscaisRPS.getCalcularPisCofinsNormal(rps.getModeloRps().getTipoCofins()), CalculosImpFiscaisRPS.getCalcularPisCofinsSt(rps.getModeloRps().getTipoCofins()), rps.getModeloRps().getIncidenciaPisCofins(), rps.getAliquotaPis(), rps.getAliquotaPis(), rps.getAliquotaCofins(), rps.getAliquotaCofins(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcCofins(), 4, (short)0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        rps.setAliquotaPis(Double.valueOf((Double)h.get("aliquotaPis") + (Double)h.get("aliquotaPisSt")));
        rps.setAliquotaCofins(Double.valueOf((Double)h.get("aliquotaCofins") + (Double)h.get("aliquotaCofinsSt")));
        rps.setValorPis((Double)h.get("valorPis"));
        rps.setValorPisST((Double)h.get("valorPisSt"));
        rps.setValorCofinsST((Double)h.get("valorCofinsSt"));
        rps.setValorCofins((Double)h.get("valorCofins"));
    }

    private static void setValorInss(Rps rps) {
        HashMap h = CalculoOutrosImpostos.calculoINSS(rps.getModeloRps().getTipoINSS(), rps.getAliquotaInss(), rps.getModeloRps().getPercRedInss(), rps.getValorInss(), 0.0, rps.getModeloRps().getValorMinimoInss(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcInss(), rps.getModoArredondamento());
        rps.setAliquotaInss((Double)h.get("aliquotaInss"));
        rps.setBcInss((Double)h.get("BCINSS"));
        rps.setValorInss(Double.valueOf((Double)h.get("valorInss") + (Double)h.get("valorInssNaoRetido")));
    }

    private static void setValorIRRF(Rps rps) {
        HashMap h = CalculoOutrosImpostos.calculoIRRF(rps.getModeloRps().getTipoIRRF(), rps.getAliquotaIr(), 0.0, rps.getValorIr(), rps.getModeloRps().getValorMinimoIR(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcIr(), rps.getModoArredondamento());
        rps.setAliquotaIr((Double)h.get("aliquotaIrrf"));
        rps.setValorIr((Double)h.get("valorIrrf"));
    }

    private static void setValorIss(Rps rps) {
        HashMap h = CalculoOutrosImpostos.calculoISS(rps.getTipoIss(), rps.getAliquotaIss(), rps.getModeloRps().getPercRedIss(), rps.getValorIss(), rps.getModeloRps().getValorMinimoISS(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcIss(), rps.getModoArredondamento());
        rps.setAliquotaIss((Double)h.get("aliquotaIss"));
        rps.setBcIss((Double)h.get("bcIss"));
        if (h.get("valorDeducaoISS") != null) {
            rps.setValorDeducoes((Double)h.get("valorDeducaoISS"));
        }
        if (rps.getTipoIss() == 1) {
            rps.setValorIssRetido((Double)h.get("valorIss"));
            rps.setValorIss(Double.valueOf(0.0));
        } else {
            rps.setValorIss((Double)h.get("valorIss"));
            rps.setValorIssRetido(Double.valueOf(0.0));
        }
    }

    private static void setValorOutros(Rps rps) {
        HashMap h = CalculoOutrosImpostos.calculoOutros(rps.getModeloRps().getTipoOutros(), rps.getAliquotaOutros(), 0.0, rps.getValorOutros(), rps.getModeloRps().getValorMinimoOutros(), 0.0, 0.0, 0.0, rps.getValorDescontoCondicionado() + rps.getValorDescontoIncondicionado(), rps.getBcOutros(), rps.getModoArredondamento());
        rps.setAliquotaOutros((Double)h.get("aliquotaOutros"));
        rps.setValorOutros((Double)h.get("valorOutros"));
    }

    private static void calcularBCOutrosValores(Rps rps) {
        Double vlr = 0.0;
        Double bcInss = 0.0;
        Double bcIss = 0.0;
        Double bcPis = 0.0;
        Double bcCofins = 0.0;
        Double bcIr = 0.0;
        Double bcCsll = 0.0;
        Double bcOutros = 0.0;
        for (ItemServicoRPSRPS it : rps.getItensRps()) {
            vlr = vlr + it.getValor();
            if (it.getIncidirCSLL() == 1) {
                bcCsll = bcCsll + it.getValor();
            }
            if (it.getIncidirCofins() == 1) {
                bcCofins = bcCofins + it.getValor();
            }
            if (it.getIncidirIR() == 1) {
                bcIr = bcIr + it.getValor();
            }
            if (it.getIncidirISS() == 1) {
                bcIss = bcIss + it.getValor();
            }
            if (it.getIncidirInss() == 1) {
                bcInss = bcInss + it.getValor();
            }
            if (it.getIncidirPis() == 1) {
                bcPis = bcPis + it.getValor();
            }
            if (it.getIncidirOutros() != 1) continue;
            bcOutros = bcOutros + it.getValor();
        }
        rps.setValorServico(vlr);
        rps.setValorDescontoIncondicionado(Double.valueOf(rps.getPercDescontoIncondicionado() / 100.0 * rps.getValorServico()));
        double vrRed = rps.getValorDescontoIncondicionado() + rps.getValorDescontoCondicionado();
        if (rps.getModeloRps().getIncidirDescCofins() == 1) {
            rps.setBcCofins(Double.valueOf(bcCofins - vrRed));
        } else {
            rps.setBcCofins(bcCofins);
        }
        if (rps.getModeloRps().getIncidirDescCSLL() == 1) {
            rps.setBcCsll(Double.valueOf(bcCsll - vrRed));
        } else {
            rps.setBcCsll(bcCsll);
        }
        if (rps.getModeloRps().getIncidirDescIR() == 1) {
            rps.setBcIr(Double.valueOf(bcIr - vrRed));
        } else {
            rps.setBcIr(bcIr);
        }
        if (rps.getModeloRps().getIncidirDescISS() == 1) {
            rps.setBcIss(Double.valueOf(bcIss - vrRed));
        } else {
            rps.setBcIss(bcIss);
        }
        if (rps.getModeloRps().getIncidirDescInss() == 1) {
            rps.setBcInss(Double.valueOf(bcInss - vrRed));
        } else {
            rps.setBcInss(bcInss);
        }
        if (rps.getModeloRps().getIncidirDescOutros() == 1) {
            rps.setBcOutros(Double.valueOf(bcOutros - vrRed));
        } else {
            rps.setBcOutros(bcOutros);
        }
        if (rps.getModeloRps().getIncidirDescPis() == 1) {
            rps.setBcPis(Double.valueOf(bcPis - vrRed));
        } else {
            rps.setBcPis(bcPis);
        }
        rps.setValorBaseCalculo(Double.valueOf(vlr - vrRed));
    }

    private static void setOBSTributos(Rps rps) {
        Double valorTotal = rps.getValorServico();
        GrupoServicoRPS grupoServRPS = rps.getServicoRPS().getGrupoServicoRPS();
        DecimalFormat df = new DecimalFormat("#,###0.00");
        Double valorPagoFederal = valorTotal / 100.0 * grupoServRPS.getTaxaFederal();
        Double valorPagoMunicipal = valorTotal / 100.0 * grupoServRPS.getTaxaMunicipal();
        String msg = "Tributacao aproximada R$: " + df.format(valorPagoFederal) + " Federal (" + grupoServRPS.getTaxaFederal() + " %) e " + df.format(valorPagoMunicipal) + " Municipal (" + grupoServRPS.getTaxaMunicipal() + " %) - Fonte: IBPT";
        rps.setDescricaoTributosRps(msg);
        rps.setDescricaoTributosRps(msg);
        rps.setValorTributacaoFederal(valorPagoFederal);
        rps.setValorTributacaoMunicipal(valorPagoMunicipal);
        rps.setTaxaTributacaoFederal(grupoServRPS.getTaxaFederal());
        rps.setTaxaTributacaoMunicipal(grupoServRPS.getTaxaMunicipal());
        rps.setCodigoTributacaoServ(grupoServRPS.getCodigoTributos());
    }

    private static Short getCalcularPisCofinsNormal(Short tipoPis) {
        if (tipoPis.equals(Short.valueOf("0"))) {
            return (short)1;
        }
        return (short)0;
    }

    private static Short getCalcularPisCofinsSt(Short tipoPis) {
        if (tipoPis.equals(Short.valueOf("1"))) {
            return (short)1;
        }
        return (short)0;
    }
}

