/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.camposdinamicos;

import java.util.LinkedList;
import java.util.List;
import mentorcore.tools.DateUtil;

public class UtilityCamposDinamicos {
    public List getListTiposCampos() {
        LinkedList<TipoCampo> l = new LinkedList<TipoCampo>();
        l.add(new TipoCampo("Texto", (short)1));
        l.add(new TipoCampo("Inteiro", (short)3));
        l.add(new TipoCampo("Inteiro Pequeno", (short)6));
        l.add(new TipoCampo("Inteiro Long", (short)5));
        l.add(new TipoCampo("Decimal", (short)4));
        l.add(new TipoCampo("Data", (short)2));
        return l;
    }

    public Object convertToValue(String value, Short codigo) {
        if (value != null && !value.isEmpty()) {
            if (codigo.equals((short)2)) {
                return DateUtil.strToDate(value);
            }
            if (codigo.equals((short)4)) {
                return new Double(value);
            }
            if (codigo.equals((short)3)) {
                return new Integer(value);
            }
            if (codigo.equals((short)5)) {
                return new Long(value);
            }
            if (codigo.equals((short)6)) {
                return new Short(value);
            }
        }
        return value;
    }

    public static class TipoCampo {
        private String nome;
        private short tipo;

        public TipoCampo(String nome, Short tipo) {
            this.nome = nome;
            this.tipo = tipo;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TipoCampo) {
                return ((TipoCampo)obj).getTipo() == this.getTipo();
            }
            if (obj instanceof Short) {
                return ((Short)obj).shortValue() == this.getTipo();
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + this.getTipo();
            return hash;
        }

        public String getNome() {
            return this.nome;
        }

        public short getTipo() {
            return this.tipo;
        }

        public String toString() {
            return this.nome;
        }
    }
}

