/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.condicoespagamento;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorspringcontext.Context;

public class UtilityCondicoesPagamento {
    public Double calcularValorTotalMajorado(Double valorTotalNota, CondicoesPagamento condicoesPagamento, String parcelasMut) {
        if (condicoesPagamento == null) {
            return valorTotalNota;
        }
        if (condicoesPagamento.getMajoracaoPreco() == null || condicoesPagamento.getMajoracaoPreco() <= 0.0) {
            return valorTotalNota;
        }
        if (condicoesPagamento.getCondMutante() != null && condicoesPagamento.getCondMutante() == 1) {
            if (condicoesPagamento.getMutanteFixa() != null && condicoesPagamento.getMutanteFixa() == 1) {
                parcelasMut = condicoesPagamento.getParcelasMutante();
            }
            int nrDiasMedios = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).calcularNrDiasMedios(condicoesPagamento, parcelasMut);
            double vlrMajorado = valorTotalNota * (condicoesPagamento.getMajoracaoPreco() / 100.0) / 30.0 * (double)nrDiasMedios;
            return vlrMajorado + valorTotalNota;
        }
        int numParc = condicoesPagamento.getNumeroParcelas();
        if (condicoesPagamento.getEntrada() != null && condicoesPagamento.getEntrada() == 1 && numParc > 1) {
            --numParc;
        }
        if (numParc > 0) {
            int prazo = 0;
            for (int i = 1; i <= numParc; ++i) {
                prazo += i * condicoesPagamento.getNumeroDiasVencimento();
            }
            double percReaj = condicoesPagamento.getMajoracaoPreco() / 30.0 * (double)(prazo / numParc);
            valorTotalNota = valorTotalNota + percReaj / 100.0 * valorTotalNota;
        }
        return valorTotalNota;
    }

    public Double calcularValorComissaoMinorado(double percComissao, CondicoesPagamento condicoesPagamento, String parcelas) {
        if (condicoesPagamento.getMinoracaoComissao() == null || condicoesPagamento.getMinoracaoComissao() <= 0.0) {
            return percComissao;
        }
        if (condicoesPagamento.getCondMutante() != null && condicoesPagamento.getCondMutante() == 1) {
            int nrDiasMedios = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).calcularNrDiasMedios(condicoesPagamento, parcelas);
            double percComissaoMinorado = percComissao * condicoesPagamento.getMinoracaoComissao() / 30.0 * ((double)nrDiasMedios / 100.0);
            return percComissao - percComissaoMinorado;
        }
        int numParc = condicoesPagamento.getNumeroParcelas();
        if (condicoesPagamento.getEntrada() != null && condicoesPagamento.getEntrada() == 1) {
            --numParc;
        }
        if (numParc > 0) {
            int prazo = 0;
            for (int i = 1; i <= numParc; ++i) {
                prazo += i * condicoesPagamento.getNumeroDiasVencimento();
            }
            double percReaj = condicoesPagamento.getMinoracaoComissao() / 30.0 * (double)(prazo / numParc);
            if ((percComissao -= percComissao * (percReaj / 100.0)) < 0.0) {
                percComissao = 0.0;
            }
        }
        return percComissao;
    }
}

