/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.cotacaocompras;

import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperFornecedorItemCotCompra;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculoICMSEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoIPIEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

public class UtilityCalculosImpostosFiscaisCotacao {
    public void calcularImpostosFiscaisFornecedorItemCotacaoCompra(List<FornecedorItemCotacaoCompra> itens, UnidadeFederativa unidadeFederativaEmpresa, GradeCor gradeCor, Double quantidade, Double fatorConversao, EmpresaContabilidade empresaContabilidade, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws ExceptionService, ExceptionCalculoPisCofins, ExceptionCalculoIPI, ExceptionCalculoICMS {
        if (itens != null) {
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itens) {
                if (fornecedorItemCotacaoCompra.getModeloFiscal() == null) {
                    throw new ExceptionService("Fornecedor/Item sem modelo fiscal " + String.valueOf(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor()) + "/" + gradeCor.getProdutoGrade().getProduto().getNome() + ".\nPrimeiro informe o Modelo Fiscal para esse Item!");
                }
                this.calcularImpostosFiscaisFornecedorItemCotacaoCompra(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), unidadeFederativaEmpresa, gradeCor, quantidade, fatorConversao, empresaContabilidade, empresa, opcoes);
            }
        }
    }

    public void calcularImpostosFiscaisFornecedorItemCotacaoCompra(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, UnidadeFatFornecedor fornecedor, UnidadeFederativa unidadeFederativaEmpresa, GradeCor gradeCor, Double quantidade, Double fatorConversao, EmpresaContabilidade empresaContabilidade, Empresa empresa, OpcoesCompraSuprimentos opcoes) throws ExceptionService, ExceptionCalculoPisCofins, ExceptionCalculoIPI, ExceptionCalculoICMS {
        if (fornecedorItemCotacaoCompra.getValorUnitario() <= 0.0) {
            fornecedorItemCotacaoCompra.setValidado(Short.valueOf((short)0));
            return;
        }
        FornecedorItemCotacaoCompraLivroFiscal fornecedorItemCotacaoCompraLivroFiscal = fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal();
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        if (modeloFiscal == null) {
            try {
                modeloFiscal = this.getModeloFiscal(fornecedorItemCotacaoCompra, empresa);
                fornecedorItemCotacaoCompra.setModeloFiscal(modeloFiscal);
            }
            catch (ExceptionObjNotFound ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
            }
        }
        if (modeloFiscal == null) {
            return;
        }
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        this.setInfoEstatisticasCusto(fornecedorItemCotacaoCompra, empresaContabilidade.getEmpresa(), opcoes);
        if (fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() == null) {
            fornecedorItemCotacaoCompra.setFornecedorItemCotacaoCompraLivroFiscal(new FornecedorItemCotacaoCompraLivroFiscal());
        }
        if (fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().getCfop() == null && fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null && fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra() != null) {
            Cfop c = this.getCfop(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra().getEmpresa());
            fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().setCfop(c);
        }
        Double quantidadeTotal = quantidade;
        Double valorProduto = quantidadeTotal * fornecedorItemCotacaoCompra.getValorUnitario();
        if (fornecedorItemCotacaoCompra.getHabilitarPercentualDesconto() == 1) {
            fornecedorItemCotacaoCompra.setValorDesconto(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualDesconto() / 100.0 * valorProduto));
        } else if (valorProduto > 0.0) {
            fornecedorItemCotacaoCompra.setPercentualDesconto(Double.valueOf(fornecedorItemCotacaoCompra.getValorDesconto() * 100.0 / valorProduto));
        }
        if (fornecedorItemCotacaoCompra.getHabilitarPercentualDespesasAcessorias() == 1) {
            fornecedorItemCotacaoCompra.setValorDespesasAcessorias(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualDespesasAcessorias() / 100.0 * valorProduto));
        } else if (valorProduto > 0.0) {
            fornecedorItemCotacaoCompra.setPercentualDespesasAcessorias(Double.valueOf(fornecedorItemCotacaoCompra.getValorDespesasAcessorias() * 100.0 / valorProduto));
        }
        if (fornecedorItemCotacaoCompra.getHabilitarPercentualFrete() == 1) {
            fornecedorItemCotacaoCompra.setValorFrete(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualFrete() / 100.0 * valorProduto));
        } else if (valorProduto > 0.0) {
            fornecedorItemCotacaoCompra.setPercentualFrete(Double.valueOf(fornecedorItemCotacaoCompra.getValorFrete() * 100.0 / valorProduto));
        }
        if (fornecedorItemCotacaoCompra.getHabilitarPercentualSeguro() == 1) {
            fornecedorItemCotacaoCompra.setValorSeguro(Double.valueOf(fornecedorItemCotacaoCompra.getPercentualSeguro() / 100.0 * valorProduto));
        } else if (valorProduto > 0.0) {
            fornecedorItemCotacaoCompra.setPercentualSeguro(Double.valueOf(fornecedorItemCotacaoCompra.getValorSeguro() * 100.0 / valorProduto));
        }
        Double baseCalculoGeral = fornecedorItemCotacaoCompra.getValorDesconto() * -1.0 + fornecedorItemCotacaoCompra.getValorDespesasAcessorias() + fornecedorItemCotacaoCompra.getValorFrete() + fornecedorItemCotacaoCompra.getValorSeguro();
        if (produto.getAliquotaIss() > 0.0) {
            fornecedorItemCotacaoCompraLivroFiscal.setValorIrrf(Double.valueOf(produto.getAliquotaIrrf() / 100.0 * baseCalculoGeral));
            fornecedorItemCotacaoCompraLivroFiscal.setValorInss(Double.valueOf(produto.getAliquotaInss() / 100.0 * baseCalculoGeral));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIss(Double.valueOf(produto.getAliquotaIss() / 100.0 * baseCalculoGeral));
            fornecedorItemCotacaoCompraLivroFiscal.setAliquotaIcms(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setAliquotaIpi(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorBaseCalculoIcmsSt(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorDiferencaAliquota(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcms(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsIsento(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsOutros(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsSemAproveitamento(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsSt(Double.valueOf(0.0));
            fornecedorItemCotacaoCompraLivroFiscal.setValorIcmsTributado(Double.valueOf(0.0));
        }
        baseCalculoGeral = baseCalculoGeral + fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal;
        this.valoresIpiItemCotacao(modeloFiscal, fornecedorItemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, produto, fornecedor, quantidadeTotal);
        this.valoresIcmsIcmsSTItemCotacao(modeloFiscal, fornecedor, fornecedorItemCotacaoCompra, baseCalculoGeral, produto, fornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf(), unidadeFederativaEmpresa, fornecedorItemCotacaoCompraLivroFiscal, quantidadeTotal, empresaContabilidade);
        this.calculoOutrosImpostos(fornecedorItemCotacaoCompraLivroFiscal, fornecedorItemCotacaoCompra, baseCalculoGeral, (short)4, produto, quantidadeTotal);
        fornecedorItemCotacaoCompraLivroFiscal.setValorTotal(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal + fornecedorItemCotacaoCompra.getValorFrete() - fornecedorItemCotacaoCompra.getValorDesconto() + fornecedorItemCotacaoCompra.getValorSeguro() + fornecedorItemCotacaoCompra.getValorDespesasAcessorias() + fornecedorItemCotacaoCompraLivroFiscal.getValorIpiIndustria() + fornecedorItemCotacaoCompraLivroFiscal.getValorIpiObservacao() + fornecedorItemCotacaoCompraLivroFiscal.getValorIcmsSt() + fornecedorItemCotacaoCompraLivroFiscal.getValorFunrural() + fornecedorItemCotacaoCompraLivroFiscal.getValorLei10833() + fornecedorItemCotacaoCompraLivroFiscal.getValorIrrf() + fornecedorItemCotacaoCompraLivroFiscal.getValorOutros()));
        this.calcularDiferencaAliquota(modeloFiscal, fornecedor.getPessoa().getEndereco().getCidade().getUf(), unidadeFederativaEmpresa, fornecedorItemCotacaoCompraLivroFiscal, produto, fornecedorItemCotacaoCompra, quantidadeTotal);
        this.atualizarGrades(fornecedorItemCotacaoCompra, fornecedorItemCotacaoCompraLivroFiscal, modeloFiscal, quantidade, fatorConversao);
        if (fornecedorItemCotacaoCompra.getValorCusto() > 0.0 && fornecedorItemCotacaoCompra.getValorUnitario() > 0.0) {
            fornecedorItemCotacaoCompra.setValidado(Short.valueOf((short)1));
        }
    }

    private ModeloFiscal getModeloFiscal(FornecedorItemCotacaoCompra fornecedorItem, Empresa empresa) throws ExceptionObjNotFound {
        return new HelperFornecedorItemCotCompra().build(fornecedorItem).getModeloFiscal(empresa);
    }

    private void calculoOutrosImpostos(FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double baseCalculoGeral, Short modoArredondamento, Produto produto, Double quantidadeTotal) throws ExceptionCalculoPisCofins {
        ModeloFiscal modeloFiscal = fornecedorItemCotacaoCompra.getModeloFiscal();
        Double aliquotaPis = 0.0;
        Double aliquotaPisSt = 0.0;
        Double aliquotaCofins = 0.0;
        Double aliquotaCofinsSt = 0.0;
        aliquotaPis = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis() : produto.getAliquotaPis()) : Double.valueOf(0.0);
        aliquotaPisSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt() : produto.getAliquotaPisSt()) : Double.valueOf(0.0);
        aliquotaCofins = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins() : produto.getAliquotaCofins()) : Double.valueOf(0.0);
        aliquotaCofinsSt = modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1) ? (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue()) ? modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt() : produto.getAliquotaCofinsSt()) : Double.valueOf(0.0);
        HashMap h = new CalculoPisCofins(fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()).calculoPisCofins(fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt(), fornecedorItemCotacaoCompra.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins(), aliquotaPis, aliquotaPisSt, aliquotaCofins, aliquotaCofinsSt, fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, modoArredondamento.shortValue(), produto.getPisCofinsTributadoQuantidade(), quantidadeTotal, 0.0, 0.0, itemCotacaoCompraLivroFiscal.getValorIcms(), itemCotacaoCompraLivroFiscal.getValorIcmsDispensado(), itemCotacaoCompraLivroFiscal.getValorIcmsSemAproveitamento(), itemCotacaoCompraLivroFiscal.getValorIpiObservacao());
        itemCotacaoCompraLivroFiscal.setAliquotaPis((Double)h.get("aliquotaPis"));
        itemCotacaoCompraLivroFiscal.setAliquotaCofins((Double)h.get("aliquotaCofins"));
        itemCotacaoCompraLivroFiscal.setValorPis((Double)h.get("valorPis"));
        itemCotacaoCompraLivroFiscal.setValorCofins((Double)h.get("valorCofins"));
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoCofins((Double)h.get("valorBCCofins"));
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoPis((Double)h.get("valorBCPis"));
        itemCotacaoCompraLivroFiscal.setAliquotaPisSt((Double)h.get("aliquotaPisSt"));
        itemCotacaoCompraLivroFiscal.setAliquotaCofinsSt((Double)h.get("aliquotaCofinsSt"));
        itemCotacaoCompraLivroFiscal.setValorPisSt((Double)h.get("valorPisSt"));
        itemCotacaoCompraLivroFiscal.setValorCofinsSt((Double)h.get("valorCofinsSt"));
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoCofinsSt((Double)h.get("valorBCCofinsSt"));
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoPisSt((Double)h.get("valorBCPisSt"));
        h = CalculoOutrosImpostos.calculoContSoc(fornecedorItemCotacaoCompra.getModeloFiscal().getTipoContSoc(), produto.getAliquotaContSoc(), produto.getPercRedContSoc(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoCSLL(), itemCotacaoCompraLivroFiscal.getValorContribuicaoSocial(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaContribuicaoSocial((Double)h.get("aliquotaContSoc"));
        itemCotacaoCompraLivroFiscal.setValorContribuicaoSocial((Double)h.get("valorContSoc"));
        h = CalculoOutrosImpostos.calculoFunrural(fornecedorItemCotacaoCompra.getModeloFiscal(), produto.getAliquotaFunrural(), produto.getPercRedFunrural(), itemCotacaoCompraLivroFiscal.getValorFunrural(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        itemCotacaoCompraLivroFiscal.setValorFunrural((Double)h.get("valorFunrural"));
        h = CalculoOutrosImpostos.calculoLei10833(fornecedorItemCotacaoCompra.getModeloFiscal(), produto.getAliquotaLei10833(), produto.getPercRedLei10833(), itemCotacaoCompraLivroFiscal.getValorLei10833(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        itemCotacaoCompraLivroFiscal.setValorLei10833((Double)h.get("valorLei10833"));
        h = CalculoOutrosImpostos.calculoINSS(fornecedorItemCotacaoCompra.getModeloFiscal().getTipoINSS(), produto.getAliquotaInss(), produto.getPercRedBCINSS(), itemCotacaoCompraLivroFiscal.getValorInss(), 0.0, fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoInss(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaInss((Double)h.get("aliquotaInss"));
        itemCotacaoCompraLivroFiscal.setValorInss((Double)h.get("valorInss"));
        itemCotacaoCompraLivroFiscal.setPercentualReducaoBaseCalculoInss((Double)h.get("percRedInss"));
        h = CalculoOutrosImpostos.calculoIRRF(fornecedorItemCotacaoCompra.getModeloFiscal().getTipoIRRF(), produto.getAliquotaIrrf(), produto.getPercRedIrrf(), itemCotacaoCompraLivroFiscal.getValorIrrf(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoIR(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        itemCotacaoCompraLivroFiscal.setValorIrrf((Double)h.get("valorIrrf"));
        h = CalculoOutrosImpostos.calculoISS(fornecedorItemCotacaoCompra.getModeloFiscal().getIssRetido(), produto.getAliquotaIss(), 0.0, itemCotacaoCompraLivroFiscal.getValorIss(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoISS(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaIss((Double)h.get("aliquotaIss"));
        itemCotacaoCompraLivroFiscal.setValorIss((Double)h.get("valorIss"));
        h = CalculoOutrosImpostos.calculoOutros(fornecedorItemCotacaoCompra.getModeloFiscal().getTipoOutros(), produto.getAliquotaOutros(), produto.getPercRedOutros(), itemCotacaoCompraLivroFiscal.getValorOutros(), fornecedorItemCotacaoCompra.getModeloFiscal().getValorMinimoOutros(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaOutros((Double)h.get("aliquotaOutros"));
        itemCotacaoCompraLivroFiscal.setValorOutros((Double)h.get("valorOutros"));
        h = CalculoOutrosImpostos.calculoSestSenat(fornecedorItemCotacaoCompra.getModeloFiscal(), produto.getPercSestSenat(), produto.getPercRedSestSenat(), itemCotacaoCompraLivroFiscal.getValorSestSenat(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, (short)6);
        itemCotacaoCompraLivroFiscal.setAliquotaSestSenat((Double)h.get("aliquotaSestSenat"));
        itemCotacaoCompraLivroFiscal.setValorSestSenat((Double)h.get("valorSestSenat"));
        itemCotacaoCompraLivroFiscal.setPercentualReducaoSestSenat((Double)h.get("percRedSestSenat"));
    }

    private void atualizarGrades(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, ModeloFiscal modeloFiscal, Double quantidadeTotal, Double fatorConversao) {
        fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal - fornecedorItemCotacaoCompra.getValorDesconto() + fornecedorItemCotacaoCompra.getValorFrete() + fornecedorItemCotacaoCompra.getValorSeguro() + fornecedorItemCotacaoCompra.getValorDespesasAcessorias() + itemCotacaoCompraLivroFiscal.getValorIcmsSt() + itemCotacaoCompraLivroFiscal.getValorDiferencaAliquota() - itemCotacaoCompraLivroFiscal.getValorCofins() - itemCotacaoCompraLivroFiscal.getValorPis() + itemCotacaoCompraLivroFiscal.getValorIpiObservacao() - itemCotacaoCompraLivroFiscal.getValorIpiComercio()));
        if (modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms() == 1) {
            fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorCusto() - itemCotacaoCompraLivroFiscal.getValorIcms()));
        }
        if (modeloFiscal.getModeloFiscalIcms().getCalcularIcmsSimples() == 1) {
            fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorCusto() - itemCotacaoCompraLivroFiscal.getValorIcmsSimples()));
        }
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null) {
            if (fatorConversao == null) {
                fornecedorItemCotacaoCompra.getItemCotacaoCompra().setFatorConversao(Double.valueOf(1.0));
            } else {
                fornecedorItemCotacaoCompra.getItemCotacaoCompra().setFatorConversao(fatorConversao);
            }
        }
        if (fatorConversao == null || fatorConversao == 0.0) {
            fatorConversao = 1.0;
        }
        fornecedorItemCotacaoCompra.setValorCusto(Double.valueOf(fornecedorItemCotacaoCompra.getValorCusto() / (quantidadeTotal * fatorConversao)));
    }

    private void valoresIpiItemCotacao(ModeloFiscal modeloFiscal, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Produto produto, UnidadeFatFornecedor fornecedor, Double quantidadeTotal) throws ExceptionCalculoIPI {
        HashMap h = new CalculoIPIEntUtilities(modeloFiscal.getModeloFiscalIpi().getIncluiSeguro(), modeloFiscal.getModeloFiscalIpi().getIncluiFrete(), modeloFiscal.getModeloFiscalIpi().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIpi().getIncluiSeguro()).calcularIpi(modeloFiscal.getModeloFiscalIpi(), modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi(), fornecedor, produto, itemCotacaoCompraLivroFiscal.getAliquotaIpi(), (short)4, fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, quantidadeTotal);
        itemCotacaoCompraLivroFiscal.setValorIpiComercio((Double)h.get("ipiComercio"));
        itemCotacaoCompraLivroFiscal.setValorIpiIndustria((Double)h.get("ipiIndustria"));
        itemCotacaoCompraLivroFiscal.setValorIpiIsento((Double)h.get("ipiIsento"));
        itemCotacaoCompraLivroFiscal.setValorIpiObservacao((Double)h.get("ipiObservacao"));
        itemCotacaoCompraLivroFiscal.setValorIpiOutros((Double)h.get("ipiOutros"));
        itemCotacaoCompraLivroFiscal.setValorIpiTributado((Double)h.get("ipiTributado"));
        itemCotacaoCompraLivroFiscal.setAliquotaIpi((Double)h.get("aliquotaIPI"));
    }

    private void valoresIcmsIcmsSTItemCotacao(ModeloFiscal modeloFiscal, UnidadeFatFornecedor fornecedor, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Double baseCalculo, Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufFornecedor, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, Double quantidadeTotal, EmpresaContabilidade empresaContabilidade) throws ExceptionService, ExceptionCalculoICMS {
        HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).valoresIcms(modeloFiscal.getModeloFiscalIcms(), modeloFiscal.getModeloFiscalIpi(), itemCotacaoCompraLivroFiscal.getValorIpiIndustria(), itemCotacaoCompraLivroFiscal.getValorIpiObservacao(), itemCotacaoCompraLivroFiscal.getAliquotaIcms(), itemCotacaoCompraLivroFiscal.getPercentualReducaoBaseCalculoIcms(), produto, (short)4, fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, empresaContabilidade, 0.0, 0.0, quantidadeTotal);
        itemCotacaoCompraLivroFiscal.setAliquotaIcms((Double)h.get("aliquotaIPI"));
        itemCotacaoCompraLivroFiscal.setValorBaseCalculoIcms((Double)h.get("bcIcms"));
        itemCotacaoCompraLivroFiscal.setValorIcmsIsento((Double)h.get("icmsIsento"));
        itemCotacaoCompraLivroFiscal.setValorIcmsOutros((Double)h.get("icmsOutros"));
        itemCotacaoCompraLivroFiscal.setValorIcmsSemAproveitamento((Double)h.get("icmsSemAprov"));
        itemCotacaoCompraLivroFiscal.setValorIcmsTributado((Double)h.get("icmsTributado"));
        itemCotacaoCompraLivroFiscal.setValorIcmsDispensado((Double)h.get("valorIcmsDesonerado"));
        itemCotacaoCompraLivroFiscal.setValorIcms((Double)h.get("valorIcms"));
        if (itemCotacaoCompraLivroFiscal.getCalcularIcmsST() != null && itemCotacaoCompraLivroFiscal.getCalcularIcmsST() == 1) {
            h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularSt(itemCotacaoCompraLivroFiscal.getValorIcms() + itemCotacaoCompraLivroFiscal.getValorIcmsSemAproveitamento(), itemCotacaoCompraLivroFiscal.getIndicadorAlteracaoIcmsST(), itemCotacaoCompraLivroFiscal.getAliquotaIcmsST(), itemCotacaoCompraLivroFiscal.getDescontoPadraoIcmsST(), quantidadeTotal, produto, itemCotacaoCompraLivroFiscal.getModalidadeIcmsSt(), fornecedorItemCotacaoCompra.getValorFrete(), fornecedorItemCotacaoCompra.getValorSeguro(), fornecedorItemCotacaoCompra.getValorDespesasAcessorias(), fornecedorItemCotacaoCompra.getValorDesconto(), fornecedorItemCotacaoCompra.getValorUnitario() * quantidadeTotal, itemCotacaoCompraLivroFiscal.getValorIpiIndustria(), itemCotacaoCompraLivroFiscal.getValorIpiObservacao(), modeloFiscal.getModeloFiscalIcms().getReducaoBaseCalcIcmsST());
            itemCotacaoCompraLivroFiscal.setIndicadorAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
            itemCotacaoCompraLivroFiscal.setDescontoPadraoIcmsST((Double)h.get("descontoPadraoST"));
            itemCotacaoCompraLivroFiscal.setAliquotaIcmsST((Double)h.get("aliquotaSt"));
            itemCotacaoCompraLivroFiscal.setValorBaseCalculoIcmsSt((Double)h.get("bcIcmsST"));
            itemCotacaoCompraLivroFiscal.setValorIcmsSt((Double)h.get("valorIcmsST"));
        }
    }

    private void calcularDiferencaAliquota(ModeloFiscal modeloFiscal, UnidadeFederativa unidadeFederativaFornecedor, UnidadeFederativa unidadeFederativaEmpresa, FornecedorItemCotacaoCompraLivroFiscal itemCotacaoCompraLivroFiscal, Produto produto, FornecedorItemCotacaoCompra itemCotacao, Double quantidadeTotal) throws ExceptionService {
        HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularDiferencaAliquota(modeloFiscal.getModeloFiscalIcms(), unidadeFederativaFornecedor, unidadeFederativaEmpresa, produto, itemCotacao.getValorFrete(), itemCotacao.getValorSeguro(), itemCotacao.getValorDespesasAcessorias(), itemCotacao.getValorDesconto(), itemCotacao.getValorUnitario() * quantidadeTotal, modeloFiscal.getModeloFiscalIcms().getIpiCompoeBCDifAliquota(), itemCotacaoCompraLivroFiscal.getValorIpiComercio() + itemCotacaoCompraLivroFiscal.getValorIpiIndustria() + itemCotacaoCompraLivroFiscal.getValorIpiObservacao(), itemCotacaoCompraLivroFiscal.getAliquotaIcms(), itemCotacaoCompraLivroFiscal.getValorIcms() + itemCotacaoCompraLivroFiscal.getValorIcmsSemAproveitamento());
        itemCotacaoCompraLivroFiscal.setValorDiferencaAliquota((Double)h.get("valorDifAliquota"));
    }

    private Cfop getCfop(FornecedorItemCotacaoCompra f, Empresa emp) throws ExceptionService {
        try {
            Cfop cfop = CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(emp.getPessoa().getEndereco().getCidade().getUf(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), f.getModeloFiscal());
            return cfop;
        }
        catch (ExceptionCFOPNotFound ex) {
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }

    private void setInfoEstatisticasCusto(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Empresa empresa, OpcoesCompraSuprimentos opcoes) {
        if (ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            return;
        }
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra() != null && fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor() != null) {
            Produto produto = fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
            ServiceNotaFiscalTerceirosImpl service = (ServiceNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(ServiceNotaFiscalTerceirosImpl.class);
            CompEstoque compEstoque = (CompEstoque)ConfApplicationContext.getBean(CompEstoque.class);
            double ultVlrCusto = compEstoque.getUltimoCusto(produto, empresa);
            double custoMedio = service.getCustoMedioProd(produto.getIdentificador(), empresa);
            double menorCusto = service.getMenorCustoProd(produto.getIdentificador(), empresa);
            fornecedorItemCotacaoCompra.setCustoMedio(Double.valueOf(custoMedio));
            fornecedorItemCotacaoCompra.setUltimoCusto(Double.valueOf(ultVlrCusto));
            fornecedorItemCotacaoCompra.setMenorCusto(Double.valueOf(menorCusto));
        }
    }
}

