/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.cotacaovendas;

import com.touchcomp.basementor.model.vo.GradeItemCotVendas;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendas;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import contatocore.util.ContatoFormatUtil;
import java.util.List;
import mentorcore.exceptions.ExceptionService;

public class CalculoValoresCotacaoVendas {
    public void calculoValoresCotacaoVendas(List<ItemCotacaoVendas> itens) {
        for (ItemCotacaoVendas it : itens) {
            this.putQuantidadeTotal(it);
            this.putValorTotalBruto(it);
            this.putValorTotal(it);
            this.putPeso(it);
        }
    }

    private void putQuantidadeTotal(ItemCotacaoVendas it) {
        double qtd = 0.0;
        for (GradeItemCotVendas g : it.getGrade()) {
            qtd += g.getQuantidade().doubleValue();
        }
        it.setQuantidadeTotal(Double.valueOf(qtd));
    }

    private void putValorTotalBruto(ItemCotacaoVendas item) {
        item.setValorTotalBruto(ToolFormatter.arrredondarNumero((Double)(item.getValorUnitario() * item.getQuantidadeTotal()), (int)2));
    }

    private void putValorTotal(ItemCotacaoVendas item) {
        Double valorTotal = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
        item.setValorTotal(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2));
    }

    private void putPeso(ItemCotacaoVendas it) {
        Double pesoItem = it.getProduto().getPesoUnitario() + it.getProduto().getPesoEmbalagem();
        if (pesoItem == null) {
            pesoItem = 0.0;
        }
        Double pesoTotal = pesoItem * it.getQuantidadeTotal();
    }

    public void ratearValoresAcessorios(List<ItemCotacaoVendas> itens, double valorDesc, double percDesc, short tipoDesc, double valorDesp, double percDesp, short tipoDesp, double valorFrete, double percFrete, short tipoFrete, double valorSeg, double percSeg, short tipoSeg) throws ExceptionService {
        CalculoValoresCotacaoVendas.ratearDesconto(itens, valorDesc, percDesc, tipoDesc);
        CalculoValoresCotacaoVendas.ratearDespAcess(itens, valorDesp, percDesp, tipoDesp);
        CalculoValoresCotacaoVendas.ratearFrete(itens, valorFrete, percFrete, tipoFrete);
        CalculoValoresCotacaoVendas.ratearSeguro(itens, valorSeg, percSeg, tipoSeg);
    }

    private static void ratearDesconto(List<ItemCotacaoVendas> itens, double valorDesc, double percDesc, short tipoDesc) throws ExceptionService {
        double valorTotalUnitario = 0.0;
        if (tipoDesc == 0) {
            valorDesc = 0.0;
        }
        for (ItemCotacaoVendas it : itens) {
            if (it.getDescontoItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario().doubleValue();
        }
        if (tipoDesc == 0 && valorTotalUnitario <= 0.0 && percDesc > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o desconto.");
        }
        if (tipoDesc == 1 && valorTotalUnitario <= 0.0 && valorDesc > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o desconto.");
        }
        ItemCotacaoVendas lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemCotacaoVendas item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDescCalc = 0.0;
            double percDescCalc = 0.0;
            if (item.getDescontoItem() != 1) {
                if (tipoDesc == 0) {
                    valorDescCalc = ContatoFormatUtil.arrredondarNumero((Double)(percDesc / 100.0 * vlrProduto), (int)2);
                    percDescCalc = percDesc;
                } else {
                    percDescCalc = valorDesc > 0.0 && valorTotalUnitario > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorDesc / valorTotalUnitario * 100.0), (int)4) : 0.0;
                    valorDescCalc = ContatoFormatUtil.arrredondarNumero((Double)(item.getValorUnitario() * percDescCalc / 100.0), (int)2);
                }
                valorDescTotal += valorDescCalc;
                lastItem = item;
                item.setPercDesconto(Double.valueOf(percDescCalc));
                item.setValorDesconto(Double.valueOf(valorDescCalc));
                continue;
            }
            if (item.getTipoDesconto() == 0) {
                if (!(item.getPercDesconto() > 0.0)) continue;
                item.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercDesconto() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)item.getValorDesconto(), (int)2));
            if (!(item.getValorDesconto() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDesconto(ContatoFormatUtil.arrredondarNumero((Double)(item.getValorDesconto() * 100.0 / vlrProduto), (int)2));
        }
        if (lastItem != null && valorDesc > 0.0) {
            lastItem.setValorDesconto(Double.valueOf(lastItem.getValorDesconto() + (valorDesc - valorDescTotal)));
        }
    }

    private static void ratearFrete(List<ItemCotacaoVendas> itens, double valorFrete, double percFrete, short tipoFrete) throws ExceptionService {
        double valorTotalUnitario = 0.0;
        if (tipoFrete == 0) {
            valorFrete = 0.0;
        }
        for (ItemCotacaoVendas it : itens) {
            if (it.getFreteItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario().doubleValue();
        }
        ItemCotacaoVendas lastItem = null;
        double valorFreteTotal = 0.0;
        for (ItemCotacaoVendas item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorFreteCalc = 0.0;
            double percFreteCalc = 0.0;
            if (item.getFreteItem() != 1) {
                if (tipoFrete == 0) {
                    valorFreteCalc = ContatoFormatUtil.arrredondarNumero((Double)(percFrete / 100.0 * vlrProduto), (int)2);
                    percFreteCalc = percFrete;
                } else {
                    percFreteCalc = valorFrete > 0.0 && valorTotalUnitario > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorFrete / valorTotalUnitario * 100.0), (int)4) : 0.0;
                    valorFreteCalc = ContatoFormatUtil.arrredondarNumero((Double)(item.getValorUnitario() * percFreteCalc / 100.0), (int)2);
                }
                valorFreteTotal += valorFreteCalc;
                lastItem = item;
                item.setPercFrete(Double.valueOf(percFreteCalc));
                item.setValorFrete(Double.valueOf(valorFreteCalc));
                continue;
            }
            if (item.getTipoFrete() == 0) {
                if (!(item.getPercFrete() > 0.0)) continue;
                item.setValorFrete(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercFrete() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorFrete(ContatoFormatUtil.arrredondarNumero((Double)item.getValorFrete(), (int)2));
            if (!(item.getValorFrete() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercFrete(ContatoFormatUtil.arrredondarNumero((Double)(item.getValorFrete() * 100.0 / vlrProduto), (int)2));
        }
        if (lastItem != null && valorFrete > 0.0) {
            lastItem.setValorFrete(Double.valueOf(lastItem.getValorFrete() + (valorFrete - valorFreteTotal)));
        }
    }

    private static void ratearDespAcess(List<ItemCotacaoVendas> itens, double valorDesp, double percDesp, short tipoDesp) throws ExceptionService {
        double valorTotalUnitario = 0.0;
        if (tipoDesp == 0) {
            valorDesp = 0.0;
        }
        for (ItemCotacaoVendas it : itens) {
            if (it.getDespAcessItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario().doubleValue();
        }
        ItemCotacaoVendas lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemCotacaoVendas item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDespCalc = 0.0;
            double percDespCalc = 0.0;
            if (item.getDespAcessItem() != 1) {
                if (tipoDesp == 0) {
                    valorDespCalc = ContatoFormatUtil.arrredondarNumero((Double)(percDesp / 100.0 * vlrProduto), (int)2);
                    percDespCalc = percDesp;
                } else {
                    percDespCalc = valorDesp > 0.0 && valorTotalUnitario > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorDesp / valorTotalUnitario * 100.0), (int)4) : 0.0;
                    valorDespCalc = ContatoFormatUtil.arrredondarNumero((Double)(item.getValorUnitario() * percDespCalc / 100.0), (int)2);
                }
                valorDespTotal += valorDespCalc;
                lastItem = item;
                item.setPercDespesaAcessoria(Double.valueOf(percDespCalc));
                item.setValorDespesaAcessoria(Double.valueOf(valorDespCalc));
                continue;
            }
            if (item.getTipoDespAcessoria() == 0) {
                if (!(item.getPercDespesaAcessoria() > 0.0)) continue;
                item.setValorDespesaAcessoria(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercDespesaAcessoria() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDespesaAcessoria(ContatoFormatUtil.arrredondarNumero((Double)item.getValorDespesaAcessoria(), (int)2));
            if (!(item.getValorDespesaAcessoria() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDespesaAcessoria(ContatoFormatUtil.arrredondarNumero((Double)(item.getValorDespesaAcessoria() * 100.0 / vlrProduto), (int)2));
        }
        if (lastItem != null && valorDesp > 0.0) {
            lastItem.setValorDespesaAcessoria(Double.valueOf(lastItem.getValorDespesaAcessoria() + (valorDesp - valorDespTotal)));
        }
    }

    private static void ratearSeguro(List<ItemCotacaoVendas> itens, double valorSeguro, double percSeguro, short tipoSeguro) throws ExceptionService {
        double valorTotalUnitario = 0.0;
        if (tipoSeguro == 0) {
            valorSeguro = 0.0;
        }
        for (ItemCotacaoVendas it : itens) {
            if (it.getOpcional() == 1 || it.getSeguroItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario().doubleValue();
        }
        ItemCotacaoVendas lastItem = null;
        double valorSeguroTotal = 0.0;
        for (ItemCotacaoVendas item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorSeguroCalc = 0.0;
            double percSeguroCalc = 0.0;
            if (item.getSeguroItem() != 1) {
                if (tipoSeguro == 0) {
                    valorSeguroCalc = ContatoFormatUtil.arrredondarNumero((Double)(percSeguro / 100.0 * vlrProduto), (int)2);
                    percSeguroCalc = percSeguro;
                } else {
                    percSeguroCalc = valorSeguro > 0.0 && valorTotalUnitario > 0.0 ? ContatoFormatUtil.arrredondarNumero((Double)(valorSeguro / valorTotalUnitario * 100.0), (int)4) : 0.0;
                    valorSeguroCalc = ContatoFormatUtil.arrredondarNumero((Double)(item.getValorUnitario() * percSeguroCalc / 100.0), (int)2);
                }
                valorSeguroTotal += valorSeguroCalc;
                lastItem = item;
                item.setPercSeguro(Double.valueOf(percSeguroCalc));
                item.setValorSeguro(Double.valueOf(valorSeguroCalc));
                continue;
            }
            if (item.getTipoSeguro() == 0) {
                if (!(item.getPercSeguro() > 0.0)) continue;
                item.setValorSeguro(ContatoFormatUtil.arrredondarNumero((Double)(item.getPercSeguro() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorSeguro(ContatoFormatUtil.arrredondarNumero((Double)item.getValorSeguro(), (int)2));
            if (!(item.getValorSeguro() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercSeguro(ContatoFormatUtil.arrredondarNumero((Double)(item.getValorSeguro() * 100.0 / vlrProduto), (int)2));
        }
        if (lastItem != null && valorSeguro > 0.0) {
            lastItem.setValorSeguro(Double.valueOf(lastItem.getValorSeguro() + (valorSeguro - valorSeguroTotal)));
        }
    }
}

