/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.csvfile;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionFileManipulation;

public class UtilCSVFile {
    public List<Object[]> readCSV(File csv) throws ExceptionFileManipulation {
        try {
            ArrayList<Object[]> toRet = new ArrayList<Object[]>();
            CsvReader products = new CsvReader(csv.getAbsolutePath(), ';');
            products.readHeaders();
            String[] readers = products.getHeaders();
            while (products.readRecord()) {
                Object[] to = new Object[readers.length];
                for (int i = 0; i < readers.length; ++i) {
                    to[i] = products.get(readers[i]);
                }
                toRet.add(to);
            }
            products.close();
            return toRet;
        }
        catch (FileNotFoundException e) {
            throw new ExceptionFileManipulation("Arquivo inexistente.", e);
        }
        catch (IOException e) {
            throw new ExceptionFileManipulation("Erro de leitura.", e);
        }
    }

    public void writeCSV(File out, Object[] header, List<Object[]> dados, char delimitator) throws ExceptionFileManipulation {
        boolean alreadyExists = new File(out.toString()).exists();
        try {
            CsvWriter csvOutput = new CsvWriter((Writer)new FileWriter(out, true), delimitator);
            if (!alreadyExists) {
                for (int i = 0; i < header.length; ++i) {
                    csvOutput.write(header[i].toString());
                }
                csvOutput.endRecord();
            }
            for (Object[] ob : dados) {
                for (int i = 0; i < ob.length; ++i) {
                    csvOutput.write(ob[i].toString());
                    csvOutput.endRecord();
                }
            }
            csvOutput.close();
        }
        catch (IOException e) {
            throw new ExceptionFileManipulation("Erro de gracacao.", e);
        }
    }
}

