/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.diagnosticoosativo;

import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.Date;

public class UtilityDiagnosticoOSAtivo {
    public void gerarPedidoAlmoxarifado(DiagnosticoOSAtivo vo, Usuario usuario) {
        if (vo.getGerarPedAlmoxarifado() == 0) {
            return;
        }
        PedidoAlmoxarifado ped = vo.getPedidoAlmoxarifado();
        if (ped == null) {
            ped = new PedidoAlmoxarifado();
            ped.setDiagnosticoOS(vo);
        }
        ped.setDataAgendamento(vo.getDataNecessidade());
        ped.setDataEmissao(new Date());
        ped.setDataCadastro(new Date());
        ped.setUsuario(usuario);
        ped.setDiagnosticoOS(vo);
        ped.setEmpresa(vo.getOrdemServico().getEmpresa());
        ped.setObservacao(vo.getObservacao());
        ped.getItensPedido().clear();
        this.getItensPedido(ped, vo);
        vo.setPedidoAlmoxarifado(ped);
    }

    private void getItensPedido(PedidoAlmoxarifado ped, DiagnosticoOSAtivo vo) {
        for (DiagnosticoOSAtivoServico servico : vo.getServicos()) {
            for (DiagnosticoOSAtivoServProc procedimento : servico.getProcedimentos()) {
                for (DiagnosticoOSAtivoItens iten : procedimento.getItens()) {
                    ItemPedidoAlmoxarifado itAl = new ItemPedidoAlmoxarifado();
                    itAl.setPedidoAlmoxarifado(ped);
                    itAl.setCentroCusto(vo.getOrdemServico().getCentroCusto());
                    itAl.setProduto(iten.getGradeCor().getProdutoGrade().getProduto());
                    itAl.setQuantidadeTotal(iten.getQuantidade());
                    iten.setItemPedidoAlmoxarifado(itAl);
                    ped.getItensPedido().add(itAl);
                    GradeItemPedidoAlmoxarifado gr = new GradeItemPedidoAlmoxarifado();
                    gr.setGradeCor(iten.getGradeCor());
                    gr.setItemPedidoAlmoxarifado(itAl);
                    gr.setQuantidade(iten.getQuantidade());
                    itAl.getGradesItensAlmoxarifado().add(gr);
                }
            }
        }
    }
}

