/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.file;

import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.utilities.CoreUtility;
import org.apache.commons.io.IOUtils;

public class UtilityFile
extends CoreUtility {
    public void writeStringInFile(String dirOutLoteNFeEnviados, StringBuffer st) throws ExceptionFileManipulation {
        this.writeStringInFile(dirOutLoteNFeEnviados, st.toString());
    }

    public File writeStringInFile(String dirOutLoteNFeEnviados, String st) throws ExceptionFileManipulation {
        try (PrintWriter pt = null;){
            File f = new File(dirOutLoteNFeEnviados);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdir();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            pt = new PrintWriter(f);
            pt.write(st);
            pt.flush();
            pt.close();
            File file = f;
            return file;
        }
    }

    public String getConteudoArquivo(String path) {
        Object result = "";
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(path));
            while ((str = in.readLine()) != null) {
                result = (String)result + str + "\n";
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao ler o arquivo.");
        }
        return result;
    }

    public String getUserDir() {
        return System.getProperty("user.dir");
    }

    public File getUserDirFile() {
        return new File(this.getUserDir());
    }

    public String getTMPDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public File getFileTMPDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public File crateTempFile(String nomeArquivo, String extensao) {
        String dir = System.getProperty("java.io.tmpdir");
        File f = new File(dir + File.separator + nomeArquivo + extensao);
        return f;
    }

    public byte[] getBytesFromFile(File temp) throws IOException {
        FileInputStream finp = new FileInputStream(temp);
        return IOUtils.toByteArray((InputStream)finp);
    }

    public void writeBytesOnFile(File temp, byte[] arquivoKeystore) throws FileNotFoundException, IOException {
        FileOutputStream fout = new FileOutputStream(temp);
        fout.write(arquivoKeystore);
        fout.flush();
        fout.close();
    }

    public String getFileName(String nomeArquivo, String ext) {
        if ((nomeArquivo = ToolString.refina((String)nomeArquivo)).endsWith(ext)) {
            return nomeArquivo;
        }
        return nomeArquivo + "." + ext;
    }

    public File getFileName(File arquivo, String ext) {
        String nomeArquivo = arquivo.getName();
        if (nomeArquivo.endsWith(ext)) {
            return arquivo;
        }
        return new File(arquivo.getParentFile().getAbsolutePath() + File.separator + nomeArquivo + "." + ext);
    }

    public File renameFileName(File ger, String nomeArquivo, boolean keepExtension) {
        File out;
        boolean res;
        int index;
        Object aux = nomeArquivo;
        if (keepExtension && (index = ger.getName().lastIndexOf(".")) > 0) {
            aux = nomeArquivo + ger.getName().substring(index);
        }
        if (res = ger.renameTo(out = new File(ger.getParentFile().getAbsolutePath() + File.separator + (String)aux))) {
            return out;
        }
        return ger;
    }
}

