/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.financeiro;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CnabFolhaAtivos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.LayoutFolhaPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.service.impl.financeiro.cnab.bb.LayoutArquivoRetornoCnabBB;
import mentorcore.service.impl.financeiro.cnab.bradesco.LayoutArquivoRetornoCnabBradesco;
import mentorcore.service.impl.financeiro.cnab.caixa.LayoutArquivoRetornoCnabCaixa;
import mentorcore.service.impl.financeiro.cnab.hsbc.LayoutArquivoRetornoCnabHSBC;
import mentorcore.service.impl.financeiro.cnab.santander.LayoutArquivoRetornoCnabSantander;
import mentorcore.service.impl.financeiro.cnabfolha.ImpressaoComprovantePgtoFolha;
import net.sf.jasperreports.engine.JasperPrint;

public class UtilityRetornoCnab {
    private static final TLogger logger = TLogger.get(UtilityRetornoCnab.class);
    private static final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    public static HashMap getRetornoFolhaCnab(CnabFolhaAtivos cnabFolhaAtivos, File file, LayoutFolhaPagamento layoutFolhaPagamento, Short tipoTitulosFolha, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws FileNotFoundException, IOException, ExceptionService, Exception {
        HashMap movimentos = new HashMap();
        if (cnabFolhaAtivos.getNrBanco().equals("399")) {
            movimentos = LayoutArquivoRetornoCnabHSBC.getRetornoFolhaCnab(file, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        } else if (cnabFolhaAtivos.getNrBanco().equals("001")) {
            movimentos = LayoutArquivoRetornoCnabBB.getRetornoFolhaCnab(file, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        } else if (cnabFolhaAtivos.getNrBanco().equals("033")) {
            movimentos = LayoutArquivoRetornoCnabSantander.getRetornoFolhaCnab(file, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        } else if (cnabFolhaAtivos.getNrBanco().equals("104")) {
            movimentos = LayoutArquivoRetornoCnabCaixa.getRetornoFolhaCnab(file, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        } else if (cnabFolhaAtivos.getNrBanco().equals("237")) {
            movimentos = LayoutArquivoRetornoCnabBradesco.getRetornoFolhaCnab(file, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        }
        return movimentos;
    }

    public static JasperPrint imprimirComprovantePgtoFolha(File file, CnabFolhaAtivos banco, LayoutFolhaPagamento layout, HashMap parametros) throws FileNotFoundException, IOException, ExceptionService, ExceptionService, ExceptionService {
        if (banco.getNrBanco().equals("237") && layout.getPosicoes().equals("240")) {
            JasperPrint jasperPrint = ImpressaoComprovantePgtoFolha.getImpressaoComprovantePgtoBradesco240(file);
            return jasperPrint;
        }
        if (banco.getNrBanco().equals("001") && layout.getPosicoes().equals("240")) {
            JasperPrint jasperPrint = ImpressaoComprovantePgtoFolha.getImpressaoComprovantePgtoBB(file, parametros);
            return jasperPrint;
        }
        if (banco.getNrBanco().equals("399") && layout.getPosicoes().equals("240")) {
            JasperPrint jasperPrint = ImpressaoComprovantePgtoFolha.getImpressaoComprovantePgtoHSBC(file, parametros);
            return jasperPrint;
        }
        if (banco.getNrBanco().equals("104") && layout.getPosicoes().equals("240")) {
            JasperPrint jasperPrint = ImpressaoComprovantePgtoFolha.getImpressaoComprovantePgtoCaixa(file, parametros);
            return jasperPrint;
        }
        throw new ExceptionService("N\u00e3o \u00e9 poss\u00edvel gerar comprovante para o Banco informado.");
    }

    public static PlanoConta getPlanoContaAntecipacao(OpcoesContabeis opcoesContabeis, Titulo t) throws ExceptionService, ExceptionInvalidData {
        Cliente cliente = UtilityRetornoCnab.getClienteTitulo(t);
        PlanoConta pcAntecip = scPlanoConta.getPlanoContaAntecip(cliente, opcoesContabeis);
        return pcAntecip;
    }

    private static Cliente getClienteTitulo(Titulo t) {
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCliente().getVOClass());
            b.and().equal("pessoa", t.getPessoa());
            Cliente cliente = (Cliente)CoreService.executeSearchUniqueResult(b);
            return cliente;
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

