/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaofaturamento;

import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.Rps;

public class UtilityGeracaoFaturamento {
    public static void recalculaFatura(FaturaCte faturaCte) {
        UtilityGeracaoFaturamento.resetarValoresFatura(faturaCte);
        for (Cte cte : faturaCte.getCte()) {
            UtilityGeracaoFaturamento.atualizarFaturaCte(faturaCte, cte);
        }
        for (Rps rps : faturaCte.getRps()) {
            UtilityGeracaoFaturamento.atualizarFaturaRps(faturaCte, rps);
        }
        faturaCte.setVlrFatura(Double.valueOf(faturaCte.getValorReceber() - faturaCte.getVlrDesconto() + faturaCte.getVlrAcrescimo()));
        faturaCte.setNrRps(Integer.valueOf(faturaCte.getRps().size()));
        faturaCte.setNrCtes(Integer.valueOf(faturaCte.getCte().size()));
    }

    private static void resetarValoresFatura(FaturaCte faturaCte) {
        faturaCte.setValorPrestacao(Double.valueOf(0.0));
        faturaCte.setValorReceber(Double.valueOf(0.0));
        faturaCte.setBaseCalcIcms(Double.valueOf(0.0));
        faturaCte.setVrIcms(Double.valueOf(0.0));
    }

    private static void atualizarFaturaCte(FaturaCte faturaCte, Cte cte) {
        faturaCte.setValorPrestacao(Double.valueOf(faturaCte.getValorPrestacao() + cte.getCteVlrImpostos().getVrPrestacao()));
        faturaCte.setValorReceber(Double.valueOf(faturaCte.getValorReceber() + cte.getCteVlrImpostos().getVrReceber()));
        faturaCte.setBaseCalcIcms(Double.valueOf(faturaCte.getBaseCalcIcms() + cte.getCteVlrImpostos().getBaseCalcIcms()));
        faturaCte.setVrIcms(Double.valueOf(faturaCte.getVrIcms() + cte.getCteVlrImpostos().getVrIcms()));
    }

    private static void atualizarFaturaRps(FaturaCte faturaCte, Rps rps) {
        faturaCte.setValorPrestacao(Double.valueOf(faturaCte.getValorPrestacao() + rps.getValorServico()));
        faturaCte.setValorReceber(Double.valueOf(faturaCte.getValorReceber() + rps.getValorLiquidoNfse()));
    }
}

