/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfpropria;

import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.utilities.impl.geracaonfpropria.AuxStandardMethodsNF;

class AuxGerarNFAcuracidadeEstoque {
    private final ApuracidadeEstoque acuracidadeEstoque;
    private final OpcoesFaturamento opFat;
    private final OpcoesImpostos opImp;
    private final OpcoesFinanceiras opFin;
    private final EmpresaFinanceiro empFin;
    private final EmpresaContabilidade empCont;
    private final OpcoesContabeis opcoesContabeis;
    private TLogger logger = TLogger.get(this.getClass());

    public AuxGerarNFAcuracidadeEstoque(ApuracidadeEstoque acuracidadeEstoque, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaFinanceiro empFin, EmpresaContabilidade empCont, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) {
        this.acuracidadeEstoque = acuracidadeEstoque;
        this.opFat = opFat;
        this.opFin = opFin;
        this.empFin = empFin;
        this.empCont = empCont;
        this.opcoesContabeis = opcoesContabeis;
        this.opImp = opImpostos;
    }

    public List<NotaFiscalPropria> createListNotasEntrada() throws ExceptionService {
        NotaFiscalPropria nTmp;
        ArrayList<NotaFiscalPropria> notas = new ArrayList<NotaFiscalPropria>();
        if (this.acuracidadeEstoque.getQuantidadeItensPorNota() > 990) {
            throw new ExceptionService("Quantidade Maxima de Itens por Nota 990, verifique a quantidade!");
        }
        ArrayList<Object> listToNota = new ArrayList<ItemApuracidadeEstoque>();
        for (ItemApuracidadeEstoque item : this.acuracidadeEstoque.getItensApuracidadeEstoque()) {
            if (ToolMethods.isEquals((Object)listToNota.size(), (Object)this.acuracidadeEstoque.getQuantidadeItensPorNota())) {
                NotaFiscalPropria nTmp2 = this.buildNFEntrada(listToNota);
                if (!ToolMethods.isNull((Object)nTmp2).booleanValue()) {
                    notas.add(nTmp2);
                }
                listToNota = new ArrayList();
            }
            if (!(item.getQuantidadeFinal() > item.getQuantidadeInicial())) continue;
            listToNota.add(item);
        }
        if (!listToNota.isEmpty() && !ToolMethods.isNull((Object)(nTmp = this.buildNFEntrada(listToNota))).booleanValue()) {
            notas.add(nTmp);
        }
        return notas;
    }

    NotaFiscalPropria buildNFEntrada(List<ItemApuracidadeEstoque> listToNota) throws ExceptionService {
        try {
            NotaFiscalPropria nf = this.createNF(this.acuracidadeEstoque.getNaturezaOperacaoEntrada(), this.acuracidadeEstoque.getDataApuracidadeEstoque(), null);
            for (ItemApuracidadeEstoque iten : listToNota) {
                if (!(iten.getQuantidadeFinal() > iten.getQuantidadeInicial())) continue;
                Double quantidade = ContatoFormatUtil.arrredondarNumero(iten.getQuantidadeFinal() - iten.getQuantidadeInicial(), 6);
                this.buildItens(iten, this.acuracidadeEstoque.getDataApuracidadeEstoque(), nf, quantidade);
            }
            if (nf.getItensNotaPropria().isEmpty()) {
                return null;
            }
            AuxStandardMethodsNF.calcImpostos(nf, this.opFat, this.empCont, this.opImp);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opcoesContabeis);
            AuxStandardMethodsNF.createVolumes(nf, this.opFat);
            AuxStandardMethodsNF.createInfAdicionaisItens(nf, this.opFat);
            this.setNumeroItem(nf);
            return nf;
        }
        catch (ExceptionCFOPNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionGeracaoTitulos ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCategoriaSTNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionValidacaoDados ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionInvalidData ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    public List<NotaFiscalPropria> createListNotasPerdas() throws ExceptionService {
        NotaFiscalPropria nTmp;
        ArrayList<NotaFiscalPropria> notas = new ArrayList<NotaFiscalPropria>();
        if (this.acuracidadeEstoque.getQuantidadeItensPorNota() > 990) {
            throw new ExceptionService("Quantidade Maxima de Itens por Nota 990, verifique a quantidade!");
        }
        ArrayList<Object> listToNota = new ArrayList<ItemApuracidadeEstoque>();
        for (ItemApuracidadeEstoque iten : this.acuracidadeEstoque.getItensApuracidadeEstoque()) {
            if (ToolMethods.isEquals((Object)listToNota.size(), (Object)this.acuracidadeEstoque.getQuantidadeItensPorNota())) {
                NotaFiscalPropria nTmp2 = this.buildNFPerda(listToNota);
                if (!ToolMethods.isNull((Object)nTmp2).booleanValue()) {
                    notas.add(nTmp2);
                }
                listToNota = new ArrayList();
            }
            if (!(iten.getQuantidadeFinal() < iten.getQuantidadeInicial())) continue;
            listToNota.add(iten);
        }
        if (!listToNota.isEmpty() && !ToolMethods.isNull((Object)(nTmp = this.buildNFPerda(listToNota))).booleanValue()) {
            notas.add(nTmp);
        }
        return notas;
    }

    private NotaFiscalPropria buildNFPerda(List<ItemApuracidadeEstoque> itensAcuracidade) throws ExceptionService {
        try {
            NotaFiscalPropria nf = this.createNF(this.acuracidadeEstoque.getNaturezaOperacaoSaida(), this.acuracidadeEstoque.getDataApuracidadeEstoque(), null);
            for (ItemApuracidadeEstoque iten : itensAcuracidade) {
                if (!(iten.getQuantidadeFinal() < iten.getQuantidadeInicial())) continue;
                Double quantidade = ContatoFormatUtil.arrredondarNumero(iten.getQuantidadeInicial() - iten.getQuantidadeFinal(), 6);
                this.buildItens(iten, this.acuracidadeEstoque.getDataApuracidadeEstoque(), nf, quantidade);
            }
            if (nf.getItensNotaPropria().isEmpty()) {
                return null;
            }
            AuxStandardMethodsNF.calcImpostos(nf, this.opFat, this.empCont, this.opImp);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opcoesContabeis);
            AuxStandardMethodsNF.createVolumes(nf, this.opFat);
            AuxStandardMethodsNF.createInfAdicionaisItens(nf, this.opFat);
            this.setNumeroItem(nf);
            return nf;
        }
        catch (ExceptionCFOPNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionGeracaoTitulos ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCategoriaSTNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionValidacaoDados ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionInvalidData ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    private NotaFiscalPropria createNF(NaturezaOperacao nat, Date data, NotaFiscalPropria nf) throws ExceptionService {
        NotaFiscalPropria n = AuxStandardMethodsNF.newNotaFiscalPropria(nf, this.acuracidadeEstoque.getUnidadeFatCliente(), this.acuracidadeEstoque.getEmpresa(), nat, this.opFat, this.opFin);
        n.setDataEmissaoNota(new Date());
        n.setDataEntradaSaida(new Date());
        n.setSituacaoDocumento(this.acuracidadeEstoque.getSituacaoDocumento());
        if (this.acuracidadeEstoque.getCondicoesPagamento() != null) {
            n.setCondicaoPagamento(this.acuracidadeEstoque.getCondicoesPagamento());
        }
        return n;
    }

    private ItemNotaFiscalPropria procurarItemNotaProduto(ItemApuracidadeEstoque ic, List list) {
        for (Object o : list) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (!i.getProduto().equals((Object)ic.getGradeCor().getProdutoGrade().getProduto())) continue;
            return i;
        }
        return null;
    }

    private void buildItens(ItemApuracidadeEstoque ic, Date dataEntradaSaida, NotaFiscalPropria nf, Double quantidade) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        ItemNotaFiscalPropria i = null;
        if (quantidade > 0.0) {
            i = this.procurarItemNotaProduto(ic, nf.getItensNotaPropria());
            if (i == null) {
                i = new ItemNotaFiscalPropria();
                nf.getItensNotaPropria().add(i);
            }
            i.setNotaFiscalPropria(nf);
            i.setCentroEstoque(ic.getApuracidadeEstoque().getCentroEstoque());
            i.setProduto(ic.getGradeCor().getProdutoGrade().getProduto());
            i.setModeloFiscal(this.getPrimeiroModFiscal(i, nf));
            i.setIndicadorTotal(Short.valueOf((short)1));
            i.setQuantidadeTotal(quantidade);
            i.setUnidadeMedida(i.getProduto().getUnidadeMedida());
            i.setFatorConversao(Double.valueOf(1.0));
            this.buildGrades(ic, dataEntradaSaida, i, nf.getEmpresa(), nf.getNaturezaOperacao().getEntradaSaida());
            i.setValorUnitario(ic.getPrecoMedioFinal());
            i.setVrProduto(Double.valueOf(ic.getPrecoMedioFinal() * i.getQuantidadeTotal()));
            i.setCest(i.getProduto().getCest());
            i.setNcm(i.getProduto().getNcm());
            AuxStandardMethodsNF.findAndSetAliquotasCont(i, nf.getNaturezaOperacao(), nf.getEmpresa(), nf.getUnidadeFatCliente(), this.opcoesContabeis);
            new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(i, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
        }
    }

    private void buildGrades(ItemApuracidadeEstoque grPre, Date dataEntradaSaida, ItemNotaFiscalPropria itemNF, Empresa empresa, Short entradaSaida) {
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        g.setQuantidade(itemNF.getQuantidadeTotal());
        g.setMovimentacaoFisica(itemNF.getModeloFiscal().getMovimentacaoFisica());
        g.setGradeCor(grPre.getGradeCor());
        g.setDataEntradaSaida(dataEntradaSaida);
        g.setLoteFabricacao(grPre.getLoteFabricacao());
        g.setItemNotaFiscalPropria(itemNF);
        g.setValorCusto(grPre.getPrecoMedioFinal());
        g.setCentroEstoque(itemNF.getCentroEstoque());
        g.setFatorConversao(itemNF.getFatorConversao());
        g.setEntradaSaida(entradaSaida);
        g.setEmpresa(empresa);
        itemNF.getGradesNotaFiscalPropria().add(g);
    }

    private ModeloFiscal getPrimeiroModFiscal(ItemNotaFiscalPropria item, NotaFiscalPropria nf) throws ExceptionService {
        try {
            HelperModeloFiscal service = (HelperModeloFiscal)Context.get(HelperModeloFiscal.class);
            ModeloFiscal mf = service.getFirst(item.getProduto(), nf.getUnidadeFatCliente(), nf.getNaturezaOperacao(), nf.getEmpresa());
            return mf;
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage());
        }
    }

    private void setNumeroItem(NotaFiscalPropria nf) {
        int cont = 1;
        for (ItemNotaFiscalPropria i : nf.getItensNotaPropria()) {
            i.setNumeroItem(Integer.valueOf(cont));
            ++cont;
        }
    }

    private Short getContribuinteEstado(UnidadeFatCliente unidade) {
        return ((HelperUnidadeFatCliente)Context.get(HelperUnidadeFatCliente.class)).build(unidade).getContribuinteEstado();
    }
}

