/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfpropria;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.DocumentosRefNFCePR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFProdutorPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFTerceirosPR;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItem;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItemGrade;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresNfPropria;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumento;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.VODevolucaoComprasVendas;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfce.VONFCe;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfce.VONFCeItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfce.VONFCeItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropria;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropriaItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropriaItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nft.VONFTerceiros;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nft.VONFTerceirosItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nft.VONFTerceirosItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPed;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPedItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPedItemGrade;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.helpers.impl.naturezaoperacao.HelperNaturezaOperacao;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaPropria;
import mentorcore.utilities.impl.geracaonfpropria.AuxStandardMethodsNF;
import mentorcore.utilities.impl.notafiscalpropria.UtilityNotaFiscalPropria;

class AuxGerarNFDevolucaoVendas {
    private final VODevolucaoComprasVendas vo;
    private final OpcoesFaturamento opFat;
    private final OpcoesFinanceiras opFin;
    private final OpcoesImpostos opImp;
    private final EmpresaFinanceiro empFin;
    private final EmpresaContabilidade empCont;
    private final OpcoesContabeis opcoesContabeis;
    private final OpcoesEstoque opcoesEstoque;
    private final Usuario usuario;
    private final Empresa empresa;
    private TLogger logger = TLogger.get(this.getClass());

    public AuxGerarNFDevolucaoVendas(VODevolucaoComprasVendas vo, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaFinanceiro empFin, EmpresaContabilidade empCont, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque, Usuario usuario, Empresa empresa, OpcoesImpostos opImpostos) {
        this.vo = vo;
        this.opFat = opFat;
        this.opFin = opFin;
        this.empFin = empFin;
        this.empCont = empCont;
        this.opcoesContabeis = opcoesContabeis;
        this.opcoesEstoque = opcoesEstoque;
        this.usuario = usuario;
        this.empresa = empresa;
        this.opImp = opImpostos;
    }

    NotaFiscalPropria buildNF() throws ExceptionService, ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        try {
            NotaFiscalPropria nf = this.createNF();
            this.buildItens(nf);
            AuxStandardMethodsNF.calcImpostos(nf, this.opFat, this.empCont, this.opImp);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opcoesContabeis);
            AuxStandardMethodsNF.createInfAdicionaisItens(nf, this.opFat);
            this.setLoteContabil(nf);
            return nf;
        }
        catch (ExceptionAvaliadorExpressoes | ExceptionGeracaoTitulos | ExceptionValidacaoDados | ExceptionCFOPNotFound | ExceptionCalculoICMS | ExceptionCalculoIPI | ExceptionCalculoPisCofins | ExceptionCategoriaSTNotFound | ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    private NotaFiscalPropria createNF() throws ExceptionService {
        NotaFiscalPropria n = AuxStandardMethodsNF.newNotaFiscalPropria(null, this.vo.getParams().getUnidadeFatCliente(), this.empresa, this.vo.getParams().getNaturezaOperacao(), this.opFat, this.opFin);
        n.setDataEmissaoNota(this.vo.getParams().getDataEmissao());
        n.setHoraEmissao(new Date());
        n.setDataEntradaSaida(this.vo.getParams().getDataEntradaSaida());
        n.setHoraEntradaSaida(new Date());
        n.setSituacaoDocumento(this.vo.getParams().getSituacaoDocumento());
        n.setCondicaoPagamento(this.vo.getParams().getCondicoesPagamento());
        if (n.getCondicaoPagamento() != null && n.getCondicaoPagamento().getMeioPagamento() != null) {
            n.setMeioPagamento(n.getCondicaoPagamento().getMeioPagamento());
        } else {
            n.setMeioPagamento(this.opFin.getMeioPagamento());
        }
        n.setParcelas(this.vo.getParams().getParcelas());
        n.setFaturadoSuframa(this.vo.getParams().getFaturadoSuframa());
        n.setInscricaoSuframa(this.vo.getParams().getSuframa());
        n.setFinalidadeEmNFe(this.vo.getParams().getNaturezaOperacao().getFinalidadeEmNFe());
        n.setInformarLocalEntregaNFPropria(Short.valueOf((short)0));
        n.setLocalEntregaNFPropria(null);
        n.setInformarLocalRetiradaNFPropria(Short.valueOf((short)0));
        n.setLocalRetiradaNFPropria(null);
        n.setClassificacaoCliente(n.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        n.setCategoriaPessoa(n.getUnidadeFatCliente().getCategoriaPessoa());
        n.setDadosTransNfPropria(this.getDadosTransNFPropria(n));
        n.setGrupoDocumentosRefPR(this.getGrupoDocRefPropria(n));
        n.setCotacaoMoeda(this.getCotacaoMoeda(n));
        return n;
    }

    private ItemNotaFiscalPropria procurarItemNotaProduto(PreFaturamentoNFItem ic, List list) {
        for (Object o : list) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (!i.getProduto().equals((Object)ic.getProduto()) || !i.getCentroEstoque().equals((Object)ic.getCentroEstoque())) continue;
            return i;
        }
        return null;
    }

    private void buildGradesConfEst(PreFaturamentoNFItem grPre, Date dataEntradaSaida, ItemNotaFiscalPropria itemNF, Empresa empresa, Short entradaSaida) throws ExceptionReflection {
        for (PreFaturamentoNFItemGrade grade : grPre.getGrades()) {
            GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
            g.setQuantidade(grade.getQuantidade());
            g.setMovimentacaoFisica(itemNF.getModeloFiscal().getMovimentacaoFisica());
            g.setGradeCor(grade.getGradeCor());
            g.setDataEntradaSaida(dataEntradaSaida);
            g.setLoteFabricacao(grade.getLoteFabricacao());
            g.setCentroEstoque(itemNF.getCentroEstoque());
            g.setEmpresa(empresa);
            g.setFatorConversao(itemNF.getFatorConversao());
            g.setEntradaSaida(entradaSaida);
            g.setItemNotaFiscalPropria(itemNF);
            if (grade.getLoteFabricacao() == null) {
                itemNF.getGradesNotaFiscalPropria().addAll(AuxStandardMethodsNF.gerarGradesConfEstoqueLote(g, empresa));
                continue;
            }
            itemNF.getGradesNotaFiscalPropria().add(g);
        }
        Double quantidadeTotal = 0.0;
        for (GradeItemNotaFiscalPropria g : itemNF.getGradesNotaFiscalPropria()) {
            quantidadeTotal = quantidadeTotal + g.getQuantidade();
        }
        itemNF.setQuantidadeTotal(quantidadeTotal);
    }

    private List<PreFaturamentoNFItem> ordenarItens(List<PreFaturamentoNFItem> itens) {
        if (itens != null) {
            Collections.sort(itens, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    PreFaturamentoNFItem item1 = (PreFaturamentoNFItem)o1;
                    PreFaturamentoNFItem item2 = (PreFaturamentoNFItem)o2;
                    Long idProduto1 = item1.getProduto().getIdentificador();
                    Long idProduto2 = item2.getProduto().getIdentificador();
                    return idProduto1.compareTo(idProduto2);
                }
            });
            return itens;
        }
        return new ArrayList<PreFaturamentoNFItem>();
    }

    private DadosTransNfPropria getDadosTransNFPropria(NotaFiscalPropria n) {
        if (n.getDadosTransNfPropria() != null && n.getDadosTransNfPropria().getIdentificador() != null) {
            return n.getDadosTransNfPropria();
        }
        VODocumento voDoc = (VODocumento)this.vo.getNotasOrigem().get(0);
        if (voDoc instanceof VONFPropria) {
            VONFPropria voNFP = (VONFPropria)voDoc;
            NotaFiscalPropria notaPropriaDevolucao = voNFP.getSource();
            DadosTransNfPropria d = new DadosTransNfPropria();
            DadosTransNfPropria dadosDevolucao = notaPropriaDevolucao.getDadosTransNfPropria();
            d.setTipoFrete(dadosDevolucao.getTipoFrete());
            d.setTransportador(dadosDevolucao.getTransportador());
            d.setNotaFiscalPropria(n);
            return d;
        }
        if (voDoc instanceof VOPed) {
            VOPed voNFP = (VOPed)voDoc;
            Pedido pedidoDevolucao = voNFP.getSource();
            DadosTransNfPropria d = new DadosTransNfPropria();
            d.setTipoFrete(pedidoDevolucao.getTipoFrete());
            d.setTransportador(pedidoDevolucao.getTransportador());
            d.setNotaFiscalPropria(n);
            return d;
        }
        if (voDoc instanceof VONFTerceiros) {
            VONFTerceiros voNFP = (VONFTerceiros)voDoc;
            NotaFiscalTerceiros notaPropriaDevolucao = voNFP.getSource();
            DadosTransNfPropria d = new DadosTransNfPropria();
            d.setTipoFrete(notaPropriaDevolucao.getTipoFrete());
            d.setTransportador(notaPropriaDevolucao.getTransportador());
            d.setNotaFiscalPropria(n);
            return d;
        }
        if (voDoc instanceof VONFCe) {
            VONFCe voNFP = (VONFCe)voDoc;
            NFCe nfce = voNFP.getSource();
            DadosTransNfPropria d = new DadosTransNfPropria();
            d.setTipoFrete(nfce.getDadosTransporte().getTipoFrete());
            d.setTransportador(nfce.getDadosTransporte().getTransportador());
            d.setNotaFiscalPropria(n);
            return d;
        }
        return null;
    }

    private GrupoDocumentosRefPR getGrupoDocRefPropria(NotaFiscalPropria nf) {
        if (nf.getIdentificador() != null) {
            return nf.getGrupoDocumentosRefPR();
        }
        GrupoDocumentosRefPR g = new GrupoDocumentosRefPR();
        for (VODocumento voDoc : this.vo.getNotasOrigem()) {
            DocumentosRefNFPropriaPR d;
            NotaFiscalPropria notaDevolucao;
            VONFPropria vNFP;
            if (voDoc instanceof VONFPropria) {
                vNFP = (VONFPropria)voDoc;
                notaDevolucao = vNFP.getSource();
                if (!notaDevolucao.getModeloDocFiscal().getCodigo().equals("55")) continue;
                d = new DocumentosRefNFPropriaPR();
                d.setChaveNFe(notaDevolucao.getChaveNFE());
                d.setNotaFiscalPropria(notaDevolucao);
                d.setGrupoDocumentosRefPR(g);
                g.getNotasProprias().add(d);
                continue;
            }
            if (voDoc instanceof VOPed) continue;
            if (voDoc instanceof VONFTerceiros) {
                vNFP = (VONFTerceiros)voDoc;
                notaDevolucao = vNFP.getSource();
                if (notaDevolucao.getModeloDocFiscal().getCodigo().equals("55")) {
                    d = new DocumentosRefNFTerceirosPR();
                    d.setChaveNFe(notaDevolucao.getChaveNFE());
                    d.setNotaFiscalTerceiros((NotaFiscalTerceiros)notaDevolucao);
                    d.setGrupoDocumentosRefPR(g);
                    g.getNotasTerceiros().add(d);
                    continue;
                }
                if (!notaDevolucao.getModeloDocFiscal().getCodigo().equals("04")) continue;
                d = new DocumentosRefNFProdutorPR();
                d.setDataEmissao(notaDevolucao.getDataEmissao());
                d.setEmissor(notaDevolucao.getUnidadeFatFornecedor().getFornecedor().getPessoa());
                d.setGrupoDocumentosRefPR(g);
                d.setModeloDocFiscal(notaDevolucao.getModeloDocFiscal());
                d.setNotaTerceiros((NotaFiscalTerceiros)notaDevolucao);
                d.setNumero(notaDevolucao.getNumeroNota());
                d.setSerie(notaDevolucao.getSerie());
                g.getNotasProdutor().add(d);
                continue;
            }
            if (!(voDoc instanceof VONFCe)) continue;
            vNFP = (VONFCe)voDoc;
            notaDevolucao = vNFP.getSource();
            d = new DocumentosRefNFCePR();
            d.setChaveNFe(notaDevolucao.getChaveNFCe());
            d.setNfce((NFCe)notaDevolucao);
            d.setGrupoDocumentosRefPR(g);
            g.getNfces().add(d);
        }
        g.setNotaFiscalPropria(nf);
        nf.setGrupoDocumentosRefPR(g);
        return g;
    }

    private CotacaoMoeda getCotacaoMoeda(NotaFiscalPropria nf) {
        VODocumento voDoc = (VODocumento)this.vo.getNotasOrigem().get(0);
        if (voDoc instanceof VONFPropria) {
            VONFPropria voNFP = (VONFPropria)voDoc;
            NotaFiscalPropria notaPropriaDevolucao = voNFP.getSource();
            return notaPropriaDevolucao.getCotacaoMoeda();
        }
        if (voDoc instanceof VOPed) {
            VOPed voNFP = (VOPed)voDoc;
            Pedido pedido = voNFP.getSource();
            return pedido.getCotacaoMoeda();
        }
        return null;
    }

    private void buildItens(NotaFiscalPropria nf) throws ExceptionCFOPNotFound, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        for (VODocumento voDoc : this.vo.getNotasOrigem()) {
            VONFPropria vNFP;
            if (voDoc instanceof VONFPropria) {
                vNFP = (VONFPropria)voDoc;
                this.getItensFromNotaPropria(vNFP, nf);
                continue;
            }
            if (voDoc instanceof VOPed) {
                vNFP = (VOPed)voDoc;
                this.getItensFromPedido((VOPed)vNFP, nf);
                continue;
            }
            if (voDoc instanceof VONFCe) {
                VONFCe vNFCe = (VONFCe)voDoc;
                this.getItensFromNFCe(vNFCe, nf);
                continue;
            }
            if (!(voDoc instanceof VONFTerceiros)) continue;
            VONFTerceiros vNFT = (VONFTerceiros)voDoc;
            this.getItensFromNotaTerceiros(vNFT, nf);
        }
    }

    private void getItensFromNotaPropria(VONFPropria vNFP, NotaFiscalPropria nf) throws ExceptionCFOPNotFound, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        for (VODocumentoItem item : vNFP.getItens()) {
            VONFPropriaItem voItem = (VONFPropriaItem)item;
            ItemNotaFiscalPropria itemNew = new ItemNotaFiscalPropria();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaFiscalPropria(itemNew);
            itemNew.setNotaFiscalPropria(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            if (ToolMethods.isEquals((Object)voItem.getSource().getNotaFiscalPropria().getNaturezaOperacao().getEntradaSaida(), (Object)2)) {
                itemNew.setFatorConversao(voItem.getSource().getFatorConversao());
            } else {
                itemNew.setFatorConversao(Double.valueOf(1.0));
            }
            itemNew.setProduto(voItem.getSource().getProduto());
            itemNew.setValorUnitario(voItem.getSource().getValorUnitario());
            itemNew.setPercDesconto(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercDespAcessoria());
            itemNew.setPercFrete(voItem.getSource().getPercFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercSeguro());
            itemNew.setPercDescontoItemInf(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessItemInf(voItem.getSource().getPercDespAcessoria());
            itemNew.setPercFreteItemInf(voItem.getSource().getPercFrete());
            itemNew.setPercSeguroItemInf(voItem.getSource().getPercSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setClassificacaoVendas(this.vo.getParams().getClassificacaoVendas());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getSource().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(itemNew, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
            this.setGradesItemNotaPropria(voItem, itemNew, nf);
            if (voItem.getSource().getUnidadeMedidaCom() != null && voItem.getSource().getValorUnitarioCom() > 0.0) {
                itemNew.setValorUnitarioCom(voItem.getSource().getValorUnitarioCom());
                itemNew.setUnidadeMedidaCom(voItem.getSource().getUnidadeMedidaCom());
                itemNew.setQuantidadeTotalCom(itemNew.getQuantidadeTotal());
            }
            if (voItem.getSource().getUnidadeMedidaTrib() != null && voItem.getSource().getValorUnitarioTrib() > 0.0) {
                itemNew.setValorUnitarioTrib(voItem.getSource().getValorUnitarioTrib());
                itemNew.setUnidadeMedidaTrib(voItem.getSource().getUnidadeMedidaTrib());
                itemNew.setQuantidadeTotalTrib(Double.valueOf(itemNew.getQuantidadeTotal() * voItem.getSource().getFatorConversao()));
            }
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(nf.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getIndicadorPresencaConsumidor()));
            this.procurarAliquotaICMS(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIcms(), nf.getNaturezaOperacao());
            this.procurarPercRedBC(itemNew, voItem.getSource().getItemNotaLivroFiscal().getPercReducaoBCIcms());
            this.mostrarDadosIpi(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIpi());
            this.mostrarDadosIcms(itemNew);
            this.mostrarDadosIcmsSt(itemNew);
            this.mostrarDadosPisCofins(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaPis(), voItem.getSource().getItemNotaLivroFiscal().getAliquotaCofins());
            this.mostrarOutrasAliquotas(itemNew);
            this.procurarAliquotaPrevImpostos(itemNew);
            this.setDadosContabeis(itemNew, itemNew.getItemNotaLivroFiscal().getCfop());
            this.setarValorCustoNotaPropria(nf.getNaturezaOperacao(), itemNew, this.empresa);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            itemNew.setValorDescontoItemInf(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            itemNew.setValorFreteItemInf(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getVrSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getVrSeguro() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            itemNew.setValorSeguroItemInf(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespAcessoria() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespAcessoria() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            itemNew.setValorDespAcessItemInf(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"00"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrFCPST));
            itemNew.setValorDespAcessItemInf(itemNew.getValorDespAcessoria());
            itemNew.getItemNotaLivroFiscal().setValorIpiDevolucao(vrIpi);
            itemNew.setNumeroItem(Integer.valueOf(nf.getItensNotaPropria().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            itemNew.setNrLoteFabricacao(voItem.getSource().getNrLoteFabricacao());
            itemNew.setDataFabricacao(voItem.getSource().getDataFabricacao());
            itemNew.setDataValidade(voItem.getSource().getDataValidade());
            nf.getItensNotaPropria().add(itemNew);
        }
    }

    private void criarEstoqueTerceirosNP(NotaFiscalPropria vo, GradeItemNotaFiscalPropria gt, EstoqueTerceiros estoqueTercMae) {
        if (vo.getNaturezaOperacao().getTipoEstoque() == 1 || vo.getNaturezaOperacao().getTipoEstoque() == 3 || vo.getNaturezaOperacao().getTipoEstoque() == 4 || vo.getNaturezaOperacao().getTipoEstoque() == 2 || vo.getNaturezaOperacao().getTipoEstoque() == 10 || vo.getNaturezaOperacao().getTipoEstoque() == 11 || vo.getNaturezaOperacao().getTipoEstoque() == 6) {
            EstoqueTerceiros estoqueTerceiros = gt.getEstoqueTerceiros();
            if (estoqueTerceiros == null) {
                estoqueTerceiros = new EstoqueTerceiros();
            }
            estoqueTerceiros.setPessoaParceiro(vo.getUnidadeFatCliente().getPessoa());
            estoqueTerceiros.setNaturezaOperacao(vo.getNaturezaOperacao());
            estoqueTerceiros.setData(gt.getDataEntradaSaida());
            estoqueTerceiros.setEmpresa(vo.getEmpresa());
            estoqueTerceiros.setGradeItemNotaPropria(gt);
            estoqueTerceiros.setQuantidade(gt.getQuantidade());
            estoqueTerceiros.setEstoqueTerceirosMae(estoqueTercMae);
            gt.setEstoqueTerceiros(estoqueTerceiros);
        }
    }

    private void setGradesItemNotaPropria(VONFPropriaItem voItem, ItemNotaFiscalPropria itemNew, NotaFiscalPropria nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VONFPropriaItemGrade voGrade = (VONFPropriaItemGrade)grade;
            GradeItemNotaFiscalPropria gt = new GradeItemNotaFiscalPropria();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaFiscalPropria(itemNew);
            gt.setLoteFabricacao(voGrade.getLoteFabricacao());
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(Double.valueOf(0.0));
            gt.setDataEntradaSaida(nf.getDataEntradaSaida());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            gt.setEntradaSaida(nf.getNaturezaOperacao().getEntradaSaida());
            itemNew.getGradesNotaFiscalPropria().add(gt);
            this.criarEstoqueTerceirosNP(nf, gt, voGrade.getSource().getEstoqueTerceiros());
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
        if (voItem.getSource().getProduto().getClassificacaoProdutoANP() != null && ToolMethods.isEquals((Object)voItem.getSource().getQuantidadeTotal(), (Object)itemNew.getQuantidadeTotal())) {
            itemNew.setVrProduto(voItem.getSource().getVrProduto());
        }
    }

    private Cfop procurarCFOP(NaturezaOperacao i, ModeloFiscal m, UnidadeFederativa ufEmpresa, UnidadeFederativa ufClienteForn, Short indicadorPresenca) throws ExceptionService, ExceptionCFOPNotFound {
        if (i.getEntradaSaida() == 1) {
            return CoreUtilityFactory.getUtilityCFOP().findCfopSaida(ufEmpresa, ufClienteForn, m, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)indicadorPresenca));
        }
        return CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(ufEmpresa, ufClienteForn, m);
    }

    private void procurarAliquotaICMS(ItemNotaFiscalPropria i, Double aliquotaIcms, NaturezaOperacao naturezaOperacao) throws ExceptionService {
        i.getItemNotaLivroFiscal().setAliquotaICMSSimples(i.getNotaFiscalPropria().getEmpresa().getEmpresaDados().getAliquotaICMSSimples());
        if (i.getItemNotaLivroFiscal().getAliquotaICMSSimples() == null) {
            i.getItemNotaLivroFiscal().setAliquotaICMSSimples(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaIcmsDevolucao(), (Object)1)) {
            i.getItemNotaLivroFiscal().setAliquotaIcms(aliquotaIcms);
        } else if (i.getModeloFiscal().getModeloFiscalIcms().getTipoAliquotaIcms() != 0) {
            i.getItemNotaLivroFiscal().setAliquotaIcms(new HelperItemNotaPropria().findAliquotaIcms(naturezaOperacao, i.getModeloFiscal(), i.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCidade().getUf(), i.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), i.getProduto()));
        } else {
            i.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(0.0));
        }
    }

    private void procurarPercRedBC(ItemNotaFiscalPropria i, Double percRedBCIcms) {
        ModeloFiscal modelo = i.getModeloFiscal();
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaIcmsDevolucao(), (Object)1)) {
            i.getItemNotaLivroFiscal().setPercReducaoBCIcms(percRedBCIcms);
        } else if (ToolMethods.isEquals((Object)modelo.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            i.getItemNotaLivroFiscal().setPercReducaoBCIcms(modelo.getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            i.getItemNotaLivroFiscal().setPercReducaoBCIcms(i.getProduto().getReducaoBaseCalcIcms());
        }
    }

    private void setDadosContabeis(ItemNotaFiscalPropria i, Cfop cfop) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)this.vo.getParams().getInformarPlanosConta(), (Object)1)) {
            i.setPlanoContaDeb(this.vo.getParams().getPlanoContaDebito());
            i.setPlanoContaCred(this.vo.getParams().getPlanoContaCredito());
            i.setPlanoContaGerencial(i.getProduto().getPlanoContaGerencial());
            return;
        }
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), i.getNotaFiscalPropria().getUnidadeFatCliente(), i.getNotaFiscalPropria().getNaturezaOperacao(), i.getNotaFiscalPropria().getEmpresa(), i.getNotaFiscalPropria().getUnidadeFatCliente().getCategoriaPessoa(), this.opcoesContabeis, cfop);
            i.setPlanoContaCred(dados.getPlanoContaCred());
            i.setPlanoContaDeb(dados.getPlanoContaDeb());
            i.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionParametrizacao ex) {
            TLogger.get(((Object)((Object)ex)).getClass()).error((Throwable)ex);
            throw new ExceptionParametrizacaoCtbModFiscalNotFound(ex.getFormattedMessage());
        }
    }

    private void mostrarDadosIpi(ItemNotaFiscalPropria i, Double aliquotaIPI) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
        i.setClasseEnquadramentoIpi(i.getProduto().getClasseEnqIpi());
        if (i.getModeloFiscal() != null && i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            i.setClasseEnquadramentoIpi(i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        }
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaIpiDevolucao(), (Object)1)) {
            i.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIPI);
        } else {
            Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)i.getProduto(), (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
            i.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIpi);
        }
    }

    private void mostrarDadosIcms(ItemNotaFiscalPropria i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setIncidenciaIcms(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms());
        i.setModalidadeIcms(modeloFiscal.getModeloFiscalIcms().getModalidadeIcms());
    }

    private void mostrarDadosIcmsSt(ItemNotaFiscalPropria i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        i.setModalidadeIcmsSt(modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt());
    }

    private void mostrarDadosPisCofins(ItemNotaFiscalPropria i, Double aliquotaPis, Double aliquotaCofins) {
        ModeloFiscal m = i.getModeloFiscal();
        i.setIncidenciaPisCofins(m.getModeloFiscalPisCofins().getIncidenciaPisCofins());
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaPisCofinsDevolucao(), (Object)1)) {
            i.getItemNotaLivroFiscal().setAliquotaPis(aliquotaPis);
            i.getItemNotaLivroFiscal().setAliquotaCofins(aliquotaCofins);
        } else {
            i.getItemNotaLivroFiscal().setAliquotaPis(i.getProduto().getAliquotaPis());
            i.getItemNotaLivroFiscal().setAliquotaCofins(i.getProduto().getAliquotaCofins());
        }
        new HelperItemNotaPropria(i).setNatReceitaPisCofins();
    }

    private void mostrarOutrasAliquotas(ItemNotaFiscalPropria i) {
        ModeloFiscal mod = i.getModeloFiscal();
        Produto produto = i.getProduto();
        if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaIrrf(produto.getAliquotaIrrf());
            i.getItemNotaLivroFiscal().setPercRedIrrf(produto.getPercRedIrrf());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaIrrf(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedIrrf(Double.valueOf(0.0));
        }
        if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaInss(produto.getAliquotaInss());
            i.getItemNotaLivroFiscal().setPercRedBcInss(produto.getPercRedBCINSS());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaInss(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedBcInss(Double.valueOf(0.0));
        }
        if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaFunrural(produto.getAliquotaFunrural());
            i.getItemNotaLivroFiscal().setPercRedFunrural(produto.getPercRedFunrural());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaFunrural(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedFunrural(Double.valueOf(0.0));
        }
        if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaRat(produto.getAliquotaRat());
        }
        if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaSenar(produto.getAliquotaSenar());
        }
        if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
            i.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(produto.getTaxaSanidadeAnimal());
            i.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(produto.getFatorTaxaSanidadeAnimal());
        }
        if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaLei10833(produto.getAliquotaLei10833());
            i.getItemNotaLivroFiscal().setPercRedLei10833(produto.getPercRedLei10833());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaLei10833(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedLei10833(Double.valueOf(0.0));
        }
        if (mod.getTipoCalculoCide() != null && mod.getTipoCalculoCide() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaCIDE(produto.getAliquotaCide());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCIDE(Double.valueOf(0.0));
        }
        if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaOutros(produto.getAliquotaOutros());
            i.getItemNotaLivroFiscal().setPercRedOutros(produto.getPercRedOutros());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaOutros(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedOutros(Double.valueOf(0.0));
        }
        if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
            i.getItemNotaLivroFiscal().setAliquotaContSoc(produto.getAliquotaContSoc());
            i.getItemNotaLivroFiscal().setPercRedContSoc(produto.getPercRedContSoc());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaContSoc(Double.valueOf(0.0));
            i.getItemNotaLivroFiscal().setPercRedContSoc(Double.valueOf(0.0));
        }
        if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
            i.getItemNotaLivroFiscal().setAliquotaIss(produto.getAliquotaIss());
        } else {
            i.getItemNotaLivroFiscal().setAliquotaIss(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaPis(i.getProduto().getAliquotaPis());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaPisSt(i.getProduto().getAliquotaPisSt());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaCofins(i.getProduto().getAliquotaCofins());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
        }
        if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                i.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
            } else {
                i.getItemNotaLivroFiscal().setAliquotaCofinsSt(i.getProduto().getAliquotaCofinsSt());
            }
        } else {
            i.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
        }
    }

    private void procurarAliquotaPrevImpostos(ItemNotaFiscalPropria i) throws ExceptionService {
        Produto produto = i.getProduto();
        IncidenciaIcms incidenciaIcms = i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms();
        CoreRequestContext c = new CoreRequestContext();
        c.setAttribute("incidenciaIcms", incidenciaIcms);
        c.setAttribute("produto", produto);
        c.setAttribute("uf", this.empresa.getPessoa().getEndereco().getCidade().getUf());
        Double aliq = (Double)CoreServiceFactory.getServicePrevisaoImpostosNCMNBM().execute(c, "pesquisarAliquotaPrevistaImpostos");
        i.getItemNotaLivroFiscal().setAliqImpostosEstimada(aliq);
    }

    private void setarValorCustoNotaPropria(NaturezaOperacao nat, ItemNotaFiscalPropria item, Empresa empresa) throws ExceptionService {
        List datasDevolucoes = this.getDatasItensDevolvidos(item.getProduto());
        Double valorCusto = 0.0;
        for (Date dataNotaOrigem : datasDevolucoes) {
            valorCusto = valorCusto + ((HelperNaturezaOperacao)Context.get(HelperNaturezaOperacao.class)).getValorSugConfNatOperacaoNFe(item.getModeloFiscal(), nat, item.getProduto(), empresa, dataNotaOrigem);
        }
        if (ToolMethods.isWithData((Collection)datasDevolucoes) && valorCusto > 0.0) {
            valorCusto = valorCusto / (double)datasDevolucoes.size();
            for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                g.setValorCusto(valorCusto);
            }
        }
    }

    private List getDatasItensDevolvidos(Produto produto) {
        ArrayList<Date> datas = new ArrayList<Date>();
        for (VODocumento voDoc : this.vo.getNotasOrigem()) {
            for (Object ob : voDoc.getItens()) {
                Date data;
                VODocumentoItem voItem = (VODocumentoItem)ob;
                if (!ToolMethods.isEquals((Object)voItem.getProduto(), (Object)produto)) continue;
                if (voDoc instanceof VONFPropria) {
                    data = ToolDate.dataSemHora((Date)voDoc.getDataEmissao());
                    if (datas.contains(data)) continue;
                    datas.add(data);
                    continue;
                }
                if (voDoc instanceof VOPed) {
                    data = ToolDate.dataSemHora((Date)voDoc.getDataEmissao());
                    if (datas.contains(data)) continue;
                    datas.add(data);
                    continue;
                }
                if (voDoc instanceof VONFTerceiros) {
                    data = ToolDate.dataSemHora((Date)voDoc.getDataEntSai());
                    if (datas.contains(data)) continue;
                    datas.add(data);
                    continue;
                }
                if (!(voDoc instanceof VONFCe) || datas.contains(data = ToolDate.dataSemHora((Date)voDoc.getDataEmissao()))) continue;
                datas.add(data);
            }
        }
        return datas;
    }

    private void calcularImpostos(NotaFiscalPropria nf) throws ExceptionService, ExceptionCategoriaSTNotFound, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionCalculoPisCofins {
        Date dataPartilhaIcms = this.getDataPartilhaIcms(nf);
        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(nf.getItensNotaPropria(), this.empresa.getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatCliente(), nf.getSituacaoDocumento(), this.empresa, nf.getIndicadorConsumidorFinal(), this.opFat, dataPartilhaIcms, this.empCont, this.opImp, nf.getNaturezaOperacao());
        this.calcularTotalizadoresItensNotaPropria(nf);
    }

    private Date getDataPartilhaIcms(NotaFiscalPropria nf) {
        GrupoDocumentosRefPR g;
        Date data = new Date();
        EnumConstNFeFinalidadeEmissao tipo = EnumConstNFeFinalidadeEmissao.get((Object)nf.getFinalidadeEmNFe().getCodigo());
        if (tipo.isDevolucao() && nf.getGrupoDocumentosRefPR() != null && (g = nf.getGrupoDocumentosRefPR()) != null && g.getNotasProprias() != null && !g.getNotasProprias().isEmpty() && ((DocumentosRefNFPropriaPR)g.getNotasProprias().get(0)).getNotaFiscalPropria() != null) {
            data = ((DocumentosRefNFPropriaPR)g.getNotasProprias().get(0)).getNotaFiscalPropria().getDataEmissaoNota();
            return data;
        }
        return data;
    }

    public void calcularTotalizadoresItensNotaPropria(NotaFiscalPropria nf) {
        CoreUtilityFactory.getUtilityNotaFiscalPropria();
        HashMap h = UtilityNotaFiscalPropria.calcularTotalizadores(nf.getItensNotaPropria());
        ValoresNfPropria v = nf.getValoresNfPropria();
        v.setValorPis((Double)h.get("vlrPis"));
        v.setValorSestSenat((Double)h.get("vlrSestSenat"));
        v.setValorCofins((Double)h.get("vlrCofins"));
        v.setValorContSoc((Double)h.get("vlrContSoc"));
        v.setValorIcmsSa((Double)h.get("vlrIcmsSA"));
        v.setValorProduto((Double)h.get("vlrProduto"));
        v.setValorServico((Double)h.get("vlrServico"));
        v.setValorFrete((Double)h.get("vlrFrete"));
        v.setValorSeguro((Double)h.get("vlrSeguro"));
        v.setValorDesconto((Double)h.get("vlrDesconto"));
        v.setValorDespAcess((Double)h.get("vlrDespAcess"));
        v.setValorIcmsTributado((Double)h.get("vlrIcmsTrib"));
        v.setValorIcms((Double)h.get("vlrIcms"));
        v.setValorIcmsDesonerado((Double)h.get("valorIcmsDesonerado"));
        v.setValorIcmsIsento((Double)h.get("vlrIcmsIsento"));
        v.setValorIss((Double)h.get("vlrIss"));
        v.setValorIcmsOutros((Double)h.get("vlrIcmsOutros"));
        v.setValorIcmsSt((Double)h.get("vlrIcmsSt"));
        v.setValorIpiTributado((Double)h.get("bcIpi"));
        v.setValorIrrf((Double)h.get("vlrIrrf"));
        v.setValorInss((Double)h.get("vlrInss"));
        v.setValorTotal((Double)h.get("vlrTotal"));
        v.setValorIpiIndustria((Double)h.get("vlrIpiInd"));
        v.setValorIpiIsento((Double)h.get("vlrIpiIsento"));
        v.setValorIpiOutros((Double)h.get("vlrIpiOutros"));
        v.setBcIcmsSt((Double)h.get("bcIcmsSt"));
        v.setValorIcmsIsento((Double)h.get("vlrIcmsIsento"));
        v.setValorIcmsOutros((Double)h.get("vlrIcmsOutros"));
        v.setValorFunrural((Double)h.get("vlrFunrural"));
        v.setValorOutros((Double)h.get("vlrOutros"));
        v.setValorLei10833((Double)h.get("vlrLei10833"));
        v.setValorIpiComercio((Double)h.get("vlrIpiComercio"));
        v.setValorPisSt((Double)h.get("vlrPisST"));
        v.setValorCofinsSt((Double)h.get("vlrCofinsSt"));
        v.setVrBcCofins((Double)h.get("valorBcCofins"));
        v.setVrBcPis((Double)h.get("vlrBCPis"));
        v.setValorImpImportacao((Double)h.get("valorImpImportacao"));
        v.setValorEstImpostos((Double)h.get("vlrEstimadoImp"));
        v.setAliquotaEstImpostos((Double)h.get("aliqEstimadaImp"));
        v.setValorFCP((Double)h.get("valorFCP"));
        v.setValorFCPSt((Double)h.get("valorFCPSt"));
        v.setValorFCPStRetido((Double)h.get("valorFCPStRetido"));
    }

    private void setInfPagNFPropria(NotaFiscalPropria nf) {
        InfPagamentoNfPropria i = new InfPagamentoNfPropria();
        i.setMeioPagamento(this.findMeioPagamentoSemPagamento());
        i.setNotaFiscalPropria(nf);
        if (i.getMeioPagamento() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        nf.getInfPagamentoNfPropria().add(i);
    }

    private MeioPagamento findMeioPagamentoSemPagamento() {
        ServiceMeioPagamentoImpl s = (ServiceMeioPagamentoImpl)ConfApplicationContext.getBean(ServiceMeioPagamentoImpl.class);
        return s.getPorTipoPagamento("90");
    }

    private void setLoteContabil(NotaFiscalPropria nf) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        if (this.empCont != null && this.empCont.getLancNotaPropria() == 0) {
            CompLancamentosEntradaSaidaFiscais comp = (CompLancamentosEntradaSaidaFiscais)ConfApplicationContext.getBean(CompLancamentosEntradaSaidaFiscais.class);
            LoteContabil loteContabil = comp.contabilizar(nf, this.opcoesContabeis);
            if (nf.getIntegracaoNotaPropriaNotas() != null) {
                nf.getIntegracaoNotaPropriaNotas().setLoteContabil(loteContabil);
            } else {
                IntegracaoNotaPropriaNotas i = new IntegracaoNotaPropriaNotas();
                i.setNotaPropria(nf);
                i.setLoteContabil(loteContabil);
                nf.setIntegracaoNotaPropriaNotas(i);
            }
        }
    }

    private void getItensFromNFCe(VONFCe vNFCe, NotaFiscalPropria nf) throws ExceptionCFOPNotFound, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        for (VODocumentoItem item : vNFCe.getItens()) {
            VONFCeItem voItem = (VONFCeItem)item;
            ItemNotaFiscalPropria itemNew = new ItemNotaFiscalPropria();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaFiscalPropria(itemNew);
            itemNew.setNotaFiscalPropria(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            itemNew.setFatorConversao(Double.valueOf(1.0));
            itemNew.setProduto(voItem.getSource().getProduto());
            itemNew.setValorUnitario(voItem.getSource().getValorUnitarioComercial());
            itemNew.setPercDesconto(voItem.getSource().getPercentualDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercentualDespAcess());
            itemNew.setPercFrete(voItem.getSource().getPercentualFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercentualSeguro());
            itemNew.setPercDescontoItemInf(voItem.getSource().getPercentualDesconto());
            itemNew.setPercDespAcessItemInf(voItem.getSource().getPercentualDespAcess());
            itemNew.setPercFreteItemInf(voItem.getSource().getPercentualFrete());
            itemNew.setPercSeguroItemInf(voItem.getSource().getPercentualSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setClassificacaoVendas(this.vo.getParams().getClassificacaoVendas());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getProduto().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(itemNew, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
            this.setGradesItemNFCe(voItem, itemNew, nf);
            itemNew.setValorUnitarioCom(voItem.getSource().getValorUnitarioComercial());
            itemNew.setUnidadeMedidaCom(voItem.getProduto().getUnidadeMedida());
            itemNew.setQuantidadeTotalCom(itemNew.getQuantidadeTotal());
            if (voItem.getSource().getUnidadeMedidaTrib() != null && voItem.getSource().getValorUnitarioTributario() > 0.0) {
                itemNew.setValorUnitarioTrib(voItem.getSource().getValorUnitarioTributario());
                itemNew.setUnidadeMedidaTrib(voItem.getSource().getUnidadeMedidaTrib());
                itemNew.setQuantidadeTotalTrib(Double.valueOf(itemNew.getQuantidadeTotal() * voItem.getSource().getFatorConversao()));
            }
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(nf.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getIndicadorPresencaConsumidor()));
            this.procurarAliquotaICMS(itemNew, voItem.getSource().getIcms().getAliquotaIcms(), nf.getNaturezaOperacao());
            this.procurarPercRedBC(itemNew, voItem.getSource().getIcms().getPercRedBCIcms());
            this.mostrarDadosIpi(itemNew, voItem.getSource().getIpi().getAliquota());
            this.mostrarDadosIcms(itemNew);
            this.mostrarDadosIcmsSt(itemNew);
            this.mostrarDadosPisCofins(itemNew, voItem.getSource().getPis().getAliquota(), voItem.getSource().getCofins().getAliquota());
            this.mostrarOutrasAliquotas(itemNew);
            this.procurarAliquotaPrevImpostos(itemNew);
            this.setDadosContabeis(itemNew, itemNew.getItemNotaLivroFiscal().getCfop());
            this.setarValorCustoNotaPropria(nf.getNaturezaOperacao(), itemNew, this.empresa);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            itemNew.setValorDescontoItemInf(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            itemNew.setValorFreteItemInf(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getValorSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorSeguro() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            itemNew.setValorSeguroItemInf(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespesasAcessorias() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespesasAcessorias() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            itemNew.setValorDespAcessItemInf(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeComercial()), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrFCPST));
            itemNew.setValorDespAcessItemInf(itemNew.getValorDespAcessoria());
            itemNew.getItemNotaLivroFiscal().setValorIpiDevolucao(vrIpi);
            itemNew.setNumeroItem(Integer.valueOf(nf.getItensNotaPropria().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            itemNew.setNrLoteFabricacao(voItem.getSource().getNrLoteFabricacao());
            itemNew.setDataFabricacao(voItem.getSource().getDataFabricacao());
            itemNew.setDataValidade(voItem.getSource().getDataValidade());
            nf.getItensNotaPropria().add(itemNew);
        }
    }

    private void setGradesItemNFCe(VONFCeItem voItem, ItemNotaFiscalPropria itemNew, NotaFiscalPropria nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VONFCeItemGrade voGrade = (VONFCeItemGrade)grade;
            GradeItemNotaFiscalPropria gt = new GradeItemNotaFiscalPropria();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaFiscalPropria(itemNew);
            gt.setLoteFabricacao(voGrade.getLoteFabricacao());
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(Double.valueOf(0.0));
            gt.setDataEntradaSaida(nf.getDataEntradaSaida());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            gt.setEntradaSaida(nf.getNaturezaOperacao().getEntradaSaida());
            itemNew.getGradesNotaFiscalPropria().add(gt);
            this.criarEstoqueTerceirosNP(nf, gt, null);
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
        if (voItem.getSource().getProduto().getClassificacaoProdutoANP() != null && ToolMethods.isEquals((Object)voItem.getSource().getQuantidadeComercial(), (Object)itemNew.getQuantidadeTotal())) {
            itemNew.setVrProduto(voItem.getSource().getValorTotalBruto());
        }
    }

    private void getItensFromNotaTerceiros(VONFTerceiros vNFT, NotaFiscalPropria nf) throws ExceptionCFOPNotFound, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        for (VODocumentoItem item : vNFT.getItens()) {
            VONFTerceirosItem voItem = (VONFTerceirosItem)item;
            ItemNotaFiscalPropria itemNew = new ItemNotaFiscalPropria();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaFiscalPropria(itemNew);
            itemNew.setNotaFiscalPropria(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            itemNew.setFatorConversao(voItem.getSource().getFatorConversao());
            itemNew.setProduto(voItem.getProduto());
            itemNew.setValorUnitario(voItem.getValorUnitario());
            itemNew.setPercDesconto(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercDespAcessoria());
            itemNew.setPercFrete(voItem.getSource().getPercFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercSeguro());
            itemNew.setPercDescontoItemInf(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessItemInf(voItem.getSource().getPercDespAcessoria());
            itemNew.setPercFreteItemInf(voItem.getSource().getPercFrete());
            itemNew.setPercSeguroItemInf(voItem.getSource().getPercSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setClassificacaoVendas(this.vo.getParams().getClassificacaoVendas());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getSource().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(itemNew, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
            this.setGradesItemNotaTerceiros(voItem, itemNew, nf);
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(nf.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getIndicadorPresencaConsumidor()));
            this.procurarAliquotaICMS(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIcms(), nf.getNaturezaOperacao());
            this.procurarPercRedBC(itemNew, voItem.getSource().getItemNotaLivroFiscal().getPercReducaoBCIcms());
            this.mostrarDadosIpi(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIpi());
            this.mostrarDadosIcms(itemNew);
            this.mostrarDadosIcmsSt(itemNew);
            this.mostrarDadosPisCofins(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaPis(), voItem.getSource().getItemNotaLivroFiscal().getAliquotaCofins());
            this.mostrarOutrasAliquotas(itemNew);
            this.procurarAliquotaPrevImpostos(itemNew);
            this.setDadosContabeis(itemNew, itemNew.getItemNotaLivroFiscal().getCfop());
            this.setarValorCustoNotaPropria(nf.getNaturezaOperacao(), itemNew, this.empresa);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            itemNew.setValorDescontoItemInf(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            itemNew.setValorFreteItemInf(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getVrSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getVrSeguro() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            itemNew.setValorSeguroItemInf(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespAcessoria() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespAcessoria() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            itemNew.setValorDespAcessItemInf(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / (voItem.getSource().getQuantidadeTotal() * voItem.getSource().getFatorConversao())), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrFCPST));
            itemNew.setValorDespAcessItemInf(itemNew.getValorDespAcessoria());
            itemNew.getItemNotaLivroFiscal().setValorIpiDevolucao(vrIpi);
            itemNew.setNumeroItem(Integer.valueOf(nf.getItensNotaPropria().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            nf.getItensNotaPropria().add(itemNew);
        }
    }

    private void setGradesItemNotaTerceiros(VONFTerceirosItem voItem, ItemNotaFiscalPropria itemNew, NotaFiscalPropria nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VONFTerceirosItemGrade voGrade = (VONFTerceirosItemGrade)grade;
            GradeItemNotaFiscalPropria gt = new GradeItemNotaFiscalPropria();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaFiscalPropria(itemNew);
            gt.setLoteFabricacao(voGrade.getLoteFabricacao());
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(voGrade.getSource().getValorCusto());
            gt.setDataEntradaSaida(nf.getDataEntradaSaida());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            gt.setEntradaSaida(nf.getNaturezaOperacao().getEntradaSaida());
            itemNew.getGradesNotaFiscalPropria().add(gt);
            this.criarEstoqueTerceirosNP(nf, gt, voGrade.getSource().getEstoqueTerceiros());
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
    }

    private void getItensFromPedido(VOPed vPed, NotaFiscalPropria nf) throws ExceptionCFOPNotFound, ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados, ExceptionInvalidData {
        for (VODocumentoItem item : vPed.getItens()) {
            VOPedItem voItem = (VOPedItem)item;
            ItemNotaFiscalPropria itemNew = new ItemNotaFiscalPropria();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaFiscalPropria(itemNew);
            itemNew.setNotaFiscalPropria(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            if (ToolMethods.isEquals((Object)voItem.getSource().getPedido().getNaturezaOperacao().getEntradaSaida(), (Object)2)) {
                itemNew.setFatorConversao(voItem.getSource().getFatorConversao());
            } else {
                itemNew.setFatorConversao(Double.valueOf(1.0));
            }
            itemNew.setProduto(voItem.getSource().getProduto());
            itemNew.setValorUnitario(voItem.getSource().getValorUnitario());
            itemNew.setPercDesconto(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercDespesaAcessoria());
            itemNew.setPercFrete(voItem.getSource().getPercFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercSeguro());
            itemNew.setPercDescontoItemInf(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessItemInf(voItem.getSource().getPercDespesaAcessoria());
            itemNew.setPercFreteItemInf(voItem.getSource().getPercFrete());
            itemNew.setPercSeguroItemInf(voItem.getSource().getPercSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setClassificacaoVendas(this.vo.getParams().getClassificacaoVendas());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getSource().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(itemNew, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
            this.setGradesItemPedido(voItem, itemNew, nf);
            if (voItem.getSource().getUnidadeMedida() != null && voItem.getSource().getValorUnitario() > 0.0) {
                itemNew.setValorUnitarioCom(voItem.getSource().getValorUnitario());
                itemNew.setUnidadeMedidaCom(voItem.getSource().getUnidadeMedida());
                itemNew.setQuantidadeTotalCom(itemNew.getQuantidadeTotal());
            }
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(nf.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getIndicadorPresencaConsumidor()));
            Double aliqIcms = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaIcms() : 0.0;
            Double percRedBCIcms = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getPercReducaoBCIcms() : 0.0;
            Double aliqIpi = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaIpi() : 0.0;
            Double aliqPis = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaPis() : 0.0;
            Double aliqCofins = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaCofins() : 0.0;
            this.procurarAliquotaICMS(itemNew, aliqIcms, nf.getNaturezaOperacao());
            this.procurarPercRedBC(itemNew, percRedBCIcms);
            this.mostrarDadosIpi(itemNew, aliqIpi);
            this.mostrarDadosIcms(itemNew);
            this.mostrarDadosIcmsSt(itemNew);
            this.mostrarDadosPisCofins(itemNew, aliqPis, aliqCofins);
            this.mostrarOutrasAliquotas(itemNew);
            this.procurarAliquotaPrevImpostos(itemNew);
            this.setDadosContabeis(itemNew, itemNew.getItemNotaLivroFiscal().getCfop());
            this.setarValorCustoNotaPropria(nf.getNaturezaOperacao(), itemNew, this.empresa);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            itemNew.setValorDescontoItemInf(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            itemNew.setValorFreteItemInf(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getValorSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorSeguro() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            itemNew.setValorSeguroItemInf(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespesaAcessoria() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespesaAcessoria() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            itemNew.setValorDespAcessItemInf(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrFCPST));
            itemNew.setValorDespAcessItemInf(itemNew.getValorDespAcessoria());
            itemNew.getItemNotaLivroFiscal().setValorIpiDevolucao(vrIpi);
            itemNew.setNumeroItem(Integer.valueOf(nf.getItensNotaPropria().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            itemNew.setNrLoteFabricacao(voItem.getSource().getNrLoteFabricacao());
            itemNew.setDataFabricacao(voItem.getSource().getDataFabricacao());
            itemNew.setDataValidade(voItem.getSource().getDataValidade());
            nf.getItensNotaPropria().add(itemNew);
        }
    }

    private void setGradesItemPedido(VOPedItem voItem, ItemNotaFiscalPropria itemNew, NotaFiscalPropria nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VOPedItemGrade voGrade = (VOPedItemGrade)grade;
            GradeItemNotaFiscalPropria gt = new GradeItemNotaFiscalPropria();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaFiscalPropria(itemNew);
            LoteFabricacao lf = voGrade.getLoteFabricacao();
            if (ToolMethods.isNull((Object)lf).booleanValue()) {
                if (voGrade.getGradeCor().getProdutoGrade().getProduto().getLoteUnico() != null && voGrade.getGradeCor().getProdutoGrade().getProduto().getLoteUnico() != 1) {
                    CentroEstoque c = voItem.getSource().getCentroEstoque() != null ? voItem.getSource().getCentroEstoque() : itemNew.getCentroEstoque();
                    ServiceSaldoEstoqueImpl serviceLoteFab = (ServiceSaldoEstoqueImpl)Context.get(ServiceSaldoEstoqueImpl.class);
                    lf = serviceLoteFab.findMelhorLoteFabricacao(nf.getDataEmissaoNota(), voGrade.getGradeCor(), nf.getEmpresa(), EnumConstCentroEstTipoPropTerc.get((Object)c.getTipoEstProprioTerceiros()));
                } else {
                    ServiceLoteFabricacaoImpl serviceLoteFab = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
                    lf = serviceLoteFab.findOrCreateLoteUnico(voGrade.getGradeCor());
                }
            }
            gt.setLoteFabricacao(lf);
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(Double.valueOf(0.0));
            gt.setDataEntradaSaida(nf.getDataEntradaSaida());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            gt.setEntradaSaida(nf.getNaturezaOperacao().getEntradaSaida());
            itemNew.getGradesNotaFiscalPropria().add(gt);
            this.criarEstoqueTerceirosNP(nf, gt, null);
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
    }
}

