/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfpropria;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PreFaturamentoNF;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItem;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItemGrade;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaItemNotaPropria;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.geracaonfpropria.AuxStandardMethodsNF;

class AuxGerarNFPreFaturamentoNF {
    private final PreFaturamentoNF preFat;
    private final OpcoesFaturamento opFat;
    private final OpcoesImpostos opImp;
    private final OpcoesFinanceiras opFin;
    private final EmpresaFinanceiro empFin;
    private final EmpresaContabilidade empCont;
    private final OpcoesContabeis opcoesContabeis;
    private final OpcoesEstoque opcoesEstoque;
    private final Usuario usuario;
    private TLogger logger = TLogger.get(this.getClass());

    public AuxGerarNFPreFaturamentoNF(PreFaturamentoNF preFat, OpcoesFaturamento opFat, OpcoesFinanceiras opFin, EmpresaFinanceiro empFin, EmpresaContabilidade empCont, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque, Usuario usuario, OpcoesImpostos opImpostos) {
        this.preFat = preFat;
        this.opFat = opFat;
        this.opFin = opFin;
        this.empFin = empFin;
        this.empCont = empCont;
        this.opcoesContabeis = opcoesContabeis;
        this.opcoesEstoque = opcoesEstoque;
        this.usuario = usuario;
        this.opImp = opImpostos;
    }

    NotaFiscalPropria buildNF() throws ExceptionService {
        try {
            NotaFiscalPropria nf = this.createNF();
            List<PreFaturamentoNFItem> itensOrdenados = this.ordenarItens(this.preFat.getItens());
            Integer numeroItem = 1;
            for (PreFaturamentoNFItem iten : itensOrdenados) {
                this.buildItens(iten, this.preFat.getDataEmissao(), nf, numeroItem);
                Integer n = numeroItem;
                numeroItem = numeroItem + 1;
            }
            this.validarItensSemLoteMovEst(nf);
            AuxStandardMethodsNF.calcImpostos(nf, this.opFat, this.empCont, this.opImp);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opcoesContabeis);
            AuxStandardMethodsNF.createVolumes(nf, this.opcoesEstoque);
            AuxStandardMethodsNF.createInfAdicionaisItens(nf, this.opFat);
            return nf;
        }
        catch (ExceptionCFOPNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionGeracaoTitulos ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCategoriaSTNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionReflection ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionValidacaoDados ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionInvalidData ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    private NotaFiscalPropria createNF() throws ExceptionService {
        NotaFiscalPropria n = AuxStandardMethodsNF.newNotaFiscalPropria(this.preFat.getNotaFiscalPropria(), this.preFat.getUnidadeFatCliente(), this.preFat.getEmpresa(), this.preFat.getNaturezaOperacao(), this.opFat, this.opFin);
        n.setDataEmissaoNota(this.preFat.getDataEmissao());
        n.setDataEntradaSaida(this.preFat.getDataSaida());
        n.setSituacaoDocumento(this.preFat.getSituacaoDocumento());
        n.setCondicaoPagamento(this.preFat.getCondicoesPagamento());
        if (n.getCondicaoPagamento() != null && n.getCondicaoPagamento().getMeioPagamento() != null) {
            n.setMeioPagamento(n.getCondicaoPagamento().getMeioPagamento());
        }
        n.setRepresentante(this.getRepUsuarioLogado());
        return n;
    }

    private ItemNotaFiscalPropria procurarItemNotaProduto(PreFaturamentoNFItem ic, List list) {
        for (Object o : list) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (!i.getProduto().equals((Object)ic.getProduto()) || !i.getCentroEstoque().equals((Object)ic.getCentroEstoque())) continue;
            return i;
        }
        return null;
    }

    private void buildItens(PreFaturamentoNFItem ic, Date dataEntradaSaida, NotaFiscalPropria nf, Integer numeroItem) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionReflection, ExceptionValidacaoDados, ExceptionInvalidData {
        if (ic.getQuantidadeTotal() <= 0.0) {
            return;
        }
        ItemNotaFiscalPropria i = null;
        i = this.procurarItemNotaProduto(ic, nf.getItensNotaPropria());
        if (i == null) {
            i = new ItemNotaFiscalPropria();
            nf.getItensNotaPropria().add(i);
        }
        i.setNotaFiscalPropria(nf);
        i.setCentroEstoque(ic.getCentroEstoque());
        if (i.getCentroEstoque() == null) {
            i.setCentroEstoque(AuxStandardMethodsNF.getCentroEstoquePadrao(nf.getEmpresa()));
        }
        i.setNumeroItem(numeroItem);
        i.setProduto(ic.getProduto());
        i.setModeloFiscal(ic.getModeloFiscal());
        i.setParamTribCbsIbsClass(ic.getParamTribCbsIbsClass());
        i.setRepresentante(nf.getRepresentante());
        i.setIndicadorTotal(Short.valueOf((short)1));
        i.setQuantidadeTotal(ic.getQuantidadeTotal());
        i.setUnidadeMedida(i.getProduto().getUnidadeMedida());
        i.setFatorConversao(Double.valueOf(1.0));
        i.setVrProduto(ic.getValorTotal());
        i.setValorUnitario(ic.getValorUnitario());
        if (ic.getRelacionamentoPessoaGC() != null) {
            RelacionamentoPessoaItemNotaPropria relItNp = new RelacionamentoPessoaItemNotaPropria();
            relItNp.setItemNotaPropria(i);
            relItNp.setRelacionamentoPessoa(ic.getRelacionamentoPessoaGC().getRelacionamentoPessoa());
            i.setRelacionamentoPessoa(relItNp);
        }
        i.setCest(i.getProduto().getCest());
        i.setNcm(i.getProduto().getNcm());
        AuxStandardMethodsNF.findAndSetAliquotasCont(i, nf.getNaturezaOperacao(), nf.getEmpresa(), nf.getUnidadeFatCliente(), this.opcoesContabeis);
        this.buildGradesConfEst(ic, dataEntradaSaida, i, nf.getEmpresa(), nf.getNaturezaOperacao().getEntradaSaida());
        AuxStandardMethodsNF.createEstoqueTerceiros(i);
        new HelperItemNotaPropria().setParametrosCBSIBSIS(i, nf.getEmpresa(), nf.getDataEmissaoNota(), nf.getNaturezaOperacao(), nf.getUnidadeFatCliente());
    }

    private void buildGradesConfEst(PreFaturamentoNFItem grPre, Date dataEntradaSaida, ItemNotaFiscalPropria itemNF, Empresa empresa, Short entradaSaida) throws ExceptionReflection {
        for (PreFaturamentoNFItemGrade grade : grPre.getGrades()) {
            GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
            g.setQuantidade(grade.getQuantidade());
            g.setMovimentacaoFisica(itemNF.getModeloFiscal().getMovimentacaoFisica());
            g.setGradeCor(grade.getGradeCor());
            g.setDataEntradaSaida(dataEntradaSaida);
            g.setLoteFabricacao(grade.getLoteFabricacao());
            g.setCentroEstoque(itemNF.getCentroEstoque());
            g.setEmpresa(empresa);
            g.setFatorConversao(itemNF.getFatorConversao());
            g.setEntradaSaida(entradaSaida);
            g.setItemNotaFiscalPropria(itemNF);
            if (grade.getLoteFabricacao() == null) {
                itemNF.getGradesNotaFiscalPropria().addAll(AuxStandardMethodsNF.gerarGradesConfEstoqueLote(g, empresa));
                continue;
            }
            itemNF.getGradesNotaFiscalPropria().add(g);
        }
        Double quantidadeTotal = 0.0;
        for (GradeItemNotaFiscalPropria g : itemNF.getGradesNotaFiscalPropria()) {
            quantidadeTotal = quantidadeTotal + g.getQuantidade();
        }
        itemNF.setQuantidadeTotal(quantidadeTotal);
    }

    private void validarItensSemLoteMovEst(NotaFiscalPropria nf) throws ExceptionService {
        StringBuilder sb = new StringBuilder();
        for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
            for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                if (g.getMovimentacaoFisica() == null || g.getMovimentacaoFisica() != 1 || g.getLoteFabricacao() != null) continue;
                sb.append("Produto sem estoque/lote: " + String.valueOf(item.getProduto()) + " - " + String.valueOf(g.getGradeCor()) + " - " + String.valueOf(g.getLoteFabricacao()));
            }
        }
        if (sb.length() > 0) {
            throw new ExceptionService(sb.toString());
        }
    }

    private List<PreFaturamentoNFItem> ordenarItens(List<PreFaturamentoNFItem> itens) {
        if (itens != null) {
            Collections.sort(itens, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    PreFaturamentoNFItem item1 = (PreFaturamentoNFItem)o1;
                    PreFaturamentoNFItem item2 = (PreFaturamentoNFItem)o2;
                    Long idProduto1 = item1.getProduto().getIdentificador();
                    Long idProduto2 = item2.getProduto().getIdentificador();
                    return idProduto1.compareTo(idProduto2);
                }
            });
            return itens;
        }
        return new ArrayList<PreFaturamentoNFItem>();
    }

    private Representante getRepUsuarioLogado() {
        if (this.usuario == null) {
            return null;
        }
        if (!ToolMethods.isWithData((Number)this.usuario.getIdentificador())) {
            return null;
        }
        ServiceRepresentanteImpl service = (ServiceRepresentanteImpl)Context.get(ServiceRepresentanteImpl.class);
        return service.findRepresentantePorPessoa(this.usuario.getUsuarioBasico().getPessoa());
    }
}

