/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfpropria;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.ValoresNfPropria;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.helpers.impl.naturezaoperacao.HelperNaturezaOperacao;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaPropria;
import mentorcore.utilities.impl.obsfaturamento.ObsFaturamentoUtilities;

public class AuxStandardMethodsNF {
    public static void createTitulos(NotaFiscalPropria n, OpcoesFinanceiras opFin, EmpresaContabilidade empCont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        CoreUtilityFactory.getUtilityTitulos().criarTitulos(n, opFin, empCont, opcoesContabeis);
    }

    private static void findAndSetPcContabilGerencial(ItemNotaFiscalPropria i, Cliente cli, OpcoesContabeis opcoesContabeis, Cfop cfop) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados {
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), i.getNotaFiscalPropria().getUnidadeFatCliente(), i.getNotaFiscalPropria().getNaturezaOperacao(), i.getNotaFiscalPropria().getEmpresa(), i.getNotaFiscalPropria().getUnidadeFatCliente().getCategoriaPessoa(), opcoesContabeis, cfop);
            i.setPlanoContaCred(dados.getPlanoContaCred());
            i.setPlanoContaDeb(dados.getPlanoContaDeb());
            i.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionInvalidData | ExceptionParametrizacao ex) {
            TLogger.get(ex.getClass()).error(ex);
            throw new ExceptionService(ex.getFormattedMessage());
        }
    }

    private static PeriodoEmissaoNFe getPeriodoEmissaoNfe(Empresa emp) throws ExceptionService {
        return (PeriodoEmissaoNFe)CoreServiceFactory.getServicePeriodoEmissaoNFe().execute(CoreRequestContext.newInstance().setAttribute("empresa", emp), "findPeriodoEmissaoNFeAtivo");
    }

    private static Integer getCodChaveAcesso(VersaoNFe versaoNfe) {
        return CoreUtilityFactory.getUtilityNFe().getCodAcesso(versaoNfe);
    }

    public static void calcImpostos(NotaFiscalPropria n, OpcoesFaturamento opFat, EmpresaContabilidade empCont, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCategoriaSTNotFound, ExceptionCalculoPisCofins, ExceptionCalculoIPI, ExceptionAvaliadorExpressoes {
        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(n.getItensNotaPropria(), n.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), n.getUnidadeFatCliente(), n.getSituacaoDocumento(), n.getEmpresa(), n.getIndicadorConsumidorFinal(), opFat, n.getDataEmissaoNota(), empCont, opImpostos, n.getNaturezaOperacao());
        CoreUtilityFactory.getUtilityNotaFiscalPropria().calcularTotalizadores(n);
        AuxStandardMethodsNF.gerarLivrosFiscais(n);
        AuxStandardMethodsNF.getObservacoesNotaPropria(n, opFat);
    }

    private static void gerarLivrosFiscais(NotaFiscalPropria n) throws ExceptionAvaliadorExpressoes {
        n.setLivrosFiscais(CoreUtilityFactory.getUtilityNotaFiscalPropria().getLivroFiscaisResumo(n.getItensNotaPropria(), n.getLivrosFiscais(), n.getModeloDocFiscal(), n.getSituacaoDocumento()));
    }

    static void findAndSetAliquotasCont(ItemNotaFiscalPropria i, NaturezaOperacao nat, Empresa emp, UnidadeFatCliente unid, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionValidacaoDados {
        ItemNotaLivroFiscal il = i.getItemNotaLivroFiscal();
        if (il == null) {
            il = new ItemNotaLivroFiscal();
            il.setItemNotaFiscalPropria(i);
            i.setItemNotaLivroFiscal(il);
        }
        Cfop cfop = null;
        cfop = nat.getEntradaSaida() == 1 ? CoreUtilityFactory.getUtilityCFOP().findCfopSaida(emp.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf(), i.getModeloFiscal(), EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)i.getNotaFiscalPropria().getIndicadorPresencaConsumidor())) : CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(emp.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf(), i.getModeloFiscal());
        il.setCfop(cfop);
        if (i.getModeloFiscal() != null) {
            i.setGerarFinanceiro(i.getModeloFiscal().getGerarFinanceiro());
            i.setIssRetido(Short.valueOf(i.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
        }
        i.setIncidenciaIcms(i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        i.setIncidenciaIpi(i.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
        i.setClasseEnquadramentoIpi(i.getProduto().getClasseEnqIpi());
        if (i.getModeloFiscal() != null && i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi() != null) {
            i.setClasseEnquadramentoIpi(i.getModeloFiscal().getModeloFiscalIpi().getClasseEnquadramentoIpi());
        }
        i.setModalidadeIcms(i.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        i.setMotivoDesoneracaoIcms(i.getModeloFiscal().getModeloFiscalIcms().getMotivoDesoneracaoIcms());
        i.setModalidadeIcmsSt(i.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
        i.setIncidenciaPisCofins(i.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        new HelperItemNotaPropria(i).setNatReceitaPisCofins();
        il.setAliquotaCofins(i.getProduto().getAliquotaCofins());
        il.setAliquotaPis(i.getProduto().getAliquotaPis());
        il.setAliquotaContSoc(i.getProduto().getAliquotaContSoc());
        il.setAliquotaFunrural(i.getProduto().getAliquotaFunrural());
        il.setAliquotaRat(i.getProduto().getAliquotaRat());
        il.setAliquotaSenar(i.getProduto().getAliquotaSenar());
        il.setTaxaSanidadeAnimal(i.getProduto().getTaxaSanidadeAnimal());
        il.setFatorTaxaSanidadeAnimal(i.getProduto().getFatorTaxaSanidadeAnimal());
        il.setAliquotaInss(i.getProduto().getAliquotaInss());
        il.setAliquotaIrrf(i.getProduto().getAliquotaIrrf());
        il.setAliquotaIss(i.getProduto().getAliquotaIss());
        il.setAliquotaLei10833(i.getProduto().getAliquotaLei10833());
        il.setAliquotaOutros(i.getProduto().getAliquotaOutros());
        il.setAliquotaSestSenat(i.getProduto().getPercSestSenat());
        il.setPercRedBcInss(i.getProduto().getPercRedBCINSS());
        il.setPercRedContSoc(i.getProduto().getPercRedContSoc());
        il.setPercRedFunrural(i.getProduto().getPercRedFunrural());
        il.setPercRedIrrf(i.getProduto().getPercRedIrrf());
        il.setPercRedLei10833(i.getProduto().getPercRedLei10833());
        il.setPercRedOutros(i.getProduto().getPercRedOutros());
        il.setPercRedSestSenat(i.getProduto().getPercSestSenat());
        if (ToolMethods.isEquals((Object)i.getModeloFiscal().getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            il.setPercReducaoBCIcms(i.getModeloFiscal().getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            il.setPercReducaoBCIcms(i.getProduto().getReducaoBaseCalcIcms());
        }
        il.setAliquotaICMSSimples(emp.getEmpresaDados().getAliquotaICMSSimples());
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)i.getProduto(), (ModeloFiscalIpi)i.getModeloFiscal().getModeloFiscalIpi());
        il.setAliquotaIpi(aliquotaIpi);
        if (i.getModeloFiscal() != null) {
            il.setAliquotaIcms(new HelperItemNotaPropria().findAliquotaIcms(nat, i.getModeloFiscal(), emp.getPessoa().getEndereco().getCidade().getUf(), unid.getCliente().getPessoa().getEndereco().getCidade().getUf(), i.getProduto()));
        }
        AuxStandardMethodsNF.findAndSetPcContabilGerencial(i, unid.getCliente(), opcoesContabeis, il.getCfop());
    }

    static NotaFiscalPropria newNotaFiscalPropria(NotaFiscalPropria n, UnidadeFatCliente unidadeFatCliente, Empresa empresa, NaturezaOperacao nat, OpcoesFaturamento opFat, OpcoesFinanceiras opFin) throws ExceptionService {
        if (n == null) {
            n = new NotaFiscalPropria();
            n.setInformarDadosReformaTributaria(opFat.getInformarDadosReformaTributaria());
            n.setDataCadastro(new Date());
            n.setDataEntradaSaida(new Date());
            n.setHoraEmissao(new Date());
            n.setHoraEntradaSaida(new Date());
            n.setPeriodoEmissaoNFe(AuxStandardMethodsNF.getPeriodoEmissaoNfe(empresa));
            n.setModeloDocFiscal(nat.getModeloDocFiscal());
            n.setTipoEmissao(Short.valueOf((short)1));
            n.setFinalidadeEmNFe(nat.getFinalidadeEmNFe());
            n.setFormatoImpressao(opFat.getTipoImpressao());
            n.setVersaoNfe(opFat.getVersaoNFe());
            n.setMeioPagamento(opFin.getMeioPagamento());
            n.setCodChaveAcesso(AuxStandardMethodsNF.getCodChaveAcesso(n.getVersaoNfe()));
        }
        n.setEmpresa(empresa);
        n.setUnidadeFatCliente(unidadeFatCliente);
        if (n.getUnidadeFatCliente() != null) {
            n.setClassificacaoCliente(n.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            n.setCategoriaPessoa(n.getUnidadeFatCliente().getCategoriaPessoa());
        }
        n.setNumeroNotaInf(n.getNumeroNota());
        n.setValoresNfPropria(new ValoresNfPropria());
        n.getValoresNfPropria().setNotaFiscalPropria(n);
        n.setDadosTransNfPropria(new DadosTransNfPropria());
        n.getDadosTransNfPropria().setNotaFiscalPropria(n);
        n.getDadosTransNfPropria().setTipoFrete(n.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete());
        n.getDadosTransNfPropria().setTransportador(n.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        n.setIndicadorPresencaConsumidor(opFat.getIndicadorPresencaConsumidor());
        n.setTipoIntermediadorComercial(opFat.getTipoIntermediadorComercial());
        n.setIndicadorConsumidorFinal(unidadeFatCliente.getCliente().getFaturamento().getTipoConsumidor());
        n.setContribuinteEstado(((HelperUnidadeFatCliente)Context.get(HelperUnidadeFatCliente.class)).build(n.getUnidadeFatCliente()).getContribuinteEstado());
        n.setSerie(((HelperNaturezaOperacao)Context.get(HelperNaturezaOperacao.class)).build(nat).getSerie(empresa));
        n.setCondicaoPagamento(unidadeFatCliente.getCliente().getFaturamento().getCondicaoPagamento());
        n.setIndicadorEmitente(Short.valueOf((short)0));
        n.setFaturadoSuframa(n.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getHabilitarSuframa());
        n.setNaturezaOperacao(nat);
        if (n.getCondicaoPagamento() != null && n.getCondicaoPagamento().getMeioPagamento() != null) {
            n.setMeioPagamento(n.getCondicaoPagamento().getMeioPagamento());
        }
        if (n.getFinalidadeEmNFe() == null) {
            n.setFinalidadeEmNFe(n.getNaturezaOperacao().getFinalidadeEmNFe());
        }
        if (n.getFinalidadeEmNFeTipo() == null) {
            n.setFinalidadeEmNFeTipo(n.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        }
        return n;
    }

    private static void getObservacoesNotaPropria(NotaFiscalPropria vo, OpcoesFaturamento opFat) {
        ObsFaturamentoUtilities.buildObs(vo, opFat.getObsFaturamentoRedespacho(), true, opFat);
    }

    static void createVolumes(NotaFiscalPropria nf, OpcoesFaturamento opFat) {
        double peso = 0.0;
        if (opFat.getEmbalagem() != null) {
            for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
                peso += (item.getProduto().getPesoUnitario() + item.getProduto().getPesoEmbalagem()) * item.getQuantidadeTotal();
            }
            VolumeNFe v = new VolumeNFe();
            v.setEmbalagem(opFat.getEmbalagem());
            v.setNumeroVolume(Long.valueOf(1L));
            v.setPesoBruto(Double.valueOf(peso + v.getEmbalagem().getPeso()));
            v.setPesoLiquido(Double.valueOf(peso));
            v.setQuantidade(Integer.valueOf(1));
            v.setNotaFiscalPropria(nf);
            nf.getVolumes().add(v);
        }
    }

    static void createVolumes(NotaFiscalPropria nf, OpcoesEstoque opcoesEstoque) {
        double peso = 0.0;
        if (opcoesEstoque != null && opcoesEstoque.getEmbalagemPreFat() != null) {
            for (ItemNotaFiscalPropria item : nf.getItensNotaPropria()) {
                peso += (item.getProduto().getPesoUnitario() + item.getProduto().getPesoEmbalagem()) * item.getQuantidadeTotal();
            }
            VolumeNFe v = new VolumeNFe();
            v.setEmbalagem(opcoesEstoque.getEmbalagemPreFat());
            v.setNumeroVolume(Long.valueOf(1L));
            v.setPesoBruto(Double.valueOf(peso + v.getEmbalagem().getPeso()));
            v.setPesoLiquido(Double.valueOf(peso));
            v.setQuantidade(Integer.valueOf(1));
            v.setNotaFiscalPropria(nf);
            nf.getVolumes().add(v);
        }
    }

    static void createEstoqueTerceiros(ItemNotaFiscalPropria item) {
        if (item.getNotaFiscalPropria().getNaturezaOperacao().getTipoEstoque() == 0) {
            return;
        }
        for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
            EstoqueTerceiros estoqueTerceiros = g.getEstoqueTerceiros();
            if (estoqueTerceiros == null) {
                estoqueTerceiros = new EstoqueTerceiros();
                estoqueTerceiros.setGradeItemNotaPropria(g);
            }
            estoqueTerceiros.setQuantidade(g.getQuantidade());
            estoqueTerceiros.setPessoaParceiro(item.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa());
            estoqueTerceiros.setNaturezaOperacao(item.getNotaFiscalPropria().getNaturezaOperacao());
            estoqueTerceiros.setData(item.getNotaFiscalPropria().getDataEmissaoNota());
            estoqueTerceiros.setEmpresa(item.getNotaFiscalPropria().getEmpresa());
            g.setEstoqueTerceiros(estoqueTerceiros);
        }
    }

    static void createInfAdicionaisItens(NotaFiscalPropria nf, OpcoesFaturamento op) throws ExceptionService {
        for (ItemNotaFiscalPropria i : nf.getItensNotaPropria()) {
            UnidadeFederativa ufEmitente = nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf();
            UnidadeFederativa ufDestinatario = nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf();
            new HelperItemNotaPropria(i).buildAndSetInfAdItemSistema(ufEmitente, ufDestinatario, i, op);
        }
    }

    public static List findLotesFabricacaoAbertos(GradeCor gradeCor, CentroEstoque centroEstoque, Empresa empresa, EnumConstCentroEstDisponibilidade tipoDisponibilidade) {
        Produto produto = gradeCor != null ? gradeCor.getProdutoGrade().getProduto() : null;
        ServiceSaldoEstoqueImpl service = (ServiceSaldoEstoqueImpl)ConfApplicationContext.getBean(ServiceSaldoEstoqueImpl.class);
        List saldos = service.findSaldoGradeCentroEstoqueLoteLista(produto, produto, gradeCor, gradeCor, new Date(), empresa, empresa, null, centroEstoque, centroEstoque, tipoDisponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD);
        return saldos;
    }

    public static Collection<? extends GradeItemNotaFiscalPropria> gerarGradesConfEstoqueLote(GradeItemNotaFiscalPropria g, Empresa empresa) throws ExceptionReflection {
        List saldos = AuxStandardMethodsNF.findLotesFabricacaoAbertos(g.getGradeCor(), g.getCentroEstoque(), empresa, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS);
        LinkedList<GradeItemNotaFiscalPropria> grades = new LinkedList<GradeItemNotaFiscalPropria>();
        double qtd = g.getQuantidade();
        do {
            grades.add(g);
            if (saldos.size() <= 0) continue;
            SaldoEstoqueGeral s = (SaldoEstoqueGeral)saldos.get(0);
            g.setLoteFabricacao(s.getLoteFabricacao());
            double diferenca = s.getQuantidade() - qtd;
            if (diferenca > 0.0) {
                qtd = 0.0;
                continue;
            }
            g.setQuantidade(s.getQuantidade());
            qtd = g.getQuantidade() - qtd;
            g = (GradeItemNotaFiscalPropria)ToolClone.clone((Object)g);
        } while (qtd > 0.0 && saldos.size() > 0);
        return grades;
    }

    static CentroEstoque getCentroEstoquePadrao(Empresa empresa) {
        ServiceCentroEstoqueImpl service = (ServiceCentroEstoqueImpl)ConfApplicationContext.getBean(ServiceCentroEstoqueImpl.class);
        return service.findCentroEstoquePadraoEmp(empresa);
    }
}

