/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfterceiros;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.conferencianfterceiros.CompConferenciaNFTerceiros;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumento;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumentoItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.VODevolucaoComprasVendas;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropria;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropriaItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropriaItemGrade;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPed;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPedItem;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.ped.VOPedItemGrade;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.importarxml.UtilNotaFiscalTerceiros;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ClearUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.geracaonfterceiros.AuxStandardMethodsNF;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;

public class AuxGeracaoNFTercDevolucaoVendas {
    private final VODevolucaoComprasVendas vo;
    private final OpcoesFinanceiras opFin;
    private final EmpresaFinanceiro empFin;
    private final EmpresaContabilidade empCont;
    private final OpcoesContabeis opCont;
    private final OpcoesCompraSuprimentos opCompraSup;
    private final OpcoesEstoque opEstoque;
    private final Usuario usuario;
    private TLogger logger = TLogger.get(this.getClass());
    private final OpcoesImpostos opImpostos;

    public AuxGeracaoNFTercDevolucaoVendas(VODevolucaoComprasVendas vODevolucaoComprasVendas, OpcoesFinanceiras opFin, EmpresaFinanceiro empFin, EmpresaContabilidade empCont, OpcoesContabeis opCont, OpcoesCompraSuprimentos opCompraSup, OpcoesEstoque opcoesEstoque, Usuario usuario, OpcoesImpostos opImpostos) {
        this.vo = vODevolucaoComprasVendas;
        this.opFin = opFin;
        this.empFin = empFin;
        this.empCont = empCont;
        this.opCont = opCont;
        this.opCompraSup = opCompraSup;
        this.opEstoque = opcoesEstoque;
        this.usuario = usuario;
        this.opImpostos = opImpostos;
    }

    NotaFiscalTerceiros buildNF() throws ExceptionService {
        try {
            NotaFiscalTerceiros nf = this.createNF();
            this.buildItens(nf);
            AuxStandardMethodsNF.calcImpostos(nf, this.empCont, this.opCompraSup, this.opImpostos);
            this.calcularValoresInformados(nf);
            AuxStandardMethodsNF.calculaTotalizadores(nf);
            AuxStandardMethodsNF.gerarLivrosFiscais(nf);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opCont);
            nf.getValoresNfTerceiros().setValorDescontoInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorDespAcessoriaInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorFreteInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorIpiInf(Double.valueOf(nf.getValoresNfTerceiros().getValorIpiIndustria() + nf.getValoresNfTerceiros().getValorIpiObservacao()));
            nf.getValoresNfTerceiros().setValorSeguroInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorTotalInf(nf.getValoresNfTerceiros().getValorTotal());
            AuxStandardMethodsNF.contabilizarNF(nf, this.empCont, this.opCont);
            this.gerarLiberacaoNFTerceiros(nf);
            return nf;
        }
        catch (ExceptionCFOPNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionGeracaoTitulos ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    private NotaFiscalTerceiros createNF() throws ExceptionService {
        NotaFiscalTerceiros n = AuxStandardMethodsNF.newNotaFiscalTerceiros(this.vo.getOut().getNotaTerceirosGerada(), this.vo.getParams().getUnidadeFatFornecedor(), this.vo.getOut().getEmpresa(), this.vo.getParams().getDataCompetencia(), this.vo.getParams().getDataEntradaSaida(), this.vo.getParams().getDataEmissao(), this.vo.getParams().getModeloDocFiscal(), this.vo.getParams().getSerie(), this.vo.getParams().getNumeroNota(), this.vo.getParams().getCondicoesPagamento(), this.vo.getParams().getParcelas(), this.vo.getParams().getSituacaoDocumento(), this.opFin);
        n.setChaveNFE(ClearUtil.refinaAll(this.vo.getParams().getChaveNFe()));
        n.setIndicadorEmitente(Short.valueOf((short)1));
        n.setModoArredondamento(Short.valueOf((short)4));
        this.setDadosTransporte(n);
        return n;
    }

    private void buildItens(NotaFiscalTerceiros nf) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound, Exception {
        for (VODocumento voDoc : this.vo.getNotasOrigem()) {
            VONFPropria vNFP;
            if (voDoc instanceof VONFPropria) {
                vNFP = (VONFPropria)voDoc;
                this.getItensFromNotaPropria(vNFP, nf);
                continue;
            }
            if (!(voDoc instanceof VOPed)) continue;
            vNFP = (VOPed)voDoc;
            this.getItensFromPedido((VOPed)vNFP, nf);
        }
    }

    private void getItensFromNotaPropria(VONFPropria vNFP, NotaFiscalTerceiros nf) throws ExceptionService, ExceptionCFOPNotFound, Exception {
        for (VODocumentoItem voDocItem : vNFP.getItens()) {
            VONFPropriaItem voItem = (VONFPropriaItem)voDocItem;
            ItemNotaTerceiros itemNew = new ItemNotaTerceiros();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaTerceiros(itemNew);
            itemNew.setNotaFiscalTerceiros(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            itemNew.setFatorConversao(Double.valueOf(1.0));
            itemNew.setProduto(voItem.getSource().getProduto());
            itemNew.setValorUnitario(voItem.getSource().getValorUnitario());
            itemNew.setPercDesconto(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercDespAcessoria());
            itemNew.setPercFrete(voItem.getSource().getPercFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setNaturezaOperacao(this.vo.getParams().getNaturezaOperacao());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getSource().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            this.setGradesItemNotaTerceirosFromNotaPropria(voItem, itemNew, nf);
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(itemNew.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf(), null));
            this.mostrarDadosModeloFiscalNotaTerceiros(itemNew);
            this.procurarPercRedBCNotaTerceiros(itemNew);
            this.setarDadosIcmsNotaTerceiros(itemNew);
            this.setarAliquotaICMSNotaTerceiros(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIcms());
            this.setarDadosIcmsStNotaTerceiros(itemNew);
            this.setarDadosPisCofinsNotaTerceiros(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaPis(), voItem.getSource().getItemNotaLivroFiscal().getAliquotaCofins());
            this.setarDadosIpiNotaTerceiros(itemNew, voItem.getSource().getItemNotaLivroFiscal().getAliquotaIpi());
            this.setarOutrasAliquotasNotaTerceiros(itemNew);
            this.setarValorCustoNotaTerceiros(itemNew);
            this.setDadosContabeisNotaTerceiros(itemNew);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getVrSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getVrSeguro() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespAcessoria() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespAcessoria() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"00"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrIpi + vrFCPST));
            itemNew.setNumeroItem(Integer.valueOf(nf.getItemNotaTerceiros().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            nf.getItemNotaTerceiros().add(itemNew);
        }
    }

    private void setGradesItemNotaTerceirosFromNotaPropria(VONFPropriaItem voItem, ItemNotaTerceiros itemNew, NotaFiscalTerceiros nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VONFPropriaItemGrade voGrade = (VONFPropriaItemGrade)grade;
            GradeItemNotaTerceiros gt = new GradeItemNotaTerceiros();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaTerceiros(itemNew);
            gt.setLoteFabricacao(voGrade.getLoteFabricacao());
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(Double.valueOf(0.0));
            gt.setDataEntradaSaida(nf.getDataEntrada());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            itemNew.getGrade().add(gt);
            this.criarEstoqueTerceirosNT(nf, gt, voGrade.getSource().getEstoqueTerceiros());
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
    }

    private Cfop procurarCFOP(NaturezaOperacao i, ModeloFiscal m, UnidadeFederativa ufEmpresa, UnidadeFederativa ufClienteForn, Short indicadorPresenca) throws ExceptionService, ExceptionCFOPNotFound {
        if (i.getEntradaSaida() == 1) {
            return CoreUtilityFactory.getUtilityCFOP().findCfopSaida(ufEmpresa, ufClienteForn, m, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)indicadorPresenca));
        }
        return CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(ufEmpresa, ufClienteForn, m);
    }

    private void criarEstoqueTerceirosNT(NotaFiscalTerceiros vo, GradeItemNotaTerceiros gt, EstoqueTerceiros estTerceirosMae) {
        ItemNotaTerceiros item = gt.getItemNotaTerceiros();
        if (item != null && item.getNaturezaOperacao().getTipoEstoque() == 1 || item.getNaturezaOperacao().getTipoEstoque() == 3 || item.getNaturezaOperacao().getTipoEstoque() == 4 || item.getNaturezaOperacao().getTipoEstoque() == 2 || item.getNaturezaOperacao().getTipoEstoque() == 10 || item.getNaturezaOperacao().getTipoEstoque() == 11 || item.getNaturezaOperacao().getTipoEstoque() == 6) {
            EstoqueTerceiros estoqueTerceiros = gt.getEstoqueTerceiros();
            if (estoqueTerceiros == null) {
                estoqueTerceiros = new EstoqueTerceiros();
            }
            estoqueTerceiros.setPessoaParceiro(vo.getUnidadeFatFornecedor().getPessoa());
            estoqueTerceiros.setNaturezaOperacao(item.getNaturezaOperacao());
            estoqueTerceiros.setData(gt.getDataEntradaSaida());
            estoqueTerceiros.setEmpresa(vo.getEmpresa());
            estoqueTerceiros.setGradeItemNotaTerceiros(gt);
            estoqueTerceiros.setQuantidade(gt.getQuantidade());
            gt.setEstoqueTerceiros(estoqueTerceiros);
        }
    }

    private void setDadosTransporte(NotaFiscalTerceiros n) {
        VODocumento voDoc = (VODocumento)this.vo.getNotasOrigem().get(0);
        if (voDoc instanceof VONFPropria) {
            VONFPropria v = (VONFPropria)voDoc;
            n.setTipoFrete(v.getSource().getDadosTransNfPropria().getTipoFrete());
            n.setTransportador(v.getSource().getDadosTransNfPropria().getTransportador());
        } else if (voDoc instanceof VOPed) {
            VOPed v = (VOPed)voDoc;
            n.setTipoFrete(v.getSource().getTipoFrete());
            n.setTransportador(v.getSource().getTransportador());
        }
    }

    private void mostrarDadosModeloFiscalNotaTerceiros(ItemNotaTerceiros i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        if (modeloFiscal != null) {
            for (GradeItemNotaTerceiros g : i.getGrade()) {
                g.setMovimentacaoFisica(modeloFiscal.getMovimentacaoFisica());
            }
        }
    }

    private void procurarPercRedBCNotaTerceiros(ItemNotaTerceiros i) {
        if (i.getModeloFiscal() != null) {
            ModeloFiscal modelo = i.getModeloFiscal();
            if (ToolMethods.isEquals((Object)modelo.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                i.getItemNotaLivroFiscal().setPercReducaoBCIcms(modelo.getModeloFiscalIcms().getReducaoBaseCalcIcms());
            } else {
                i.getItemNotaLivroFiscal().setPercReducaoBCIcms(i.getProduto().getReducaoBaseCalcIcms());
            }
        }
    }

    private void setarDadosIpiNotaTerceiros(ItemNotaTerceiros i, Double aliquotaIpi) {
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaIpiDevolucao(), (Object)1)) {
            i.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIpi);
            i.setIncidenciaIpi(i.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
        } else {
            ModeloFiscal modeloFiscal = i.getModeloFiscal();
            if (i.getProduto() != null && modeloFiscal != null) {
                i.setIncidenciaIpi(modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi());
                this.setAliquotaIpiNotaTerceiros(i);
            }
        }
    }

    private void setAliquotaIpiNotaTerceiros(ItemNotaTerceiros i) {
        ModeloFiscal modeloFiscal = i.getModeloFiscal();
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)i.getProduto(), (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
        i.getItemNotaLivroFiscal().setAliquotaIpi(aliquotaIpi);
    }

    private void setarDadosIcmsNotaTerceiros(ItemNotaTerceiros item) {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (item.getProduto() != null && modeloFiscal != null) {
            item.setIncidenciaIcms(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms());
            item.setModalidadeIcmsSt(modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt());
            item.setCodigoTributacaoDia(modeloFiscal.getModeloFiscalIcms().getCodigoTributacaoDia());
        }
    }

    private void setarDadosPisCofinsNotaTerceiros(ItemNotaTerceiros item, Double aliquotaPis, Double aliquotaCofins) {
        ModeloFiscal modeloFiscal;
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaPisCofinsDevolucao(), (Object)1)) {
            item.getItemNotaLivroFiscal().setAliquotaPis(aliquotaPis);
            item.getItemNotaLivroFiscal().setAliquotaCofins(aliquotaCofins);
        } else {
            modeloFiscal = item.getModeloFiscal();
            if (modeloFiscal != null) {
                item.setIncidenciaPisCofins(modeloFiscal.getModeloFiscalPisCofins().getIncidenciaPisCofins());
                if (modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        item.getItemNotaLivroFiscal().setAliquotaPis(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis());
                    } else {
                        item.getItemNotaLivroFiscal().setAliquotaPis(item.getProduto().getAliquotaPis());
                    }
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
                }
                if (modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        item.getItemNotaLivroFiscal().setAliquotaPisSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt());
                    } else {
                        item.getItemNotaLivroFiscal().setAliquotaPisSt(item.getProduto().getAliquotaPisSt());
                    }
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
                }
                if (modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        item.getItemNotaLivroFiscal().setAliquotaCofins(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins());
                    } else {
                        item.getItemNotaLivroFiscal().setAliquotaCofins(item.getProduto().getAliquotaCofins());
                    }
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
                }
                if (modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                    if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                        item.getItemNotaLivroFiscal().setAliquotaCofinsSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                    } else {
                        item.getItemNotaLivroFiscal().setAliquotaCofinsSt(item.getProduto().getAliquotaCofinsSt());
                    }
                } else {
                    item.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
                }
            }
        }
        modeloFiscal = item.getModeloFiscal();
        if (modeloFiscal != null) {
            item.setNaturezaBCCredito(modeloFiscal.getModeloFiscalPisCofins().getNaturezaBCCredito());
        }
    }

    private void setarDadosIcmsStNotaTerceiros(ItemNotaTerceiros item) {
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt() != null) {
            item.setModalidadeIcmsSt(modeloFiscal.getModeloFiscalIcms().getModalidadeIcmsSt());
        }
    }

    private void setarOutrasAliquotasNotaTerceiros(ItemNotaTerceiros item) {
        ModeloFiscal mod = item.getModeloFiscal();
        if (item.getProduto() != null && mod != null) {
            Produto produto = item.getProduto();
            if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaIrrf(produto.getAliquotaIrrf());
                item.getItemNotaLivroFiscal().setPercRedFunrural(produto.getPercRedIrrf());
            }
            if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaInss(produto.getAliquotaInss());
                item.getItemNotaLivroFiscal().setPercRedBcInss(produto.getPercRedBCINSS());
            }
            if (mod.getTipoSestSenat() != null && mod.getTipoSestSenat() == 1) {
                item.getItemNotaLivroFiscal().setPercRedSestSenat(produto.getPercSestSenat());
                item.getItemNotaLivroFiscal().setPercRedSestSenat(produto.getPercRedSestSenat());
            }
            if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaFunrural(produto.getAliquotaFunrural());
                item.getItemNotaLivroFiscal().setPercRedFunrural(produto.getPercRedFunrural());
            }
            if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaRat(produto.getAliquotaRat());
            }
            if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaSenar(produto.getAliquotaSenar());
            }
            if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
                item.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(produto.getTaxaSanidadeAnimal());
                item.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(produto.getFatorTaxaSanidadeAnimal());
            }
            if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaLei10833(produto.getAliquotaLei10833());
                item.getItemNotaLivroFiscal().setPercRedLei10833(produto.getPercRedLei10833());
            }
            if (mod.getTipoCalculoCide() != null && mod.getTipoCalculoCide() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaCIDE(produto.getAliquotaCide());
            }
            if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaOutros(produto.getAliquotaOutros());
                item.getItemNotaLivroFiscal().setPercRedOutros(produto.getPercRedOutros());
            }
            if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
                item.getItemNotaLivroFiscal().setAliquotaContSoc(produto.getAliquotaContSoc());
                item.getItemNotaLivroFiscal().setPercRedContSoc(produto.getPercRedContSoc());
            }
            if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
                item.getItemNotaLivroFiscal().setAliquotaIss(produto.getAliquotaIss());
            }
        }
    }

    private void setarAliquotaICMSNotaTerceiros(ItemNotaTerceiros item, Double aliquotaIcms) throws Exception {
        if (ToolMethods.isEquals((Object)this.vo.getParams().getRespeitarAliquotaIcmsDevolucao(), (Object)1)) {
            item.getItemNotaLivroFiscal().setAliquotaIcms(aliquotaIcms);
        } else {
            ModeloFiscal modelo = item.getModeloFiscal();
            double alICMS = 0.0;
            alICMS = modelo != null && modelo.getModeloFiscalIcms().getTipoAliquotaIcms() == 2 ? modelo.getModeloFiscalIcms().getAliquotaIcms().doubleValue() : new UtilNotaFiscalTerceiros().getAliquotaICMS(item.getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf(), item.getNotaFiscalTerceiros().getEmpresa().getPessoa().getEndereco().getCidade().getUf(), item.getProduto()).doubleValue();
            item.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(alICMS));
        }
    }

    private void setarValorCustoNotaTerceiros(ItemNotaTerceiros item) throws ExceptionService {
        List datasDevolucoes = this.getDatasItensDevolvidos(item.getProduto());
        Double valorCusto = 0.0;
        for (Date dataNotaOrigem : datasDevolucoes) {
            if (item.getItemNotaLivroFiscal().getCfop() == null || item.getItemNotaLivroFiscal().getCfop().getCfopDevolucaoVenda() == null || item.getItemNotaLivroFiscal().getCfop().getCfopDevolucaoVenda() != 1) continue;
            valorCusto = valorCusto + SaldoEstoqueUtilities.findPrecoMedioPorProduto(dataNotaOrigem, item.getProduto(), item.getNotaFiscalTerceiros().getEmpresa(), EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_PRODUTO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_TUDO, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_VALOR, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        }
        valorCusto = valorCusto / (double)datasDevolucoes.size();
        for (GradeItemNotaTerceiros g : item.getGrade()) {
            g.setValorCusto(valorCusto);
        }
    }

    private List getDatasItensDevolvidos(Produto produto) {
        ArrayList<Date> datas = new ArrayList<Date>();
        for (VODocumento voDoc : this.vo.getNotasOrigem()) {
            for (Object ob : voDoc.getItens()) {
                Date data;
                VODocumentoItem voItem = (VODocumentoItem)ob;
                if (!ToolMethods.isEquals((Object)voItem.getProduto(), (Object)produto)) continue;
                if (voDoc instanceof VONFPropria) {
                    data = ToolDate.dataSemHora((Date)voDoc.getDataEmissao());
                    if (datas.contains(data)) continue;
                    datas.add(data);
                    continue;
                }
                if (!(voDoc instanceof VOPed) || datas.contains(data = ToolDate.dataSemHora((Date)voDoc.getDataEmissao()))) continue;
                datas.add(data);
            }
        }
        return datas;
    }

    private void setDadosContabeisNotaTerceiros(ItemNotaTerceiros i) throws ExceptionParametrizacao, ExceptionInvalidData {
        if (ToolMethods.isEquals((Object)this.vo.getParams().getInformarPlanosConta(), (Object)1)) {
            i.setPlanoContaDeb(this.vo.getParams().getPlanoContaDebito());
            i.setPlanoContaCred(this.vo.getParams().getPlanoContaCredito());
            i.setPlanoContaGerencial(i.getProduto().getPlanoContaGerencial());
            return;
        }
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(i.getModeloFiscal(), i.getProduto(), i.getNotaFiscalTerceiros().getUnidadeFatFornecedor(), i.getNaturezaOperacao(), i.getNotaFiscalTerceiros().getEmpresa(), i.getNotaFiscalTerceiros().getUnidadeFatFornecedor().getCategoriaPessoa(), this.opCont);
        i.setPlanoContaDeb(dados.getPlanoContaDeb());
        i.setPlanoContaCred(dados.getPlanoContaCred());
        i.setPlanoContaGerencial(dados.getPcGerencial());
    }

    private void calcularValoresInformados(NotaFiscalTerceiros nf) {
        Double valorTotalItens = 0.0;
        int nrItens = nf.getItemNotaTerceiros().size();
        Double valorIpiItens = 0.0;
        Double valorIcmsItens = 0.0;
        for (Object o : nf.getItemNotaTerceiros()) {
            ItemNotaTerceiros v = (ItemNotaTerceiros)o;
            valorTotalItens = valorTotalItens + v.getItemNotaLivroFiscal().getValorTotal();
            valorIcmsItens = valorIcmsItens + (v.getItemNotaLivroFiscal().getVrIcms() + v.getItemNotaLivroFiscal().getVrIcmsSemAprov());
            valorIpiItens = valorIpiItens + (v.getItemNotaLivroFiscal().getVrIpiObservacao() + v.getItemNotaLivroFiscal().getVrIpiIndustria());
        }
        valorIcmsItens = ToolFormatter.arrredondarNumero((Double)valorIcmsItens, (int)2);
        valorIpiItens = ToolFormatter.arrredondarNumero((Double)valorIpiItens, (int)2);
        valorTotalItens = ToolFormatter.arrredondarNumero((Double)valorTotalItens, (int)2);
        nf.setNumeroItensInf(Integer.valueOf(nrItens));
        nf.getValoresNfTerceiros().setValorIcmsInf(valorIcmsItens);
        nf.getValoresNfTerceiros().setValorIpiInf(valorIpiItens);
        nf.getValoresNfTerceiros().setValorTotalInf(valorTotalItens);
    }

    private void gerarLiberacaoNFTerceiros(NotaFiscalTerceiros nf) {
        CompConferenciaNFTerceiros.avaliarNFParaConferencia((NotaFiscalTerceiros)nf, (OpcoesCompraSuprimentos)this.opCompraSup);
    }

    private void getItensFromPedido(VOPed vNFP, NotaFiscalTerceiros nf) throws ExceptionService, ExceptionCFOPNotFound, Exception {
        for (VODocumentoItem voDocItem : vNFP.getItens()) {
            VOPedItem voItem = (VOPedItem)voDocItem;
            ItemNotaTerceiros itemNew = new ItemNotaTerceiros();
            ItemNotaLivroFiscal ilf = new ItemNotaLivroFiscal();
            ilf.setItemNotaTerceiros(itemNew);
            itemNew.setNotaFiscalTerceiros(nf);
            itemNew.setItemNotaLivroFiscal(ilf);
            itemNew.setFatorConversao(Double.valueOf(1.0));
            itemNew.setProduto(voItem.getSource().getProduto());
            itemNew.setValorUnitario(voItem.getSource().getValorUnitario());
            itemNew.setPercDesconto(voItem.getSource().getPercDesconto());
            itemNew.setPercDespAcessoria(voItem.getSource().getPercDespesaAcessoria());
            itemNew.setPercFrete(voItem.getSource().getPercFrete());
            itemNew.setPercSeguro(voItem.getSource().getPercSeguro());
            itemNew.setTipoDesconto(Short.valueOf((short)1));
            itemNew.setTipoDespAcessoria(Short.valueOf((short)1));
            itemNew.setTipoSeguro(Short.valueOf((short)1));
            itemNew.setTipoFrete(Short.valueOf((short)1));
            itemNew.setDescontoItem(Short.valueOf((short)1));
            itemNew.setFreteItem(Short.valueOf((short)1));
            itemNew.setSeguroItem(Short.valueOf((short)1));
            itemNew.setDespAcessItem(Short.valueOf((short)1));
            itemNew.setIndicadorTotal(Short.valueOf((short)1));
            itemNew.setNaturezaOperacao(this.vo.getParams().getNaturezaOperacao());
            if (this.vo.getParams().getCentroEstoque() != null) {
                itemNew.setCentroEstoque(this.vo.getParams().getCentroEstoque());
            } else {
                itemNew.setCentroEstoque(voItem.getSource().getCentroEstoque());
            }
            itemNew.setUnidadeMedida(voItem.getSource().getUnidadeMedida());
            itemNew.setModeloFiscal(voItem.getModeloFiscal());
            itemNew.setGerarFinanceiro(itemNew.getModeloFiscal().getGerarFinanceiro());
            itemNew.setIssRetido(Short.valueOf(itemNew.getModeloFiscal().getIssRetido().equals((short)1) ? (short)1 : 0));
            this.setGradesItemNotaTerceirosFromItemPedido(voItem, itemNew, nf);
            itemNew.getItemNotaLivroFiscal().setCfop(this.procurarCFOP(itemNew.getNaturezaOperacao(), itemNew.getModeloFiscal(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nf.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf(), null));
            this.mostrarDadosModeloFiscalNotaTerceiros(itemNew);
            this.procurarPercRedBCNotaTerceiros(itemNew);
            this.setarDadosIcmsNotaTerceiros(itemNew);
            Double aliqIcms = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaIcms() : 0.0;
            Double percRedBCIcms = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getPercReducaoBCIcms() : 0.0;
            Double aliqIpi = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaIpi() : 0.0;
            Double aliqPis = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaPis() : 0.0;
            Double aliqCofins = voItem.getSource().getItemPedidoFiscal() != null ? voItem.getSource().getItemPedidoFiscal().getAliquotaCofins() : 0.0;
            this.setarAliquotaICMSNotaTerceiros(itemNew, aliqIcms);
            this.setarDadosIcmsStNotaTerceiros(itemNew);
            this.setarDadosPisCofinsNotaTerceiros(itemNew, aliqPis, aliqCofins);
            this.setarDadosIpiNotaTerceiros(itemNew, aliqIpi);
            this.setarOutrasAliquotasNotaTerceiros(itemNew);
            this.setarValorCustoNotaTerceiros(itemNew);
            this.setDadosContabeisNotaTerceiros(itemNew);
            Double vrDesconto = 0.0;
            if (voItem.getSource().getValorDesconto() > 0.0) {
                vrDesconto = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDesconto() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDesconto(vrDesconto);
            Double vrFrete = 0.0;
            if (voItem.getSource().getValorFrete() > 0.0) {
                vrFrete = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorFrete() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorFrete(vrFrete);
            Double vrSeguro = 0.0;
            if (voItem.getSource().getValorSeguro() > 0.0) {
                vrSeguro = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorSeguro() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setVrSeguro(vrSeguro);
            Double vrDespAcess = 0.0;
            if (voItem.getSource().getValorDespesaAcessoria() > 0.0) {
                vrDespAcess = ToolFormatter.arrredondarNumero((Double)(voItem.getSource().getValorDespesaAcessoria() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(vrDespAcess);
            Double vrIcmsSTRateado = 0.0;
            if (voItem.getValorIcmsSTCusto() > 0.0 || ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1) && voItem.getValorIcmsST() > 0.0) {
                vrIcmsSTRateado = ToolFormatter.arrredondarNumero((Double)((voItem.getValorIcmsSTCusto() + voItem.getValorIcmsST()) * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            Double vrIpi = 0.0;
            if (voItem.getValorIPI() > 0.0) {
                if (ToolMethods.isEquals((Object)nf.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo(), (Object)2) && ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getRecuperarTributosIPI(), (Object)1) && (ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"01") || ToolMethods.isEquals((Object)voItem.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi().getCodigo(), (Object)"50"))) {
                    Double vrIpiIndustria = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                    itemNew.getItemNotaLivroFiscal().setVrIpiIndustria(vrIpiIndustria);
                } else {
                    vrIpi = ToolFormatter.arrredondarNumero((Double)(voItem.getValorIPI() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
                }
            }
            Double vrFCPST = 0.0;
            if (voItem.getValorFCPSt() > 0.0 && ToolMethods.isEquals((Object)this.vo.getParams().getCalcularSTDespAcessorias(), (Object)1)) {
                vrFCPST = ToolFormatter.arrredondarNumero((Double)(voItem.getValorFCPSt() * itemNew.getQuantidadeTotal() / voItem.getSource().getQuantidadeTotal()), (int)2);
            }
            itemNew.setValorDespAcessoria(Double.valueOf(itemNew.getValorDespAcessoria() + vrIcmsSTRateado + vrIpi + vrFCPST));
            itemNew.setNumeroItem(Integer.valueOf(nf.getItemNotaTerceiros().size() + 1));
            itemNew.setCest(itemNew.getProduto().getCest());
            itemNew.setNcm(itemNew.getProduto().getNcm());
            nf.getItemNotaTerceiros().add(itemNew);
        }
    }

    private void setGradesItemNotaTerceirosFromItemPedido(VOPedItem voItem, ItemNotaTerceiros itemNew, NotaFiscalTerceiros nf) {
        Double quantidadeTotal = 0.0;
        for (VODocumentoItemGrade grade : voItem.getGrades()) {
            VOPedItemGrade voGrade = (VOPedItemGrade)grade;
            GradeItemNotaTerceiros gt = new GradeItemNotaTerceiros();
            gt.setGradeCor(voGrade.getGradeCor());
            gt.setItemNotaTerceiros(itemNew);
            gt.setLoteFabricacao(voGrade.getLoteFabricacao());
            gt.setMovimentacaoFisica(itemNew.getModeloFiscal().getMovimentacaoFisica());
            gt.setQuantidade(voGrade.getQuantidadeDevolver());
            gt.setValorCusto(Double.valueOf(0.0));
            gt.setDataEntradaSaida(nf.getDataEntrada());
            gt.setCentroEstoque(itemNew.getCentroEstoque());
            gt.setEmpresa(nf.getEmpresa());
            gt.setFatorConversao(itemNew.getFatorConversao());
            itemNew.getGrade().add(gt);
            this.criarEstoqueTerceirosNT(nf, gt, null);
            quantidadeTotal = quantidadeTotal + gt.getQuantidade();
        }
        itemNew.setQuantidadeTotal(ToolFormatter.arrredondarNumero((Double)quantidadeTotal, (int)6));
        itemNew.setVrProduto(Double.valueOf(itemNew.getValorUnitario() * itemNew.getQuantidadeTotal()));
    }
}

