/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemDupTransporteNotaPropria;
import com.touchcomp.basementor.model.vo.ItemDupTransporteNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemDuplicataTransporte;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.geracaonfterceiros.AuxStandardMethodsNF;

public class AuxGeracaoNFTercItemDupTransporte {
    private final ItemDuplicataTransporte itemDuplicataTransporte;
    private final OpcoesFinanceiras opFin;
    private final EmpresaFinanceiro empFin;
    private final EmpresaContabilidade empCont;
    private final OpcoesContabeis opCont;
    private final OpcoesCompraSuprimentos opCompraSup;
    private final OpcoesEstoque opEstoque;
    private final Usuario usuario;
    private final OpcoesImpostos opImpostos;
    private TLogger logger = TLogger.get(this.getClass());

    public AuxGeracaoNFTercItemDupTransporte(ItemDuplicataTransporte itemDuplicataTransporte, OpcoesFinanceiras opFin, EmpresaFinanceiro empFin, EmpresaContabilidade empCont, OpcoesContabeis opCont, OpcoesCompraSuprimentos opCompraSup, OpcoesEstoque opcoesEstoque, Usuario usuario, OpcoesImpostos opImpostos) {
        this.itemDuplicataTransporte = itemDuplicataTransporte;
        this.opFin = opFin;
        this.empFin = empFin;
        this.empCont = empCont;
        this.opCont = opCont;
        this.opCompraSup = opCompraSup;
        this.opEstoque = opcoesEstoque;
        this.usuario = usuario;
        this.opImpostos = opImpostos;
    }

    NotaFiscalTerceiros buildNF() throws ExceptionService, ExceptionInvalidData {
        try {
            NotaFiscalTerceiros nf = this.createNF();
            this.buildItens(nf);
            AuxStandardMethodsNF.calcImpostos(nf, this.empCont, this.opCompraSup, this.opImpostos);
            this.verificaAjustaIcms(nf);
            AuxStandardMethodsNF.calculaTotalizadores(nf);
            AuxStandardMethodsNF.gerarLivrosFiscais(nf);
            AuxStandardMethodsNF.createTitulos(nf, this.opFin, this.empCont, this.opCont);
            this.buildLancCentroCusto(nf);
            nf.getValoresNfTerceiros().setValorIcmsInf(this.itemDuplicataTransporte.getValorIcms());
            nf.getValoresNfTerceiros().setValorDescontoInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorDespAcessoriaInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorFreteInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorIpiInf(Double.valueOf(nf.getValoresNfTerceiros().getValorIpiIndustria() + nf.getValoresNfTerceiros().getValorIpiObservacao()));
            nf.getValoresNfTerceiros().setValorSeguroInf(Double.valueOf(0.0));
            nf.getValoresNfTerceiros().setValorTotalInf(nf.getValoresNfTerceiros().getValorTotal());
            nf.setTransportador(this.getTransportador(this.itemDuplicataTransporte));
            AuxStandardMethodsNF.contabilizarNF(nf, this.empCont, this.opCont);
            this.itemDuplicataTransporte.setNotaTercGerada(nf);
            return nf;
        }
        catch (ExceptionCFOPNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionParametrizacaoCtbModFiscalNotFound ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionGeracaoTitulos ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
        catch (ExceptionAvaliadorExpressoes ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a nota fiscal.\n" + ex.getMessage());
        }
    }

    private Transportador getTransportador(ItemDuplicataTransporte it) {
        if (it.getItemDuplicataTransNF().size() > 0) {
            ItemDupTransporteNotaPropria np = (ItemDupTransporteNotaPropria)it.getItemDuplicataTransNF().get(0);
            if (np.getNotaFiscalPropria().getDadosTransNfPropria().getTransportador() != null) {
                return np.getNotaFiscalPropria().getDadosTransNfPropria().getTransportador();
            }
            return null;
        }
        ItemDupTransporteNotaTerceiros np = (ItemDupTransporteNotaTerceiros)it.getItemDuplicataTransNFTerc().get(0);
        if (np.getNotaFiscalTerceiros().getTransportador() != null) {
            return np.getNotaFiscalTerceiros().getTransportador();
        }
        return null;
    }

    private NotaFiscalTerceiros createNF() throws ExceptionService {
        NotaFiscalTerceiros n = AuxStandardMethodsNF.newNotaFiscalTerceiros(this.itemDuplicataTransporte.getNotaTercGerada(), this.itemDuplicataTransporte.getDuplicataTransporte().getUnidadeFatFornecedor(), this.itemDuplicataTransporte.getDuplicataTransporte().getEmpresa(), this.itemDuplicataTransporte.getDataCompetencia(), this.itemDuplicataTransporte.getDataEntradaSaida(), this.itemDuplicataTransporte.getDataEmissao(), this.itemDuplicataTransporte.getModeloDocFiscal(), this.itemDuplicataTransporte.getSerie(), this.itemDuplicataTransporte.getNumeroNota().intValue(), this.itemDuplicataTransporte.getCondicoesPagamento(), "", this.itemDuplicataTransporte.getSituacaoDocumento(), this.opFin);
        n.setTipoCte(this.itemDuplicataTransporte.getTipoCte());
        n.setChaveNFE(this.itemDuplicataTransporte.getChave());
        if (this.itemDuplicataTransporte.getModeloDocFiscal() != null && ToolMethods.isEquals((Object)this.itemDuplicataTransporte.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.CTE_57.getCodigo()) && this.itemDuplicataTransporte.getTipoCte() != null && ToolMethods.isEquals((Object)this.itemDuplicataTransporte.getTipoCte().getCodigo(), (Object)3)) {
            n.setChaveCteSubstituido(this.itemDuplicataTransporte.getChaveCteSubstituido());
        }
        n.setIndicadorEmitente(Short.valueOf((short)1));
        n.setUfPrestacao(this.itemDuplicataTransporte.getUfPrestacao());
        n.setCidadePrestacao(this.itemDuplicataTransporte.getCidadePrestacao());
        n.setNaturezaFrete(this.itemDuplicataTransporte.getNaturezaFrete());
        n.setTransportador(this.getTransportador(this.itemDuplicataTransporte));
        n.setCidadeOrigem(this.itemDuplicataTransporte.getCidadeOrigem());
        n.setCidadeDestino(this.itemDuplicataTransporte.getCidadeDestino());
        return n;
    }

    private ItemNotaTerceiros procurarItemNotaProduto(List list, Produto prod) {
        for (Object o : list) {
            ItemNotaTerceiros i = (ItemNotaTerceiros)o;
            if (!i.getProduto().equals((Object)prod)) continue;
            return i;
        }
        return null;
    }

    private void buildItens(NotaFiscalTerceiros nf) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound {
        ItemNotaTerceiros i = null;
        i = this.procurarItemNotaProduto(nf.getItemNotaTerceiros(), this.itemDuplicataTransporte.getProduto());
        if (i == null) {
            i = new ItemNotaTerceiros();
            nf.getItemNotaTerceiros().add(i);
            i.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
            i.getItemNotaLivroFiscal().setItemNotaTerceiros(i);
        }
        i.setNotaFiscalTerceiros(nf);
        i.setProduto(this.itemDuplicataTransporte.getProduto());
        i.setNaturezaOperacao(this.itemDuplicataTransporte.getNaturezaOperacao());
        i.setModeloFiscal(this.itemDuplicataTransporte.getModeloFiscal());
        i.setGerarFinanceiro(i.getModeloFiscal().getGerarFinanceiro());
        i.setCentroEstoque(AuxStandardMethodsNF.getCentroEstoquePadrao(nf.getEmpresa(), this.opEstoque, i, this.usuario));
        i.setIndicadorTotal(Short.valueOf((short)1));
        i.setQuantidadeTotal(Double.valueOf(1.0));
        i.setUnidadeMedida(i.getProduto().getUnidadeMedida());
        i.setVrProduto(this.itemDuplicataTransporte.getValorInformadoCte());
        i.setValorUnitario(this.itemDuplicataTransporte.getValorInformadoCte());
        i.getItemNotaLivroFiscal().setFreteIcmsST(this.itemDuplicataTransporte.getValorFreteST());
        i.getItemNotaLivroFiscal().setBaseCalcIcmsFreteST(this.itemDuplicataTransporte.getBcFreteST());
        i.setCest(i.getProduto().getCest());
        i.setNcm(i.getProduto().getNcm());
        AuxStandardMethodsNF.findAndSetAliquotasCont(i, this.itemDuplicataTransporte.getNaturezaOperacao(), nf.getEmpresa(), nf.getUnidadeFatFornecedor(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), this.itemDuplicataTransporte.getUfPrestacao(), this.opCont);
        this.buildGrades(i);
    }

    private void buildGrades(ItemNotaTerceiros itemNF) throws ExceptionService {
        GradeCor gc = AuxStandardMethodsNF.getFirstGradeCor(itemNF.getProduto());
        LoteFabricacao lote = AuxStandardMethodsNF.getLoteUnico(itemNF.getProduto());
        if (gc == null) {
            throw new ExceptionService("Produto sem grades definidas: " + String.valueOf(itemNF.getProduto()));
        }
        if (gc == null) {
            throw new ExceptionService("Produto sem lote unico: " + String.valueOf(itemNF.getProduto()));
        }
        GradeItemNotaTerceiros g = new GradeItemNotaTerceiros();
        g.setQuantidade(itemNF.getQuantidadeTotal());
        g.setMovimentacaoFisica(itemNF.getModeloFiscal().getMovimentacaoFisica());
        g.setDataEntradaSaida(itemNF.getNotaFiscalTerceiros().getDataEntrada());
        g.setLoteFabricacao(lote);
        g.setGradeCor(gc);
        g.setCentroEstoque(itemNF.getCentroEstoque());
        g.setEmpresa(itemNF.getNotaFiscalTerceiros().getEmpresa());
        g.setFatorConversao(itemNF.getFatorConversao());
        g.setItemNotaTerceiros(itemNF);
        itemNF.getGrade().clear();
        itemNF.getGrade().add(g);
    }

    private void buildLancCentroCusto(NotaFiscalTerceiros nf) {
        AuxStandardMethodsNF.gerarLancCentroCusto(nf, this.itemDuplicataTransporte.getCentroCusto());
    }

    private void verificaAjustaIcms(NotaFiscalTerceiros nf) {
        Double vlrIcms = nf.getValoresNfTerceiros().getValorIcms();
        Double vlrIcmsInf = this.itemDuplicataTransporte.getValorIcms();
        Double dif = vlrIcmsInf - vlrIcms;
        ItemNotaTerceiros item = (ItemNotaTerceiros)nf.getItemNotaTerceiros().get(0);
        if (vlrIcmsInf > 0.0) {
            item.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(item.getItemNotaLivroFiscal().getVrIcms() + vlrIcmsInf));
        }
        if (item.getItemNotaLivroFiscal().getVrIcmsSemAprov() > 0.0) {
            item.getItemNotaLivroFiscal().setVrIcmsSemAprov(Double.valueOf(item.getItemNotaLivroFiscal().getVrIcmsSemAprov() + dif));
        }
    }
}

